/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.opengl.WGLSurfaceData;
import sun.java2d.pipe.hw.ExtendedBufferCapabilities;

public class WGLVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public WGLVolatileSurfaceManager(SunVolatileImage vImg, Object context) {
        super(vImg, context);
        int transparency = vImg.getTransparency();
        WGLGraphicsConfig gc = (WGLGraphicsConfig)vImg.getGraphicsConfig();
        this.accelerationEnabled = transparency == 1 || transparency == 3 && (gc.isCapPresent(12) || gc.isCapPresent(2));
    }

    @Override
    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    @Override
    protected SurfaceData initAcceleratedSurface() {
        WGLSurfaceData.WGLOffScreenSurfaceData sData;
        Component comp = this.vImg.getComponent();
        WComponentPeer peer = comp != null ? (WComponentPeer)comp.getPeer() : null;
        try {
            ExtendedBufferCapabilities ebc;
            BufferCapabilities caps;
            boolean createVSynced = false;
            boolean forceback = false;
            if (this.context instanceof Boolean && (forceback = ((Boolean)this.context).booleanValue()) && (caps = peer.getBackBufferCaps()) instanceof ExtendedBufferCapabilities && (ebc = (ExtendedBufferCapabilities)caps).getVSync() == ExtendedBufferCapabilities.VSyncType.VSYNC_ON && ebc.getFlipContents() == BufferCapabilities.FlipContents.COPIED) {
                createVSynced = true;
                forceback = false;
            }
            if (forceback) {
                sData = WGLSurfaceData.createData(peer, this.vImg, 4);
            } else {
                WGLGraphicsConfig gc = (WGLGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel cm = gc.getColorModel(this.vImg.getTransparency());
                int type = this.vImg.getForcedAccelSurfaceType();
                if (type == 0) {
                    int n = type = gc.isCapPresent(12) ? 5 : 2;
                }
                sData = createVSynced ? WGLSurfaceData.createData(peer, this.vImg, type) : WGLSurfaceData.createData(gc, this.vImg.getWidth(), this.vImg.getHeight(), cm, this.vImg, type);
            }
        }
        catch (NullPointerException ex) {
            sData = null;
        }
        catch (OutOfMemoryError er) {
            sData = null;
        }
        return sData;
    }

    @Override
    protected boolean isConfigValid(GraphicsConfiguration gc) {
        return gc == null || gc instanceof WGLGraphicsConfig && gc == this.vImg.getGraphicsConfig();
    }

    @Override
    public void initContents() {
        if (this.vImg.getForcedAccelSurfaceType() != 3) {
            super.initContents();
        }
    }
}

