/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock = new Object();
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private static boolean changed = false;
    private static long lastRefresh = -1L;
    private static final int TIMEOUT = 120000;
    private static String os_searchlist;
    private static String os_nameservers;
    private static LinkedList<String> searchlist;
    private static LinkedList<String> nameservers;

    private LinkedList<String> stringToList(String str) {
        LinkedList<String> ll = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(str, ", ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (ll.contains(s)) continue;
            ll.add(s);
        }
        return ll;
    }

    private void loadConfig() {
        long currTime;
        assert (Thread.holdsLock(lock));
        if (changed) {
            changed = false;
        } else if (lastRefresh >= 0L && (currTime = System.currentTimeMillis()) - lastRefresh < 120000L) {
            return;
        }
        ResolverConfigurationImpl.loadDNSconfig0();
        lastRefresh = System.currentTimeMillis();
        searchlist = this.stringToList(os_searchlist);
        nameservers = this.stringToList(os_nameservers);
        os_searchlist = null;
        os_nameservers = null;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)nameservers.clone();
        }
    }

    @Override
    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native void init0();

    static native void loadDNSconfig0();

    static native int notifyAddrChange0();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                return null;
            }
        });
        ResolverConfigurationImpl.init0();
        AddressChangeListener thr = new AddressChangeListener();
        thr.setDaemon(true);
        thr.start();
    }

    static class AddressChangeListener
    extends Thread {
        AddressChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ResolverConfigurationImpl.notifyAddrChange0() == 0) {
                Object object = lock;
                synchronized (object) {
                    changed = true;
                }
            }
            return;
        }
    }
}

