/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import sun.nio.fs.AbstractPath;
import sun.nio.fs.BasicFileAttributesHolder;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPathParser;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsUriSupport;
import sun.nio.fs.WindowsWatchService;

class WindowsPath
extends AbstractPath {
    private static final int MAX_PATH = 247;
    private static final int MAX_LONG_PATH = 32000;
    private final WindowsFileSystem fs;
    private final WindowsPathType type;
    private final String root;
    private final String path;
    private volatile WeakReference<String> pathForWin32Calls;
    private volatile Integer[] offsets;
    private int hash;

    private WindowsPath(WindowsFileSystem fs, WindowsPathType type, String root, String path) {
        this.fs = fs;
        this.type = type;
        this.root = root;
        this.path = path;
    }

    static WindowsPath parse(WindowsFileSystem fs, String path) {
        WindowsPathParser.Result result = WindowsPathParser.parse(path);
        return new WindowsPath(fs, result.type(), result.root(), result.path());
    }

    static WindowsPath createFromNormalizedPath(WindowsFileSystem fs, String path, BasicFileAttributes attrs) {
        try {
            WindowsPathParser.Result result = WindowsPathParser.parseNormalizedPath(path);
            if (attrs == null) {
                return new WindowsPath(fs, result.type(), result.root(), result.path());
            }
            return new WindowsPathWithAttributes(fs, result.type(), result.root(), result.path(), attrs);
        }
        catch (InvalidPathException x) {
            throw new AssertionError((Object)x.getMessage());
        }
    }

    static WindowsPath createFromNormalizedPath(WindowsFileSystem fs, String path) {
        return WindowsPath.createFromNormalizedPath(fs, path, null);
    }

    String getPathForExceptionMessage() {
        return this.path;
    }

    String getPathForPermissionCheck() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPathForWin32Calls() throws WindowsException {
        String resolved;
        if (this.isAbsolute() && this.path.length() <= 247) {
            return this.path;
        }
        WeakReference<String> ref = this.pathForWin32Calls;
        String string = resolved = ref != null ? (String)ref.get() : null;
        if (resolved != null) {
            return resolved;
        }
        resolved = this.getAbsolutePath();
        if (resolved.length() > 247) {
            if (resolved.length() > 32000) {
                throw new WindowsException("Cannot access file with path exceeding 32000 characters");
            }
            resolved = WindowsPath.addPrefixIfNeeded(WindowsNativeDispatcher.GetFullPathName(resolved));
        }
        if (this.type != WindowsPathType.DRIVE_RELATIVE) {
            String string2 = this.path;
            synchronized (string2) {
                this.pathForWin32Calls = new WeakReference<String>(resolved);
            }
        }
        return resolved;
    }

    private String getAbsolutePath() throws WindowsException {
        String wd;
        if (this.isAbsolute()) {
            return this.path;
        }
        if (this.type == WindowsPathType.RELATIVE) {
            String defaultDirectory = this.getFileSystem().defaultDirectory();
            if (this.isEmpty()) {
                return defaultDirectory;
            }
            if (defaultDirectory.endsWith("\\")) {
                return defaultDirectory + this.path;
            }
            StringBuilder sb = new StringBuilder(defaultDirectory.length() + this.path.length() + 1);
            return sb.append(defaultDirectory).append('\\').append(this.path).toString();
        }
        if (this.type == WindowsPathType.DIRECTORY_RELATIVE) {
            String defaultRoot = this.getFileSystem().defaultRoot();
            return defaultRoot + this.path.substring(1);
        }
        if (WindowsPath.isSameDrive(this.root, this.getFileSystem().defaultRoot())) {
            String remaining = this.path.substring(this.root.length());
            String defaultDirectory = this.getFileSystem().defaultDirectory();
            String result = defaultDirectory.endsWith("\\") ? defaultDirectory + remaining : defaultDirectory + "\\" + remaining;
            return result;
        }
        try {
            int dt = WindowsNativeDispatcher.GetDriveType(this.root + "\\");
            if (dt == 0 || dt == 1) {
                throw new WindowsException("");
            }
            wd = WindowsNativeDispatcher.GetFullPathName(this.root + ".");
        }
        catch (WindowsException x) {
            throw new WindowsException("Unable to get working directory of drive '" + Character.toUpperCase(this.root.charAt(0)) + "'");
        }
        String result = wd;
        if (wd.endsWith("\\")) {
            result = result + this.path.substring(this.root.length());
        } else if (this.path.length() > this.root.length()) {
            result = result + "\\" + this.path.substring(this.root.length());
        }
        return result;
    }

    private static boolean isSameDrive(String root1, String root2) {
        return Character.toUpperCase(root1.charAt(0)) == Character.toUpperCase(root2.charAt(0));
    }

    static String addPrefixIfNeeded(String path) {
        if (path.length() > 247) {
            path = path.startsWith("\\\\") ? "\\\\?\\UNC" + path.substring(1, path.length()) : "\\\\?\\" + path;
        }
        return path;
    }

    @Override
    public WindowsFileSystem getFileSystem() {
        return this.fs;
    }

    private boolean isEmpty() {
        return this.path.length() == 0;
    }

    private WindowsPath emptyPath() {
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", "");
    }

    @Override
    public Path getFileName() {
        int len = this.path.length();
        if (len == 0) {
            return this;
        }
        if (this.root.length() == len) {
            return null;
        }
        int off = this.path.lastIndexOf(92);
        off = off < this.root.length() ? this.root.length() : ++off;
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", this.path.substring(off));
    }

    @Override
    public WindowsPath getParent() {
        if (this.root.length() == this.path.length()) {
            return null;
        }
        int off = this.path.lastIndexOf(92);
        if (off < this.root.length()) {
            return this.getRoot();
        }
        return new WindowsPath(this.getFileSystem(), this.type, this.root, this.path.substring(0, off));
    }

    @Override
    public WindowsPath getRoot() {
        if (this.root.length() == 0) {
            return null;
        }
        return new WindowsPath(this.getFileSystem(), this.type, this.root, this.root);
    }

    WindowsPathType type() {
        return this.type;
    }

    boolean isUnc() {
        return this.type == WindowsPathType.UNC;
    }

    boolean needsSlashWhenResolving() {
        if (this.path.endsWith("\\")) {
            return false;
        }
        return this.path.length() > this.root.length();
    }

    @Override
    public boolean isAbsolute() {
        return this.type == WindowsPathType.ABSOLUTE || this.type == WindowsPathType.UNC;
    }

    static WindowsPath toWindowsPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof WindowsPath)) {
            throw new ProviderMismatchException();
        }
        return (WindowsPath)path;
    }

    @Override
    public WindowsPath relativize(Path obj) {
        int j;
        int cn;
        WindowsPath other = WindowsPath.toWindowsPath(obj);
        if (this.equals(other)) {
            return this.emptyPath();
        }
        if (this.type != other.type) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        if (!this.root.equalsIgnoreCase(other.root)) {
            throw new IllegalArgumentException("'other' has different root");
        }
        int bn = this.getNameCount();
        int n = bn > (cn = other.getNameCount()) ? cn : bn;
        for (int i = 0; i < n && this.getName(i).equals(other.getName(i)); ++i) {
        }
        StringBuilder result = new StringBuilder();
        for (j = i; j < bn; ++j) {
            result.append("..\\");
        }
        for (j = i; j < cn; ++j) {
            result.append(other.getName(j).toString());
            result.append("\\");
        }
        result.setLength(result.length() - 1);
        return WindowsPath.createFromNormalizedPath(this.getFileSystem(), result.toString());
    }

    @Override
    public Path normalize() {
        int i;
        int prevRemaining;
        int count = this.getNameCount();
        if (count == 0 || this.isEmpty()) {
            return this;
        }
        boolean[] ignore = new boolean[count];
        int remaining = count;
        do {
            prevRemaining = remaining;
            int prevName = -1;
            for (i = 0; i < count; ++i) {
                if (ignore[i]) continue;
                String name = this.elementAsString(i);
                if (name.length() > 2) {
                    prevName = i;
                    continue;
                }
                if (name.length() == 1) {
                    if (name.charAt(0) == '.') {
                        ignore[i] = true;
                        --remaining;
                        continue;
                    }
                    prevName = i;
                    continue;
                }
                if (name.charAt(0) != '.' || name.charAt(1) != '.') {
                    prevName = i;
                    continue;
                }
                if (prevName >= 0) {
                    ignore[prevName] = true;
                    ignore[i] = true;
                    remaining -= 2;
                    prevName = -1;
                    continue;
                }
                if (!this.isAbsolute() && this.type != WindowsPathType.DIRECTORY_RELATIVE) continue;
                boolean hasPrevious = false;
                for (int j = 0; j < i; ++j) {
                    if (ignore[j]) continue;
                    hasPrevious = true;
                    break;
                }
                if (hasPrevious) continue;
                ignore[i] = true;
                --remaining;
            }
        } while (prevRemaining > remaining);
        if (remaining == count) {
            return this;
        }
        if (remaining == 0) {
            return this.root.length() == 0 ? this.emptyPath() : this.getRoot();
        }
        StringBuilder result = new StringBuilder();
        if (this.root != null) {
            result.append(this.root);
        }
        for (i = 0; i < count; ++i) {
            if (ignore[i]) continue;
            result.append(this.getName(i));
            result.append("\\");
        }
        result.setLength(result.length() - 1);
        return WindowsPath.createFromNormalizedPath(this.getFileSystem(), result.toString());
    }

    @Override
    public WindowsPath resolve(Path obj) {
        WindowsPath other = WindowsPath.toWindowsPath(obj);
        if (other.isEmpty()) {
            return this;
        }
        if (other.isAbsolute()) {
            return other;
        }
        switch (other.type) {
            case RELATIVE: {
                String result = this.path.endsWith("\\") || this.root.length() == this.path.length() ? this.path + other.path : this.path + "\\" + other.path;
                return new WindowsPath(this.getFileSystem(), this.type, this.root, result);
            }
            case DIRECTORY_RELATIVE: {
                String result = this.root.endsWith("\\") ? this.root + other.path.substring(1) : this.root + other.path;
                return WindowsPath.createFromNormalizedPath(this.getFileSystem(), result);
            }
            case DRIVE_RELATIVE: {
                if (!this.root.endsWith("\\")) {
                    return other;
                }
                String thisRoot = this.root.substring(0, this.root.length() - 1);
                if (!thisRoot.equalsIgnoreCase(other.root)) {
                    return other;
                }
                String remaining = other.path.substring(other.root.length());
                String result = this.path.endsWith("\\") ? this.path + remaining : this.path + "\\" + remaining;
                return WindowsPath.createFromNormalizedPath(this.getFileSystem(), result);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (this.isEmpty()) {
                list.add(0);
            } else {
                int start = this.root.length();
                int off = this.root.length();
                while (off < this.path.length()) {
                    if (this.path.charAt(off) != '\\') {
                        ++off;
                        continue;
                    }
                    list.add(start);
                    start = ++off;
                }
                if (start != off) {
                    list.add(start);
                }
            }
            WindowsPath windowsPath = this;
            synchronized (windowsPath) {
                if (this.offsets == null) {
                    this.offsets = list.toArray(new Integer[list.size()]);
                }
            }
        }
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    private String elementAsString(int i) {
        this.initOffsets();
        if (i == this.offsets.length - 1) {
            return this.path.substring(this.offsets[i]);
        }
        return this.path.substring(this.offsets[i], this.offsets[i + 1] - 1);
    }

    @Override
    public WindowsPath getName(int index) {
        this.initOffsets();
        if (index < 0 || index >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", this.elementAsString(index));
    }

    @Override
    public WindowsPath subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (beginIndex >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (endIndex > this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (beginIndex >= endIndex) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        Integer[] nelems = new Integer[endIndex - beginIndex];
        for (int i = beginIndex; i < endIndex; ++i) {
            nelems[i - beginIndex] = sb.length();
            sb.append(this.elementAsString(i));
            if (i == endIndex - 1) continue;
            sb.append("\\");
        }
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", sb.toString());
    }

    @Override
    public boolean startsWith(Path obj) {
        if (!(Objects.requireNonNull(obj) instanceof WindowsPath)) {
            return false;
        }
        WindowsPath other = (WindowsPath)obj;
        if (!this.root.equalsIgnoreCase(other.root)) {
            return false;
        }
        if (other.isEmpty()) {
            return this.isEmpty();
        }
        int thisCount = this.getNameCount();
        int otherCount = other.getNameCount();
        if (otherCount <= thisCount) {
            while (--otherCount >= 0) {
                String otherElement;
                String thisElement = this.elementAsString(otherCount);
                if (thisElement.equalsIgnoreCase(otherElement = other.elementAsString(otherCount))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(Path obj) {
        if (!(Objects.requireNonNull(obj) instanceof WindowsPath)) {
            return false;
        }
        WindowsPath other = (WindowsPath)obj;
        if (other.path.length() > this.path.length()) {
            return false;
        }
        if (other.isEmpty()) {
            return this.isEmpty();
        }
        int thisCount = this.getNameCount();
        int otherCount = other.getNameCount();
        if (otherCount > thisCount) {
            return false;
        }
        if (other.root.length() > 0) {
            if (otherCount < thisCount) {
                return false;
            }
            if (!this.root.equalsIgnoreCase(other.root)) {
                return false;
            }
        }
        int off = thisCount - otherCount;
        while (--otherCount >= 0) {
            String otherElement;
            String thisElement = this.elementAsString(off + otherCount);
            if (thisElement.equalsIgnoreCase(otherElement = other.elementAsString(otherCount))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Path obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        String s1 = this.path;
        String s2 = ((WindowsPath)obj).path;
        int n1 = s1.length();
        int n2 = s2.length();
        int min = Math.min(n1, n2);
        for (int i = 0; i < min; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof WindowsPath) {
            return this.compareTo((Path)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int i = 0; i < this.path.length(); ++i) {
                h = 31 * h + Character.toUpperCase(this.path.charAt(i));
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    public String toString() {
        return this.path;
    }

    long openForReadAttributeAccess(boolean followLinks) throws WindowsException {
        int flags = 0x2000000;
        if (!followLinks && this.getFileSystem().supportsLinks()) {
            flags |= 0x200000;
        }
        return WindowsNativeDispatcher.CreateFile(this.getPathForWin32Calls(), 128, 7, 0L, 3, flags);
    }

    void checkRead() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(this.getPathForPermissionCheck());
        }
    }

    void checkWrite() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkWrite(this.getPathForPermissionCheck());
        }
    }

    void checkDelete() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkDelete(this.getPathForPermissionCheck());
        }
    }

    @Override
    public URI toUri() {
        return WindowsUriSupport.toUri(this);
    }

    @Override
    public WindowsPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess("user.dir");
        }
        try {
            return WindowsPath.createFromNormalizedPath(this.getFileSystem(), this.getAbsolutePath());
        }
        catch (WindowsException x) {
            throw new IOError(new IOException(x.getMessage()));
        }
    }

    @Override
    public WindowsPath toRealPath(LinkOption ... options) throws IOException {
        this.checkRead();
        String rp = WindowsLinkSupport.getRealPath(this, Util.followLinks(options));
        return WindowsPath.createFromNormalizedPath(this.getFileSystem(), rp);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (watcher == null) {
            throw new NullPointerException();
        }
        if (!(watcher instanceof WindowsWatchService)) {
            throw new ProviderMismatchException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            boolean watchSubtree = false;
            int ml = modifiers.length;
            if (ml > 0) {
                modifiers = Arrays.copyOf(modifiers, ml);
                int i = 0;
                while (i < ml) {
                    if (modifiers[i++] != ExtendedWatchEventModifier.FILE_TREE) continue;
                    watchSubtree = true;
                    break;
                }
            }
            String s = this.getPathForPermissionCheck();
            sm.checkRead(s);
            if (watchSubtree) {
                sm.checkRead(s + "\\-");
            }
        }
        return ((WindowsWatchService)watcher).register(this, events, modifiers);
    }

    private static class WindowsPathWithAttributes
    extends WindowsPath
    implements BasicFileAttributesHolder {
        final WeakReference<BasicFileAttributes> ref;

        WindowsPathWithAttributes(WindowsFileSystem fs, WindowsPathType type, String root, String path, BasicFileAttributes attrs) {
            super(fs, type, root, path);
            this.ref = new WeakReference<BasicFileAttributes>(attrs);
        }

        @Override
        public BasicFileAttributes get() {
            return (BasicFileAttributes)this.ref.get();
        }

        @Override
        public void invalidate() {
            this.ref.clear();
        }
    }
}

