/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.keytool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.Timestamp;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs10.PKCS10;
import sun.security.pkcs10.PKCS10Attribute;
import sun.security.provider.certpath.CertStoreHelper;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.PathList;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.tools.keytool.Pair;
import sun.security.util.DerValue;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.ObjectIdentifier;
import sun.security.util.Password;
import sun.security.util.Pem;
import sun.security.util.SecurityProviderConstants;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLReasonCodeExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.DistributionPoint;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectInfoAccessExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class Main {
    private static final byte[] CRLF = new byte[]{13, 10};
    private boolean debug = false;
    private Command command = null;
    private String sigAlgName = null;
    private String keyAlgName = null;
    private boolean verbose = false;
    private int keysize = -1;
    private boolean rfc = false;
    private long validity = 90L;
    private String alias = null;
    private String dname = null;
    private String dest = null;
    private String filename = null;
    private String infilename = null;
    private String outfilename = null;
    private String srcksfname = null;
    private boolean systemLineEndings = false;
    private Set<Pair<String, String>> providers = null;
    private String storetype = null;
    private String srcProviderName = null;
    private String providerName = null;
    private String pathlist = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] newPass = null;
    private char[] destKeyPass = null;
    private char[] srckeyPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private String sslserver = null;
    private String jarfile = null;
    private KeyStore keyStore = null;
    private boolean token = false;
    private boolean nullStream = false;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private boolean nowarn = false;
    private boolean protectedPath = false;
    private boolean srcprotectedPath = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private char[] srcstorePass = null;
    private String srcstoretype = null;
    private Set<char[]> passwords = new HashSet<char[]>();
    private String startDate = null;
    private List<String> ids = new ArrayList<String>();
    private List<String> v3ext = new ArrayList<String>();
    private boolean inplaceImport = false;
    private String inplaceBackupName = null;
    private List<String> weakWarnings = new ArrayList<String>();
    private static final DisabledAlgorithmConstraints DISABLED_CHECK = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");
    private static final Set<CryptoPrimitive> SIG_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Class<?>[] PARAM_STRING = new Class[]{String.class};
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String P12KEYSTORE = "PKCS12";
    private static final String keyAlias = "mykey";
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.keytool.Resources");
    private static final Collator collator = Collator.getInstance();
    private static final String[] extSupported;

    private Main() {
    }

    public static void main(String[] args) throws Exception {
        Main kt = new Main();
        kt.run(args, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args, PrintStream out) throws Exception {
        block10: {
            try {
                this.parseArgs(args);
                if (this.command != null) {
                    this.doCommands(out);
                }
            }
            catch (Exception e) {
                System.out.println(rb.getString("keytool.error.") + e);
                if (this.verbose) {
                    e.printStackTrace(System.out);
                }
                if (!this.debug) {
                    System.exit(1);
                    break block10;
                }
                throw e;
            }
            finally {
                this.printWeakWarnings(false);
                for (char[] pass : this.passwords) {
                    if (pass == null) continue;
                    Arrays.fill(pass, ' ');
                    pass = null;
                }
                if (this.ksStream != null) {
                    this.ksStream.close();
                }
            }
        }
    }

    void parseArgs(String[] args) {
        int i = 0;
        boolean help = args.length == 0;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String flags = args[i];
            if (i == args.length - 1) {
                for (Option option : Option.values()) {
                    if (collator.compare(flags, option.toString()) != 0) continue;
                    if (option.arg == null) break;
                    this.errorNeedArgument(flags);
                    break;
                }
            }
            String modifier = null;
            int pos = flags.indexOf(58);
            if (pos > 0) {
                modifier = flags.substring(pos + 1);
                flags = flags.substring(0, pos);
            }
            boolean isCommand = false;
            for (Command c : Command.values()) {
                if (collator.compare(flags, c.toString()) != 0) continue;
                this.command = c;
                isCommand = true;
                break;
            }
            if (isCommand) continue;
            if (collator.compare(flags, "-export") == 0) {
                this.command = Command.EXPORTCERT;
                continue;
            }
            if (collator.compare(flags, "-genkey") == 0) {
                this.command = Command.GENKEYPAIR;
                continue;
            }
            if (collator.compare(flags, "-import") == 0) {
                this.command = Command.IMPORTCERT;
                continue;
            }
            if (collator.compare(flags, "-importpassword") == 0) {
                this.command = Command.IMPORTPASS;
                continue;
            }
            if (collator.compare(flags, "-help") == 0) {
                help = true;
                continue;
            }
            if (collator.compare(flags, "-nowarn") == 0) {
                this.nowarn = true;
                continue;
            }
            if (collator.compare(flags, "-keystore") == 0 || collator.compare(flags, "-destkeystore") == 0) {
                this.ksfname = args[++i];
                continue;
            }
            if (collator.compare(flags, "-storepass") == 0 || collator.compare(flags, "-deststorepass") == 0) {
                this.storePass = this.getPass(modifier, args[++i]);
                this.passwords.add(this.storePass);
                continue;
            }
            if (collator.compare(flags, "-storetype") == 0 || collator.compare(flags, "-deststoretype") == 0) {
                this.storetype = KeyStoreUtil.niceStoreTypeName(args[++i]);
                continue;
            }
            if (collator.compare(flags, "-srcstorepass") == 0) {
                this.srcstorePass = this.getPass(modifier, args[++i]);
                this.passwords.add(this.srcstorePass);
                continue;
            }
            if (collator.compare(flags, "-srcstoretype") == 0) {
                this.srcstoretype = KeyStoreUtil.niceStoreTypeName(args[++i]);
                continue;
            }
            if (collator.compare(flags, "-srckeypass") == 0) {
                this.srckeyPass = this.getPass(modifier, args[++i]);
                this.passwords.add(this.srckeyPass);
                continue;
            }
            if (collator.compare(flags, "-srcprovidername") == 0) {
                this.srcProviderName = args[++i];
                continue;
            }
            if (collator.compare(flags, "-providername") == 0 || collator.compare(flags, "-destprovidername") == 0) {
                this.providerName = args[++i];
                continue;
            }
            if (collator.compare(flags, "-providerpath") == 0) {
                this.pathlist = args[++i];
                continue;
            }
            if (collator.compare(flags, "-keypass") == 0) {
                this.keyPass = this.getPass(modifier, args[++i]);
                this.passwords.add(this.keyPass);
                continue;
            }
            if (collator.compare(flags, "-new") == 0) {
                this.newPass = this.getPass(modifier, args[++i]);
                this.passwords.add(this.newPass);
                continue;
            }
            if (collator.compare(flags, "-destkeypass") == 0) {
                this.destKeyPass = this.getPass(modifier, args[++i]);
                this.passwords.add(this.destKeyPass);
                continue;
            }
            if (collator.compare(flags, "-alias") == 0 || collator.compare(flags, "-srcalias") == 0) {
                this.alias = args[++i];
                continue;
            }
            if (collator.compare(flags, "-dest") == 0 || collator.compare(flags, "-destalias") == 0) {
                this.dest = args[++i];
                continue;
            }
            if (collator.compare(flags, "-dname") == 0) {
                this.dname = args[++i];
                continue;
            }
            if (collator.compare(flags, "-keysize") == 0) {
                this.keysize = Integer.parseInt(args[++i]);
                continue;
            }
            if (collator.compare(flags, "-keyalg") == 0) {
                this.keyAlgName = args[++i];
                continue;
            }
            if (collator.compare(flags, "-sigalg") == 0) {
                this.sigAlgName = args[++i];
                continue;
            }
            if (collator.compare(flags, "-startdate") == 0) {
                this.startDate = args[++i];
                continue;
            }
            if (collator.compare(flags, "-validity") == 0) {
                this.validity = Long.parseLong(args[++i]);
                continue;
            }
            if (collator.compare(flags, "-ext") == 0) {
                this.v3ext.add(args[++i]);
                continue;
            }
            if (collator.compare(flags, "-id") == 0) {
                this.ids.add(args[++i]);
                continue;
            }
            if (collator.compare(flags, "-file") == 0) {
                this.filename = args[++i];
                continue;
            }
            if (collator.compare(flags, "-infile") == 0) {
                this.infilename = args[++i];
                continue;
            }
            if (collator.compare(flags, "-outfile") == 0) {
                this.outfilename = args[++i];
                continue;
            }
            if (collator.compare(flags, "-sslserver") == 0) {
                this.sslserver = args[++i];
                continue;
            }
            if (collator.compare(flags, "-jarfile") == 0) {
                this.jarfile = args[++i];
                continue;
            }
            if (collator.compare(flags, "-srckeystore") == 0) {
                this.srcksfname = args[++i];
                continue;
            }
            if (collator.compare(flags, "-provider") == 0 || collator.compare(flags, "-providerclass") == 0) {
                if (this.providers == null) {
                    this.providers = new HashSet<Pair<String, String>>(3);
                }
                String string = args[++i];
                String providerArg = null;
                if (args.length > i + 1 && collator.compare(flags = args[i + 1], "-providerarg") == 0) {
                    if (args.length == i + 2) {
                        this.errorNeedArgument(flags);
                    }
                    providerArg = args[i + 2];
                    i += 2;
                }
                this.providers.add(Pair.of(string, providerArg));
                continue;
            }
            if (collator.compare(flags, "-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(flags, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(flags, "-rfc") == 0) {
                this.rfc = true;
                continue;
            }
            if (collator.compare(flags, "-noprompt") == 0) {
                this.noprompt = true;
                continue;
            }
            if (collator.compare(flags, "-trustcacerts") == 0) {
                this.trustcacerts = true;
                continue;
            }
            if (collator.compare(flags, "-protected") == 0 || collator.compare(flags, "-destprotected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare(flags, "-srcprotected") == 0) {
                this.srcprotectedPath = true;
                continue;
            }
            if (collator.compare(flags, "-systemlineendings") == 0) {
                this.systemLineEndings = true;
                continue;
            }
            System.err.println(rb.getString("Illegal.option.") + flags);
            this.tinyHelp();
        }
        if (i < args.length) {
            System.err.println(rb.getString("Illegal.option.") + args[i]);
            this.tinyHelp();
        }
        if (this.command == null) {
            if (help) {
                this.usage();
            } else {
                System.err.println(rb.getString("Usage.error.no.command.provided"));
                this.tinyHelp();
            }
        } else if (help) {
            this.usage();
            this.command = null;
        }
    }

    boolean isKeyStoreRelated(Command cmd) {
        return cmd != Command.PRINTCERT && cmd != Command.PRINTCERTREQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    void doCommands(PrintStream out) throws Exception {
        block228: {
            if ("PKCS11".equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.token = true;
                if (this.ksfname == null) {
                    this.ksfname = "NONE";
                }
            }
            if ("NONE".equals(this.ksfname)) {
                this.nullStream = true;
            }
            if (this.token && !this.nullStream) {
                System.err.println(MessageFormat.format(Main.rb.getString(".keystore.must.be.NONE.if.storetype.is.{0}"), new Object[]{this.storetype}));
                System.err.println();
                this.tinyHelp();
            }
            if (this.token && (this.command == Command.KEYPASSWD || this.command == Command.STOREPASSWD)) {
                throw new UnsupportedOperationException(MessageFormat.format(Main.rb.getString(".storepasswd.and.keypasswd.commands.not.supported.if.storetype.is.{0}"), new Object[]{this.storetype}));
            }
            if (this.token && (this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(MessageFormat.format(Main.rb.getString(".keypass.and.new.can.not.be.specified.if.storetype.is.{0}"), new Object[]{this.storetype}));
            }
            if (this.protectedPath && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.protected.is.specified.then.storepass.keypass.and.new.must.not.be.specified"));
            }
            if (this.srcprotectedPath && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.srcprotected.is.specified.then.srcstorepass.and.srckeypass.must.not.be.specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.storetype) && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.keystore.is.not.password.protected.then.storepass.keypass.and.new.must.not.be.specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.srcstoretype) && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.source.keystore.is.not.password.protected.then.srcstorepass.and.srckeypass.must.not.be.specified"));
            }
            if (this.validity <= 0L) {
                throw new Exception(Main.rb.getString("Validity.must.be.greater.than.zero"));
            }
            if (this.providers != null) {
                cl = null;
                if (this.pathlist != null) {
                    path = null;
                    path = PathList.appendPath(path, System.getProperty("java.class.path"));
                    path = PathList.appendPath((String)path, System.getProperty("env.class.path"));
                    path = PathList.appendPath((String)path, this.pathlist);
                    urls = PathList.pathToURLs((String)path);
                    cl = new URLClassLoader(urls);
                } else {
                    cl = ClassLoader.getSystemClassLoader();
                }
                for (Pair provider : this.providers) {
                    provName = (String)provider.fst;
                    provClass = cl != null ? cl.loadClass(provName) : Class.forName(provName);
                    provArg = (String)provider.snd;
                    if (provArg == null) {
                        obj = provClass.newInstance();
                    } else {
                        c = provClass.getConstructor(Main.PARAM_STRING);
                        obj = c.newInstance(new Object[]{provArg});
                    }
                    if (!(obj instanceof Provider)) {
                        form = new MessageFormat(Main.rb.getString("provName.not.a.provider"));
                        source = new Object[]{provName};
                        throw new Exception(form.format(source));
                    }
                    Security.addProvider((Provider)obj);
                }
            }
            if (this.command == Command.LIST && this.verbose && this.rfc) {
                System.err.println(Main.rb.getString("Must.not.specify.both.v.and.rfc.with.list.command"));
                this.tinyHelp();
            }
            if (this.command == Command.GENKEYPAIR && this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception(Main.rb.getString("Key.password.must.be.at.least.6.characters"));
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception(Main.rb.getString("New.password.must.be.at.least.6.characters"));
            }
            if (this.destKeyPass != null && this.destKeyPass.length < 6) {
                throw new Exception(Main.rb.getString("New.password.must.be.at.least.6.characters"));
            }
            if (this.ksfname == null) {
                this.ksfname = System.getProperty("user.home") + File.separator + ".keystore";
            }
            srcKeyStore = null;
            if (this.command == Command.IMPORTKEYSTORE) {
                this.inplaceImport = this.inplaceImportCheck();
                if (this.inplaceImport) {
                    srcKeyStore = this.loadSourceKeyStore();
                    if (this.storePass == null) {
                        this.storePass = this.srcstorePass;
                    }
                }
            }
            if (this.isKeyStoreRelated(this.command) && !this.nullStream && !this.inplaceImport) {
                try {
                    this.ksfile = new File(this.ksfname);
                    if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                        throw new Exception(Main.rb.getString("Keystore.file.exists.but.is.empty.") + this.ksfname);
                    }
                    this.ksStream = new FileInputStream(this.ksfile);
                }
                catch (FileNotFoundException e) {
                    if (this.command == Command.GENKEYPAIR || this.command == Command.GENSECKEY || this.command == Command.IDENTITYDB || this.command == Command.IMPORTCERT || this.command == Command.IMPORTPASS || this.command == Command.IMPORTKEYSTORE || this.command == Command.PRINTCRL) break block228;
                    throw new Exception(Main.rb.getString("Keystore.file.does.not.exist.") + this.ksfname);
                }
            }
        }
        if ((this.command == Command.KEYCLONE || this.command == Command.CHANGEALIAS) && this.dest == null) {
            this.dest = this.getAlias("destination");
            if ("".equals(this.dest)) {
                throw new Exception(Main.rb.getString("Must.specify.destination.alias"));
            }
        }
        if (this.command == Command.DELETE && this.alias == null) {
            this.alias = this.getAlias(null);
            if ("".equals(this.alias)) {
                throw new Exception(Main.rb.getString("Must.specify.alias"));
            }
        }
        if (this.storetype == null) {
            this.storetype = KeyStore.getDefaultType();
        }
        this.keyStore = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
        if (!this.nullStream) {
            if (this.inplaceImport) {
                this.keyStore.load(null, this.storePass);
            } else {
                this.keyStore.load(this.ksStream, this.storePass);
            }
            if (this.ksStream != null) {
                this.ksStream.close();
            }
        }
        if ("PKCS12".equalsIgnoreCase(this.storetype) && this.command == Command.KEYPASSWD) {
            throw new UnsupportedOperationException(Main.rb.getString(".keypasswd.commands.not.supported.if.storetype.is.PKCS12"));
        }
        if (this.nullStream && this.storePass != null) {
            this.keyStore.load(null, this.storePass);
        } else if (!this.nullStream && this.storePass != null) {
            if (this.ksStream == null && this.storePass.length < 6) {
                throw new Exception(Main.rb.getString("Keystore.password.must.be.at.least.6.characters"));
            }
        } else if (this.storePass == null) {
            if (!(this.protectedPath || KeyStoreUtil.isWindowsKeyStore(this.storetype) || this.command != Command.CERTREQ && this.command != Command.DELETE && this.command != Command.GENKEYPAIR && this.command != Command.GENSECKEY && this.command != Command.IMPORTCERT && this.command != Command.IMPORTPASS && this.command != Command.IMPORTKEYSTORE && this.command != Command.KEYCLONE && this.command != Command.CHANGEALIAS && this.command != Command.SELFCERT && this.command != Command.STOREPASSWD && this.command != Command.KEYPASSWD && this.command != Command.IDENTITYDB)) {
                count = 0;
                do {
                    if (this.command == Command.IMPORTKEYSTORE) {
                        System.err.print(Main.rb.getString("Enter.destination.keystore.password."));
                    } else {
                        System.err.print(Main.rb.getString("Enter.keystore.password."));
                    }
                    System.err.flush();
                    this.storePass = Password.readPassword(System.in);
                    this.passwords.add(this.storePass);
                    if (!(this.nullStream || this.storePass != null && this.storePass.length >= 6)) {
                        System.err.println(Main.rb.getString("Keystore.password.is.too.short.must.be.at.least.6.characters"));
                        this.storePass = null;
                    }
                    if (this.storePass == null || this.nullStream || this.ksStream != null) continue;
                    System.err.print(Main.rb.getString("Re.enter.new.password."));
                    storePassAgain = Password.readPassword(System.in);
                    this.passwords.add(storePassAgain);
                    if (Arrays.equals(this.storePass, storePassAgain)) continue;
                    System.err.println(Main.rb.getString("They.don.t.match.Try.again"));
                    this.storePass = null;
                } while (this.storePass == null && ++count < 3);
                if (this.storePass == null) {
                    System.err.println(Main.rb.getString("Too.many.failures.try.later"));
                    return;
                }
            } else if (!this.protectedPath && !KeyStoreUtil.isWindowsKeyStore(this.storetype) && this.isKeyStoreRelated(this.command) && this.command != Command.PRINTCRL) {
                System.err.print(Main.rb.getString("Enter.keystore.password."));
                System.err.flush();
                this.storePass = Password.readPassword(System.in);
                this.passwords.add(this.storePass);
            }
            if (this.nullStream) {
                this.keyStore.load(null, this.storePass);
            } else if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.storePass != null && "PKCS12".equalsIgnoreCase(this.storetype)) {
            form = new MessageFormat(Main.rb.getString("Warning.Different.store.and.key.passwords.not.supported.for.PKCS12.KeyStores.Ignoring.user.specified.command.value."));
            if (this.keyPass != null && !Arrays.equals(this.storePass, this.keyPass)) {
                source = new Object[]{"-keypass"};
                System.err.println(form.format(source));
                this.keyPass = this.storePass;
            }
            if (this.newPass != null && !Arrays.equals(this.storePass, this.newPass)) {
                source = new Object[]{"-new"};
                System.err.println(form.format(source));
                this.newPass = this.storePass;
            }
            if (this.destKeyPass != null && !Arrays.equals(this.storePass, this.destKeyPass)) {
                source = new Object[]{"-destkeypass"};
                System.err.println(form.format(source));
                this.destKeyPass = this.storePass;
            }
        }
        if (this.command == Command.PRINTCERT || this.command == Command.IMPORTCERT || this.command == Command.IDENTITYDB || this.command == Command.PRINTCRL) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.command != Command.IMPORTCERT) {
            this.trustcacerts = false;
        }
        if (this.trustcacerts) {
            this.caks = KeyStoreUtil.getCacertsKeyStore();
        }
        if (this.command == Command.CERTREQ) {
            if (this.filename != null) {
                ps = new PrintStream(new FileOutputStream(this.filename));
                source = null;
                try {
                    this.doCertReq(this.alias, this.sigAlgName, ps);
                }
                catch (Throwable provName) {
                    source = provName;
                    throw provName;
                }
                finally {
                    if (ps != null) {
                        if (source != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable provName) {
                                source.addSuppressed(provName);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            } else {
                this.doCertReq(this.alias, this.sigAlgName, out);
            }
            if (this.verbose && this.filename != null) {
                form = new MessageFormat(Main.rb.getString("Certification.request.stored.in.file.filename."));
                source = new Object[]{this.filename};
                System.err.println(form.format(source));
                System.err.println(Main.rb.getString("Submit.this.to.your.CA"));
            }
        } else if (this.command == Command.DELETE) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command == Command.EXPORTCERT) {
            if (this.filename != null) {
                ps = new PrintStream(new FileOutputStream(this.filename));
                source = null;
                try {
                    this.doExportCert(this.alias, ps);
                }
                catch (Throwable provName) {
                    source = provName;
                    throw provName;
                }
                finally {
                    if (ps != null) {
                        if (source != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable provName) {
                                source.addSuppressed(provName);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            } else {
                this.doExportCert(this.alias, out);
            }
            if (this.filename != null) {
                form = new MessageFormat(Main.rb.getString("Certificate.stored.in.file.filename."));
                source = new Object[]{this.filename};
                System.err.println(form.format(source));
            }
        } else if (this.command == Command.GENKEYPAIR) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DSA";
            }
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == Command.GENSECKEY) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DES";
            }
            this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
            this.kssave = true;
        } else if (this.command == Command.IMPORTPASS) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "PBE";
            }
            this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
            this.kssave = true;
        } else if (this.command == Command.IDENTITYDB) {
            if (this.filename != null) {
                inStream = new FileInputStream(this.filename);
                source = null;
                try {
                    this.doImportIdentityDatabase(inStream);
                }
                catch (Throwable provName) {
                    source = provName;
                    throw provName;
                }
                finally {
                    if (inStream != null) {
                        if (source != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable provName) {
                                source.addSuppressed(provName);
                            }
                        } else {
                            inStream.close();
                        }
                    }
                }
            } else {
                this.doImportIdentityDatabase(System.in);
            }
        } else if (this.command == Command.IMPORTCERT) {
            inStream = System.in;
            if (this.filename != null) {
                inStream = new FileInputStream(this.filename);
            }
            importAlias = this.alias != null ? this.alias : "mykey";
            try {
                if (this.keyStore.entryInstanceOf(importAlias, KeyStore.PrivateKeyEntry.class)) {
                    this.kssave = this.installReply(importAlias, inStream);
                    if (this.kssave) {
                        System.err.println(Main.rb.getString("Certificate.reply.was.installed.in.keystore"));
                    }
                    System.err.println(Main.rb.getString("Certificate.reply.was.not.installed.in.keystore"));
                }
                if (this.keyStore.containsAlias(importAlias) && !this.keyStore.entryInstanceOf(importAlias, KeyStore.TrustedCertificateEntry.class)) ** GOTO lbl417
                this.kssave = this.addTrustedCert(importAlias, inStream);
                if (this.kssave) {
                    System.err.println(Main.rb.getString("Certificate.was.added.to.keystore"));
                }
                System.err.println(Main.rb.getString("Certificate.was.not.added.to.keystore"));
            }
            finally {
                if (inStream != System.in) {
                    inStream.close();
                }
            }
        } else if (this.command == Command.IMPORTKEYSTORE) {
            if (srcKeyStore == null) {
                srcKeyStore = this.loadSourceKeyStore();
            }
            this.doImportKeyStore(srcKeyStore);
            this.kssave = true;
        } else if (this.command == Command.KEYCLONE) {
            this.keyPassNew = this.newPass;
            if (this.alias == null) {
                this.alias = "mykey";
            }
            if (!this.keyStore.containsAlias(this.alias)) {
                form = new MessageFormat(Main.rb.getString("Alias.alias.does.not.exist"));
                source = new Object[]{this.alias};
                throw new Exception(form.format(source));
            }
            if (!this.keyStore.entryInstanceOf(this.alias, KeyStore.PrivateKeyEntry.class)) {
                form = new MessageFormat(Main.rb.getString("Alias.alias.references.an.entry.type.that.is.not.a.private.key.entry.The.keyclone.command.only.supports.cloning.of.private.key"));
                source = new Object[]{this.alias};
                throw new Exception(form.format(source));
            }
            this.doCloneEntry(this.alias, this.dest, true);
            this.kssave = true;
        } else if (this.command == Command.CHANGEALIAS) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            this.doCloneEntry(this.alias, this.dest, false);
            if (this.keyStore.containsAlias(this.alias)) {
                this.doDeleteEntry(this.alias);
            }
            this.kssave = true;
        } else if (this.command == Command.KEYPASSWD) {
            this.keyPassNew = this.newPass;
            this.doChangeKeyPasswd(this.alias);
            this.kssave = true;
        } else if (this.command == Command.LIST) {
            if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.printNoIntegrityWarning();
            }
            if (this.alias != null) {
                this.doPrintEntry(Main.rb.getString("the.certificate"), this.alias, out);
            } else {
                this.doPrintEntries(out);
            }
        } else if (this.command == Command.PRINTCERT) {
            this.doPrintCert(out);
        } else if (this.command == Command.SELFCERT) {
            this.doSelfCert(this.alias, this.dname, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == Command.STOREPASSWD) {
            this.storePassNew = this.newPass;
            if (this.storePassNew == null) {
                this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
            }
            this.kssave = true;
        } else if (this.command == Command.GENCERT) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            inStream = System.in;
            if (this.infilename != null) {
                inStream = new FileInputStream(this.infilename);
            }
            ps = null;
            if (this.outfilename != null) {
                ps = new PrintStream(new FileOutputStream(this.outfilename));
                out = ps;
            }
            try {
                this.doGenCert(this.alias, this.sigAlgName, inStream, out);
            }
            finally {
                if (inStream != System.in) {
                    inStream.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
        } else if (this.command == Command.GENCRL) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            if (this.filename != null) {
                ps = new PrintStream(new FileOutputStream(this.filename));
                ps = null;
                try {
                    this.doGenCRL(ps);
                }
                catch (Throwable provName) {
                    ps = provName;
                    throw provName;
                }
                finally {
                    if (ps != null) {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable provName) {
                                ps.addSuppressed(provName);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            } else {
                this.doGenCRL(out);
            }
        } else if (this.command == Command.PRINTCERTREQ) {
            if (this.filename != null) {
                inStream = new FileInputStream(this.filename);
                ps = null;
                try {
                    this.doPrintCertReq(inStream, out);
                }
                catch (Throwable provName) {
                    ps = provName;
                    throw provName;
                }
                finally {
                    if (inStream != null) {
                        if (ps != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable provName) {
                                ps.addSuppressed(provName);
                            }
                        } else {
                            inStream.close();
                        }
                    }
                }
            } else {
                this.doPrintCertReq(System.in, out);
            }
        } else if (this.command == Command.PRINTCRL) {
            this.doPrintCRL(this.filename, out);
        }
lbl417:
        // 30 sources

        if (this.kssave) {
            if (this.verbose) {
                form = new MessageFormat(Main.rb.getString(".Storing.ksfname."));
                source = new Object[]{this.nullStream != false ? "keystore" : this.ksfname};
                System.err.println(form.format(source));
            }
            if (this.token) {
                this.keyStore.store(null, null);
            } else {
                v0 = pass = this.storePassNew != null ? this.storePassNew : this.storePass;
                if (this.nullStream) {
                    this.keyStore.store(null, pass);
                } else {
                    bout = new ByteArrayOutputStream();
                    this.keyStore.store(bout, pass);
                    fout = new FileOutputStream(this.ksfname);
                    provClass = null;
                    try {
                        fout.write(bout.toByteArray());
                    }
                    catch (Throwable provArg) {
                        provClass = provArg;
                        throw provArg;
                    }
                    finally {
                        if (fout != null) {
                            if (provClass != null) {
                                try {
                                    fout.close();
                                }
                                catch (Throwable provArg) {
                                    provClass.addSuppressed(provArg);
                                }
                            } else {
                                fout.close();
                            }
                        }
                    }
                }
            }
        }
        if (this.isKeyStoreRelated(this.command) && !this.token && !this.nullStream && this.ksfname != null && (f = new File(this.ksfname)).exists()) {
            realType = this.keyStoreType(f);
            if (realType.equalsIgnoreCase("JKS") || realType.equalsIgnoreCase("JCEKS")) {
                allCerts = true;
                for (String a : Collections.list(this.keyStore.aliases())) {
                    if (this.keyStore.entryInstanceOf(a, KeyStore.TrustedCertificateEntry.class)) continue;
                    allCerts = false;
                    break;
                }
                if (!allCerts) {
                    this.weakWarnings.add(String.format(Main.rb.getString("jks.storetype.warning"), new Object[]{realType, this.ksfname}));
                }
            }
            if (this.inplaceImport) {
                realSourceStoreType = this.keyStoreType(new File(this.inplaceBackupName));
                format = realType.equalsIgnoreCase(realSourceStoreType) != false ? Main.rb.getString("backup.keystore.warning") : Main.rb.getString("migrate.keystore.warning");
                this.weakWarnings.add(String.format(format, new Object[]{this.srcksfname, realSourceStoreType, this.inplaceBackupName, realType}));
            }
        }
    }

    private String keyStoreType(File f) throws IOException {
        int MAGIC = -17957139;
        int JCEKS_MAGIC = -825307442;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(f));){
            int xMagic = dis.readInt();
            if (xMagic == MAGIC) {
                String string = "JKS";
                return string;
            }
            if (xMagic == JCEKS_MAGIC) {
                String string = "JCEKS";
                return string;
            }
            String string = "Non JKS/JCEKS";
            return string;
        }
    }

    private void doGenCert(String alias, String sigAlgName, InputStream in, PrintStream out) throws Exception {
        String s;
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Certificate signerCert = this.keyStore.getCertificate(alias);
        byte[] encoded = signerCert.getEncoded();
        X509CertImpl signerCertImpl = new X509CertImpl(encoded);
        X509CertInfo signerCertInfo = (X509CertInfo)signerCertImpl.get("x509.info");
        X500Name issuer = (X500Name)signerCertInfo.get("subject.dname");
        Date firstDate = Main.getStartDate(this.startDate);
        Date lastDate = new Date();
        lastDate.setTime(firstDate.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        PrivateKey privateKey = (PrivateKey)this.recoverKey((String)alias, (char[])this.storePass, (char[])this.keyPass).fst;
        if (sigAlgName == null) {
            sigAlgName = Main.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        Signature signature = Signature.getInstance(sigAlgName);
        signature.initSign(privateKey);
        X509CertInfo info = new X509CertInfo();
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        info.set("version", new CertificateVersion(2));
        info.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(sigAlgName)));
        info.set("issuer", issuer);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        boolean canRead = false;
        StringBuffer sb = new StringBuffer();
        while ((s = reader.readLine()) != null) {
            if (s.startsWith("-----BEGIN") && s.indexOf("REQUEST") >= 0) {
                canRead = true;
                continue;
            }
            if (s.startsWith("-----END") && s.indexOf("REQUEST") >= 0) break;
            if (!canRead) continue;
            sb.append(s);
        }
        byte[] rawReq = Pem.decode(new String(sb));
        PKCS10 req = new PKCS10(rawReq);
        this.checkWeak(rb.getString("the.certificate.request"), req);
        info.set("key", new CertificateX509Key(req.getSubjectPublicKeyInfo()));
        info.set("subject", this.dname == null ? req.getSubjectName() : new X500Name(this.dname));
        CertificateExtensions reqex = null;
        for (PKCS10Attribute attr : req.getAttributes().getAttributes()) {
            if (!attr.getAttributeId().equals((Object)PKCS9Attribute.EXTENSION_REQUEST_OID)) continue;
            reqex = (CertificateExtensions)attr.getAttributeValue();
        }
        CertificateExtensions ext = this.createV3Extensions(reqex, null, this.v3ext, req.getSubjectPublicKeyInfo(), signerCert.getPublicKey());
        info.set("extensions", ext);
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(privateKey, sigAlgName);
        this.dumpCert(cert, out);
        for (Certificate ca : this.keyStore.getCertificateChain(alias)) {
            X509Certificate xca;
            if (!(ca instanceof X509Certificate) || KeyStoreUtil.isSelfSigned(xca = (X509Certificate)ca)) continue;
            this.dumpCert(xca, out);
        }
        this.checkWeak(rb.getString("the.issuer"), this.keyStore.getCertificateChain(alias));
        this.checkWeak(rb.getString("the.generated.certificate"), cert);
    }

    private void doGenCRL(PrintStream out) throws Exception {
        if (this.ids == null) {
            throw new Exception("Must provide -id when -gencrl");
        }
        Certificate signerCert = this.keyStore.getCertificate(this.alias);
        byte[] encoded = signerCert.getEncoded();
        X509CertImpl signerCertImpl = new X509CertImpl(encoded);
        X509CertInfo signerCertInfo = (X509CertInfo)signerCertImpl.get("x509.info");
        X500Name owner = (X500Name)signerCertInfo.get("subject.dname");
        Date firstDate = Main.getStartDate(this.startDate);
        Date lastDate = (Date)firstDate.clone();
        lastDate.setTime(lastDate.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        PrivateKey privateKey = (PrivateKey)this.recoverKey((String)this.alias, (char[])this.storePass, (char[])this.keyPass).fst;
        if (this.sigAlgName == null) {
            this.sigAlgName = Main.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        X509CRLEntry[] badCerts = new X509CRLEntry[this.ids.size()];
        for (int i = 0; i < this.ids.size(); ++i) {
            String id = this.ids.get(i);
            int d = id.indexOf(58);
            if (d >= 0) {
                CRLExtensions ext = new CRLExtensions();
                ext.set("Reason", new CRLReasonCodeExtension(Integer.parseInt(id.substring(d + 1))));
                badCerts[i] = new X509CRLEntryImpl(new BigInteger(id.substring(0, d)), firstDate, ext);
                continue;
            }
            badCerts[i] = new X509CRLEntryImpl(new BigInteger(this.ids.get(i)), firstDate);
        }
        X509CRLImpl crl = new X509CRLImpl(owner, firstDate, lastDate, badCerts);
        crl.sign(privateKey, this.sigAlgName);
        if (this.rfc) {
            out.println("-----BEGIN X509 CRL-----");
            out.println(Base64.getMimeEncoder(64, CRLF).encodeToString(crl.getEncodedInternal()));
            out.println("-----END X509 CRL-----");
        } else {
            out.write(crl.getEncodedInternal());
        }
        this.checkWeak(rb.getString("the.generated.crl"), crl, (Key)privateKey);
    }

    private void doCertReq(String alias, String sigAlgName, PrintStream out) throws Exception {
        Certificate cert;
        if (alias == null) {
            alias = keyAlias;
        }
        Pair<Key, char[]> objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])objs.snd;
        }
        if ((cert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias.has.no.public.key.certificate."));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        PKCS10 request = new PKCS10(cert.getPublicKey());
        CertificateExtensions ext = this.createV3Extensions(null, null, this.v3ext, cert.getPublicKey(), null);
        request.getAttributes().setAttribute("extensions", new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, ext));
        if (sigAlgName == null) {
            sigAlgName = Main.getCompatibleSigAlgName(privKey.getAlgorithm());
        }
        Signature signature = Signature.getInstance(sigAlgName);
        signature.initSign(privKey);
        X500Name subject = this.dname == null ? new X500Name(((X509Certificate)cert).getSubjectDN().toString()) : new X500Name(this.dname);
        request.encodeAndSign(subject, signature);
        request.print(out, this.systemLineEndings);
        this.checkWeak(rb.getString("the.generated.certificate.request"), request);
    }

    private void doDeleteEntry(String alias) throws Exception {
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        this.keyStore.deleteEntry(alias);
    }

    private void doExportCert(String alias, PrintStream out) throws Exception {
        if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printNoIntegrityWarning();
        }
        if (alias == null) {
            alias = keyAlias;
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
        if (cert == null) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.has.no.certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        this.dumpCert(cert, out);
        this.checkWeak(rb.getString("the.certificate"), cert);
    }

    private char[] promptForKeyPass(String alias, String orig, char[] origPass) throws Exception {
        if (P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
            return origPass;
        }
        if (!this.token && !this.protectedPath) {
            int count;
            for (count = 0; count < 3; ++count) {
                MessageFormat form = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                Object[] source = new Object[]{alias};
                System.err.println(form.format(source));
                if (orig == null) {
                    System.err.print(rb.getString(".RETURN.if.same.as.keystore.password."));
                } else {
                    form = new MessageFormat(rb.getString(".RETURN.if.same.as.for.otherAlias."));
                    Object[] src = new Object[]{orig};
                    System.err.print(form.format(src));
                }
                System.err.flush();
                char[] entered = Password.readPassword(System.in);
                this.passwords.add(entered);
                if (entered == null) {
                    return origPass;
                }
                if (entered.length >= 6) {
                    System.err.print(rb.getString("Re.enter.new.password."));
                    char[] passAgain = Password.readPassword(System.in);
                    this.passwords.add(passAgain);
                    if (!Arrays.equals(entered, passAgain)) {
                        System.err.println(rb.getString("They.don.t.match.Try.again"));
                        continue;
                    }
                    return entered;
                }
                System.err.println(rb.getString("Key.password.is.too.short.must.be.at.least.6.characters"));
            }
            if (count == 3) {
                if (this.command == Command.KEYCLONE) {
                    throw new Exception(rb.getString("Too.many.failures.Key.entry.not.cloned"));
                }
                throw new Exception(rb.getString("Too.many.failures.key.not.added.to.keystore"));
            }
        }
        return null;
    }

    private char[] promptForCredential() throws Exception {
        int count;
        if (System.console() == null) {
            char[] importPass = Password.readPassword(System.in);
            this.passwords.add(importPass);
            return importPass;
        }
        for (count = 0; count < 3; ++count) {
            System.err.print(rb.getString("Enter.the.password.to.be.stored."));
            System.err.flush();
            char[] entered = Password.readPassword(System.in);
            this.passwords.add(entered);
            System.err.print(rb.getString("Re.enter.password."));
            char[] passAgain = Password.readPassword(System.in);
            this.passwords.add(passAgain);
            if (Arrays.equals(entered, passAgain)) {
                return entered;
            }
            System.err.println(rb.getString("They.don.t.match.Try.again"));
        }
        if (count == 3) {
            throw new Exception(rb.getString("Too.many.failures.key.not.added.to.keystore"));
        }
        return null;
    }

    private void doGenSecretKey(String alias, String keyAlgName, int keysize) throws Exception {
        if (alias == null) {
            alias = keyAlias;
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Secret.key.not.generated.alias.alias.already.exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        boolean useDefaultPBEAlgorithm = true;
        SecretKey secKey = null;
        if (keyAlgName.toUpperCase(Locale.ENGLISH).startsWith("PBE")) {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            secKey = factory.generateSecret(new PBEKeySpec(this.promptForCredential()));
            if (!"PBE".equalsIgnoreCase(keyAlgName)) {
                useDefaultPBEAlgorithm = false;
            }
            if (this.verbose) {
                MessageFormat form = new MessageFormat(rb.getString("Generated.keyAlgName.secret.key"));
                Object[] source = new Object[]{useDefaultPBEAlgorithm ? "PBE" : secKey.getAlgorithm()};
                System.err.println(form.format(source));
            }
        } else {
            KeyGenerator keygen = KeyGenerator.getInstance(keyAlgName);
            if (keysize == -1) {
                if ("DES".equalsIgnoreCase(keyAlgName)) {
                    keysize = 56;
                } else if ("DESede".equalsIgnoreCase(keyAlgName)) {
                    keysize = 168;
                } else {
                    throw new Exception(rb.getString("Please.provide.keysize.for.secret.key.generation"));
                }
            }
            keygen.init(keysize);
            secKey = keygen.generateKey();
            if (this.verbose) {
                MessageFormat form = new MessageFormat(rb.getString("Generated.keysize.bit.keyAlgName.secret.key"));
                Object[] source = new Object[]{new Integer(keysize), secKey.getAlgorithm()};
                System.err.println(form.format(source));
            }
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(alias, null, this.storePass);
        }
        if (useDefaultPBEAlgorithm) {
            this.keyStore.setKeyEntry(alias, secKey, this.keyPass, null);
        } else {
            this.keyStore.setEntry(alias, new KeyStore.SecretKeyEntry(secKey), new KeyStore.PasswordProtection(this.keyPass, keyAlgName, null));
        }
    }

    private static String getCompatibleSigAlgName(String keyAlgName) throws Exception {
        if ("DSA".equalsIgnoreCase(keyAlgName)) {
            return "SHA256WithDSA";
        }
        if ("RSA".equalsIgnoreCase(keyAlgName)) {
            return "SHA256WithRSA";
        }
        if ("EC".equalsIgnoreCase(keyAlgName)) {
            return "SHA256withECDSA";
        }
        throw new Exception(rb.getString("Cannot.derive.signature.algorithm"));
    }

    private void doGenKeyPair(String alias, String dname, String keyAlgName, int keysize, String sigAlgName) throws Exception {
        if (keysize == -1) {
            if ("EC".equalsIgnoreCase(keyAlgName)) {
                keysize = SecurityProviderConstants.DEF_EC_KEY_SIZE;
            } else if ("RSA".equalsIgnoreCase(keyAlgName)) {
                keysize = SecurityProviderConstants.DEF_RSA_KEY_SIZE;
            } else if ("DSA".equalsIgnoreCase(keyAlgName)) {
                keysize = SecurityProviderConstants.DEF_DSA_KEY_SIZE;
            }
        }
        if (alias == null) {
            alias = keyAlias;
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Key.pair.not.generated.alias.alias.already.exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (sigAlgName == null) {
            sigAlgName = Main.getCompatibleSigAlgName(keyAlgName);
        }
        CertAndKeyGen keypair = new CertAndKeyGen(keyAlgName, sigAlgName, this.providerName);
        X500Name x500Name = dname == null ? this.getX500Name() : new X500Name(dname);
        keypair.generate(keysize);
        PrivateKey privKey = keypair.getPrivateKey();
        CertificateExtensions ext = this.createV3Extensions(null, null, this.v3ext, keypair.getPublicKeyAnyway(), null);
        Certificate[] chain = new X509Certificate[]{keypair.getSelfCertificate(x500Name, Main.getStartDate(this.startDate), this.validity * 24L * 60L * 60L, ext)};
        if (this.verbose) {
            MessageFormat form = new MessageFormat(rb.getString("Generating.keysize.bit.keyAlgName.key.pair.and.self.signed.certificate.sigAlgName.with.a.validity.of.validality.days.for"));
            Object[] source = new Object[]{new Integer(keysize), privKey.getAlgorithm(), ((X509Certificate)chain[0]).getSigAlgName(), new Long(this.validity), x500Name};
            System.err.println(form.format(source));
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(alias, null, this.storePass);
        }
        this.checkWeak(rb.getString("the.generated.certificate"), chain[0]);
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass, chain);
    }

    private void doCloneEntry(String orig, String dest, boolean changePassword) throws Exception {
        if (orig == null) {
            orig = keyAlias;
        }
        if (this.keyStore.containsAlias(dest)) {
            MessageFormat form = new MessageFormat(rb.getString("Destination.alias.dest.already.exists"));
            Object[] source = new Object[]{dest};
            throw new Exception(form.format(source));
        }
        Pair<KeyStore.Entry, char[]> objs = this.recoverEntry(this.keyStore, orig, this.storePass, this.keyPass);
        KeyStore.Entry entry = (KeyStore.Entry)objs.fst;
        this.keyPass = (char[])objs.snd;
        KeyStore.PasswordProtection pp = null;
        if (this.keyPass != null) {
            if (!changePassword || P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
                this.keyPassNew = this.keyPass;
            } else if (this.keyPassNew == null) {
                this.keyPassNew = this.promptForKeyPass(dest, orig, this.keyPass);
            }
            pp = new KeyStore.PasswordProtection(this.keyPassNew);
        }
        this.keyStore.setEntry(dest, entry, pp);
    }

    private void doChangeKeyPasswd(String alias) throws Exception {
        if (alias == null) {
            alias = keyAlias;
        }
        Pair<Key, char[]> objs = this.recoverKey(alias, this.storePass, this.keyPass);
        Key privKey = (Key)objs.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])objs.snd;
        }
        if (this.keyPassNew == null) {
            MessageFormat form = new MessageFormat(rb.getString("key.password.for.alias."));
            Object[] source = new Object[]{alias};
            this.keyPassNew = this.getNewPasswd(form.format(source), this.keyPass);
        }
        this.keyStore.setKeyEntry(alias, privKey, this.keyPassNew, this.keyStore.getCertificateChain(alias));
    }

    private void doImportIdentityDatabase(InputStream in) throws Exception {
        System.err.println(rb.getString("No.entries.from.identity.database.added"));
    }

    private void doPrintEntry(String label, String alias, PrintStream out) throws Exception {
        Object[] source;
        Object[] source2;
        MessageFormat form;
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form2 = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] source3 = new Object[]{alias};
            throw new Exception(form2.format(source3));
        }
        if (this.verbose || this.rfc || this.debug) {
            form = new MessageFormat(rb.getString("Alias.name.alias"));
            source2 = new Object[]{alias};
            out.println(form.format(source2));
            if (!this.token) {
                form = new MessageFormat(rb.getString("Creation.date.keyStore.getCreationDate.alias."));
                Object[] src = new Object[]{this.keyStore.getCreationDate(alias)};
                out.println(form.format(src));
            }
        } else if (!this.token) {
            form = new MessageFormat(rb.getString("alias.keyStore.getCreationDate.alias."));
            source2 = new Object[]{alias, this.keyStore.getCreationDate(alias)};
            out.print(form.format(source2));
        } else {
            form = new MessageFormat(rb.getString("alias."));
            source2 = new Object[]{alias};
            out.print(form.format(source2));
        }
        if (this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                source = new Object[]{"SecretKeyEntry"};
                out.println(new MessageFormat(rb.getString("Entry.type.type.")).format(source));
            } else {
                out.println("SecretKeyEntry, ");
            }
        } else if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                source = new Object[]{"PrivateKeyEntry"};
                out.println(new MessageFormat(rb.getString("Entry.type.type.")).format(source));
            } else {
                out.println("PrivateKeyEntry, ");
            }
            Certificate[] chain = this.keyStore.getCertificateChain(alias);
            if (chain != null) {
                if (this.verbose || this.rfc || this.debug) {
                    out.println(rb.getString("Certificate.chain.length.") + chain.length);
                    for (int i = 0; i < chain.length; ++i) {
                        MessageFormat form3 = new MessageFormat(rb.getString("Certificate.i.1."));
                        Object[] source4 = new Object[]{new Integer(i + 1)};
                        out.println(form3.format(source4));
                        if (this.verbose && chain[i] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)chain[i], out);
                        } else if (this.debug) {
                            out.println(chain[i].toString());
                        } else {
                            this.dumpCert(chain[i], out);
                        }
                        this.checkWeak(label, chain[i]);
                    }
                } else {
                    out.println(rb.getString("Certificate.fingerprint.SHA1.") + this.getCertFingerPrint("SHA1", chain[0]));
                    this.checkWeak(label, chain[0]);
                }
            }
        } else if (this.keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
            Certificate cert = this.keyStore.getCertificate(alias);
            source2 = new Object[]{"trustedCertEntry"};
            String mf = new MessageFormat(rb.getString("Entry.type.type.")).format(source2) + "\n";
            if (this.verbose && cert instanceof X509Certificate) {
                out.println(mf);
                this.printX509Cert((X509Certificate)cert, out);
            } else if (this.rfc) {
                out.println(mf);
                this.dumpCert(cert, out);
            } else if (this.debug) {
                out.println(cert.toString());
            } else {
                out.println("trustedCertEntry, ");
                out.println(rb.getString("Certificate.fingerprint.SHA1.") + this.getCertFingerPrint("SHA1", cert));
            }
            this.checkWeak(label, cert);
        } else {
            out.println(rb.getString("Unknown.Entry.Type"));
        }
    }

    boolean inplaceImportCheck() throws Exception {
        if (P11KEYSTORE.equalsIgnoreCase(this.srcstoretype) || KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            return false;
        }
        if (this.srcksfname != null) {
            File srcksfile = new File(this.srcksfname);
            if (srcksfile.exists() && srcksfile.length() == 0L) {
                throw new Exception(rb.getString("Source.keystore.file.exists.but.is.empty.") + this.srcksfname);
            }
            if (srcksfile.getCanonicalFile().equals(new File(this.ksfname).getCanonicalFile())) {
                return true;
            }
            System.err.println(String.format(rb.getString("importing.keystore.status"), this.srcksfname, this.ksfname));
            return false;
        }
        throw new Exception(rb.getString("Please.specify.srckeystore"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore loadSourceKeyStore() throws Exception {
        KeyStore store;
        InputStream is = null;
        File srcksfile = null;
        if (P11KEYSTORE.equalsIgnoreCase(this.srcstoretype) || KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            if (!NONE.equals(this.srcksfname)) {
                System.err.println(MessageFormat.format(rb.getString(".keystore.must.be.NONE.if.storetype.is.{0}"), this.srcstoretype));
                System.err.println();
                this.tinyHelp();
            }
        } else {
            srcksfile = new File(this.srcksfname);
            is = new FileInputStream(srcksfile);
        }
        try {
            if (this.srcstoretype == null) {
                this.srcstoretype = KeyStore.getDefaultType();
            }
            store = this.srcProviderName == null ? KeyStore.getInstance(this.srcstoretype) : KeyStore.getInstance(this.srcstoretype, this.srcProviderName);
            if (this.srcstorePass == null && !this.srcprotectedPath && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
                System.err.print(rb.getString("Enter.source.keystore.password."));
                System.err.flush();
                this.srcstorePass = Password.readPassword(System.in);
                this.passwords.add(this.srcstorePass);
            }
            if (P12KEYSTORE.equalsIgnoreCase(this.srcstoretype) && this.srckeyPass != null && this.srcstorePass != null && !Arrays.equals(this.srcstorePass, this.srckeyPass)) {
                MessageFormat form = new MessageFormat(rb.getString("Warning.Different.store.and.key.passwords.not.supported.for.PKCS12.KeyStores.Ignoring.user.specified.command.value."));
                Object[] source = new Object[]{"-srckeypass"};
                System.err.println(form.format(source));
                this.srckeyPass = this.srcstorePass;
            }
            store.load(is, this.srcstorePass);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (this.srcstorePass == null && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            System.err.println();
            System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
            System.err.println(rb.getString(".The.integrity.of.the.information.stored.in.the.srckeystore."));
            System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
            System.err.println();
        }
        return store;
    }

    private void doImportKeyStore(KeyStore srcKS) throws Exception {
        if (this.alias != null) {
            this.doImportKeyStoreSingle(srcKS, this.alias);
        } else {
            if (this.dest != null || this.srckeyPass != null) {
                throw new Exception(rb.getString("if.alias.not.specified.destalias.and.srckeypass.must.not.be.specified"));
            }
            this.doImportKeyStoreAll(srcKS);
        }
        if (this.inplaceImport) {
            int n = 1;
            while (true) {
                this.inplaceBackupName = this.srcksfname + ".old" + (n == 1 ? "" : Integer.valueOf(n));
                File bkFile = new File(this.inplaceBackupName);
                if (!bkFile.exists()) {
                    Files.copy(Paths.get(this.srcksfname, new String[0]), bkFile.toPath(), new CopyOption[0]);
                    break;
                }
                ++n;
            }
        }
    }

    private int doImportKeyStoreSingle(KeyStore srckeystore, String alias) throws Exception {
        String newAlias;
        String string = newAlias = this.dest == null ? alias : this.dest;
        if (this.keyStore.containsAlias(newAlias)) {
            Object[] source = new Object[]{alias};
            if (this.noprompt) {
                System.err.println(new MessageFormat(rb.getString("Warning.Overwriting.existing.alias.alias.in.destination.keystore")).format(source));
            } else {
                String reply = this.getYesNoReply(new MessageFormat(rb.getString("Existing.entry.alias.alias.exists.overwrite.no.")).format(source));
                if ("NO".equals(reply) && "".equals(newAlias = this.inputStringFromStdin(rb.getString("Enter.new.alias.name.RETURN.to.cancel.import.for.this.entry.")))) {
                    System.err.println(new MessageFormat(rb.getString("Entry.for.alias.alias.not.imported.")).format(source));
                    return 0;
                }
            }
        }
        Pair<KeyStore.Entry, char[]> objs = this.recoverEntry(srckeystore, alias, this.srcstorePass, this.srckeyPass);
        KeyStore.Entry entry = (KeyStore.Entry)objs.fst;
        KeyStore.PasswordProtection pp = null;
        char[] newPass = null;
        if (this.destKeyPass != null) {
            newPass = this.destKeyPass;
            pp = new KeyStore.PasswordProtection(this.destKeyPass);
        } else if (objs.snd != null) {
            newPass = (char[])objs.snd;
            pp = new KeyStore.PasswordProtection((char[])objs.snd);
        }
        try {
            Certificate c = srckeystore.getCertificate(alias);
            if (c != null) {
                this.checkWeak("<" + newAlias + ">", c);
            }
            this.keyStore.setEntry(newAlias, entry, pp);
            if (P12KEYSTORE.equalsIgnoreCase(this.storetype) && newPass != null && !Arrays.equals(newPass, this.storePass)) {
                throw new Exception(rb.getString("The.destination.pkcs12.keystore.has.different.storepass.and.keypass.Please.retry.with.destkeypass.specified."));
            }
            return 1;
        }
        catch (KeyStoreException kse) {
            Object[] source2 = new Object[]{alias, kse.toString()};
            MessageFormat form = new MessageFormat(rb.getString("Problem.importing.entry.for.alias.alias.exception.Entry.for.alias.alias.not.imported."));
            System.err.println(form.format(source2));
            return 2;
        }
    }

    private void doImportKeyStoreAll(KeyStore srckeystore) throws Exception {
        int ok = 0;
        int count = srckeystore.size();
        Enumeration<String> e = srckeystore.aliases();
        while (e.hasMoreElements()) {
            String reply;
            String alias = e.nextElement();
            int result = this.doImportKeyStoreSingle(srckeystore, alias);
            if (result == 1) {
                ++ok;
                Object[] source = new Object[]{alias};
                MessageFormat form = new MessageFormat(rb.getString("Entry.for.alias.alias.successfully.imported."));
                System.err.println(form.format(source));
                continue;
            }
            if (result != 2 || this.noprompt || !"YES".equals(reply = this.getYesNoReply("Do you want to quit the import process? [no]:  "))) continue;
            break;
        }
        Object[] source = new Object[]{ok, count - ok};
        MessageFormat form = new MessageFormat(rb.getString("Import.command.completed.ok.entries.successfully.imported.fail.entries.failed.or.cancelled"));
        System.err.println(form.format(source));
    }

    private void doPrintEntries(PrintStream out) throws Exception {
        out.println(rb.getString("Keystore.type.") + this.keyStore.getType());
        out.println(rb.getString("Keystore.provider.") + this.keyStore.getProvider().getName());
        out.println();
        MessageFormat form = this.keyStore.size() == 1 ? new MessageFormat(rb.getString("Your.keystore.contains.keyStore.size.entry")) : new MessageFormat(rb.getString("Your.keystore.contains.keyStore.size.entries"));
        Object[] source = new Object[]{new Integer(this.keyStore.size())};
        out.println(form.format(source));
        out.println();
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.doPrintEntry("<" + alias + ">", alias, out);
            if (!this.verbose && !this.rfc) continue;
            out.println(rb.getString("NEWLINE"));
            out.println(rb.getString("STAR"));
            out.println(rb.getString("STARNN"));
        }
    }

    private static <T> Iterable<T> e2i(final Enumeration<T> e) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends CRL> loadCRLs(String src) throws Exception {
        InputStream in = null;
        URI uri = null;
        if (src == null) {
            in = System.in;
        } else {
            try {
                uri = new URI(src);
                if (!uri.getScheme().equals("ldap")) {
                    in = uri.toURL().openStream();
                }
            }
            catch (Exception e) {
                try {
                    in = new FileInputStream(src);
                }
                catch (Exception e2) {
                    if (uri == null || uri.getScheme() == null) {
                        throw e2;
                    }
                    throw e;
                }
            }
        }
        if (in != null) {
            try {
                int len22;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] b = new byte[4096];
                while ((len22 = in.read(b)) >= 0) {
                    bout.write(b, 0, len22);
                }
                Collection<? extends CRL> len22 = CertificateFactory.getInstance("X509").generateCRLs(new ByteArrayInputStream(bout.toByteArray()));
                return len22;
            }
            finally {
                if (in != System.in) {
                    in.close();
                }
            }
        }
        CertStoreHelper helper = CertStoreHelper.getInstance("LDAP");
        String path = uri.getPath();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        CertStore s = helper.getCertStore(uri);
        X509CRLSelector sel = helper.wrap(new X509CRLSelector(), null, path);
        return s.getCRLs(sel);
    }

    public static List<CRL> readCRLsFromCert(X509Certificate cert) throws Exception {
        ArrayList<CRL> crls = new ArrayList<CRL>();
        CRLDistributionPointsExtension ext = X509CertImpl.toImpl(cert).getCRLDistributionPointsExtension();
        if (ext == null) {
            return crls;
        }
        Object distPoints = ext.get("points");
        Iterator iterator = distPoints.iterator();
        block0: while (iterator.hasNext()) {
            DistributionPoint o = (DistributionPoint)iterator.next();
            GeneralNames names = o.getFullName();
            if (names == null) continue;
            for (GeneralName name : names.names()) {
                if (name.getType() != 6) continue;
                URIName uriName = (URIName)name.getName();
                for (CRL cRL : Main.loadCRLs(uriName.getName())) {
                    if (!(cRL instanceof X509CRL)) continue;
                    crls.add((X509CRL)cRL);
                }
                continue block0;
            }
        }
        return crls;
    }

    private static String verifyCRL(KeyStore ks, CRL crl) throws Exception {
        X509CRLImpl xcrl = (X509CRLImpl)crl;
        X500Principal issuer = xcrl.getIssuerX500Principal();
        for (String s : Main.e2i(ks.aliases())) {
            X509Certificate xcert;
            Certificate cert = ks.getCertificate(s);
            if (!(cert instanceof X509Certificate) || !(xcert = (X509Certificate)cert).getSubjectX500Principal().equals(issuer)) continue;
            try {
                ((X509CRLImpl)crl).verify(cert.getPublicKey());
                return s;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private void doPrintCRL(String src, PrintStream out) throws Exception {
        for (CRL cRL : Main.loadCRLs(src)) {
            this.printCRL(cRL, out);
            String issuer = null;
            Certificate signer = null;
            if (this.caks != null && (issuer = Main.verifyCRL(this.caks, cRL)) != null) {
                signer = this.caks.getCertificate(issuer);
                out.printf(rb.getString("verified.by.s.in.s.weak"), issuer, "cacerts", this.withWeak(signer.getPublicKey()));
                out.println();
            }
            if (issuer == null && this.keyStore != null && (issuer = Main.verifyCRL(this.keyStore, cRL)) != null) {
                signer = this.keyStore.getCertificate(issuer);
                out.printf(rb.getString("verified.by.s.in.s.weak"), issuer, "keystore", this.withWeak(signer.getPublicKey()));
                out.println();
            }
            if (issuer == null) {
                out.println(rb.getString("STAR"));
                out.println(rb.getString("warning.not.verified.make.sure.keystore.is.correct"));
                out.println(rb.getString("STARNN"));
            }
            this.checkWeak(rb.getString("the.crl"), cRL, (Key)(signer == null ? null : signer.getPublicKey()));
        }
    }

    private void printCRL(CRL crl, PrintStream out) throws Exception {
        X509CRL xcrl = (X509CRL)crl;
        if (this.rfc) {
            out.println("-----BEGIN X509 CRL-----");
            out.println(Base64.getMimeEncoder(64, CRLF).encodeToString(xcrl.getEncoded()));
            out.println("-----END X509 CRL-----");
        } else {
            String s;
            if (crl instanceof X509CRLImpl) {
                X509CRLImpl x509crl = (X509CRLImpl)crl;
                s = x509crl.toStringWithAlgName(this.withWeak("" + x509crl.getSigAlgId()));
            } else {
                s = crl.toString();
            }
            out.println(s);
        }
    }

    private void doPrintCertReq(InputStream in, PrintStream out) throws Exception {
        String s;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer sb = new StringBuffer();
        boolean started = false;
        while ((s = reader.readLine()) != null) {
            if (!started) {
                if (!s.startsWith("-----")) continue;
                started = true;
                continue;
            }
            if (s.startsWith("-----")) break;
            sb.append(s);
        }
        PKCS10 req = new PKCS10(Pem.decode(new String(sb)));
        PublicKey pkey = req.getSubjectPublicKeyInfo();
        out.printf(rb.getString("PKCS.10.with.weak"), req.getSubjectName(), pkey.getFormat(), this.withWeak(pkey), this.withWeak(req.getSigAlg()));
        for (PKCS10Attribute attr : req.getAttributes().getAttributes()) {
            ObjectIdentifier oid = attr.getAttributeId();
            if (oid.equals((Object)PKCS9Attribute.EXTENSION_REQUEST_OID)) {
                CertificateExtensions exts = (CertificateExtensions)attr.getAttributeValue();
                if (exts == null) continue;
                Main.printExtensions(rb.getString("Extension.Request."), exts, out);
                continue;
            }
            out.println("Attribute: " + attr.getAttributeId());
            PKCS9Attribute pkcs9Attr = new PKCS9Attribute(attr.getAttributeId(), attr.getAttributeValue());
            out.print(pkcs9Attr.getName() + ": ");
            Object attrVal = attr.getAttributeValue();
            out.println(attrVal instanceof String[] ? Arrays.toString((String[])attrVal) : attrVal);
        }
        if (this.debug) {
            out.println(req);
        }
        this.checkWeak(rb.getString("the.certificate.request"), req);
    }

    private void printCertFromStream(InputStream in, PrintStream out) throws Exception {
        Collection<? extends Certificate> c = null;
        try {
            c = this.cf.generateCertificates(in);
        }
        catch (CertificateException ce) {
            throw new Exception(rb.getString("Failed.to.parse.input"), ce);
        }
        if (c.isEmpty()) {
            throw new Exception(rb.getString("Empty.input"));
        }
        Certificate[] certs = c.toArray(new Certificate[c.size()]);
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate x509Cert = null;
            try {
                x509Cert = (X509Certificate)certs[i];
            }
            catch (ClassCastException cce) {
                throw new Exception(rb.getString("Not.X.509.certificate"));
            }
            if (certs.length > 1) {
                MessageFormat form = new MessageFormat(rb.getString("Certificate.i.1."));
                Object[] source = new Object[]{new Integer(i + 1)};
                out.println(form.format(source));
            }
            if (this.rfc) {
                this.dumpCert(x509Cert, out);
            } else {
                this.printX509Cert(x509Cert, out);
            }
            if (i < certs.length - 1) {
                out.println();
            }
            this.checkWeak(Main.oneInMany(rb.getString("the.certificate"), i, certs.length), x509Cert);
        }
    }

    private static String oneInMany(String label, int i, int num) {
        if (num == 1) {
            return label;
        }
        return String.format(rb.getString("one.in.many"), label, i + 1, num);
    }

    private void doPrintCert(PrintStream out) throws Exception {
        if (this.jarfile != null) {
            JarFile jf = new JarFile(this.jarfile, true);
            Enumeration<JarEntry> entries = jf.entries();
            HashSet<CodeSigner> ss = new HashSet<CodeSigner>();
            byte[] buffer = new byte[8192];
            int pos = 0;
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                CodeSigner[] codeSignerArray = null;
                try (InputStream is = jf.getInputStream(jarEntry);){
                    while (is.read(buffer) != -1) {
                    }
                }
                catch (Throwable object) {
                    codeSignerArray = object;
                    throw object;
                }
                CodeSigner[] signers = jarEntry.getCodeSigners();
                if (signers == null) continue;
                for (CodeSigner signer : signers) {
                    if (ss.contains(signer)) continue;
                    ss.add(signer);
                    out.printf(rb.getString("Signer.d."), ++pos);
                    out.println();
                    out.println();
                    out.println(rb.getString("Signature."));
                    out.println();
                    List<? extends Certificate> certs = signer.getSignerCertPath().getCertificates();
                    int cc = 0;
                    for (Certificate certificate : certs) {
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        if (this.rfc) {
                            out.println(rb.getString("Certificate.owner.") + x509Certificate.getSubjectDN() + "\n");
                            this.dumpCert(x509Certificate, out);
                        } else {
                            this.printX509Cert(x509Certificate, out);
                        }
                        out.println();
                        this.checkWeak(Main.oneInMany(rb.getString("the.certificate"), cc++, certs.size()), x509Certificate);
                    }
                    Timestamp ts = signer.getTimestamp();
                    if (ts == null) continue;
                    out.println(rb.getString("Timestamp."));
                    out.println();
                    certs = ts.getSignerCertPath().getCertificates();
                    cc = 0;
                    for (Certificate certificate : certs) {
                        X509Certificate x = (X509Certificate)certificate;
                        if (this.rfc) {
                            out.println(rb.getString("Certificate.owner.") + x.getSubjectDN() + "\n");
                            this.dumpCert(x, out);
                        } else {
                            this.printX509Cert(x, out);
                        }
                        out.println();
                        this.checkWeak(Main.oneInMany(rb.getString("the.tsa.certificate"), cc++, certs.size()), x);
                    }
                }
            }
            jf.close();
            if (ss.isEmpty()) {
                out.println(rb.getString("Not.a.signed.jar.file"));
            }
        } else if (this.sslserver != null) {
            Collection<? extends Certificate> chain;
            CertStoreHelper helper = CertStoreHelper.getInstance("SSLServer");
            CertStore cs = helper.getCertStore(new URI("https://" + this.sslserver));
            try {
                chain = cs.getCertificates(null);
                if (chain.isEmpty()) {
                    throw new Exception(rb.getString("No.certificate.from.the.SSL.server"));
                }
            }
            catch (CertStoreException cse) {
                if (cse.getCause() instanceof IOException) {
                    throw new Exception(rb.getString("No.certificate.from.the.SSL.server"), cse.getCause());
                }
                throw cse;
            }
            int i = 0;
            for (Certificate certificate : chain) {
                try {
                    if (this.rfc) {
                        this.dumpCert(certificate, out);
                    } else {
                        out.println("Certificate #" + i);
                        out.println("====================================");
                        this.printX509Cert((X509Certificate)certificate, out);
                        out.println();
                    }
                    this.checkWeak(Main.oneInMany(rb.getString("the.certificate"), i++, chain.size()), certificate);
                }
                catch (Exception e) {
                    if (!this.debug) continue;
                    e.printStackTrace();
                }
            }
        } else if (this.filename != null) {
            try (FileInputStream inStream = new FileInputStream(this.filename);){
                this.printCertFromStream(inStream, out);
            }
        } else {
            this.printCertFromStream(System.in, out);
        }
    }

    private void doSelfCert(String alias, String dname, String sigAlgName) throws Exception {
        X500Name owner;
        Certificate oldCert;
        if (alias == null) {
            alias = keyAlias;
        }
        Pair<Key, char[]> objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])objs.snd;
        }
        if (sigAlgName == null) {
            sigAlgName = Main.getCompatibleSigAlgName(privKey.getAlgorithm());
        }
        if ((oldCert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias.has.no.public.key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!(oldCert instanceof X509Certificate)) {
            MessageFormat form = new MessageFormat(rb.getString("alias.has.no.X.509.certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        byte[] encoded = oldCert.getEncoded();
        X509CertImpl certImpl = new X509CertImpl(encoded);
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        Date firstDate = Main.getStartDate(this.startDate);
        Date lastDate = new Date();
        lastDate.setTime(firstDate.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        certInfo.set("validity", interval);
        certInfo.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        if (dname == null) {
            owner = (X500Name)certInfo.get("subject.dname");
        } else {
            owner = new X500Name(dname);
            certInfo.set("subject.dname", owner);
        }
        certInfo.set("issuer.dname", owner);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(privKey, sigAlgName);
        AlgorithmId sigAlgid = (AlgorithmId)newCert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", sigAlgid);
        certInfo.set("version", new CertificateVersion(2));
        CertificateExtensions ext = this.createV3Extensions(null, (CertificateExtensions)certInfo.get("extensions"), this.v3ext, oldCert.getPublicKey(), null);
        certInfo.set("extensions", ext);
        newCert = new X509CertImpl(certInfo);
        newCert.sign(privKey, sigAlgName);
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{newCert});
        if (this.verbose) {
            System.err.println(rb.getString("New.certificate.self.signed."));
            System.err.print(newCert.toString());
            System.err.println();
        }
    }

    private boolean installReply(String alias, InputStream in) throws Exception {
        Certificate userCert;
        if (alias == null) {
            alias = keyAlias;
        }
        Pair<Key, char[]> objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])objs.snd;
        }
        if ((userCert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias.has.no.public.key.certificate."));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Collection<? extends Certificate> c = this.cf.generateCertificates(in);
        if (c.isEmpty()) {
            throw new Exception(rb.getString("Reply.has.no.certificates"));
        }
        Certificate[] replyCerts = c.toArray(new Certificate[c.size()]);
        Certificate[] newChain = replyCerts.length == 1 ? this.establishCertChain(userCert, replyCerts[0]) : this.validateReply(alias, userCert, replyCerts);
        if (newChain != null) {
            this.keyStore.setKeyEntry(alias, privKey, this.keyPass != null ? this.keyPass : this.storePass, newChain);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String alias, InputStream in) throws Exception {
        MessageFormat form;
        if (alias == null) {
            throw new Exception(rb.getString("Must.specify.alias"));
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form2 = new MessageFormat(rb.getString("Certificate.not.imported.alias.alias.already.exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form2.format(source));
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.cf.generateCertificate(in);
        }
        catch (ClassCastException | CertificateException ce) {
            throw new Exception(rb.getString("Input.not.an.X.509.certificate"));
        }
        if (this.noprompt) {
            this.checkWeak(rb.getString("the.input"), cert);
            this.keyStore.setCertificateEntry(alias, cert);
            return true;
        }
        boolean selfSigned = false;
        if (KeyStoreUtil.isSelfSigned(cert)) {
            cert.verify(cert.getPublicKey());
            selfSigned = true;
        }
        String reply = null;
        String trustalias = this.keyStore.getCertificateAlias(cert);
        if (trustalias != null) {
            form = new MessageFormat(rb.getString("Certificate.already.exists.in.keystore.under.alias.trustalias."));
            Object[] source = new Object[]{trustalias};
            System.err.println(form.format(source));
            this.checkWeak(rb.getString("the.input"), cert);
            this.printWeakWarnings(true);
            reply = this.getYesNoReply(rb.getString("Do.you.still.want.to.add.it.no."));
        } else if (selfSigned) {
            if (this.trustcacerts && this.caks != null && (trustalias = this.caks.getCertificateAlias(cert)) != null) {
                form = new MessageFormat(rb.getString("Certificate.already.exists.in.system.wide.CA.keystore.under.alias.trustalias."));
                Object[] source = new Object[]{trustalias};
                System.err.println(form.format(source));
                this.checkWeak(rb.getString("the.input"), cert);
                this.printWeakWarnings(true);
                reply = this.getYesNoReply(rb.getString("Do.you.still.want.to.add.it.to.your.own.keystore.no."));
            }
            if (trustalias == null) {
                this.printX509Cert(cert, System.out);
                this.checkWeak(rb.getString("the.input"), cert);
                this.printWeakWarnings(true);
                reply = this.getYesNoReply(rb.getString("Trust.this.certificate.no."));
            }
        }
        if (reply != null) {
            if ("YES".equals(reply)) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
            return false;
        }
        try {
            Certificate[] chain = this.establishCertChain(null, cert);
            if (chain != null) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
        }
        catch (Exception e) {
            this.printX509Cert(cert, System.out);
            this.checkWeak(rb.getString("the.input"), cert);
            this.printWeakWarnings(true);
            reply = this.getYesNoReply(rb.getString("Trust.this.certificate.no."));
            if ("YES".equals(reply)) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
            return false;
        }
        return false;
    }

    private char[] getNewPasswd(String prompt, char[] oldPasswd) throws Exception {
        char[] entered = null;
        char[] reentered = null;
        for (int count = 0; count < 3; ++count) {
            MessageFormat form = new MessageFormat(rb.getString("New.prompt."));
            Object[] source = new Object[]{prompt};
            System.err.print(form.format(source));
            entered = Password.readPassword(System.in);
            this.passwords.add(entered);
            if (entered == null || entered.length < 6) {
                System.err.println(rb.getString("Password.is.too.short.must.be.at.least.6.characters"));
            } else if (Arrays.equals(entered, oldPasswd)) {
                System.err.println(rb.getString("Passwords.must.differ"));
            } else {
                form = new MessageFormat(rb.getString("Re.enter.new.prompt."));
                Object[] src = new Object[]{prompt};
                System.err.print(form.format(src));
                reentered = Password.readPassword(System.in);
                this.passwords.add(reentered);
                if (!Arrays.equals(entered, reentered)) {
                    System.err.println(rb.getString("They.don.t.match.Try.again"));
                } else {
                    Arrays.fill(reentered, ' ');
                    return entered;
                }
            }
            if (entered != null) {
                Arrays.fill(entered, ' ');
                entered = null;
            }
            if (reentered == null) continue;
            Arrays.fill(reentered, ' ');
            reentered = null;
        }
        throw new Exception(rb.getString("Too.many.failures.try.later"));
    }

    private String getAlias(String prompt) throws Exception {
        if (prompt != null) {
            MessageFormat form = new MessageFormat(rb.getString("Enter.prompt.alias.name."));
            Object[] source = new Object[]{prompt};
            System.err.print(form.format(source));
        } else {
            System.err.print(rb.getString("Enter.alias.name."));
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private String inputStringFromStdin(String prompt) throws Exception {
        System.err.print(prompt);
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String alias, String otherAlias, char[] otherKeyPass) throws Exception {
        int count = 0;
        char[] keyPass = null;
        do {
            Object[] source;
            MessageFormat form;
            if (otherKeyPass != null) {
                form = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                source = new Object[]{alias};
                System.err.println(form.format(source));
                form = new MessageFormat(rb.getString(".RETURN.if.same.as.for.otherAlias."));
                Object[] src = new Object[]{otherAlias};
                System.err.print(form.format(src));
            } else {
                form = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                source = new Object[]{alias};
                System.err.print(form.format(source));
            }
            System.err.flush();
            keyPass = Password.readPassword(System.in);
            this.passwords.add(keyPass);
            if (keyPass != null) continue;
            keyPass = otherKeyPass;
        } while (keyPass == null && ++count < 3);
        if (keyPass == null) {
            throw new Exception(rb.getString("Too.many.failures.try.later"));
        }
        return keyPass;
    }

    private String withWeak(String alg) {
        if (DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, alg, null)) {
            return alg;
        }
        return String.format(rb.getString("with.weak"), alg);
    }

    private String withWeak(PublicKey key) {
        if (DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, key)) {
            return String.format(rb.getString("key.bit"), KeyUtil.getKeySize(key), key.getAlgorithm());
        }
        return String.format(rb.getString("key.bit.weak"), KeyUtil.getKeySize(key), key.getAlgorithm());
    }

    private void printX509Cert(X509Certificate cert, PrintStream out) throws Exception {
        X509CertImpl impl;
        X509CertInfo certInfo;
        CertificateExtensions exts;
        MessageFormat form = new MessageFormat(rb.getString(".PATTERN.printX509Cert.with.weak"));
        PublicKey pkey = cert.getPublicKey();
        String sigName = cert.getSigAlgName();
        if (!this.isTrustedCert(cert)) {
            sigName = this.withWeak(sigName);
        }
        Object[] source = new Object[]{cert.getSubjectDN().toString(), cert.getIssuerDN().toString(), cert.getSerialNumber().toString(16), cert.getNotBefore().toString(), cert.getNotAfter().toString(), this.getCertFingerPrint("MD5", cert), this.getCertFingerPrint("SHA1", cert), this.getCertFingerPrint("SHA-256", cert), sigName, this.withWeak(pkey), cert.getVersion()};
        out.println(form.format(source));
        if (cert instanceof X509CertImpl && (exts = (CertificateExtensions)(certInfo = (X509CertInfo)(impl = (X509CertImpl)cert).get("x509.info")).get("extensions")) != null) {
            Main.printExtensions(rb.getString("Extensions."), exts, out);
        }
    }

    private static void printExtensions(String title, CertificateExtensions exts, PrintStream out) throws Exception {
        int extnum = 0;
        Iterator<Extension> i1 = exts.getAllExtensions().iterator();
        Iterator<Extension> i2 = exts.getUnparseableExtensions().values().iterator();
        while (i1.hasNext() || i2.hasNext()) {
            Extension ext;
            Extension extension = ext = i1.hasNext() ? i1.next() : i2.next();
            if (extnum == 0) {
                out.println();
                out.println(title);
                out.println();
            }
            out.print("#" + ++extnum + ": " + ext);
            if (ext.getClass() == Extension.class) {
                byte[] v = ext.getExtensionValue();
                if (v.length == 0) {
                    out.println(rb.getString(".Empty.value."));
                } else {
                    new HexDumpEncoder().encodeBuffer(ext.getExtensionValue(), (OutputStream)out);
                    out.println();
                }
            }
            out.println();
        }
    }

    private static Pair<String, Certificate> getSigner(Certificate cert, KeyStore ks) throws Exception {
        if (ks.getCertificateAlias(cert) != null) {
            return new Pair<String, Certificate>("", cert);
        }
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String name = aliases.nextElement();
            Certificate trustedCert = ks.getCertificate(name);
            if (trustedCert == null) continue;
            try {
                cert.verify(trustedCert.getPublicKey());
                return new Pair<String, Certificate>(name, trustedCert);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name name;
        Object[] source;
        MessageFormat form;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String commonName = "Unknown";
        String organizationalUnit = "Unknown";
        String organization = "Unknown";
        String city = "Unknown";
        String state = "Unknown";
        String country = "Unknown";
        String userInput = null;
        int maxRetry = 20;
        do {
            if (maxRetry-- < 0) {
                throw new RuntimeException(rb.getString("Too.many.retries.program.terminated"));
            }
            commonName = this.inputString(in, rb.getString("What.is.your.first.and.last.name."), commonName);
            organizationalUnit = this.inputString(in, rb.getString("What.is.the.name.of.your.organizational.unit."), organizationalUnit);
            organization = this.inputString(in, rb.getString("What.is.the.name.of.your.organization."), organization);
            city = this.inputString(in, rb.getString("What.is.the.name.of.your.City.or.Locality."), city);
            state = this.inputString(in, rb.getString("What.is.the.name.of.your.State.or.Province."), state);
            country = this.inputString(in, rb.getString("What.is.the.two.letter.country.code.for.this.unit."), country);
            name = new X500Name(commonName, organizationalUnit, organization, city, state, country);
        } while (collator.compare(userInput = this.inputString(in, (form = new MessageFormat(rb.getString("Is.name.correct."))).format(source = new Object[]{name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(userInput, rb.getString("y")) != 0);
        System.err.println();
        return name;
    }

    private String inputString(BufferedReader in, String prompt, String defaultValue) throws IOException {
        System.err.println(prompt);
        MessageFormat form = new MessageFormat(rb.getString(".defaultValue."));
        Object[] source = new Object[]{defaultValue};
        System.err.print(form.format(source));
        System.err.flush();
        String value = in.readLine();
        if (value == null || collator.compare(value, "") == 0) {
            value = defaultValue;
        }
        return value;
    }

    private void dumpCert(Certificate cert, PrintStream out) throws IOException, CertificateException {
        if (this.rfc) {
            out.println("-----BEGIN CERTIFICATE-----");
            out.println(Base64.getMimeEncoder(64, CRLF).encodeToString(cert.getEncoded()));
            out.println("-----END CERTIFICATE-----");
        } else {
            out.write(cert.getEncoded());
        }
    }

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private Pair<Key, char[]> recoverKey(String alias, char[] storePass, char[] keyPass) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.has.no.key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (keyPass == null) {
            try {
                key = this.keyStore.getKey(alias, storePass);
                keyPass = storePass;
                this.passwords.add(keyPass);
            }
            catch (UnrecoverableKeyException e) {
                if (!this.token) {
                    keyPass = this.getKeyPasswd(alias, null, null);
                    key = this.keyStore.getKey(alias, keyPass);
                }
                throw e;
            }
        } else {
            key = this.keyStore.getKey(alias, keyPass);
        }
        return Pair.of(key, keyPass);
    }

    private Pair<KeyStore.Entry, char[]> recoverEntry(KeyStore ks, String alias, char[] pstore, char[] pkey) throws Exception {
        KeyStore.Entry entry;
        if (!ks.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        KeyStore.PasswordProtection pp = null;
        try {
            entry = ks.getEntry(alias, pp);
            pkey = null;
        }
        catch (UnrecoverableEntryException une) {
            if (P11KEYSTORE.equalsIgnoreCase(ks.getType()) || KeyStoreUtil.isWindowsKeyStore(ks.getType())) {
                throw une;
            }
            if (pkey != null) {
                pp = new KeyStore.PasswordProtection(pkey);
                entry = ks.getEntry(alias, pp);
            }
            try {
                pp = new KeyStore.PasswordProtection(pstore);
                entry = ks.getEntry(alias, pp);
                pkey = pstore;
            }
            catch (UnrecoverableEntryException une2) {
                if (P12KEYSTORE.equalsIgnoreCase(ks.getType())) {
                    throw une2;
                }
                pkey = this.getKeyPasswd(alias, null, null);
                pp = new KeyStore.PasswordProtection(pkey);
                entry = ks.getEntry(alias, pp);
            }
        }
        return Pair.of(entry, pkey);
    }

    private String getCertFingerPrint(String mdAlg, Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return this.toHexString(digest);
    }

    private void printNoIntegrityWarning() {
        System.err.println();
        System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
        System.err.println(rb.getString(".The.integrity.of.the.information.stored.in.your.keystore."));
        System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
        System.err.println();
    }

    private Certificate[] validateReply(String alias, Certificate userCert, Certificate[] replyCerts) throws Exception {
        int i;
        this.checkWeak(rb.getString("reply"), replyCerts);
        PublicKey userPubKey = userCert.getPublicKey();
        for (i = 0; i < replyCerts.length && !userPubKey.equals(replyCerts[i].getPublicKey()); ++i) {
        }
        if (i == replyCerts.length) {
            MessageFormat form = new MessageFormat(rb.getString("Certificate.reply.does.not.contain.public.key.for.alias."));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Certificate tmpCert = replyCerts[0];
        replyCerts[0] = replyCerts[i];
        replyCerts[i] = tmpCert;
        X509Certificate thisCert = (X509Certificate)replyCerts[0];
        for (i = 1; i < replyCerts.length - 1; ++i) {
            int j;
            for (j = i; j < replyCerts.length; ++j) {
                if (!KeyStoreUtil.signedBy(thisCert, (X509Certificate)replyCerts[j])) continue;
                tmpCert = replyCerts[i];
                replyCerts[i] = replyCerts[j];
                replyCerts[j] = tmpCert;
                thisCert = (X509Certificate)replyCerts[i];
                break;
            }
            if (j != replyCerts.length) continue;
            throw new Exception(rb.getString("Incomplete.certificate.chain.in.reply"));
        }
        if (this.noprompt) {
            return replyCerts;
        }
        Certificate topCert = replyCerts[replyCerts.length - 1];
        boolean fromKeyStore = true;
        Pair<String, Certificate> root = Main.getSigner(topCert, this.keyStore);
        if (root == null && this.trustcacerts && this.caks != null) {
            root = Main.getSigner(topCert, this.caks);
            fromKeyStore = false;
        }
        if (root == null) {
            System.err.println();
            System.err.println(rb.getString("Top.level.certificate.in.reply."));
            this.printX509Cert((X509Certificate)topCert, System.out);
            System.err.println();
            System.err.print(rb.getString(".is.not.trusted."));
            this.printWeakWarnings(true);
            String reply = this.getYesNoReply(rb.getString("Install.reply.anyway.no."));
            if ("NO".equals(reply)) {
                return null;
            }
        } else if (root.snd != topCert) {
            Certificate[] tmpCerts = new Certificate[replyCerts.length + 1];
            System.arraycopy(replyCerts, 0, tmpCerts, 0, replyCerts.length);
            tmpCerts[tmpCerts.length - 1] = (Certificate)root.snd;
            replyCerts = tmpCerts;
            this.checkWeak(String.format(rb.getString(fromKeyStore ? "alias.in.keystore" : "alias.in.cacerts"), root.fst), (Certificate)root.snd);
        }
        return replyCerts;
    }

    private Certificate[] establishCertChain(Certificate userCert, Certificate certToVerify) throws Exception {
        if (userCert != null) {
            PublicKey replyPubKey;
            PublicKey origPubKey = userCert.getPublicKey();
            if (!origPubKey.equals(replyPubKey = certToVerify.getPublicKey())) {
                throw new Exception(rb.getString("Public.keys.in.reply.and.keystore.don.t.match"));
            }
            if (certToVerify.equals(userCert)) {
                throw new Exception(rb.getString("Certificate.reply.and.certificate.in.keystore.are.identical"));
            }
        }
        Hashtable<Principal, Vector<Pair<String, X509Certificate>>> certs = null;
        if (this.keyStore.size() > 0) {
            certs = new Hashtable<Principal, Vector<Pair<String, X509Certificate>>>(11);
            this.keystorecerts2Hashtable(this.keyStore, certs);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (certs == null) {
                certs = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, certs);
        }
        Vector<Pair<String, X509Certificate>> chain = new Vector<Pair<String, X509Certificate>>(2);
        if (this.buildChain(new Pair<String, X509Certificate>(rb.getString("the.input"), (X509Certificate)certToVerify), chain, certs)) {
            for (Pair<String, X509Certificate> p : chain) {
                this.checkWeak((String)p.fst, (Certificate)p.snd);
            }
            Certificate[] newChain = new Certificate[chain.size()];
            int j = 0;
            for (int i = chain.size() - 1; i >= 0; --i) {
                newChain[j] = (Certificate)chain.elementAt((int)i).snd;
                ++j;
            }
            return newChain;
        }
        throw new Exception(rb.getString("Failed.to.establish.chain.from.reply"));
    }

    private boolean buildChain(Pair<String, X509Certificate> certToVerify, Vector<Pair<String, X509Certificate>> chain, Hashtable<Principal, Vector<Pair<String, X509Certificate>>> certs) {
        if (KeyStoreUtil.isSelfSigned((X509Certificate)certToVerify.snd)) {
            chain.addElement(certToVerify);
            return true;
        }
        Principal issuer = ((X509Certificate)certToVerify.snd).getIssuerDN();
        Vector<Pair<String, X509Certificate>> vec = certs.get(issuer);
        if (vec == null) {
            return false;
        }
        Enumeration<Pair<String, X509Certificate>> issuerCerts = vec.elements();
        while (issuerCerts.hasMoreElements()) {
            Pair<String, X509Certificate> issuerCert = issuerCerts.nextElement();
            PublicKey issuerPubKey = ((X509Certificate)issuerCert.snd).getPublicKey();
            try {
                ((X509Certificate)certToVerify.snd).verify(issuerPubKey);
            }
            catch (Exception e) {
                continue;
            }
            if (!this.buildChain(issuerCert, chain, certs)) continue;
            chain.addElement(certToVerify);
            return true;
        }
        return false;
    }

    private String getYesNoReply(String prompt) throws IOException {
        String reply = null;
        int maxRetry = 20;
        do {
            if (maxRetry-- < 0) {
                throw new RuntimeException(rb.getString("Too.many.retries.program.terminated"));
            }
            System.err.print(prompt);
            System.err.flush();
            reply = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(reply, "") == 0 || collator.compare(reply, rb.getString("n")) == 0 || collator.compare(reply, rb.getString("no")) == 0) {
                reply = "NO";
                continue;
            }
            if (collator.compare(reply, rb.getString("y")) == 0 || collator.compare(reply, rb.getString("yes")) == 0) {
                reply = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong.answer.try.again"));
            reply = null;
        } while (reply == null);
        return reply;
    }

    private void keystorecerts2Hashtable(KeyStore ks, Hashtable<Principal, Vector<Pair<String, X509Certificate>>> hash) throws Exception {
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) continue;
            Principal subjectDN = ((X509Certificate)cert).getSubjectDN();
            Pair<String, X509Certificate> pair = new Pair<String, X509Certificate>(String.format(rb.getString(ks == this.caks ? "alias.in.cacerts" : "alias.in.keystore"), alias), (X509Certificate)cert);
            Vector<Pair<String, X509Certificate>> vec = hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector();
                vec.addElement(pair);
            } else if (!vec.contains(pair)) {
                vec.addElement(pair);
            }
            hash.put(subjectDN, vec);
        }
    }

    private static Date getStartDate(String s) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        if (s != null) {
            IOException ioe = new IOException(rb.getString("Illegal.startdate.value"));
            int len = s.length();
            if (len == 0) {
                throw ioe;
            }
            if (s.charAt(0) == '-' || s.charAt(0) == '+') {
                int start = 0;
                while (start < len) {
                    char ch;
                    int i;
                    int sign = 0;
                    switch (s.charAt(start)) {
                        case '+': {
                            sign = 1;
                            break;
                        }
                        case '-': {
                            sign = -1;
                            break;
                        }
                        default: {
                            throw ioe;
                        }
                    }
                    for (i = start + 1; i < len && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
                    }
                    if (i == start + 1) {
                        throw ioe;
                    }
                    int number = Integer.parseInt(s.substring(start + 1, i));
                    if (i >= len) {
                        throw ioe;
                    }
                    int unit = 0;
                    switch (s.charAt(i)) {
                        case 'y': {
                            unit = 1;
                            break;
                        }
                        case 'm': {
                            unit = 2;
                            break;
                        }
                        case 'd': {
                            unit = 5;
                            break;
                        }
                        case 'H': {
                            unit = 10;
                            break;
                        }
                        case 'M': {
                            unit = 12;
                            break;
                        }
                        case 'S': {
                            unit = 13;
                            break;
                        }
                        default: {
                            throw ioe;
                        }
                    }
                    ((Calendar)c).add(unit, sign * number);
                    start = i + 1;
                }
            } else {
                String date = null;
                String time = null;
                if (len == 19) {
                    date = s.substring(0, 10);
                    time = s.substring(11);
                    if (s.charAt(10) != ' ') {
                        throw ioe;
                    }
                } else if (len == 10) {
                    date = s;
                } else if (len == 8) {
                    time = s;
                } else {
                    throw ioe;
                }
                if (date != null) {
                    if (date.matches("\\d\\d\\d\\d\\/\\d\\d\\/\\d\\d")) {
                        c.set(Integer.valueOf(date.substring(0, 4)), Integer.valueOf(date.substring(5, 7)) - 1, Integer.valueOf(date.substring(8, 10)));
                    } else {
                        throw ioe;
                    }
                }
                if (time != null) {
                    if (time.matches("\\d\\d:\\d\\d:\\d\\d")) {
                        c.set(11, Integer.valueOf(time.substring(0, 2)));
                        c.set(12, Integer.valueOf(time.substring(0, 2)));
                        c.set(13, Integer.valueOf(time.substring(0, 2)));
                        c.set(14, 0);
                    } else {
                        throw ioe;
                    }
                }
            }
        }
        return c.getTime();
    }

    private static int oneOf(String s, String ... list) throws Exception {
        int[] match = new int[list.length];
        int nmatch = 0;
        int experiment = Integer.MAX_VALUE;
        for (int i = 0; i < list.length; ++i) {
            String one = list[i];
            if (one == null) {
                experiment = i;
                continue;
            }
            if (one.toLowerCase(Locale.ENGLISH).startsWith(s.toLowerCase(Locale.ENGLISH))) {
                match[nmatch++] = i;
                continue;
            }
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (char c : one.toCharArray()) {
                if (first) {
                    sb.append(c);
                    first = false;
                    continue;
                }
                if (Character.isLowerCase(c)) continue;
                sb.append(c);
            }
            if (!sb.toString().equalsIgnoreCase(s)) continue;
            match[nmatch++] = i;
        }
        if (nmatch == 0) {
            return -1;
        }
        if (nmatch == 1) {
            return match[0];
        }
        if (match[1] > experiment) {
            return match[0];
        }
        StringBuffer sb = new StringBuffer();
        MessageFormat form = new MessageFormat(rb.getString("command.{0}.is.ambiguous."));
        Object[] source = new Object[]{s};
        sb.append(form.format(source));
        sb.append("\n    ");
        for (int i = 0; i < nmatch && match[i] < experiment; ++i) {
            sb.append(' ');
            sb.append(list[match[i]]);
        }
        throw new Exception(sb.toString());
    }

    private GeneralName createGeneralName(String t, String v) throws Exception {
        GeneralNameInterface gn;
        int p = Main.oneOf(t, "EMAIL", "URI", "DNS", "IP", "OID");
        if (p < 0) {
            throw new Exception(rb.getString("Unrecognized.GeneralName.type.") + t);
        }
        switch (p) {
            case 0: {
                gn = new RFC822Name(v);
                break;
            }
            case 1: {
                gn = new URIName(v);
                break;
            }
            case 2: {
                gn = new DNSName(v);
                break;
            }
            case 3: {
                gn = new IPAddressName(v);
                break;
            }
            default: {
                gn = new OIDName(v);
            }
        }
        return new GeneralName(gn);
    }

    private ObjectIdentifier findOidForExtName(String type) throws Exception {
        switch (Main.oneOf(type, extSupported)) {
            case 0: {
                return PKIXExtensions.BasicConstraints_Id;
            }
            case 1: {
                return PKIXExtensions.KeyUsage_Id;
            }
            case 2: {
                return PKIXExtensions.ExtendedKeyUsage_Id;
            }
            case 3: {
                return PKIXExtensions.SubjectAlternativeName_Id;
            }
            case 4: {
                return PKIXExtensions.IssuerAlternativeName_Id;
            }
            case 5: {
                return PKIXExtensions.SubjectInfoAccess_Id;
            }
            case 6: {
                return PKIXExtensions.AuthInfoAccess_Id;
            }
            case 8: {
                return PKIXExtensions.CRLDistributionPoints_Id;
            }
        }
        return new ObjectIdentifier(type);
    }

    private CertificateExtensions createV3Extensions(CertificateExtensions reqex, CertificateExtensions ext, List<String> extstrs, PublicKey pkey, PublicKey akey) throws Exception {
        if (ext != null && reqex != null) {
            throw new Exception("One of request and original should be null.");
        }
        if (ext == null) {
            ext = new CertificateExtensions();
        }
        try {
            if (reqex != null) {
                for (String extstr : extstrs) {
                    if (!extstr.toLowerCase(Locale.ENGLISH).startsWith("honored=")) continue;
                    List<String> list = Arrays.asList(extstr.toLowerCase(Locale.ENGLISH).substring(8).split(","));
                    if (list.contains("all")) {
                        ext = reqex;
                    }
                    for (String item : list) {
                        if (item.equals("all")) continue;
                        boolean add = true;
                        int action = -1;
                        String type = null;
                        if (item.startsWith("-")) {
                            add = false;
                            type = item.substring(1);
                        } else {
                            int colonpos = item.indexOf(58);
                            if (colonpos >= 0) {
                                type = item.substring(0, colonpos);
                                action = Main.oneOf(item.substring(colonpos + 1), "critical", "non-critical");
                                if (action == -1) {
                                    throw new Exception(rb.getString("Illegal.value.") + item);
                                }
                            }
                        }
                        String n = reqex.getNameByOid(this.findOidForExtName(type));
                        if (add) {
                            Extension e = reqex.get(n);
                            if ((e.isCritical() || action != 0) && (!e.isCritical() || action != 1)) continue;
                            e = Extension.newExtension(e.getExtensionId(), !e.isCritical(), e.getExtensionValue());
                            ext.set(n, e);
                            continue;
                        }
                        ext.delete(n);
                    }
                }
            }
            for (String extstr : extstrs) {
                String value;
                String name;
                boolean isCritical = false;
                int eqpos = extstr.indexOf(61);
                if (eqpos >= 0) {
                    name = extstr.substring(0, eqpos);
                    value = extstr.substring(eqpos + 1);
                } else {
                    name = extstr;
                    value = null;
                }
                int colonpos = name.indexOf(58);
                if (colonpos >= 0) {
                    if (Main.oneOf(name.substring(colonpos + 1), "critical") == 0) {
                        isCritical = true;
                    }
                    name = name.substring(0, colonpos);
                }
                if (name.equalsIgnoreCase("honored")) continue;
                int exttype = Main.oneOf(name, extSupported);
                switch (exttype) {
                    case 0: {
                        int pathLen = -1;
                        boolean isCA = false;
                        if (value == null) {
                            isCA = true;
                        } else {
                            try {
                                pathLen = Integer.parseInt(value);
                                isCA = true;
                            }
                            catch (NumberFormatException ufe) {
                                for (String part : value.split(",")) {
                                    String[] nv = part.split(":");
                                    if (nv.length != 2) {
                                        throw new Exception(rb.getString("Illegal.value.") + extstr);
                                    }
                                    if (nv[0].equalsIgnoreCase("ca")) {
                                        isCA = Boolean.parseBoolean(nv[1]);
                                        continue;
                                    }
                                    if (nv[0].equalsIgnoreCase("pathlen")) {
                                        pathLen = Integer.parseInt(nv[1]);
                                        continue;
                                    }
                                    throw new Exception(rb.getString("Illegal.value.") + extstr);
                                }
                            }
                        }
                        ext.set("BasicConstraints", new BasicConstraintsExtension(isCritical, isCA, pathLen));
                        break;
                    }
                    case 1: {
                        if (value != null) {
                            boolean[] ok = new boolean[9];
                            for (String s : value.split(",")) {
                                int p = Main.oneOf(s, "digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly", "contentCommitment");
                                if (p < 0) {
                                    throw new Exception(rb.getString("Unknown.keyUsage.type.") + s);
                                }
                                if (p == 9) {
                                    p = 1;
                                }
                                ok[p] = true;
                            }
                            KeyUsageExtension kue = new KeyUsageExtension(ok);
                            ext.set("KeyUsage", Extension.newExtension(kue.getExtensionId(), isCritical, kue.getExtensionValue()));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + extstr);
                    }
                    case 2: {
                        if (value != null) {
                            Vector<ObjectIdentifier> v = new Vector<ObjectIdentifier>();
                            for (String s : value.split(",")) {
                                int p = Main.oneOf(s, "anyExtendedKeyUsage", "serverAuth", "clientAuth", "codeSigning", "emailProtection", "", "", "", "timeStamping", "OCSPSigning");
                                if (p < 0) {
                                    try {
                                        v.add(new ObjectIdentifier(s));
                                        continue;
                                    }
                                    catch (Exception e) {
                                        throw new Exception(rb.getString("Unknown.extendedkeyUsage.type.") + s);
                                    }
                                }
                                if (p == 0) {
                                    v.add(new ObjectIdentifier("2.5.29.37.0"));
                                    continue;
                                }
                                v.add(new ObjectIdentifier("1.3.6.1.5.5.7.3." + p));
                            }
                            ext.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension((Boolean)isCritical, v));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + extstr);
                    }
                    case 3: 
                    case 4: {
                        String v;
                        int n;
                        GeneralNames gnames;
                        String[] ps;
                        if (value != null) {
                            ps = value.split(",");
                            gnames = new GeneralNames();
                            String[] stringArray = ps;
                            int n2 = stringArray.length;
                            for (n = 0; n < n2; ++n) {
                                String item = stringArray[n];
                                colonpos = item.indexOf(58);
                                if (colonpos < 0) {
                                    throw new Exception("Illegal item " + item + " in " + extstr);
                                }
                                String t = item.substring(0, colonpos);
                                v = item.substring(colonpos + 1);
                                gnames.add(this.createGeneralName(t, v));
                            }
                            if (exttype == 3) {
                                ext.set("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)isCritical, gnames));
                                break;
                            }
                            ext.set("IssuerAlternativeName", new IssuerAlternativeNameExtension((Boolean)isCritical, gnames));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + extstr);
                    }
                    case 5: 
                    case 6: {
                        int n;
                        if (isCritical) {
                            throw new Exception(rb.getString("This.extension.cannot.be.marked.as.critical.") + extstr);
                        }
                        if (value != null) {
                            String[] ps;
                            ArrayList<AccessDescription> accessDescriptions = new ArrayList<AccessDescription>();
                            String[] stringArray = ps = value.split(",");
                            int n3 = stringArray.length;
                            for (n = 0; n < n3; ++n) {
                                ObjectIdentifier oid;
                                String item = stringArray[n];
                                colonpos = item.indexOf(58);
                                int colonpos2 = item.indexOf(58, colonpos + 1);
                                if (colonpos < 0 || colonpos2 < 0) {
                                    throw new Exception(rb.getString("Illegal.value.") + extstr);
                                }
                                String m = item.substring(0, colonpos);
                                String t = item.substring(colonpos + 1, colonpos2);
                                String v = item.substring(colonpos2 + 1);
                                int p = Main.oneOf(m, "", "ocsp", "caIssuers", "timeStamping", "", "caRepository");
                                if (p < 0) {
                                    try {
                                        oid = new ObjectIdentifier(m);
                                    }
                                    catch (Exception e) {
                                        throw new Exception(rb.getString("Unknown.AccessDescription.type.") + m);
                                    }
                                } else {
                                    oid = new ObjectIdentifier("1.3.6.1.5.5.7.48." + p);
                                }
                                accessDescriptions.add(new AccessDescription(oid, this.createGeneralName(t, v)));
                            }
                            if (exttype == 5) {
                                ext.set("SubjectInfoAccess", new SubjectInfoAccessExtension(accessDescriptions));
                                break;
                            }
                            ext.set("AuthorityInfoAccess", new AuthorityInfoAccessExtension(accessDescriptions));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + extstr);
                    }
                    case 8: {
                        String v;
                        int n;
                        GeneralNames gnames;
                        String[] ps;
                        if (value != null) {
                            ps = value.split(",");
                            gnames = new GeneralNames();
                            String[] stringArray = ps;
                            int n4 = stringArray.length;
                            for (n = 0; n < n4; ++n) {
                                String item = stringArray[n];
                                colonpos = item.indexOf(58);
                                if (colonpos < 0) {
                                    throw new Exception("Illegal item " + item + " in " + extstr);
                                }
                                String t = item.substring(0, colonpos);
                                v = item.substring(colonpos + 1);
                                gnames.add(this.createGeneralName(t, v));
                            }
                            ext.set("CRLDistributionPoints", new CRLDistributionPointsExtension(isCritical, Collections.singletonList(new DistributionPoint(gnames, null, null))));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + extstr);
                    }
                    case -1: {
                        int n;
                        ObjectIdentifier oid = new ObjectIdentifier(name);
                        byte[] data = null;
                        if (value != null) {
                            data = new byte[value.length() / 2 + 1];
                            int pos = 0;
                            char[] cArray = value.toCharArray();
                            n = cArray.length;
                            for (int i = 0; i < n; ++i) {
                                int hex;
                                char c = cArray[i];
                                if (c >= '0' && c <= '9') {
                                    hex = c - 48;
                                } else if (c >= 'A' && c <= 'F') {
                                    hex = c - 65 + 10;
                                } else {
                                    if (c < 'a' || c > 'f') continue;
                                    hex = c - 97 + 10;
                                }
                                if (pos % 2 == 0) {
                                    data[pos / 2] = (byte)(hex << 4);
                                } else {
                                    int n5 = pos / 2;
                                    data[n5] = (byte)(data[n5] + hex);
                                }
                                ++pos;
                            }
                            if (pos % 2 != 0) {
                                throw new Exception(rb.getString("Odd.number.of.hex.digits.found.") + extstr);
                            }
                            data = Arrays.copyOf(data, pos / 2);
                        } else {
                            data = new byte[]{};
                        }
                        ext.set(oid.toString(), new Extension(oid, isCritical, new DerValue(4, data).toByteArray()));
                        break;
                    }
                    default: {
                        throw new Exception(rb.getString("Unknown.extension.type.") + extstr);
                    }
                }
            }
            ext.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(pkey).getIdentifier()));
            if (akey != null && !pkey.equals(akey)) {
                ext.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(akey), null, null));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ext;
    }

    private boolean isTrustedCert(Certificate cert) throws KeyStoreException {
        if (this.caks != null && this.caks.getCertificateAlias(cert) != null) {
            return true;
        }
        String inKS = this.keyStore.getCertificateAlias(cert);
        return inKS != null && this.keyStore.isCertificateEntry(inKS);
    }

    private void checkWeak(String label, String sigAlg, Key key) {
        if (sigAlg != null && !DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, sigAlg, null)) {
            this.weakWarnings.add(String.format(rb.getString("whose.sigalg.risk"), label, sigAlg));
        }
        if (key != null && !DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, key)) {
            this.weakWarnings.add(String.format(rb.getString("whose.key.risk"), label, String.format(rb.getString("key.bit"), KeyUtil.getKeySize(key), key.getAlgorithm())));
        }
    }

    private void checkWeak(String label, Certificate[] certs) throws KeyStoreException {
        for (int i = 0; i < certs.length; ++i) {
            Certificate cert = certs[i];
            if (!(cert instanceof X509Certificate)) continue;
            X509Certificate xc = (X509Certificate)cert;
            String fullLabel = label;
            if (certs.length > 1) {
                fullLabel = Main.oneInMany(label, i, certs.length);
            }
            this.checkWeak(fullLabel, xc);
        }
    }

    private void checkWeak(String label, Certificate cert) throws KeyStoreException {
        if (cert instanceof X509Certificate) {
            X509Certificate xc = (X509Certificate)cert;
            String sigAlg = this.isTrustedCert(cert) ? null : xc.getSigAlgName();
            this.checkWeak(label, sigAlg, (Key)xc.getPublicKey());
        }
    }

    private void checkWeak(String label, PKCS10 p10) {
        this.checkWeak(label, p10.getSigAlg(), (Key)p10.getSubjectPublicKeyInfo());
    }

    private void checkWeak(String label, CRL crl, Key key) {
        if (crl instanceof X509CRLImpl) {
            X509CRLImpl impl = (X509CRLImpl)crl;
            this.checkWeak(label, impl.getSigAlgName(), key);
        }
    }

    private void printWeakWarnings(boolean newLine) {
        if (!this.weakWarnings.isEmpty() && !this.nowarn) {
            System.err.println("\nWarning:");
            for (String warning : this.weakWarnings) {
                System.err.println(warning);
            }
            if (newLine) {
                System.err.println();
            }
        }
        this.weakWarnings.clear();
    }

    private void usage() {
        if (this.command != null) {
            int j;
            System.err.println("keytool " + (Object)((Object)this.command) + rb.getString(".OPTION."));
            System.err.println();
            System.err.println(rb.getString(this.command.description));
            System.err.println();
            System.err.println(rb.getString("Options."));
            System.err.println();
            String[] left = new String[this.command.options.length];
            String[] right = new String[this.command.options.length];
            boolean found = false;
            int lenLeft = 0;
            for (j = 0; j < left.length; ++j) {
                Option opt = this.command.options[j];
                left[j] = opt.toString();
                if (opt.arg != null) {
                    int n = j;
                    left[n] = left[n] + " " + opt.arg;
                }
                if (left[j].length() > lenLeft) {
                    lenLeft = left[j].length();
                }
                right[j] = rb.getString(opt.description);
            }
            for (j = 0; j < left.length; ++j) {
                System.err.printf(" %-" + lenLeft + "s  %s\n", left[j], right[j]);
            }
            System.err.println();
            System.err.println(rb.getString("Use.keytool.help.for.all.available.commands"));
        } else {
            System.err.println(rb.getString("Key.and.Certificate.Management.Tool"));
            System.err.println();
            System.err.println(rb.getString("Commands."));
            System.err.println();
            for (Command c : Command.values()) {
                if (c == Command.KEYCLONE) break;
                System.err.printf(" %-20s%s\n", new Object[]{c, rb.getString(c.description)});
            }
            System.err.println();
            System.err.println(rb.getString("Use.keytool.command.name.help.for.usage.of.command.name"));
        }
    }

    private void tinyHelp() {
        this.usage();
        if (this.debug) {
            throw new RuntimeException("NO BIG ERROR, SORRY");
        }
        System.exit(1);
    }

    private void errorNeedArgument(String flag) {
        Object[] source = new Object[]{flag};
        System.err.println(new MessageFormat(rb.getString("Command.option.flag.needs.an.argument.")).format(source));
        this.tinyHelp();
    }

    private char[] getPass(String modifier, String arg) {
        char[] output = KeyStoreUtil.getPassWithModifier(modifier, arg, rb);
        if (output != null) {
            return output;
        }
        this.tinyHelp();
        return null;
    }

    static {
        collator.setStrength(0);
        extSupported = new String[]{"BasicConstraints", "KeyUsage", "ExtendedKeyUsage", "SubjectAlternativeName", "IssuerAlternativeName", "SubjectInfoAccess", "AuthorityInfoAccess", null, "CRLDistributionPoints"};
    }

    static enum Option {
        ALIAS("alias", "<alias>", "alias.name.of.the.entry.to.process"),
        DESTALIAS("destalias", "<destalias>", "destination.alias"),
        DESTKEYPASS("destkeypass", "<arg>", "destination.key.password"),
        DESTKEYSTORE("destkeystore", "<destkeystore>", "destination.keystore.name"),
        DESTPROTECTED("destprotected", null, "destination.keystore.password.protected"),
        DESTPROVIDERNAME("destprovidername", "<destprovidername>", "destination.keystore.provider.name"),
        DESTSTOREPASS("deststorepass", "<arg>", "destination.keystore.password"),
        DESTSTORETYPE("deststoretype", "<deststoretype>", "destination.keystore.type"),
        DNAME("dname", "<dname>", "distinguished.name"),
        EXT("ext", "<value>", "X.509.extension"),
        FILEOUT("file", "<filename>", "output.file.name"),
        FILEIN("file", "<filename>", "input.file.name"),
        ID("id", "<id:reason>", "Serial.ID.of.cert.to.revoke"),
        INFILE("infile", "<filename>", "input.file.name"),
        KEYALG("keyalg", "<keyalg>", "key.algorithm.name"),
        KEYPASS("keypass", "<arg>", "key.password"),
        KEYSIZE("keysize", "<keysize>", "key.bit.size"),
        KEYSTORE("keystore", "<keystore>", "keystore.name"),
        NEW("new", "<arg>", "new.password"),
        NOPROMPT("noprompt", null, "do.not.prompt"),
        OUTFILE("outfile", "<filename>", "output.file.name"),
        PROTECTED("protected", null, "password.through.protected.mechanism"),
        PROVIDERARG("providerarg", "<arg>", "provider.argument"),
        PROVIDERCLASS("providerclass", "<providerclass>", "provider.class.name"),
        PROVIDERNAME("providername", "<providername>", "provider.name"),
        PROVIDERPATH("providerpath", "<pathlist>", "provider.classpath"),
        RFC("rfc", null, "output.in.RFC.style"),
        SIGALG("sigalg", "<sigalg>", "signature.algorithm.name"),
        SRCALIAS("srcalias", "<srcalias>", "source.alias"),
        SRCKEYPASS("srckeypass", "<arg>", "source.key.password"),
        SRCKEYSTORE("srckeystore", "<srckeystore>", "source.keystore.name"),
        SRCPROTECTED("srcprotected", null, "source.keystore.password.protected"),
        SRCPROVIDERNAME("srcprovidername", "<srcprovidername>", "source.keystore.provider.name"),
        SRCSTOREPASS("srcstorepass", "<arg>", "source.keystore.password"),
        SRCSTORETYPE("srcstoretype", "<srcstoretype>", "source.keystore.type"),
        SSLSERVER("sslserver", "<server[:port]>", "SSL.server.host.and.port"),
        JARFILE("jarfile", "<filename>", "signed.jar.file"),
        STARTDATE("startdate", "<startdate>", "certificate.validity.start.date.time"),
        STOREPASS("storepass", "<arg>", "keystore.password"),
        STORETYPE("storetype", "<storetype>", "keystore.type"),
        SYSTEMLINEENDINGS("systemlineendings", null, "system.line.endings"),
        TRUSTCACERTS("trustcacerts", null, "trust.certificates.from.cacerts"),
        V("v", null, "verbose.output"),
        VALIDITY("validity", "<valDays>", "validity.number.of.days");

        final String name;
        final String arg;
        final String description;

        private Option(String name, String arg, String description) {
            this.name = name;
            this.arg = arg;
            this.description = description;
        }

        public String toString() {
            return "-" + this.name;
        }
    }

    static enum Command {
        CERTREQ("Generates.a.certificate.request", Option.ALIAS, Option.SIGALG, Option.FILEOUT, Option.KEYPASS, Option.KEYSTORE, Option.DNAME, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.SYSTEMLINEENDINGS, Option.V, Option.PROTECTED),
        CHANGEALIAS("Changes.an.entry.s.alias", Option.ALIAS, Option.DESTALIAS, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        DELETE("Deletes.an.entry", Option.ALIAS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        EXPORTCERT("Exports.certificate", Option.RFC, Option.ALIAS, Option.FILEOUT, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        GENKEYPAIR("Generates.a.key.pair", Option.ALIAS, Option.KEYALG, Option.KEYSIZE, Option.SIGALG, Option.DESTALIAS, Option.DNAME, Option.STARTDATE, Option.EXT, Option.VALIDITY, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        GENSECKEY("Generates.a.secret.key", Option.ALIAS, Option.KEYPASS, Option.KEYALG, Option.KEYSIZE, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        GENCERT("Generates.certificate.from.a.certificate.request", Option.RFC, Option.INFILE, Option.OUTFILE, Option.ALIAS, Option.SIGALG, Option.DNAME, Option.STARTDATE, Option.EXT, Option.VALIDITY, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        IMPORTCERT("Imports.a.certificate.or.a.certificate.chain", Option.NOPROMPT, Option.TRUSTCACERTS, Option.PROTECTED, Option.ALIAS, Option.FILEIN, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        IMPORTPASS("Imports.a.password", Option.ALIAS, Option.KEYPASS, Option.KEYALG, Option.KEYSIZE, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        IMPORTKEYSTORE("Imports.one.or.all.entries.from.another.keystore", Option.SRCKEYSTORE, Option.DESTKEYSTORE, Option.SRCSTORETYPE, Option.DESTSTORETYPE, Option.SRCSTOREPASS, Option.DESTSTOREPASS, Option.SRCPROTECTED, Option.SRCPROVIDERNAME, Option.DESTPROVIDERNAME, Option.SRCALIAS, Option.DESTALIAS, Option.SRCKEYPASS, Option.DESTKEYPASS, Option.NOPROMPT, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        KEYPASSWD("Changes.the.key.password.of.an.entry", Option.ALIAS, Option.KEYPASS, Option.NEW, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        LIST("Lists.entries.in.a.keystore", Option.RFC, Option.ALIAS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        PRINTCERT("Prints.the.content.of.a.certificate", Option.RFC, Option.FILEIN, Option.SSLSERVER, Option.JARFILE, Option.V),
        PRINTCERTREQ("Prints.the.content.of.a.certificate.request", Option.FILEIN, Option.V),
        PRINTCRL("Prints.the.content.of.a.CRL.file", Option.FILEIN, Option.V),
        STOREPASSWD("Changes.the.store.password.of.a.keystore", Option.NEW, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        KEYCLONE("Clones.a.key.entry", Option.ALIAS, Option.DESTALIAS, Option.KEYPASS, Option.NEW, Option.STORETYPE, Option.KEYSTORE, Option.STOREPASS, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        SELFCERT("Generates.a.self.signed.certificate", Option.ALIAS, Option.SIGALG, Option.DNAME, Option.STARTDATE, Option.VALIDITY, Option.KEYPASS, Option.STORETYPE, Option.KEYSTORE, Option.STOREPASS, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        GENCRL("Generates.CRL", Option.RFC, Option.FILEOUT, Option.ID, Option.ALIAS, Option.SIGALG, Option.EXT, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        IDENTITYDB("Imports.entries.from.a.JDK.1.1.x.style.identity.database", Option.FILEIN, Option.STORETYPE, Option.KEYSTORE, Option.STOREPASS, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V);

        final String description;
        final Option[] options;

        private Command(String d, Option ... o) {
            this.description = d;
            this.options = o;
        }

        public String toString() {
            return "-" + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

