/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelPerformer;
import java.util.Arrays;

public final class ModelStandardDirector
implements ModelDirector {
    private final ModelPerformer[] performers;
    private final ModelDirectedPlayer player;
    private boolean noteOnUsed = false;
    private boolean noteOffUsed = false;

    public ModelStandardDirector(ModelPerformer[] performers, ModelDirectedPlayer player) {
        this.performers = Arrays.copyOf(performers, performers.length);
        this.player = player;
        for (ModelPerformer p : this.performers) {
            if (p.isReleaseTriggered()) {
                this.noteOffUsed = true;
                continue;
            }
            this.noteOnUsed = true;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void noteOff(int noteNumber, int velocity) {
        if (!this.noteOffUsed) {
            return;
        }
        for (int i = 0; i < this.performers.length; ++i) {
            ModelPerformer p = this.performers[i];
            if (p.getKeyFrom() > noteNumber || p.getKeyTo() < noteNumber || p.getVelFrom() > velocity || p.getVelTo() < velocity || !p.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }

    @Override
    public void noteOn(int noteNumber, int velocity) {
        if (!this.noteOnUsed) {
            return;
        }
        for (int i = 0; i < this.performers.length; ++i) {
            ModelPerformer p = this.performers[i];
            if (p.getKeyFrom() > noteNumber || p.getKeyTo() < noteNumber || p.getVelFrom() > velocity || p.getVelTo() < velocity || p.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }
}

