/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.windows.EHTMLReadMode;
import sun.awt.windows.HTMLCodec;
import sun.awt.windows.WToolkitThreadBlockedHandler;

final class WDataTransferer
extends DataTransferer {
    private static final String[] predefinedClipboardNames = new String[]{"", "TEXT", "BITMAP", "METAFILEPICT", "SYLK", "DIF", "TIFF", "OEM TEXT", "DIB", "PALETTE", "PENDATA", "RIFF", "WAVE", "UNICODE TEXT", "ENHMETAFILE", "HDROP", "LOCALE", "DIBV5"};
    private static final Map<String, Long> predefinedClipboardNameMap;
    public static final int CF_TEXT = 1;
    public static final int CF_METAFILEPICT = 3;
    public static final int CF_DIB = 8;
    public static final int CF_ENHMETAFILE = 14;
    public static final int CF_HDROP = 15;
    public static final int CF_LOCALE = 16;
    public static final long CF_HTML;
    public static final long CFSTR_INETURL;
    public static final long CF_PNG;
    public static final long CF_JFIF;
    public static final long CF_FILEGROUPDESCRIPTORW;
    public static final long CF_FILEGROUPDESCRIPTORA;
    private static final Long L_CF_LOCALE;
    private static final DirectColorModel directColorModel;
    private static final int[] bandmasks;
    private static WDataTransferer transferer;
    private final ToolkitThreadBlockedHandler handler = new WToolkitThreadBlockedHandler();
    private static final byte[] UNICODE_NULL_TERMINATOR;

    private WDataTransferer() {
    }

    static synchronized WDataTransferer getInstanceImpl() {
        if (transferer == null) {
            transferer = new WDataTransferer();
        }
        return transferer;
    }

    @Override
    public SortedMap<Long, DataFlavor> getFormatsForFlavors(DataFlavor[] flavors, FlavorTable map) {
        SortedMap<Long, DataFlavor> retval = super.getFormatsForFlavors(flavors, map);
        retval.remove(L_CF_LOCALE);
        return retval;
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    @Override
    public byte[] translateTransferable(Transferable contents, DataFlavor flavor, long format) throws IOException {
        byte[] bytes = null;
        bytes = format == CF_HTML ? (contents.isDataFlavorSupported(DataFlavor.selectionHtmlFlavor) ? super.translateTransferable(contents, DataFlavor.selectionHtmlFlavor, format) : (contents.isDataFlavorSupported(DataFlavor.allHtmlFlavor) ? super.translateTransferable(contents, DataFlavor.allHtmlFlavor, format) : HTMLCodec.convertToHTMLFormat(super.translateTransferable(contents, flavor, format)))) : super.translateTransferable(contents, flavor, format);
        return bytes;
    }

    @Override
    public Object translateStream(InputStream str, DataFlavor flavor, long format, Transferable localeTransferable) throws IOException {
        if (format == CF_HTML && flavor.isFlavorTextType()) {
            str = new HTMLCodec(str, EHTMLReadMode.getEHTMLReadMode(flavor));
        }
        return super.translateStream(str, flavor, format, localeTransferable);
    }

    @Override
    public Object translateBytes(byte[] bytes, DataFlavor flavor, long format, Transferable localeTransferable) throws IOException {
        if (format == CF_FILEGROUPDESCRIPTORA || format == CF_FILEGROUPDESCRIPTORW) {
            if (bytes == null || !DataFlavor.javaFileListFlavor.equals(flavor)) {
                throw new IOException("data translation failed");
            }
            String st = new String(bytes, 0, bytes.length, "UTF-16LE");
            String[] filenames = st.split("\u0000");
            if (0 == filenames.length) {
                return null;
            }
            File[] files = new File[filenames.length];
            for (int i = 0; i < filenames.length; ++i) {
                files[i] = new File(filenames[i]);
                files[i].deleteOnExit();
            }
            return Arrays.asList(files);
        }
        if (format == CFSTR_INETURL && URL.class.equals(flavor.getRepresentationClass())) {
            String charset = WDataTransferer.getDefaultTextCharset();
            if (localeTransferable != null && localeTransferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    charset = new String((byte[])localeTransferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(bytes, charset));
        }
        return super.translateBytes(bytes, flavor, format, localeTransferable);
    }

    @Override
    public boolean isLocaleDependentTextFormat(long format) {
        return format == 1L || format == CFSTR_INETURL;
    }

    @Override
    public boolean isFileFormat(long format) {
        return format == 15L || format == CF_FILEGROUPDESCRIPTORA || format == CF_FILEGROUPDESCRIPTORW;
    }

    @Override
    protected Long getFormatForNativeAsLong(String str) {
        Long format = predefinedClipboardNameMap.get(str);
        if (format == null) {
            format = WDataTransferer.registerClipboardFormat(str);
        }
        return format;
    }

    @Override
    protected String getNativeForFormat(long format) {
        return format < (long)predefinedClipboardNames.length ? predefinedClipboardNames[(int)format] : WDataTransferer.getClipboardFormatName(format);
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    private static native long registerClipboardFormat(String var0);

    private static native String getClipboardFormatName(long var0);

    @Override
    public boolean isImageFormat(long format) {
        return format == 8L || format == 14L || format == 3L || format == CF_PNG || format == CF_JFIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] imageToPlatformBytes(Image image, long format) throws IOException {
        String mimeType = null;
        if (format == CF_PNG) {
            mimeType = "image/png";
        } else if (format == CF_JFIF) {
            mimeType = "image/jpeg";
        }
        if (mimeType != null) {
            return this.imageToStandardBytes(image, mimeType);
        }
        int width = 0;
        int height = 0;
        if (image instanceof ToolkitImage) {
            ImageRepresentation ir = ((ToolkitImage)image).getImageRep();
            ir.reconstruct(32);
            width = ir.getWidth();
            height = ir.getHeight();
        } else {
            width = image.getWidth(null);
            height = image.getHeight(null);
        }
        int mod = width * 3 % 4;
        int pad = mod > 0 ? 4 - mod : 0;
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        int[] bOffs = new int[]{2, 1, 0};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, width, height, width * 3 + pad, 3, bOffs, null);
        BufferedImage bimage = new BufferedImage(colorModel, raster, false, null);
        AffineTransform imageFlipTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, height);
        Graphics2D g2d = bimage.createGraphics();
        try {
            g2d.drawImage(image, imageFlipTransform, null);
        }
        finally {
            g2d.dispose();
        }
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        byte[] imageData = buffer.getData();
        return this.imageDataToPlatformImageBytes(imageData, width, height, format);
    }

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> fileList) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (fileList.isEmpty()) {
            bos.write(UNICODE_NULL_TERMINATOR);
        } else {
            for (int i = 0; i < fileList.size(); ++i) {
                byte[] bytes = fileList.get(i).getBytes(this.getDefaultUnicodeEncoding());
                bos.write(bytes, 0, bytes.length);
                bos.write(UNICODE_NULL_TERMINATOR);
            }
        }
        bos.write(UNICODE_NULL_TERMINATOR);
        return bos;
    }

    private native byte[] imageDataToPlatformImageBytes(byte[] var1, int var2, int var3, long var4);

    @Override
    protected Image platformImageBytesToImage(byte[] bytes, long format) throws IOException {
        String mimeType = null;
        if (format == CF_PNG) {
            mimeType = "image/png";
        } else if (format == CF_JFIF) {
            mimeType = "image/jpeg";
        }
        if (mimeType != null) {
            return this.standardImageBytesToImage(bytes, mimeType);
        }
        int[] imageData = this.platformImageBytesToImageData(bytes, format);
        if (imageData == null) {
            throw new IOException("data translation failed");
        }
        int len = imageData.length - 2;
        int width = imageData[len];
        int height = imageData[len + 1];
        DataBufferInt buffer = new DataBufferInt(imageData, len);
        WritableRaster raster = Raster.createPackedRaster(buffer, width, height, width, bandmasks, null);
        return new BufferedImage(directColorModel, raster, false, null);
    }

    private native int[] platformImageBytesToImageData(byte[] var1, long var2) throws IOException;

    @Override
    protected native String[] dragQueryFile(byte[] var1);

    static {
        HashMap<String, Long> tempMap = new HashMap<String, Long>(predefinedClipboardNames.length, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            tempMap.put(predefinedClipboardNames[i], Long.valueOf(i));
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(tempMap);
        CF_HTML = WDataTransferer.registerClipboardFormat("HTML Format");
        CFSTR_INETURL = WDataTransferer.registerClipboardFormat("UniformResourceLocator");
        CF_PNG = WDataTransferer.registerClipboardFormat("PNG");
        CF_JFIF = WDataTransferer.registerClipboardFormat("JFIF");
        CF_FILEGROUPDESCRIPTORW = WDataTransferer.registerClipboardFormat("FileGroupDescriptorW");
        CF_FILEGROUPDESCRIPTORA = WDataTransferer.registerClipboardFormat("FileGroupDescriptor");
        L_CF_LOCALE = predefinedClipboardNameMap.get(predefinedClipboardNames[16]);
        directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        bandmasks = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
        UNICODE_NULL_TERMINATOR = new byte[]{0, 0};
    }
}

