/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.shenandoah;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.shenandoah.ShenandoahHeapRegion;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.JLongField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ShenandoahHeap
extends CollectedHeap {
    private static CIntegerField numRegions;
    private static JLongField usedRegions;
    private static CIntegerField committedRegions;
    private static AddressField regionsField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ShenandoahHeap");
        numRegions = type.getCIntegerField("_num_regions");
        usedRegions = type.getJLongField("_used");
        committedRegions = type.getCIntegerField("_committed");
        regionsField = type.getAddressField("_regions");
    }

    @Override
    public CollectedHeapName kind() {
        return CollectedHeapName.SHENANDOAH_HEAP;
    }

    public long numOfRegions() {
        return numRegions.getValue(this.addr);
    }

    @Override
    public long used() {
        return usedRegions.getValue(this.addr);
    }

    public long committed() {
        return committedRegions.getValue(this.addr);
    }

    public void heapRegionIterate(SpaceClosure scl) {
        int numRgns = (int)numRegions.getValue(this.addr);
        for (int index = 0; index < numRgns; ++index) {
            ShenandoahHeapRegion r = this.getRegion(index);
            if (r.isTrash() || r.isUncommitted() || r.isEmpty()) continue;
            scl.doSpace(r);
        }
    }

    @Override
    public int oop_extra_words() {
        return 1;
    }

    @Override
    public int oop_region_offset_words() {
        return 1;
    }

    @Override
    public void printOn(PrintStream tty) {
        MemRegion mr = this.reservedRegion();
        tty.print("Shenandoah heap");
        tty.print(" [" + mr.start() + ", " + mr.end() + "]");
        tty.println(" region size " + ShenandoahHeapRegion.regionSizeBytes() / 1024L + " K");
    }

    private ShenandoahHeapRegion getRegion(int index) {
        Address regsAddr = regionsField.getValue(this.addr);
        return (ShenandoahHeapRegion)VMObjectFactory.newObject(ShenandoahHeapRegion.class, regsAddr.getAddressAt((long)index * VM.getVM().getAddressSize()));
    }

    public ShenandoahHeap(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ShenandoahHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

