/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_implementation.g1.G1CollectedHeap;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSOldGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSYoungGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.ParallelScavengeHeap;
import sun.jvm.hotspot.gc_implementation.shenandoah.ShenandoahHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.CompactibleFreeListSpace;
import sun.jvm.hotspot.memory.ConcurrentMarkSweepGeneration;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.memory.Space;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.oops.HeapPrinter;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.RawHeapVisitor;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.ThreadLocalAllocBuffer;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class ObjectHeap {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.oops.ObjectHeap.DEBUG") != null;
    private Address boolArrayKlassHandle;
    private Address byteArrayKlassHandle;
    private Address charArrayKlassHandle;
    private Address intArrayKlassHandle;
    private Address shortArrayKlassHandle;
    private Address longArrayKlassHandle;
    private Address singleArrayKlassHandle;
    private Address doubleArrayKlassHandle;
    private TypeArrayKlass boolArrayKlassObj;
    private TypeArrayKlass byteArrayKlassObj;
    private TypeArrayKlass charArrayKlassObj;
    private TypeArrayKlass intArrayKlassObj;
    private TypeArrayKlass shortArrayKlassObj;
    private TypeArrayKlass longArrayKlassObj;
    private TypeArrayKlass singleArrayKlassObj;
    private TypeArrayKlass doubleArrayKlassObj;
    private long oopSize = VM.getVM().getOopSize();
    private long byteSize;
    private long charSize;
    private long booleanSize;
    private long intSize;
    private long shortSize;
    private long longSize;
    private long floatSize;
    private long doubleSize;

    public void initialize(TypeDataBase db) throws WrongTypeException {
        Type universeType = db.lookupType("Universe");
        this.boolArrayKlassHandle = universeType.getAddressField("_boolArrayKlassObj").getValue();
        this.boolArrayKlassObj = new TypeArrayKlass(this.boolArrayKlassHandle);
        this.byteArrayKlassHandle = universeType.getAddressField("_byteArrayKlassObj").getValue();
        this.byteArrayKlassObj = new TypeArrayKlass(this.byteArrayKlassHandle);
        this.charArrayKlassHandle = universeType.getAddressField("_charArrayKlassObj").getValue();
        this.charArrayKlassObj = new TypeArrayKlass(this.charArrayKlassHandle);
        this.intArrayKlassHandle = universeType.getAddressField("_intArrayKlassObj").getValue();
        this.intArrayKlassObj = new TypeArrayKlass(this.intArrayKlassHandle);
        this.shortArrayKlassHandle = universeType.getAddressField("_shortArrayKlassObj").getValue();
        this.shortArrayKlassObj = new TypeArrayKlass(this.shortArrayKlassHandle);
        this.longArrayKlassHandle = universeType.getAddressField("_longArrayKlassObj").getValue();
        this.longArrayKlassObj = new TypeArrayKlass(this.longArrayKlassHandle);
        this.singleArrayKlassHandle = universeType.getAddressField("_singleArrayKlassObj").getValue();
        this.singleArrayKlassObj = new TypeArrayKlass(this.singleArrayKlassHandle);
        this.doubleArrayKlassHandle = universeType.getAddressField("_doubleArrayKlassObj").getValue();
        this.doubleArrayKlassObj = new TypeArrayKlass(this.doubleArrayKlassHandle);
    }

    public ObjectHeap(TypeDataBase db) throws WrongTypeException {
        this.byteSize = db.getJByteType().getSize();
        this.charSize = db.getJCharType().getSize();
        this.booleanSize = db.getJBooleanType().getSize();
        this.intSize = db.getJIntType().getSize();
        this.shortSize = db.getJShortType().getSize();
        this.longSize = db.getJLongType().getSize();
        this.floatSize = db.getJFloatType().getSize();
        this.doubleSize = db.getJDoubleType().getSize();
        this.initialize(db);
    }

    public boolean equal(Oop o1, Oop o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public long getOopSize() {
        return this.oopSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public long getCharSize() {
        return this.charSize;
    }

    public long getBooleanSize() {
        return this.booleanSize;
    }

    public long getIntSize() {
        return this.intSize;
    }

    public long getShortSize() {
        return this.shortSize;
    }

    public long getLongSize() {
        return this.longSize;
    }

    public long getFloatSize() {
        return this.floatSize;
    }

    public long getDoubleSize() {
        return this.doubleSize;
    }

    public TypeArrayKlass getBoolArrayKlassObj() {
        return this.boolArrayKlassObj;
    }

    public TypeArrayKlass getByteArrayKlassObj() {
        return this.byteArrayKlassObj;
    }

    public TypeArrayKlass getCharArrayKlassObj() {
        return this.charArrayKlassObj;
    }

    public TypeArrayKlass getIntArrayKlassObj() {
        return this.intArrayKlassObj;
    }

    public TypeArrayKlass getShortArrayKlassObj() {
        return this.shortArrayKlassObj;
    }

    public TypeArrayKlass getLongArrayKlassObj() {
        return this.longArrayKlassObj;
    }

    public TypeArrayKlass getSingleArrayKlassObj() {
        return this.singleArrayKlassObj;
    }

    public TypeArrayKlass getDoubleArrayKlassObj() {
        return this.doubleArrayKlassObj;
    }

    public Klass typeArrayKlassObj(int t) {
        if (t == BasicType.getTBoolean()) {
            return this.getBoolArrayKlassObj();
        }
        if (t == BasicType.getTChar()) {
            return this.getCharArrayKlassObj();
        }
        if (t == BasicType.getTFloat()) {
            return this.getSingleArrayKlassObj();
        }
        if (t == BasicType.getTDouble()) {
            return this.getDoubleArrayKlassObj();
        }
        if (t == BasicType.getTByte()) {
            return this.getByteArrayKlassObj();
        }
        if (t == BasicType.getTShort()) {
            return this.getShortArrayKlassObj();
        }
        if (t == BasicType.getTInt()) {
            return this.getIntArrayKlassObj();
        }
        if (t == BasicType.getTLong()) {
            return this.getLongArrayKlassObj();
        }
        throw new RuntimeException("Illegal basic type " + t);
    }

    public void iterate(HeapVisitor visitor) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, null);
    }

    public void iterate(HeapVisitor visitor, ObjectFilter of) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, of);
    }

    public void iterateObjectsOfKlass(HeapVisitor visitor, Klass k, boolean includeSubtypes) {
        if (includeSubtypes) {
            if (k.isFinal()) {
                this.iterateExact(visitor, k);
            } else {
                this.iterateSubtypes(visitor, k);
            }
        } else if (!k.isAbstract() && !k.isInterface()) {
            this.iterateExact(visitor, k);
        }
    }

    public void iterateObjectsOfKlass(HeapVisitor visitor, Klass k) {
        this.iterateObjectsOfKlass(visitor, k, true);
    }

    public void iterateRaw(RawHeapVisitor visitor) {
        Address top;
        Address bottom;
        int i;
        List liveRegions = this.collectLiveRegions();
        long totalSize = 0L;
        for (i = 0; i < liveRegions.size(); i += 2) {
            bottom = (Address)liveRegions.get(i);
            top = (Address)liveRegions.get(i + 1);
            totalSize += top.minus(bottom);
        }
        visitor.prologue(totalSize);
        for (i = 0; i < liveRegions.size(); i += 2) {
            bottom = (Address)liveRegions.get(i);
            top = (Address)liveRegions.get(i + 1);
            while (bottom.lessThan(top)) {
                visitor.visitAddress(bottom);
                bottom = bottom.addOffsetTo(VM.getVM().getAddressSize());
            }
        }
        visitor.epilogue();
    }

    public boolean isValidMethod(Address handle) {
        try {
            Method m = (Method)Metadata.instantiateWrapperFor(handle);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Oop newOop(OopHandle handle) {
        if (handle == null) {
            return null;
        }
        Klass klass = Oop.getKlassForOopHandle(handle);
        if (klass != null) {
            if (klass instanceof TypeArrayKlass) {
                return new TypeArray(handle, this);
            }
            if (klass instanceof ObjArrayKlass) {
                return new ObjArray(handle, this);
            }
            if (klass instanceof InstanceKlass) {
                return new Instance(handle, this);
            }
        }
        if (DEBUG) {
            System.err.println("Unknown oop at " + handle);
            System.err.println("Oop's klass is " + klass);
        }
        throw new UnknownOopException();
    }

    public void print() {
        HeapPrinter printer = new HeapPrinter(System.out);
        this.iterate(printer);
    }

    private void iterateExact(HeapVisitor visitor, final Klass k) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, new ObjectFilter(){

            @Override
            public boolean canInclude(Oop obj) {
                Klass tk = obj.getKlass();
                return tk != null && tk.equals(k);
            }
        });
    }

    private void iterateSubtypes(HeapVisitor visitor, final Klass k) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, new ObjectFilter(){

            @Override
            public boolean canInclude(Oop obj) {
                Klass tk = obj.getKlass();
                return tk != null && tk.isSubtypeOf(k);
            }
        });
    }

    private void iterateLiveRegions(List liveRegions, HeapVisitor visitor, ObjectFilter of) {
        GenCollectedHeap genHeap;
        Generation genOld;
        long totalSize = 0L;
        for (int i = 0; i < liveRegions.size(); i += 2) {
            Address bottom = (Address)liveRegions.get(i);
            Address top = (Address)liveRegions.get(i + 1);
            totalSize += top.minus(bottom);
        }
        visitor.prologue(totalSize);
        CompactibleFreeListSpace cmsSpaceOld = null;
        CollectedHeap heap = VM.getVM().getUniverse().heap();
        if (heap instanceof GenCollectedHeap && (genOld = (genHeap = (GenCollectedHeap)heap).getGen(1)) instanceof ConcurrentMarkSweepGeneration) {
            ConcurrentMarkSweepGeneration concGen = (ConcurrentMarkSweepGeneration)genOld;
            cmsSpaceOld = concGen.cmsSpace();
        }
        int oop_offset = heap.oop_region_offset_words() * VM.getVM().getHeapWordSize();
        int oop_extra_size = heap.oop_extra_words() * VM.getVM().getHeapWordSize();
        block6: for (int i = 0; i < liveRegions.size(); i += 2) {
            Address bottom = (Address)liveRegions.get(i);
            Address top = (Address)liveRegions.get(i + 1);
            try {
                OopHandle handle = bottom.addOffsetToAsOopHandle(oop_offset);
                while (handle.lessThan(top)) {
                    Oop obj;
                    block13: {
                        obj = null;
                        try {
                            obj = this.newOop(handle);
                        }
                        catch (UnknownOopException exp) {
                            if (!DEBUG) break block13;
                            throw new RuntimeException(" UnknownOopException  " + exp);
                        }
                    }
                    if (obj == null) {
                        long size = 0L;
                        if (cmsSpaceOld != null && cmsSpaceOld.contains(handle)) {
                            size = cmsSpaceOld.collector().blockSizeUsingPrintezisBits(handle);
                        }
                        if (size <= 0L) {
                            throw new UnknownOopException();
                        }
                        handle = handle.addOffsetToAsOopHandle(CompactibleFreeListSpace.adjustObjectSizeInBytes(size));
                        continue;
                    }
                    if ((of == null || of.canInclude(obj)) && visitor.doObj(obj)) continue block6;
                    if (cmsSpaceOld != null && cmsSpaceOld.contains(handle)) {
                        handle = handle.addOffsetToAsOopHandle(CompactibleFreeListSpace.adjustObjectSizeInBytes(obj.getObjectSize()));
                        continue;
                    }
                    handle = handle.addOffsetToAsOopHandle(obj.getObjectSize() + (long)oop_extra_size);
                }
                continue;
            }
            catch (AddressException addressException) {
                continue;
            }
            catch (UnknownOopException unknownOopException) {
                // empty catch block
            }
        }
        visitor.epilogue();
    }

    private void addLiveRegions(String name, List input, List output) {
        for (MemRegion reg : input) {
            Address top = reg.end();
            Address bottom = reg.start();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(top != null, "top address in a live region should not be null");
            }
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(bottom != null, "bottom address in a live region should not be null");
            }
            output.add(top);
            output.add(bottom);
            if (!DEBUG) continue;
            System.err.println("Live region: " + name + ": " + bottom + ", " + top);
        }
    }

    private List collectLiveRegions() {
        ArrayList<Address> liveRegions = new ArrayList<Address>();
        LiveRegionsCollector lrc = new LiveRegionsCollector(liveRegions);
        CollectedHeap heap = VM.getVM().getUniverse().heap();
        if (heap instanceof GenCollectedHeap) {
            GenCollectedHeap genHeap = (GenCollectedHeap)heap;
            for (int i = 0; i < genHeap.nGens(); ++i) {
                Generation gen = genHeap.getGen(i);
                gen.spaceIterate(lrc, true);
            }
        } else if (heap instanceof ParallelScavengeHeap) {
            ParallelScavengeHeap psh = (ParallelScavengeHeap)heap;
            PSYoungGen youngGen = psh.youngGen();
            this.addLiveRegions("eden", youngGen.edenSpace().getLiveRegions(), liveRegions);
            this.addLiveRegions("from", youngGen.fromSpace().getLiveRegions(), liveRegions);
            PSOldGen oldGen = psh.oldGen();
            this.addLiveRegions("old ", oldGen.objectSpace().getLiveRegions(), liveRegions);
        } else if (heap instanceof G1CollectedHeap) {
            G1CollectedHeap g1h = (G1CollectedHeap)heap;
            g1h.heapRegionIterate(lrc);
        } else if (heap instanceof ShenandoahHeap) {
            ShenandoahHeap sh = (ShenandoahHeap)heap;
            sh.heapRegionIterate(lrc);
        } else if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "Expecting GenCollectedHeap, G1CollectedHeap, SheandoahHeap or ParallelScavengeHeap, but got " + heap.getClass().getName());
        }
        if (VM.getVM().getUseTLAB()) {
            for (JavaThread thread = VM.getVM().getThreads().first(); thread != null; thread = thread.next()) {
                ThreadLocalAllocBuffer tlab = thread.tlab();
                if (tlab.start() == null) continue;
                if (tlab.top() == null || tlab.end() == null) {
                    System.err.print("Warning: skipping invalid TLAB for thread ");
                    thread.printThreadIDOn(System.err);
                    System.err.println();
                    continue;
                }
                if (DEBUG) {
                    System.err.print("TLAB for " + thread.getThreadName() + ", #");
                    thread.printThreadIDOn(System.err);
                    System.err.print(": ");
                    tlab.printOn(System.err);
                }
                liveRegions.add(tlab.start());
                liveRegions.add(tlab.start());
                liveRegions.add(tlab.top());
                liveRegions.add(tlab.hardEnd());
            }
        }
        this.sortLiveRegions(liveRegions);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(liveRegions.size() % 2 == 0, "Must have even number of region boundaries");
        }
        if (DEBUG) {
            System.err.println("liveRegions:");
            for (int i = 0; i < liveRegions.size(); i += 2) {
                Address bottom = (Address)liveRegions.get(i);
                Address top = (Address)liveRegions.get(i + 1);
                System.err.println(" " + bottom + " - " + top);
            }
        }
        return liveRegions;
    }

    private void sortLiveRegions(List liveRegions) {
        Collections.sort(liveRegions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Address a1 = (Address)o1;
                Address a2 = (Address)o2;
                if (AddressOps.lt(a1, a2)) {
                    return -1;
                }
                if (AddressOps.gt(a1, a2)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private class LiveRegionsCollector
    implements SpaceClosure {
        private List liveRegions;

        LiveRegionsCollector(List l) {
            this.liveRegions = l;
        }

        @Override
        public void doSpace(Space s) {
            ObjectHeap.this.addLiveRegions(s.toString(), s.getLiveRegions(), this.liveRegions);
        }
    }

    public static interface ObjectFilter {
        public boolean canInclude(Oop var1);
    }
}

