/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.shenandoah;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.ContiguousSpace;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ShenandoahHeapRegion
extends ContiguousSpace {
    private static CIntegerField RegionSizeBytes;
    private static CIntegerField State;
    private static CIntegerField regionNumber;
    private static int empty_uncommitted;
    private static int empty_committed;
    private static int regular;
    private static int humongous_start;
    private static int humongous_cont;
    private static int pinned_humongous_start;
    private static int cset;
    private static int pinned;
    private static int pinned_cset;
    private static int trash;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ShenandoahHeapRegion");
        RegionSizeBytes = type.getCIntegerField("RegionSizeBytes");
        State = type.getCIntegerField("_state");
        regionNumber = type.getCIntegerField("_region_number");
        empty_uncommitted = db.lookupIntConstant("ShenandoahHeapRegion::_empty_uncommitted");
        empty_committed = db.lookupIntConstant("ShenandoahHeapRegion::_empty_committed");
        regular = db.lookupIntConstant("ShenandoahHeapRegion::_regular");
        humongous_start = db.lookupIntConstant("ShenandoahHeapRegion::_humongous_start");
        humongous_cont = db.lookupIntConstant("ShenandoahHeapRegion::_humongous_cont");
        pinned_humongous_start = db.lookupIntConstant("ShenandoahHeapRegion::_pinned_humongous_start");
        cset = db.lookupIntConstant("ShenandoahHeapRegion::_cset");
        pinned_cset = db.lookupIntConstant("ShenandoahHeapRegion::_pinned_cset");
        trash = db.lookupIntConstant("ShenandoahHeapRegion::_trash");
    }

    public static long regionSizeBytes() {
        return RegionSizeBytes.getValue();
    }

    public long regionNumber() {
        return regionNumber.getValue(this.addr);
    }

    public boolean isUncommitted() {
        return this.state() == empty_uncommitted;
    }

    public boolean isEmpty() {
        return this.state() == empty_committed;
    }

    public boolean isRegular() {
        return this.state() == regular;
    }

    public boolean isHumongousStart() {
        return this.state() == humongous_start;
    }

    public boolean isHumongousCont() {
        return this.state() == humongous_cont;
    }

    public boolean isPinnedHumongous() {
        return this.state() == pinned_humongous_start;
    }

    public boolean isCSet() {
        return this.state() == cset;
    }

    public boolean isPinned() {
        return this.state() == pinned;
    }

    public boolean isPinnedCset() {
        return this.state() == pinned_cset;
    }

    public boolean isTrash() {
        return this.state() == trash;
    }

    public ShenandoahHeapRegion(Address addr) {
        super(addr);
    }

    public int state() {
        return (int)State.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ShenandoahHeapRegion.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

