/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import sun.misc.JavaNetAccess;
import sun.misc.SharedSecrets;
import sun.security.ssl.Alerts;
import sun.security.ssl.AppInputStream;
import sun.security.ssl.AppOutputStream;
import sun.security.ssl.Authenticator;
import sun.security.ssl.BaseSSLSocketImpl;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ClientHandshaker;
import sun.security.ssl.Debug;
import sun.security.ssl.Handshaker;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.ServerHandshaker;
import sun.security.ssl.Utilities;

public final class SSLSocketImpl
extends BaseSSLSocketImpl {
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_SENT_CLOSE = 5;
    private static final int cs_CLOSED = 6;
    private static final int cs_APP_CLOSED = 7;
    private volatile int connectionState;
    private boolean expectingFinished;
    private SSLException closeReason;
    private byte doClientAuth;
    private boolean roleIsServer;
    private boolean enableSessionCreation = true;
    private String host;
    private boolean autoClose = true;
    private AccessControlContext acc;
    private CipherSuiteList enabledCipherSuites;
    private String identificationProtocol = null;
    private AlgorithmConstraints algorithmConstraints = null;
    List<SNIServerName> serverNames = Collections.emptyList();
    Collection<SNIMatcher> sniMatchers = Collections.emptyList();
    private boolean noSniExtension = false;
    private boolean noSniMatcher = false;
    private final Object handshakeLock = new Object();
    final ReentrantLock writeLock = new ReentrantLock();
    private final Object readLock = new Object();
    private InputRecord inrec;
    private Authenticator readAuthenticator;
    private Authenticator writeAuthenticator;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private boolean secureRenegotiation;
    private byte[] clientVerifyData;
    private byte[] serverVerifyData;
    private SSLContextImpl sslContext;
    private Handshaker handshaker;
    private SSLSessionImpl sess;
    private volatile SSLSessionImpl handshakeSession;
    private HashMap<HandshakeCompletedListener, AccessControlContext> handshakeListeners;
    private InputStream sockInput;
    private OutputStream sockOutput;
    private AppInputStream input;
    private AppOutputStream output;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private static final Debug debug = Debug.getInstance("ssl");
    private boolean isFirstAppOutputRecord = true;
    private ByteArrayOutputStream heldRecordBuffer = null;
    private boolean preferLocalCipherSuites = false;
    static final boolean trustNameService = Debug.getBooleanProperty("jdk.tls.trustNameService", false);

    SSLSocketImpl(SSLContextImpl context, String host, int port) throws IOException, UnknownHostException {
        this.host = host;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        this.init(context, false);
        InetSocketAddress socketAddress = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, InetAddress host, int port) throws IOException {
        this.init(context, false);
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        this.host = host;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        this.init(context, false);
        this.bind(new InetSocketAddress(localAddr, localPort));
        InetSocketAddress socketAddress = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, InetAddress host, int port, InetAddress localAddr, int localPort) throws IOException {
        this.init(context, false);
        this.bind(new InetSocketAddress(localAddr, localPort));
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, boolean serverMode, CipherSuiteList suites, byte clientAuth, boolean sessionCreation, ProtocolList protocols, String identificationProtocol, AlgorithmConstraints algorithmConstraints, Collection<SNIMatcher> sniMatchers, boolean preferLocalCipherSuites) throws IOException {
        this.doClientAuth = clientAuth;
        this.enableSessionCreation = sessionCreation;
        this.identificationProtocol = identificationProtocol;
        this.algorithmConstraints = algorithmConstraints;
        this.sniMatchers = sniMatchers;
        this.preferLocalCipherSuites = preferLocalCipherSuites;
        this.init(context, serverMode);
        this.enabledCipherSuites = suites;
        this.enabledProtocols = protocols;
    }

    SSLSocketImpl(SSLContextImpl context) {
        this.init(context, false);
    }

    SSLSocketImpl(SSLContextImpl context, Socket sock, String host, int port, boolean autoClose) throws IOException {
        super(sock);
        if (!sock.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.host = host;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        this.init(context, false);
        this.autoClose = autoClose;
        this.doneConnect();
    }

    SSLSocketImpl(SSLContextImpl context, Socket sock, InputStream consumed, boolean autoClose) throws IOException {
        super(sock, consumed);
        if (!sock.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.init(context, true);
        this.autoClose = autoClose;
        this.doneConnect();
    }

    private void init(SSLContextImpl context, boolean isServer) {
        this.sslContext = context;
        this.sess = SSLSessionImpl.nullSession;
        this.handshakeSession = null;
        this.roleIsServer = isServer;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readAuthenticator = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeAuthenticator = MAC.NULL;
        this.secureRenegotiation = false;
        this.clientVerifyData = new byte[0];
        this.serverVerifyData = new byte[0];
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(this.roleIsServer);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(this.roleIsServer);
        this.inrec = null;
        this.acc = AccessController.getContext();
        this.input = new AppInputStream(this);
        this.output = new AppOutputStream(this);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.isLayered()) {
            throw new SocketException("Already connected");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        super.connect(endpoint, timeout);
        if (this.host == null || this.host.length() == 0) {
            this.useImplicitHost(false);
        }
        this.doneConnect();
    }

    void doneConnect() throws IOException {
        this.sockInput = super.getInputStream();
        this.sockOutput = super.getOutputStream();
        this.initHandshaker();
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int state) {
        this.connectionState = state;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    void writeRecord(OutputRecord r) throws IOException {
        this.writeRecord(r, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRecord(OutputRecord r, boolean holdRecord) throws IOException {
        block14: while (r.contentType() == 23) {
            switch (this.getConnectionState()) {
                case 1: {
                    this.performInitialHandshake();
                    continue block14;
                }
                case 2: 
                case 3: {
                    break block14;
                }
                case 4: {
                    this.fatal((byte)0, "error while writing to socket");
                    continue block14;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.closeReason != null) {
                        throw this.closeReason;
                    }
                    throw new SocketException("Socket closed");
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
            }
        }
        if (!r.isEmpty()) {
            if (r.isAlert((byte)0) && this.getSoLinger() >= 0) {
                boolean interrupted;
                block24: {
                    interrupted = Thread.interrupted();
                    try {
                        if (this.writeLock.tryLock(this.getSoLinger(), TimeUnit.SECONDS)) {
                            try {
                                this.writeRecordInternal(r, holdRecord);
                                break block24;
                            }
                            finally {
                                this.writeLock.unlock();
                            }
                        }
                        SSLException ssle = new SSLException("SO_LINGER timeout, close_notify message cannot be sent.");
                        if (this.isLayered() && !this.autoClose) {
                            this.fatal((byte)-1, ssle);
                        } else if (debug != null && Debug.isOn("ssl")) {
                            System.out.println(Thread.currentThread().getName() + ", received Exception: " + ssle);
                        }
                        this.sess.invalidate();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.writeLock.lock();
                try {
                    this.writeRecordInternal(r, holdRecord);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    private void writeRecordInternal(OutputRecord r, boolean holdRecord) throws IOException {
        r.encrypt(this.writeAuthenticator, this.writeCipher);
        if (holdRecord) {
            if (this.getTcpNoDelay()) {
                holdRecord = false;
            } else if (this.heldRecordBuffer == null) {
                this.heldRecordBuffer = new ByteArrayOutputStream(40);
            }
        }
        r.write(this.sockOutput, holdRecord, this.heldRecordBuffer);
        if (this.connectionState < 4) {
            this.checkSequenceNumber(this.writeAuthenticator, r.contentType());
        }
        if (this.isFirstAppOutputRecord && r.contentType() == 23) {
            this.isFirstAppOutputRecord = false;
        }
    }

    boolean needToSplitPayload() {
        this.writeLock.lock();
        try {
            boolean bl = this.protocolVersion.v <= ProtocolVersion.TLS10.v && this.writeCipher.isCBCMode() && !this.isFirstAppOutputRecord && Record.enableCBCProtection;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void readDataRecord(InputRecord r) throws IOException {
        if (this.getConnectionState() == 1) {
            this.performInitialHandshake();
        }
        this.readRecord(r, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecord(InputRecord r, boolean needAppData) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int state;
            block19: while ((state = this.getConnectionState()) != 6 && state != 4 && state != 7) {
                try {
                    r.setAppDataValid(false);
                    r.read(this.sockInput, this.sockOutput);
                }
                catch (SSLProtocolException e) {
                    try {
                        this.fatal((byte)10, e);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (EOFException eof) {
                    boolean rethrow;
                    boolean handshaking = this.getConnectionState() <= 1;
                    boolean bl = rethrow = requireCloseNotify || handshaking;
                    if (debug != null && Debug.isOn("ssl")) {
                        System.out.println(Thread.currentThread().getName() + ", received EOFException: " + (rethrow ? "error" : "ignored"));
                    }
                    if (rethrow) {
                        SSLException e = handshaking ? new SSLHandshakeException("Remote host closed connection during handshake") : new SSLProtocolException("Remote host closed connection incorrectly");
                        e.initCause(eof);
                        throw e;
                    }
                    this.closeInternal(false);
                    continue;
                }
                try {
                    r.decrypt(this.readAuthenticator, this.readCipher);
                }
                catch (BadPaddingException e) {
                    byte alertType = r.contentType() == 22 ? (byte)40 : 20;
                    this.fatal(alertType, e.getMessage(), e);
                }
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    switch (r.contentType()) {
                        case 22: {
                            this.initHandshaker();
                            if (!this.handshaker.activated()) {
                                if (this.connectionState == 3) {
                                    this.handshaker.activate(this.protocolVersion);
                                } else {
                                    this.handshaker.activate(null);
                                }
                            }
                            this.handshaker.process_record(r, this.expectingFinished);
                            this.expectingFinished = false;
                            if (this.handshaker.invalidated) {
                                this.handshaker = null;
                                this.inrec.setHandshakeHash(null);
                                if (this.connectionState == 3) {
                                    this.connectionState = 2;
                                }
                            } else if (this.handshaker.isDone()) {
                                this.secureRenegotiation = this.handshaker.isSecureRenegotiation();
                                this.clientVerifyData = this.handshaker.getClientVerifyData();
                                this.serverVerifyData = this.handshaker.getServerVerifyData();
                                this.sess = this.handshaker.getSession();
                                this.handshakeSession = null;
                                this.handshaker = null;
                                this.connectionState = 2;
                                if (this.handshakeListeners != null) {
                                    HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sess);
                                    NotifyHandshakeThread t = new NotifyHandshakeThread(this.handshakeListeners.entrySet(), event);
                                    t.start();
                                }
                            }
                            if (!needAppData && this.connectionState == 2) break;
                            continue block19;
                        }
                        case 23: {
                            if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 5) {
                                throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                            }
                            if (this.expectingFinished) {
                                throw new SSLProtocolException("Expecting finished message, received data");
                            }
                            if (!needAppData) {
                                throw new SSLException("Discarding app data");
                            }
                            r.setAppDataValid(true);
                            break;
                        }
                        case 21: {
                            this.recvAlert(r);
                            continue block19;
                        }
                        case 20: {
                            if (this.connectionState != 1 && this.connectionState != 3) {
                                this.fatal((byte)10, "illegal change cipher spec msg, conn state = " + this.connectionState);
                            } else if (r.available() != 1 || r.read() != 1) {
                                this.fatal((byte)10, "Malformed change cipher spec msg");
                            }
                            this.handshaker.receiveChangeCipherSpec();
                            this.changeReadCiphers();
                            this.expectingFinished = true;
                            continue block19;
                        }
                        default: {
                            if (debug != null && Debug.isOn("ssl")) {
                                System.out.println(Thread.currentThread().getName() + ", Received record type: " + r.contentType());
                            }
                            continue block19;
                        }
                    }
                    if (this.connectionState < 4) {
                        this.checkSequenceNumber(this.readAuthenticator, r.contentType());
                    }
                    return;
                }
            }
            r.close();
            return;
        }
    }

    private void checkSequenceNumber(Authenticator authenticator, byte type) throws IOException {
        if (this.connectionState >= 4 || authenticator == MAC.NULL) {
            return;
        }
        if (authenticator.seqNumOverflow()) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", sequence number extremely close to overflow (2^64-1 packets). Closing connection.");
            }
            this.fatal((byte)40, "sequence number overflow");
        }
        if (type != 22 && authenticator.seqNumIsHuge()) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", request renegotiation to avoid sequence number overflow");
            }
            this.startHandshake();
        }
    }

    AppInputStream getAppInputStream() {
        return this.input;
    }

    AppOutputStream getAppOutputStream() {
        return this.output;
    }

    private void initHandshaker() {
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        if (this.roleIsServer) {
            this.handshaker = new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
            this.handshaker.setSNIMatchers(this.sniMatchers);
            this.handshaker.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        } else {
            this.handshaker = new ClientHandshaker(this, this.sslContext, this.enabledProtocols, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
            this.handshaker.setSNIServerNames(this.serverNames);
        }
        this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialHandshake() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.getConnectionState() == 1) {
                this.kickstartHandshake();
                if (this.inrec == null) {
                    this.inrec = new InputRecord();
                    this.inrec.setHandshakeHash(this.input.r.getHandshakeHash());
                    this.inrec.setHelloVersion(this.input.r.getHelloVersion());
                    this.inrec.enableFormatChecks();
                }
                this.readRecord(this.inrec, false);
                this.inrec = null;
            }
        }
    }

    @Override
    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    private void startHandshake(boolean resumable) throws IOException {
        this.checkWrite();
        try {
            if (this.getConnectionState() == 1) {
                this.performInitialHandshake();
            } else {
                this.kickstartHandshake();
            }
        }
        catch (Exception e) {
            this.handleException(e, resumable);
        }
    }

    private synchronized void kickstartHandshake() throws IOException {
        switch (this.connectionState) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.secureRenegotiation && !Handshaker.allowUnsafeRenegotiation) {
                    throw new SSLHandshakeException("Insecure renegotiation is not allowed");
                }
                if (!this.secureRenegotiation && debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: Using insecure renegotiation");
                }
                this.initHandshaker();
                break;
            }
            case 3: {
                return;
            }
            case 0: {
                throw new SocketException("handshaking attempted on unconnected socket");
            }
            default: {
                throw new SocketException("connection is closed");
            }
        }
        if (!this.handshaker.activated()) {
            if (this.connectionState == 3) {
                this.handshaker.activate(this.protocolVersion);
            } else {
                this.handshaker.activate(null);
            }
            if (this.handshaker instanceof ClientHandshaker) {
                this.handshaker.kickstart();
            } else if (this.connectionState != 1) {
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.connectionState == 7;
    }

    boolean checkEOF() throws IOException {
        switch (this.getConnectionState()) {
            case 0: {
                throw new SocketException("Socket is not connected");
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 7: {
                throw new SocketException("Socket is closed");
            }
        }
        if (this.closeReason == null) {
            return true;
        }
        SSLException e = new SSLException("Connection has been shutdown: " + this.closeReason);
        e.initCause(this.closeReason);
        throw e;
    }

    void checkWrite() throws IOException {
        if (this.checkEOF() || this.getConnectionState() == 5) {
            throw new SocketException("Connection closed by remote host");
        }
    }

    protected void closeSocket() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", called closeSocket()");
        }
        super.close();
    }

    private void closeSocket(boolean selfInitiated) throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", called closeSocket(" + selfInitiated + ")");
        }
        if (!this.isLayered() || this.autoClose) {
            super.close();
        } else if (selfInitiated) {
            this.waitForClose(false);
        }
    }

    @Override
    public void close() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", called close()");
        }
        this.closeInternal(true);
        this.setConnectionState(7);
    }

    /*
     * Exception decompiling
     */
    private void closeInternal(boolean selfInitiated) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForClose(boolean rethrow) throws IOException {
        block9: {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", waiting for close_notify or alert: state " + this.getConnectionState());
            }
            try {
                int state;
                while ((state = this.getConnectionState()) != 6 && state != 4 && state != 7) {
                    if (this.inrec == null) {
                        this.inrec = new InputRecord();
                    }
                    try {
                        this.readRecord(this.inrec, true);
                    }
                    catch (SocketTimeoutException e) {
                        if (debug != null && Debug.isOn("ssl")) {
                            System.out.println(Thread.currentThread().getName() + ", received Exception: " + e);
                        }
                        this.fatal((byte)-1, "Did not receive close_notify from peer", e);
                    }
                }
                this.inrec = null;
            }
            catch (IOException e) {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(Thread.currentThread().getName() + ", Exception while waiting for close " + e);
                }
                if (!rethrow) break block9;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeCiphers() {
        Object object = this.readLock;
        synchronized (object) {
            this.readCipher.dispose();
        }
        this.writeLock.lock();
        try {
            this.writeCipher.dispose();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void handleException(Exception e) throws IOException {
        this.handleException(e, true);
    }

    private synchronized void handleException(Exception e, boolean resumable) throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", handling exception: " + e.toString());
        }
        if (e instanceof InterruptedIOException && resumable) {
            throw (IOException)e;
        }
        if (this.closeReason != null) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Alerts.getSSLException((byte)80, e, "Unexpected exception");
        }
        boolean isSSLException = e instanceof SSLException;
        if (!isSSLException && e instanceof IOException) {
            try {
                this.fatal((byte)10, e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (IOException)e;
        }
        byte alertType = isSSLException ? (e instanceof SSLHandshakeException ? (byte)40 : 10) : (byte)80;
        this.fatal(alertType, e);
    }

    void warning(byte description) {
        this.sendAlert((byte)1, description);
    }

    synchronized void fatal(byte description, String diagnostic) throws IOException {
        this.fatal(description, diagnostic, null);
    }

    synchronized void fatal(byte description, Throwable cause) throws IOException {
        this.fatal(description, null, cause);
    }

    synchronized void fatal(byte description, String diagnostic, Throwable cause) throws IOException {
        if (this.input != null && this.input.r != null) {
            this.input.r.close();
        }
        this.sess.invalidate();
        if (this.handshakeSession != null) {
            this.handshakeSession.invalidate();
        }
        int oldState = this.connectionState;
        if (this.connectionState < 4) {
            this.connectionState = 4;
        }
        if (this.closeReason == null) {
            if (oldState == 1) {
                this.sockInput.skip(this.sockInput.available());
            }
            if (description != -1) {
                this.sendAlert((byte)2, description);
            }
            this.closeReason = cause instanceof SSLException ? (SSLException)cause : Alerts.getSSLException(description, cause, diagnostic);
        }
        this.closeSocket();
        if (this.connectionState < 6) {
            this.connectionState = oldState == 7 ? 7 : 6;
            this.readCipher.dispose();
            this.writeCipher.dispose();
        }
        throw this.closeReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recvAlert(InputRecord r) throws IOException {
        byte level = (byte)r.read();
        byte description = (byte)r.read();
        if (description == -1) {
            this.fatal((byte)47, "Short alert message");
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.print(Thread.currentThread().getName());
                System.out.print(", RECV " + this.protocolVersion + " ALERT:  ");
                if (level == 2) {
                    System.out.print("fatal, ");
                } else if (level == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & level) + ">, ");
                }
                System.out.println(Alerts.alertDescription(description));
            }
        }
        if (level == 1) {
            if (description == 0) {
                if (this.connectionState == 1) {
                    this.fatal((byte)10, "Received close_notify during handshake");
                } else {
                    this.closeInternal(false);
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(description);
            }
        } else {
            String reason = "Received fatal alert: " + Alerts.alertDescription(description);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(description, reason);
            }
            this.fatal((byte)10, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlert(byte level, byte description) {
        block12: {
            boolean useDebug;
            if (this.connectionState >= 5) {
                return;
            }
            if (!(this.connectionState != 1 || this.handshaker != null && this.handshaker.started())) {
                return;
            }
            OutputRecord r = new OutputRecord(21);
            r.setVersion(this.protocolVersion);
            boolean bl = useDebug = debug != null && Debug.isOn("ssl");
            if (useDebug) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(Thread.currentThread().getName());
                    System.out.print(", SEND " + this.protocolVersion + " ALERT:  ");
                    if (level == 2) {
                        System.out.print("fatal, ");
                    } else if (level == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & level) + ">, ");
                    }
                    System.out.println("description = " + Alerts.alertDescription(description));
                }
            }
            r.write(level);
            r.write(description);
            try {
                this.writeRecord(r);
            }
            catch (IOException e) {
                if (!useDebug) break block12;
                System.out.println(Thread.currentThread().getName() + ", Exception sending alert: " + e);
            }
        }
    }

    private void changeReadCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox oldCipher = this.readCipher;
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readAuthenticator = this.handshaker.newReadAuthenticator();
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Algorithm missing:  ", e);
        }
        oldCipher.dispose();
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox oldCipher = this.writeCipher;
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeAuthenticator = this.handshaker.newWriteAuthenticator();
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Algorithm missing:  ", e);
        }
        oldCipher.dispose();
        this.isFirstAppOutputRecord = true;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.output.r.setVersion(protocolVersion);
    }

    synchronized String getHost() {
        if (this.host == null || this.host.length() == 0) {
            this.useImplicitHost(true);
        }
        return this.host;
    }

    private synchronized void useImplicitHost(boolean noSniUpdate) {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            return;
        }
        JavaNetAccess jna = SharedSecrets.getJavaNetAccess();
        String originalHostname = jna.getOriginalHostName(inetAddress);
        if (originalHostname != null && originalHostname.length() != 0) {
            this.host = originalHostname;
            if (!noSniUpdate && this.serverNames.isEmpty() && !this.noSniExtension) {
                this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
                if (!this.roleIsServer && this.handshaker != null && !this.handshaker.started()) {
                    this.handshaker.setSNIServerNames(this.serverNames);
                }
            }
            return;
        }
        this.host = !trustNameService ? inetAddress.getHostAddress() : this.getInetAddress().getHostName();
    }

    public synchronized void setHost(String host) {
        this.host = host;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        if (!this.roleIsServer && this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setSNIServerNames(this.serverNames);
        }
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.input;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSession getSession() {
        block6: {
            if (this.getConnectionState() == 1) {
                try {
                    this.startHandshake(false);
                }
                catch (IOException e) {
                    if (debug == null || !Debug.isOn("handshake")) break block6;
                    System.out.println(Thread.currentThread().getName() + ", IOException in getSession():  " + e);
                }
            }
        }
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            return this.sess;
        }
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    synchronized void setHandshakeSession(SSLSessionImpl session) {
        this.handshakeSession = session;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean flag) {
        this.doClientAuth = (byte)(flag ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    @Override
    public synchronized void setWantClientAuth(boolean flag) {
        byte by = this.doClientAuth = flag ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    @Override
    public synchronized void setUseClientMode(boolean flag) {
        switch (this.connectionState) {
            case 0: {
                if (this.roleIsServer != !flag && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                    this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
                }
                this.roleIsServer = !flag;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.activated()) {
                    if (this.roleIsServer != !flag && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                        this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
                    }
                    this.roleIsServer = !flag;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(Thread.currentThread().getName() + ", setUseClientMode() invoked in state = " + this.connectionState);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = new CipherSuiteList(suites);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        }
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslContext.getSuportedProtocolList().toStringArray();
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = new ProtocolList(protocols);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", setSoTimeout(" + timeout + ") called");
        }
        super.setSoTimeout(timeout);
    }

    @Override
    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new HashMap(4);
        }
        this.handshakeListeners.put(listener, AccessController.getContext());
    }

    @Override
    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.handshakeListeners.remove(listener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        SSLParameters params = super.getSSLParameters();
        params.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        params.setAlgorithmConstraints(this.algorithmConstraints);
        if (this.sniMatchers.isEmpty() && !this.noSniMatcher) {
            params.setSNIMatchers(null);
        } else {
            params.setSNIMatchers(this.sniMatchers);
        }
        if (this.serverNames.isEmpty() && !this.noSniExtension) {
            params.setServerNames(null);
        } else {
            params.setServerNames(this.serverNames);
        }
        params.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        return params;
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters params) {
        Collection<SNIMatcher> matchers;
        super.setSSLParameters(params);
        this.identificationProtocol = params.getEndpointIdentificationAlgorithm();
        this.algorithmConstraints = params.getAlgorithmConstraints();
        this.preferLocalCipherSuites = params.getUseCipherSuitesOrder();
        List<SNIServerName> sniNames = params.getServerNames();
        if (sniNames != null) {
            this.noSniExtension = sniNames.isEmpty();
            this.serverNames = sniNames;
        }
        if ((matchers = params.getSNIMatchers()) != null) {
            this.noSniMatcher = matchers.isEmpty();
            this.sniMatchers = matchers;
        }
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setIdentificationProtocol(this.identificationProtocol);
            this.handshaker.setAlgorithmConstraints(this.algorithmConstraints);
            if (this.roleIsServer) {
                this.handshaker.setSNIMatchers(this.sniMatchers);
                this.handshaker.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
            } else {
                this.handshaker.setSNIServerNames(this.serverNames);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer retval = new StringBuffer(80);
        retval.append(Integer.toHexString(this.hashCode()));
        retval.append("[");
        retval.append(this.sess.getCipherSuite());
        retval.append(": ");
        retval.append(super.toString());
        retval.append("]");
        return retval.toString();
    }

    private static class NotifyHandshakeThread
    extends Thread {
        private Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> targets;
        private HandshakeCompletedEvent event;

        NotifyHandshakeThread(Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> entrySet, HandshakeCompletedEvent e) {
            super("HandshakeCompletedNotify-Thread");
            this.targets = new HashSet<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(entrySet);
            this.event = e;
        }

        @Override
        public void run() {
            for (Map.Entry<HandshakeCompletedListener, AccessControlContext> entry : this.targets) {
                final HandshakeCompletedListener l = entry.getKey();
                AccessControlContext acc = entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        l.handshakeCompleted(event);
                        return null;
                    }
                }, acc);
            }
        }
    }
}

