/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ru;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ru extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MST",
               "\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MST",
               "\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u042f\u043f\u043e\u043d\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "JST",
               "\u042f\u043f\u043e\u043d\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "JDT",
               "\u042f\u043f\u043e\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "JT",
            };
        final String[] Hovd = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0425\u043e\u0432\u0434\u0443",
               "HST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u0425\u043e\u0432\u0434\u0435",
               "HST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0425\u043e\u0432\u0434\u0443",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041c\u0430\u0433\u0430\u0434\u0430\u043d\u0443",
               "MST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041c\u0430\u0433\u0430\u0434\u0430\u043d\u0443",
               "MST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u041c\u0430\u0433\u0430\u0434\u0430\u043d\u0443",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u043e\u0435 \u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0435 (\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435)",
               "ACWST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u043e\u0435 \u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0435 (\u043b\u0435\u0442\u043d\u0435\u0435)",
               "ACWDT",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u043e\u0435 \u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0435",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CEST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CEST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u0421\u0430\u0445\u0430\u043b\u0438\u043d\u0435",
               "SST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u0421\u0430\u0445\u0430\u043b\u0438\u043d\u0435",
               "SST",
               "\u0412\u0440\u0435\u043c\u044f \u043d\u0430 \u0421\u0430\u0445\u0430\u043b\u0438\u043d\u0435",
               "ST",
            };
        final String[] America_Eastern = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EST",
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EDT",
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u041b\u043e\u0440\u0434-\u0425\u0430\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "LHST",
               "\u041b\u043e\u0440\u0434-\u0425\u0430\u0443 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "LHDT",
               "\u041b\u043e\u0440\u0434-\u0425\u0430\u0443 \u0432\u0440\u0435\u043c\u044f",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u041d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "NZST",
               "\u041d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "NZDT",
               "\u041d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0418\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u043e\u043a\u0435\u0430\u043d",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u042f\u043a\u0443\u0442\u0441\u043a\u0443",
               "YST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u042f\u043a\u0443\u0442\u0441\u043a\u0443",
               "YST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u042f\u043a\u0443\u0442\u0441\u043a\u0443",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MST",
               "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MST",
               "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Kosrae = new String[] {
               "\u041a\u043e\u0441\u0440\u0430\u044d \u0432\u0440\u0435\u043c\u044f",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EEST",
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EEST",
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u041d\u044c\u044e\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434\u0430",
               "NST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u041d\u044c\u044e\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434\u0435",
               "NDT",
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u041d\u044c\u044e\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434\u0435",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u044f",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0413\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "HKST",
               "\u0413\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "HKST",
               "\u0413\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 (\u0437\u0430\u043f\u0430\u0434) \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WAST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0439 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0435",
               "WAST",
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0439 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0435",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "ADT",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AT",
            };
        final String[] Indochina = new String[] {
               "\u0418\u043d\u0434\u043e\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433\u0443",
               "YST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433\u0435",
               "YST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433\u0443",
               "YT",
            };
        final String[] Maldives = new String[] {
               "\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Israel = new String[] {
               "\u0418\u0437\u0440\u0430\u0438\u043b\u044c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "IST",
               "\u0418\u0437\u0440\u0430\u0438\u043b\u044c \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "IDT",
               "\u0418\u0437\u0440\u0430\u0438\u043b\u044c \u0432\u0440\u0435\u043c\u044f",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "\u042e\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0421\u0451\u0432\u0430 \u0432\u0440\u0435\u043c\u044f",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041b\u0430\u0439\u043d \u0432\u0440\u0435\u043c\u044f",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Omsk = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041e\u043c\u0441\u043a\u0443",
               "OST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041e\u043c\u0441\u043a\u0443",
               "OST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u041e\u043c\u0441\u043a\u0443",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Mongolia = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0423\u043b\u0430\u043d-\u0411\u0430\u0442\u043e\u0440\u0443",
               "UBST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0423\u043b\u0430\u043d-\u0411\u0430\u0442\u043e\u0440\u0443",
               "UBST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0423\u043b\u0430\u043d-\u0411\u0430\u0442\u043e\u0440\u0443",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0421\u0440\u0435\u0434\u043d\u0435-\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CST",
               "\u0421\u0440\u0435\u0434\u043d\u0435-\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CDT",
               "\u0421\u0440\u0435\u0434\u043d\u0435-\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CT",
            };
        final String[] Falkland = new String[] {
               "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "FIST",
               "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "FIST",
               "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "FIT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0443",
               "NST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0443",
               "NST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0443",
               "NT",
            };
        final String[] Azores = new String[] {
               "\u0410\u0437\u043e\u0440\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u0437\u043e\u0440\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u0437\u043e\u0440\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0443",
               "KST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0443",
               "KST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0443",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u0417\u0430\u043f\u0430\u0434\u043d\u043e\u043c \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0435",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Christmas = new String[] {
               "\u041e\u0441\u0442\u0440\u043e\u0432 \u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u0430 \u0432\u0440\u0435\u043c\u044f",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0410\u043c\u0430\u0437\u043e\u043d\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d\u043a\u0430 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d\u043a\u0430 \u0432\u0440\u0435\u043c\u044f",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e\u043c \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0435",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "\u0424\u0438\u0434\u0436\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "FST",
               "\u0424\u0438\u0434\u0436\u0438 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "FST",
               "\u0424\u0438\u0434\u0436\u0438 \u0432\u0440\u0435\u043c\u044f",
               "FT",
            };
        final String[] Reunion = new String[] {
               "\u0420\u0435\u044e\u043d\u044c\u043e\u043d \u0432\u0440\u0435\u043c\u044f",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u044b\u0435 \u043e-\u0432\u0430 \u0432\u0440\u0435\u043c\u044f",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "\u0427\u0430\u0442\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CST",
               "\u0427\u0430\u0442\u0435\u043c \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CDT",
               "\u0427\u0430\u0442\u0435\u043c \u0432\u0440\u0435\u043c\u044f",
               "CT",
            };
        final String[] Vostok = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u044f",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0435",
               "AT",
            };
        final String[] Gambier = new String[] {
               "\u0413\u0430\u043c\u0431\u044c\u0435 \u0432\u0440\u0435\u043c\u044f",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Galapagos = new String[] {
               "\u0413\u0430\u043b\u0430\u043f\u0430\u0433\u043e\u0441\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "\u0412\u0440\u0435\u043c\u044f \u043d\u0430 \u041c\u0430\u043a\u043a\u0443\u043e\u0440\u0438",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0413\u0430\u0432\u0430\u0439\u0441\u043a\u043e-\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "HAST",
               "\u0413\u0430\u0432\u0430\u0439\u0441\u043a\u043e-\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "HADT",
               "\u0412\u0440\u0435\u043c\u044f \u043d\u0430 \u0413\u0430\u0432\u0430\u0439\u0441\u043a\u0438\u0445 \u0438 \u0410\u043b\u0435\u0443\u0442\u0441\u043a\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u0430\u0445",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f (\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435)",
               "ACST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f (\u043b\u0435\u0442\u043d\u0435\u0435)",
               "ACDT",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\u0422\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "PST",
               "\u0422\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "PDT",
               "\u0422\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CVST",
               "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CVST",
               "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CVT",
            };
        final String[] Rothera = new String[] {
               "\u0420\u043e\u0442\u0435\u0440\u0430 \u0432\u0440\u0435\u043c\u044f",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Mawson = new String[] {
               "\u041c\u043e\u0443\u0441\u043e\u043d \u0432\u0440\u0435\u043c\u044f",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0414\u0435\u0439\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u044f",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Africa_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0421\u0440\u0435\u0434\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0413\u0440\u0438\u043d\u0432\u0438\u0447\u0443",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] French_Southern = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u043e\u0435 \u044e\u0436\u043d\u043e\u0435 \u0438 \u0430\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "\u042e\u0436\u043d\u0430\u044f \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u0432\u0440\u0435\u043c\u044f",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Volgograd = new String[] {
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "VST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434\u0443",
               "VT",
            };
        final String[] Easter = new String[] {
               "\u041e\u0441\u0442\u0440\u043e\u0432 \u041f\u0430\u0441\u0445\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EIST",
               "\u041e\u0441\u0442\u0440\u043e\u0432 \u041f\u0430\u0441\u0445\u0438 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EIST",
               "\u041e\u0441\u0442\u0440\u043e\u0432 \u041f\u0430\u0441\u0445\u0438 \u0432\u0440\u0435\u043c\u044f",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0414\u044e\u043c\u043e\u043d \u0434'\u042e\u0440\u0432\u0438\u043b\u044c \u0432\u0440\u0435\u043c\u044f",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "KST",
               "\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "KDT",
               "\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u043e\u0435 (\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435)",
               "AWST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u043e\u0435 (\u043b\u0435\u0442\u043d\u0435\u0435)",
               "AWDT",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u043e\u0435",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f (\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435)",
               "AEST",
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f (\u043b\u0435\u0442\u043d\u0435\u0435)",
               "AEDT",
               "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u0430\u044f \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f",
               "EAT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u0413\u0438\u043b\u0431\u0435\u0440\u0442\u0430 \u0432\u0440\u0435\u043c\u044f",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "\u0413\u043e\u0440\u043d\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f (\u0421\u0428\u0410)",
               "MST",
               "\u0413\u043e\u0440\u043d\u043e\u0435 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f (\u0421\u0428\u0410)",
               "MDT",
               "\u0413\u043e\u0440\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f (\u0421\u0428\u0410)",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "ADT",
               "\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f \u0432\u0440\u0435\u043c\u044f",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0410\u043b\u044f\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AKST",
               "\u0410\u043b\u044f\u0441\u043a\u0430 \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AKDT",
               "\u0410\u043b\u044f\u0441\u043a\u0430 \u0432\u0440\u0435\u043c\u044f",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a\u0443",
               "VST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a\u0443",
               "VST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a\u0443",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "\u0427\u0430\u043c\u043e\u0440\u0440\u043e \u0432\u0440\u0435\u043c\u044f",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0443",
               "IST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0443",
               "IST",
               "\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0443",
               "IT",
            };
        final String[] Noronha = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u0424\u0435\u0440\u043d\u0430\u043d\u0434\u0443-\u0434\u0438-\u041d\u043e\u0440\u043e\u043d\u044c\u044f",
               "FNST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u0424\u0435\u0440\u043d\u0430\u043d\u0434\u0443-\u0434\u0438-\u041d\u043e\u0440\u043e\u043d\u044c\u044f",
               "FNST",
               "\u0412\u0440\u0435\u043c\u044f \u043d\u0430 \u0424\u0435\u0440\u043d\u0430\u043d\u0434\u0443-\u0434\u0438-\u041d\u043e\u0440\u043e\u043d\u044c\u044f",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0412\u0440\u0435\u043c\u044f \u0432 \u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d\u0435",
               "CST",
               "\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e \u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d\u0443",
               "CST",
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d\u0435",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f \u0434\u043d\u0435\u0432\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "BST",
               "\u0412\u0440\u0435\u043c\u044f \u0432 \u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0438",
               "BT",
            };
        final String[] China = new String[] {
               "\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CST",
               "China Daylight Time",
               "CDT",
               "China Time",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0410\u0440\u043c\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u0440\u043c\u0435\u043d\u0438\u044f \u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "AST",
               "\u0410\u0440\u043c\u0435\u043d\u0438\u044f \u0432\u0440\u0435\u043c\u044f",
               "AT",
            };
        final String[] India = new String[] {
               "\u0418\u043d\u0434\u0438\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CIST",
               "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430 \u043f\u043e\u043b\u0443\u043b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f",
               "CIHST",
               "\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430 \u0432\u0440\u0435\u043c\u044f",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", GMT },
            { "Africa/Windhoek", Africa_Western },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
