package com.digiwin.pressure.client;

import com.digiwin.pressure.cs.core.*;
import com.digiwin.pressure.cs.core.domain.Constants;
import com.digiwin.pressure.cs.core.domain.Message;
import com.digiwin.pressure.cs.core.domain.RegisterReq;
import com.digiwin.pressure.cs.core.domain.Result;
import lombok.extern.slf4j.Slf4j;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

@Slf4j
public class SocketClient {

    private AioSession serverSession;

    private AioQuickClient<Message> client;

    private SocketTemplate socketTemplate;

    private final List<BaseApiHandler> apiHandlers;

    private final SocketClientProperties properties;

    public SocketClient(List<BaseApiHandler> apiHandlers, SocketClientProperties socketClientProperties) {
        this.apiHandlers = apiHandlers;

        this.properties = socketClientProperties;
    }

    public void start() {
        this.socketTemplate = new SocketTemplate(this.apiHandlers);

        client = new AioQuickClient<>(properties.getServerHost(), properties.getServerPort(), new BinaryProtocol(), new PressureMessageProcessor(socketTemplate) {
            @Override
            protected void handleSessionClosedEvent(AioSession session) {
                sleep(5);
                client.shutdown();
                start();
            }

            @Override
            protected void handleSessionErrorEvent(AioSession session) {
                session.close();
            }
        });
        Result res = null;
        for (int i = 0; i < 20; i++) {
            try {
                this.serverSession = client.start();
                RegisterReq registerReq = new RegisterReq();
                registerReq.setLocalIp(getLocalIp());
                registerReq.setSlaverKey(properties.getSlaverKey());
                res = this.socketTemplate.request(serverSession, Constants.REIGSTER_API_ID, registerReq, 30);
            } catch (Throwable e) {
                log.error("Error starting client", e);
                sleep(30);
                continue;
            }
            break;
        }
        if (res.isFail()) {
            log.error("注册失败, errorCode:{}, msg:{}", res.getErrorCode(), res.getErrorMsg());
            throw new Error("register master error: " + res.getErrorMsg());
        }
    }

    public static String getLocalIp() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;

                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!addr.isLoopbackAddress() &&
                            addr.isSiteLocalAddress() &&
                            !addr.getHostAddress().contains(":")) {
                        return addr.getHostAddress();
                    }
                }
            }
            return InetAddress.getLocalHost().getHostAddress(); // 备选方案
        } catch (Exception e) {
            log.error("获取IP地址失败", e);
            return "";
        }
    }

    private static void sleep(long seconds) {
        try {
            Thread.sleep(seconds * 1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}
