package com.digiwin.pressure.client;

import com.digiwin.pressure.cs.core.BaseApiHandler;
import com.digiwin.pressure.cs.core.BinaryProtocol;
import com.digiwin.pressure.cs.core.PressureMessageProcessor;
import com.digiwin.pressure.cs.core.SocketTemplate;
import com.digiwin.pressure.cs.core.domain.Constants;
import com.digiwin.pressure.cs.core.domain.Message;
import com.digiwin.pressure.cs.core.domain.RegisterReq;
import com.digiwin.pressure.cs.core.domain.Result;
import com.digiwin.pressure.cs.core.util.IPUtils;
import lombok.extern.slf4j.Slf4j;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

import java.util.List;

@Slf4j
public class SocketClient {

    private AioSession serverSession;

    private AioQuickClient client;

    private SocketTemplate socketTemplate;

    private final List<BaseApiHandler> apiHandlers;

    private final SocketClientProperties properties;

    public SocketClient(List<BaseApiHandler> apiHandlers, SocketClientProperties socketClientProperties) {
        this.apiHandlers = apiHandlers;

        this.properties = socketClientProperties;
    }

    public void start() {
        this.socketTemplate = new SocketTemplate(this.apiHandlers);
        Result res = null;
        for (int i = 0; i < 20; i++) {
            try {
                client = new AioQuickClient(properties.getServerHost(), properties.getServerPort(), new BinaryProtocol(), new PressureMessageProcessor(socketTemplate) {
                    @Override
                    protected void handleSessionClosedEvent(AioSession session) {
                        sleep(30);
                        client.shutdown();
                        start();
                    }

                    @Override
                    protected void handleSessionErrorEvent(AioSession session) {
                        //session.close();
                    }
                });
                client.setReadBufferSize(1024);
                client.setWriteBuffer(1024, 10);
                this.serverSession = client.start();
                RegisterReq registerReq = new RegisterReq();
                registerReq.setLocalIp(IPUtils.getPreferredInternalIp());
                registerReq.setSlaverKey(properties.getSlaverKey());
                registerReq.setVersion(properties.getSlaverVersion());
                res = this.socketTemplate.request(serverSession, Constants.REIGSTER_API_ID, registerReq, 30);
            } catch (Throwable e) {
                client.shutdownNow();
                log.error("Error starting client", e);
                sleep(30);
                continue;
            }
            break;
        }
        if (res.isFail()) {
            log.error("注册失败, errorCode:{}, msg:{}", res.getErrorCode(), res.getErrorMsg());
            throw new Error("register master error: " + res.getErrorMsg());
        }
    }

    private static void sleep(long seconds) {
        try {
            Thread.sleep(seconds * 1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}
