/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.pressure.client;

import com.digiwin.pressure.client.SocketClientProperties;
import com.digiwin.pressure.cs.core.BaseApiHandler;
import com.digiwin.pressure.cs.core.BinaryProtocol;
import com.digiwin.pressure.cs.core.PressureMessageProcessor;
import com.digiwin.pressure.cs.core.SocketTemplate;
import com.digiwin.pressure.cs.core.domain.RegisterReq;
import com.digiwin.pressure.cs.core.domain.Result;
import com.digiwin.pressure.cs.core.util.IPUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

public class SocketClient {
    private static final Logger log = LoggerFactory.getLogger(SocketClient.class);
    private AioSession serverSession;
    private AioQuickClient client;
    private SocketTemplate socketTemplate;
    private final List<BaseApiHandler> apiHandlers;
    private final SocketClientProperties properties;

    public SocketClient(List<BaseApiHandler> apiHandlers, SocketClientProperties socketClientProperties) {
        this.apiHandlers = apiHandlers;
        this.properties = socketClientProperties;
    }

    public void start() {
        this.socketTemplate = new SocketTemplate(this.apiHandlers);
        Result res = null;
        for (int i = 0; i < 20; ++i) {
            try {
                this.client = new AioQuickClient(this.properties.getServerHost(), this.properties.getServerPort().intValue(), (Protocol)new BinaryProtocol(), (MessageProcessor)new PressureMessageProcessor(this.socketTemplate){

                    protected void handleSessionClosedEvent(AioSession session) {
                        SocketClient.sleep(30L);
                        SocketClient.this.client.shutdown();
                        SocketClient.this.start();
                    }

                    protected void handleSessionErrorEvent(AioSession session) {
                    }
                });
                this.client.setReadBufferSize(1024);
                this.client.setWriteBuffer(1024, 10);
                this.serverSession = this.client.start();
                RegisterReq registerReq = new RegisterReq();
                registerReq.setLocalIp(IPUtils.getPreferredInternalIp());
                registerReq.setSlaverKey(this.properties.getSlaverKey());
                registerReq.setVersion(this.properties.getSlaverVersion());
                res = this.socketTemplate.request(this.serverSession, 80001, (Object)registerReq, 30);
                break;
            }
            catch (Throwable e) {
                this.client.shutdownNow();
                log.error("Error starting client", e);
                SocketClient.sleep(30L);
                continue;
            }
        }
        if (res.isFail()) {
            log.error("\u6ce8\u518c\u5931\u8d25, errorCode:{}, msg:{}", (Object)res.getErrorCode(), (Object)res.getErrorMsg());
            throw new Error("register master error: " + res.getErrorMsg());
        }
    }

    private static void sleep(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

