/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.pressure.cs.server;

import com.digiwin.pressure.cs.core.BaseApiHandler;
import com.digiwin.pressure.cs.core.BinaryProtocol;
import com.digiwin.pressure.cs.core.PressureMessageProcessor;
import com.digiwin.pressure.cs.core.SocketTemplate;
import com.digiwin.pressure.cs.core.domain.RegisterReq;
import com.digiwin.pressure.cs.core.domain.Result;
import com.digiwin.pressure.cs.server.BaseRegister;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioQuickServer;
import org.smartboot.socket.transport.AioSession;

public class SocketServer {
    private static final Logger log = LoggerFactory.getLogger(SocketServer.class);
    private final Integer port;
    private final BaseRegister register;
    private final Map<Long, AioSession> sessionMap = new ConcurrentHashMap<Long, AioSession>();
    private String blackIp;
    private SocketTemplate socketTemplate;

    public SocketServer(int port, BaseRegister register) {
        this.port = port;
        this.register = register;
    }

    public <T> Result<T> requestClient(long slaverId, int apiId, Object requestData, int timeoutSeconds) throws Exception {
        AioSession session = this.sessionMap.get(slaverId);
        return this.socketTemplate.request(session, apiId, requestData, timeoutSeconds);
    }

    public void start() throws IOException {
        BaseApiHandler<RegisterReq, Void> registerHandler = new BaseApiHandler<RegisterReq, Void>(){

            public int getApiId() {
                return 80001;
            }

            public Result<Void> handle(AioSession session, RegisterReq req) {
                try {
                    req.setRemoteIp(session.getRemoteAddress().getHostString());
                }
                catch (IOException e) {
                    log.error("Error getting remote ip", (Throwable)e);
                }
                Result<Long> result = SocketServer.this.register.register(req);
                if (result.isFail()) {
                    return Result.buildFailResult((String)result.getErrorCode(), (String)result.getErrorMsg());
                }
                Long slaverId = (Long)result.getData();
                SocketServer.this.sessionMap.put(slaverId, session);
                return Result.buildSuccessResult(null);
            }
        };
        this.socketTemplate = new SocketTemplate(Collections.singletonList(registerHandler));
        AioQuickServer server = new AioQuickServer(this.port.intValue(), (Protocol)new BinaryProtocol(), (MessageProcessor)new PressureMessageProcessor(this.socketTemplate){

            protected void handleSessionClosedEvent(AioSession session) {
                Long slaverId = SocketServer.this.sessionMap.entrySet().stream().filter(entry -> ((AioSession)entry.getValue()).getSessionID().equals(session.getSessionID())).map(Map.Entry::getKey).findFirst().orElse(null);
                if (slaverId != null) {
                    SocketServer.this.sessionMap.remove(slaverId);
                    SocketServer.this.register.disconnect(slaverId);
                }
            }

            protected List<String> getBlackIp() {
                if (null == SocketServer.this.blackIp) {
                    return null;
                }
                String[] blackIpArray = SocketServer.this.blackIp.split(",");
                if (blackIpArray.length == 0) {
                    return null;
                }
                return Arrays.asList(blackIpArray);
            }

            protected void handleSessionErrorEvent(AioSession session) {
                session.close();
            }
        });
        server.setReadBufferSize(1024);
        server.setWriteBuffer(1024, 10);
        server.start();
        log.info("Server started on port {}", (Object)this.port);
    }

    public void setBlackIp(String blackIp) {
        this.blackIp = blackIp;
    }
}

