/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.aop;

import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import java.lang.reflect.Field;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RestControllerAfterAdvice {
    private static final Logger log = LoggerFactory.getLogger(RestControllerAfterAdvice.class);

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController) && execution(* *(..))")
    public void restControllerPointcut() {
    }

    @AfterReturning(pointcut="restControllerPointcut()", returning="result")
    public void afterMethodExecution(JoinPoint joinPoint, Object result) {
        this.releaseThrealLocale(joinPoint);
    }

    @AfterThrowing(pointcut="restControllerPointcut()", throwing="exception")
    public void afterThrowing(JoinPoint joinPoint, Exception exception) {
        this.releaseThrealLocale(joinPoint);
    }

    private void releaseThrealLocale(JoinPoint joinPoint) {
        if (this.isNeedRelease(joinPoint)) {
            Pipeline.clearAll();
        }
    }

    private boolean isNeedRelease(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0 || args[0] == null) {
            return true;
        }
        Object firstParam = args[0];
        Class<?> paramClass = firstParam.getClass();
        try {
            Field field = paramClass.getDeclaredField("closeStream");
            field.setAccessible(true);
            Object fieldValue = field.get(firstParam);
            if (fieldValue instanceof Boolean) {
                log.info("===== \u5207\u9762\u91ca\u653ethreadLocal =====");
                return (Boolean)fieldValue;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof NoSuchFieldException) {
                log.debug("\u53c2\u6570\u5bf9\u8c61 [{}] \u4e2d\u4e0d\u5305\u542b\u5b57\u6bb5 [closeStream]\u3002", (Object)paramClass.getSimpleName());
                return true;
            }
            return true;
        }
    }
}

