/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.search.config.AthenaDeployerHostConfig;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AthenaDeployerServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(AthenaDeployerServiceInvoker.class);
    @Autowired
    private AthenaDeployerHostConfig athenaDeployerHostConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final String TENANT_APPRELATENANTVERSION = "/athena-deployer-service/tenant/appRelatenantVersion/";
    private static final String TOKEN = "token";
    private String ERR_MESSAGE = "\u67e5\u8be2\u8bbe\u8ba1\u5668\u7cfb\u7edf\u5f02\u5e38";
    private static final String ROUTERKEY = "routerKey";

    public List<String> getAppRelatenantVersion(String token, String routerKey, String appCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add(ROUTERKEY, routerKey);
        }
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.athenaDeployerHostConfig.getUrl().concat(TENANT_APPRELATENANTVERSION).concat(appCode), HttpMethod.GET, entity, JSONObject.class, new Object[0]);
            log.info("getAppRelatenantVersion responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return ((JSONObject)responseEntity.getBody()).getJSONArray("data").stream().map(json -> ((JSONObject)json).getString("tenantId")).collect(Collectors.toList());
            }
            log.info("\u67e5\u8be2\u79df\u6237\u5173\u8054\u5e94\u7528\u5931\u8d25:{}", (Object)Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u79df\u6237\u5173\u8054\u5e94\u7528\u5931\u8d25\uff1a{} ", (Throwable)e2);
        }
        return null;
    }
}

