/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.search.config.UibotHostConfig;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class UibotServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(UibotServiceInvoker.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private UibotHostConfig uibotHostConfig;
    private static final String SHOW_REPORT_URL = "/api/ai/v1/agile/report/show/";
    private String ERR_MESSAGE = "\u67e5\u8be2uibot\u7cfb\u7edf\u5f02\u5e38";

    public JSONObject showReport(String token, String routerKey, String snapshotId) {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add("token", token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        headers.add("Content-Type", "application/json");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.uibotHostConfig.getUrl().concat(SHOW_REPORT_URL).concat(snapshotId), HttpMethod.GET, entity, String.class, new Object[0]);
            log.info("showReport responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.info("\u67e5\u8be2\u751f\u6210\u56fe\u50cf\u6570\u636e\u6210\u529f");
                JSONObject body = JSONObject.parseObject((String)((String)responseEntity.getBody()));
                JSONObject response = Optional.ofNullable(body).map(r -> r.getJSONObject("response")).orElse(new JSONObject());
                if (!response.isEmpty()) {
                    return response;
                }
            } else {
                log.info("\u67e5\u8be2\u751f\u6210\u56fe\u50cf\u6570\u636e\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u751f\u6210\u56fe\u50cf\u6570\u636e\u5931\u8d25\uff1a{} ", (Throwable)e2);
        }
        return null;
    }
}

