/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.search.config.AppTokenConfig;
import com.digiwin.chatbi.reasoning.search.config.IamHostConfig;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class UserLoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UserLoginInterceptor.class);
    @Value(value="${dyn-params.iamAddr}")
    private String iamAddr;
    @Autowired
    private AppTokenConfig appTokenConfig;
    private String SCRUMBI_TOKEN = "4oAdURv.P4J5bdL2YXepKsnlp";
    private String ERR_MESSAGE = "\u7528\u6236token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u8054\u7cfb\u5ba2\u670d\u4e13\u5458";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IamHostConfig iamHostConfig;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String scrumbiToken;
        boolean result = false;
        String uri = request.getRequestURI();
        if (uri.contains("swagger") || uri.contains("api-docs")) {
            result = true;
        }
        String locale = request.getHeader("locale");
        log.info("UserLoginInterceptor locale is exist: {}", (Object)locale);
        String userToken = request.getHeader("token");
        if (StringUtils.isNotEmpty((CharSequence)userToken)) {
            Pipeline.addUserToken((String)userToken);
        }
        String routerKey = request.getHeader("routerKey");
        log.info("UserLoginInterceptor routerKey is exist: {}", (Object)routerKey);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            Pipeline.addRouterKey((String)routerKey);
        }
        String messageId = request.getHeader("messageId");
        log.info("UserLoginInterceptor messageId is exist: {}", (Object)messageId);
        if (StringUtils.isNotEmpty((CharSequence)messageId)) {
            Pipeline.addMessageId((String)messageId);
        }
        String ptxId = request.getHeader("ptxId");
        log.info("UserLoginInterceptor pixBackendId is exist: {}", (Object)ptxId);
        if (StringUtils.isNotEmpty((CharSequence)ptxId)) {
            Pipeline.addPtxId((String)ptxId);
        }
        if (this.SCRUMBI_TOKEN.equals(scrumbiToken = request.getHeader("scrumbiToken"))) {
            return true;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", this.appTokenConfig.getAthena());
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(), (MultiValueMap)headers);
        String sid = null;
        try {
            log.info("UserLoginInterceptor#preHandle addr:{}, token:{}. apptoken:{}", new Object[]{this.iamHostConfig.getAnalyzeAddr(), userToken, this.appTokenConfig.getAthena()});
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.iamHostConfig.getAnalyzeAddr(), (Object)httpEntity, JSONObject.class, new Object[0]);
            log.info("UserLoginInterceptor#preHandle responseEntity\uff1a{}", responseEntity.getBody());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.returnTokenCheckJson(response, Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
                return false;
            }
            sid = ((JSONObject)responseEntity.getBody()).getString("tenantSid");
        }
        catch (Exception e2) {
            this.returnTokenCheckJson(response, this.ERR_MESSAGE);
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)sid)) {
            Pipeline.addsId((String)sid);
        }
        return true;
    }

    public void returnTokenCheckJson(HttpServletResponse response, String returnMsg) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        try {
            response.getWriter().print(JSON.toJSONString((Object)ResultBean._401((String)returnMsg)));
        }
        catch (IOException e) {
            log.warn("****** \u8bf7\u6c42token\u8bb8\u53ef\u62e6\u622a\u5668\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a{} ******", (Object)e.getMessage());
        }
    }

    public void setIamAddr(String iamAddr) {
        this.iamAddr = iamAddr;
    }
}

