/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.exception.Supplier;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.service.MessageUtils;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtil {
    public static final Supplier<Random> randomS = () -> new Random();
    public static final Pattern bracketPattern = Pattern.compile("\u3010([^\u3011]*)\u3011");

    public static String LongestPrefixMatch(List<String> targetList, String targetStr) {
        AtomicReference matchStr = new AtomicReference();
        if (CollectionUtils.isEmpty(targetList) || StringUtils.isBlank((CharSequence)targetStr)) {
            return (String)matchStr.get();
        }
        Optional<String> longestPrefixMatch = targetList.stream().max(Comparator.comparingInt(s -> CommonUtil.calculateCommonPrefixLength((String)s, (String)targetStr)));
        HashMap<String, Integer> matchMap = new HashMap<String, Integer>();
        for (String s2 : targetList) {
            matchMap.put(s2, CommonUtil.calculateCommonPrefixLength((String)s2, (String)targetStr));
        }
        longestPrefixMatch.ifPresent(s -> matchStr.set(s));
        if ((Integer)matchMap.get(matchStr.get()) == 0 || !targetStr.contains((CharSequence)matchStr.get())) {
            return null;
        }
        return (String)matchStr.get();
    }

    private static int calculateCommonPrefixLength(String str1, String str2) {
        if (str1.length() > str2.length()) {
            return 0;
        }
        if (str1.length() == str2.length()) {
            return str1.equals(str2) ? str1.length() : 0;
        }
        int minLength = Math.min(str1.length(), str2.length());
        for (int i = 0; i < minLength; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            return i - 1;
        }
        return minLength;
    }

    public static List<String> getBracketValList(String prompt) {
        Matcher matcher = bracketPattern.matcher(prompt);
        ArrayList<String> bracketValList = new ArrayList<String>();
        while (matcher.find()) {
            bracketValList.add(matcher.group(1));
        }
        return bracketValList;
    }

    public static Map<String, String> userInfoToMap(String userAllInfoJsonStr) {
        JSONObject resultJson = JSONObject.parseObject((String)userAllInfoJsonStr);
        JSONArray userInfoArray = resultJson.getJSONArray("userBasicInformation");
        HashMap<String, String> map = new HashMap<String, String>();
        userInfoArray.forEach(item -> {
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)item));
            map.put(jsonObject.getJSONObject("user").getString("id"), jsonObject.getJSONObject("user").getString("name"));
        });
        return map;
    }

    public static String extractDataBetweenBraces(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return "";
        }
        int startIndex = input.indexOf("{");
        int endIndex = input.lastIndexOf("}");
        if (startIndex >= 0 && endIndex >= 0 && endIndex > startIndex) {
            return input.substring(startIndex, endIndex + 1);
        }
        return "";
    }

    public static String base64ToUtf8(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return new String(Base64.getDecoder().decode(str), StandardCharsets.UTF_8);
        }
        return "";
    }

    public static String utf8ToBase64(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
        }
        return "";
    }

    public static String mapToString(List<LinkedHashMap<String, Object>> data) {
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(map -> {
                ArrayList entries = new ArrayList(map.entrySet());
                for (int i = 0; i < entries.size(); ++i) {
                    Object value = ((Map.Entry)entries.get(i)).getValue();
                    if (i == entries.size() - 1) {
                        stringBuilder.append(" | " + value + " |\n");
                        continue;
                    }
                    stringBuilder.append(" | " + value);
                }
            });
        }
        return stringBuilder.toString();
    }

    public static boolean isLastCharPunctuation(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char lastChar = str.charAt(str.length() - 1);
        String punctuationRegex = "[\\p{Punct}\uff0c\u3002\uff01\uff1f\uff1a\uff1b\u201c\u201d\u2018\u2019\uff08\uff09\u300a\u300b\u3010\u3011]";
        return String.valueOf(lastChar).matches(punctuationRegex);
    }

    public static String transBracketsContent(String text) {
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        String one_more_target = messageUtils.getMessageByLangName("message.scrumbi.one.more.target", "zh_CN");
        if (!text.startsWith(one_more_target)) {
            return ZhConverterUtil.toTraditional((String)text);
        }
        Pattern pattern = Pattern.compile("\u3010.*?\u3011");
        Matcher matcher = pattern.matcher(text);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            String original = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            String before = text.substring(lastEnd, start);
            String simplifiedBefore = ZhConverterUtil.toTraditional((String)before);
            result.append(simplifiedBefore);
            result.append(original);
            lastEnd = end;
        }
        String remaining = text.substring(lastEnd);
        String simplifiedRemaining = ZhConverterUtil.toTraditional((String)remaining);
        result.append(simplifiedRemaining);
        return result.toString();
    }

    public static List<Map<String, String>> jsonArrayToListMap(JSONArray jsonArray) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : jsonObject.keySet()) {
                map.put(key, jsonObject.getString(key));
            }
            list.add(map);
        }
        return list;
    }

    public static int compareDateRanges(String range1, String range2) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String[] parts1 = range1.split("#");
        LocalDate startDate1 = LocalDate.parse(parts1[0], formatter);
        LocalDate endDate1 = LocalDate.parse(parts1[1], formatter);
        String[] parts2 = range2.split("#");
        LocalDate startDate2 = LocalDate.parse(parts2[0], formatter);
        LocalDate endDate2 = LocalDate.parse(parts2[1], formatter);
        int startComparison = startDate1.compareTo(startDate2);
        if (startComparison != 0) {
            return startComparison;
        }
        return endDate1.compareTo(endDate2);
    }
}

