/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.util;

import com.digiwin.chatbi.common.util.MatchFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class MatchFinder {
    public static boolean isCompletelyOverlapping(Match match1, Match match2) {
        return match1.start >= match2.start && match1.end <= match2.end || match2.start >= match1.start && match2.end <= match1.end;
    }

    public static List<String>[] findMatchesWithOverlap(String question, String standardName, List<String> synonyms) {
        String questionLower = question.toLowerCase();
        ArrayList<String> allTerms = new ArrayList<String>();
        allTerms.add(standardName);
        allTerms.addAll(synonyms);
        ArrayList<String> allTermsLower = new ArrayList<String>();
        for (String term : allTerms) {
            allTermsLower.add(term.toLowerCase());
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (int i = 0; i < allTermsLower.size(); ++i) {
            int pos;
            String termLower = (String)allTermsLower.get(i);
            int start = 0;
            while ((pos = questionLower.indexOf(termLower, start)) != -1) {
                String originalCase = question.substring(pos, pos + termLower.length());
                String originalTerm = (String)allTerms.get(i);
                matches.add(new Match(originalCase, originalTerm, termLower, pos, pos + termLower.length()));
                start = pos + 1;
            }
        }
        matches.sort(Comparator.comparingInt(m -> m.start));
        ArrayList<String> matchedWords = new ArrayList<String>();
        ArrayList<String> highlightMatches = new ArrayList<String>();
        int i = 0;
        while (i < matches.size()) {
            int j;
            ArrayList currentGroup = new ArrayList();
            currentGroup.add(matches.get(i));
            for (j = i + 1; j < matches.size() && ((Match)matches.get((int)j)).start < ((Match)matches.get((int)i)).end; ++j) {
                currentGroup.add(matches.get(j));
            }
            if (currentGroup.size() > 1) {
                ArrayList completeOverlapGroup = new ArrayList();
                ArrayList partialOverlapGroup = new ArrayList();
                for (int k = 0; k < currentGroup.size(); ++k) {
                    boolean isComplete = false;
                    for (int l = 0; l < currentGroup.size(); ++l) {
                        if (k == l || !MatchFinder.isCompletelyOverlapping((Match)((Match)currentGroup.get(k)), (Match)((Match)currentGroup.get(l)))) continue;
                        isComplete = true;
                        break;
                    }
                    if (isComplete) {
                        completeOverlapGroup.add(currentGroup.get(k));
                        continue;
                    }
                    partialOverlapGroup.add(currentGroup.get(k));
                }
                if (!completeOverlapGroup.isEmpty()) {
                    Match longestMatch = Collections.max(completeOverlapGroup, Comparator.comparingInt(m -> m.length));
                    if (!matchedWords.stream().anyMatch(w -> w.toLowerCase().equals(longestMatch.termLower))) {
                        matchedWords.add(longestMatch.term);
                    }
                }
                for (Match match : partialOverlapGroup) {
                    if (matchedWords.stream().anyMatch(w -> w.toLowerCase().equals(match.termLower))) continue;
                    matchedWords.add(match.term);
                }
                for (Match match : currentGroup) {
                    if (highlightMatches.stream().anyMatch(w -> w.toLowerCase().equals(match.termLower))) continue;
                    highlightMatches.add(match.highlightTerm);
                }
            } else {
                Match match = (Match)currentGroup.get(0);
                if (!matchedWords.stream().anyMatch(w -> w.toLowerCase().equals(match.termLower))) {
                    matchedWords.add(match.term);
                }
                if (!highlightMatches.stream().anyMatch(w -> w.toLowerCase().equals(match.termLower))) {
                    highlightMatches.add(match.highlightTerm);
                }
            }
            i = j > i + 1 ? j : i + 1;
        }
        return new List[]{matchedWords, highlightMatches};
    }

    public static void main(String[] args) {
        String question = "This is a test question";
        String standardName = "test";
        List<String> synonyms = Arrays.asList("exam", "quiz");
        List[] result = MatchFinder.findMatchesWithOverlap((String)question, (String)standardName, synonyms);
        System.out.println("Matched Words: " + result[0]);
        System.out.println("Highlight Matches: " + result[1]);
    }
}

