/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.config;

import com.digiwin.chatbi.reasoning.search.client.EsRestClient;
import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchHealthIndicator
implements HealthIndicator {
    @Autowired
    private EsRestClient esRestClient;

    public Health health() {
        try {
            Request request = new Request("GET", "/_cluster/health");
            Response response = this.esRestClient.doHealthCheck(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return Health.up().build();
            }
            return Health.down().withDetail("statusCode", (Object)statusCode).build();
        }
        catch (IOException e) {
            return Health.down((Exception)e).build();
        }
    }
}

