/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.EsQuery;
import com.digiwin.chatbi.reasoning.search.EsQueryExecutor;
import com.digiwin.chatbi.reasoning.search.dto.AliasesDto;
import com.digiwin.chatbi.reasoning.search.dto.BulkDto;
import com.digiwin.chatbi.reasoning.search.dto.ReindexDto;
import com.digiwin.chatbi.reasoning.search.facade.EsConfigFacade;
import com.digiwin.chatbi.reasoning.search.facade.EsIndexFacade;
import com.digiwin.chatbi.reasoning.search.util.DslUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scrumbi"})
@Api(value="SearchController", tags={"SearchController"})
public class SearchController {
    @Resource
    private EsQueryExecutor esQueryExecutor;
    @Resource
    private EsIndexFacade esIndexFacade;
    @Resource
    private EsConfigFacade esConfigFacade;

    @ApiOperation(value="\u67e5\u8be2\u7d22\u5f15\u4fe1\u606f")
    @PostMapping(value={"/indexDetail/{index}"})
    public JSONObject indexDetail(@PathVariable(value="index") String index) {
        return this.esConfigFacade.getIndexDetail(index);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7d22\u5f15\u4fe1\u606f")
    @PostMapping(value={"/setNewIndex/{index}"})
    public JSONObject setNewIndex(@PathVariable(value="index") String index, @RequestBody JSONObject param) {
        return this.esConfigFacade.setNewIndex(index, param);
    }

    @ApiOperation(value="\u66f4\u65b0\u7d22\u5f15\u4fe1\u606f")
    @PostMapping(value={"/changMapping/{index}"})
    public JSONObject changMapping(@PathVariable(value="index") String index, @RequestBody JSONObject param) {
        return this.esConfigFacade.changeMapping(index, param);
    }

    @PostMapping(value={"/queryEsById"})
    @ApiOperation(value="queryEsById")
    public JSONObject queryEsById(@RequestBody EsQuery esQuery) {
        return this.esQueryExecutor.queryById(esQuery.getIndexName(), esQuery.getId());
    }

    @ApiOperation(value="\u900f\u4f20\u53c2\u6570\u8c03\u7528es\u76f4\u63a5\u67e5\u8be2")
    @PostMapping(value={"/{index}/_search"})
    public JSONObject search(@PathVariable(value="index") String index, @RequestBody(required=false) JSONObject param, HttpServletRequest request) {
        return this.esQueryExecutor.queryByParam(index, DslUtil.JsonToString((JSONObject)param), request.getQueryString());
    }

    @ApiOperation(value="\u900f\u4f20\u53c2\u6570\u8c03\u7528es\u76f4\u63a5\u67e5\u8be2")
    @PostMapping(value={"/{index}/count"})
    public JSONObject count(@PathVariable(value="index") String index, @RequestBody(required=false) JSONObject param) {
        return this.esQueryExecutor.countByParam(index, DslUtil.JsonToString((JSONObject)param));
    }

    @ApiOperation(value="\u900f\u4f20\u53c2\u6570\u8c03\u7528es\u6839\u636eid\u67e5\u8be2")
    @PostMapping(value={"/get/{index}/{id}"})
    public JSONObject get(@PathVariable(value="index") String index, @PathVariable(value="id") String id) {
        return this.esQueryExecutor.queryById(index, id);
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u4e0e\u53c2\u6570\u67e5\u8be2es")
    @PostMapping(value={"/retrieve/{index}/{dsl}"})
    public JSONObject retrieve(@PathVariable(value="index") String index, @PathVariable(value="dsl") String dsl, @RequestBody JSONObject param) {
        return this.esQueryExecutor.queryByDslTemplate(index, dsl, (Map)param);
    }

    @ApiOperation(value="\u6279\u91cf\u5411es\u4e2d\u63d2\u5165\u6570\u636e")
    @PostMapping(value={"/index/bulk/{index}"})
    public JSONObject bulkIndex(@PathVariable(value="index") String index, @RequestBody List<BulkDto> param) {
        return this.esIndexFacade.bulkInsert(index, param);
    }

    @ApiOperation(value="\u6279\u91cf\u5411es\u4e2d\u66f4\u65b0\u6570\u636e")
    @PostMapping(value={"/update/bulk/{index}"})
    public JSONObject bulkUpdate(@PathVariable(value="index") String index, @RequestBody List<BulkDto> param) {
        return this.esIndexFacade.bulkUpdate(index, param);
    }

    @ApiOperation(value="\u6279\u91cf\u5411es\u4e2d\u5408\u5e76\u6570\u636e\uff08\u5982\u679c\u6307\u5b9aid\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5219\u5199\u5165\uff0c\u5426\u5219\u53ea\u66f4\u65b0\u6307\u5b9a\u5b57\u6bb5\uff09")
    @PostMapping(value={"/merge/bulk/{index}"})
    public JSONObject bulkMerge(@PathVariable(value="index") String index, @RequestBody List<BulkDto> param) {
        return this.esIndexFacade.bulkMerge(index, param);
    }

    @ApiOperation(value="\u4e0d\u6307\u5b9aid\u5411es\u4e2d\u63d2\u5165\u6570\u636e")
    @PostMapping(value={"/index/{index}"})
    public JSONObject index(@PathVariable(value="index") String index, @RequestBody JSONObject param) {
        return this.esIndexFacade.insert(index, param);
    }

    @ApiOperation(value="\u6307\u5b9aid\u5411es\u4e2d\u63d2\u5165\u6570\u636e")
    @PostMapping(value={"/index/{index}/{id}"})
    public JSONObject index(@PathVariable(value="index") String index, @PathVariable(value="id") String id, @RequestBody JSONObject param) {
        return this.esIndexFacade.insertById(index, id, param, true);
    }

    @ApiOperation(value="\u6307\u5b9aid\u5411\u5c40\u90e8\u66f4\u65b0\u5355\u6761es\u6570\u636e")
    @PostMapping(value={"/update/{index}/{id}"})
    public JSONObject update(@PathVariable(value="index") String index, @PathVariable(value="id") String id, @RequestBody(required=false) JSONObject param) {
        return this.esIndexFacade.updateById(index, id, param);
    }

    @ApiOperation(value="\u6307\u5b9aid\u5411es\u4e2d\u5408\u5e76\u6570\u636e\uff08\u5982\u679c\u6307\u5b9aid\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5219\u5199\u5165\uff0c\u5426\u5219\u53ea\u66f4\u65b0\u6307\u5b9a\u5b57\u6bb5\uff09")
    @PostMapping(value={"/merge/{index}/{id}"})
    public JSONObject merge(@PathVariable(value="index") String index, @PathVariable(value="id") String id, @RequestBody JSONObject param) {
        return this.esIndexFacade.mergeById(index, id, param);
    }

    @ApiOperation(value="\u66f4\u65b0\u7d22\u5f15\u6570\u636e\uff0c\u901a\u5e38\u7528\u6765\u5728\u8bcd\u5178\u91cd\u65b0\u52a0\u8f7d\u540e\u8c03\u7528\u4f7f\u53d8\u66f4\u8bcd\u5bf9\u5386\u53f2\u6570\u636e\u751f\u6548")
    @PostMapping(value={"/updateByQuery/{index}"})
    public JSONObject updateByQuery(@PathVariable(value="index") String index, @RequestBody(required=false) JSONObject param) {
        return this.esIndexFacade.updateByQuery(index, param != null ? param : JSONObject.parseObject((String)"{}"));
    }

    @ApiOperation(value="\u6307\u5b9aid\u5728es\u4e2d\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/delete/{index}/{id}"})
    public JSONObject delete(@PathVariable(value="index") String index, @PathVariable(value="id") String id) {
        return this.esIndexFacade.delById(index, id);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/deleteByQuery/{index}"})
    public JSONObject deleteByQuery(@PathVariable(value="index") String index, @RequestBody(required=false) JSONObject param) {
        return this.esIndexFacade.deleteByQuery(index, param != null ? param : JSONObject.parseObject((String)"{}"));
    }

    @ApiOperation(value="\u5220\u9664\u7d22\u5f15(\u614e\u7528\uff01\uff01\uff01)")
    @PostMapping(value={"/deleteIndex/{index}"})
    public JSONObject deleteIndex(@PathVariable(value="index") String index) {
        return this.esConfigFacade.deleteIndex(index);
    }

    @ApiOperation(value="\u6570\u636e\u91cd\u5b9a\u5411")
    @PostMapping(value={"/reIndex"})
    public JSONObject reIndex(@RequestBody ReindexDto reindexDto) {
        return this.esConfigFacade.reIndex(JSONObject.parseObject((String)JSONObject.toJSONString((Object)reindexDto)));
    }

    @ApiOperation(value="\u8bbe\u7f6e\u522b\u540d")
    @PostMapping(value={"/setAliases"})
    public JSONObject setAliases(@RequestBody AliasesDto aliasesDto) {
        return this.esConfigFacade.setAliases(JSONObject.parseObject((String)JSONObject.toJSONString((Object)aliasesDto)));
    }
}

