/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.controller;

import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.beans.SysUserInfo;
import com.digiwin.chatbi.beans.pojos.gpt.ModelAI;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsQo;
import com.digiwin.chatbi.common.UserThreadLocal;
import com.digiwin.chatbi.service.VectorDataSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"vector"})
@Api(value="VectorController", tags={"VectorController"})
public class VectorController {
    @Autowired
    private VectorDataSourceService vectorDataSourceService;
    @Value(value="${vector.prefix}")
    private String vectorPrefix;

    @PostMapping(value={"/searchDocs"})
    @ApiOperation(value="\u641c\u7d22\u77e5\u8bc6\u5e93")
    public ResultBean searchDocs(@RequestBody SearchDocsQo searchDocsQo) throws Exception {
        List searchDocsResults = this.vectorDataSourceService.searchDocs(searchDocsQo, "\u6570\u636e\u6e90\u89e3\u6790\uff08\u5411\u91cf\u5e93\uff09");
        return ResultBean.ok((Object)searchDocsResults);
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2\u89e3\u6790\u5de5\u4f5c\u8868")
    public ResultBean queryDataSourceVoList() throws Exception {
        String list = this.vectorDataSourceService.queryDataSourceVoList(null);
        return ResultBean.ok((Object)list);
    }

    @PostMapping(value={"/uploadDoc"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6\u5230\u77e5\u8bc6\u5e93")
    public ResultBean uploadDoc(String fileName, Long tenantSid) throws Exception {
        String tenantSidStr = this.vectorPrefix + tenantSid;
        ResultBean resultBean = this.vectorDataSourceService.uploadDoc(fileName, tenantSidStr);
        return resultBean;
    }

    @PostMapping(value={"/file/vector/create"})
    @ApiOperation(value="\u751f\u6210\u5411\u91cf\u5e93\u6587\u4ef6")
    public ResultBean create() throws Exception {
        SysUserInfo sysUserInfo = UserThreadLocal.get();
        ResultBean resultBean = this.vectorDataSourceService.create(null);
        return resultBean;
    }

    @PostMapping(value={"/knowledge/query"})
    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u5e93\u5217\u8868")
    public ResultBean queryKnowledgeBases() throws Exception {
        this.vectorDataSourceService.queryKnowledgeBases();
        return ResultBean.ok();
    }

    @PostMapping(value={"/knowledge/create"})
    @ApiOperation(value="\u521b\u5efa\u77e5\u8bc6\u5e93")
    public ResultBean createKnowledgeBase(Long tenantSid) throws Exception {
        String tenantSidStr = this.vectorPrefix + tenantSid;
        String knowledgeBase = this.vectorDataSourceService.createKnowledgeBase(tenantSidStr);
        return ResultBean.ok((Object)knowledgeBase);
    }

    @GetMapping(value={"/file/vector/sync"})
    @ApiOperation(value="\u5411\u91cf\u5e93\u6587\u4ef6\u540c\u6b65(\u8fd0\u7ef4)")
    public ResultBean vectorSync(@RequestBody List<ModelAI> modelAIList) throws Exception {
        ResultBean resultBean = this.vectorDataSourceService.vectorSync(modelAIList);
        return resultBean;
    }
}

