/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.boostEngine.logic.reasoning;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.parse.CalculateParser;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.RuleType;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.model.Token;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.DataType;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.Field;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.MetricSchema;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.fator.Sort;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.fator.condition.DateCondition;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.fator.condition.ValueCondition;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.logicform.DateDimension;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.logicform.LogicForm;
import com.digiwin.chatbi.reasoning.boostEngine.logic.model.logicform.Metric;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MetricParse {
    private List<Field> metrics;
    private List<Field> dates;
    private List<Field> entities;

    private MetricParse() {
    }

    public static MetricParse of(MetricSchema metricSchema) {
        MetricParse metricParse = new MetricParse();
        metricParse.metrics = DataType.METRIC.filterByDataType(metricSchema);
        metricParse.dates = DataType.DATE.filterByDataType(metricSchema).stream().filter(schema -> Objects.nonNull(schema.getDefaultDate()) && schema.getDefaultDate().equalsIgnoreCase("true")).collect(Collectors.toList());
        metricParse.entities = DataType.ENTITY.filterByDataType(metricSchema);
        assert (metricParse.metrics.size() == 1);
        return metricParse;
    }

    public LogicForm parse(List<Token> tokens) {
        LogicForm logicForm = new LogicForm();
        Map<RuleType, List<Token>> groupedTokens = tokens.stream().collect(Collectors.groupingBy(token -> token.getRule().getRuleType()));
        logicForm.setMetric(this.parseMetric(groupedTokens));
        logicForm.setDate(this.parseDateDimension(groupedTokens));
        return logicForm;
    }

    private DateDimension parseDateDimension(Map<RuleType, List<Token>> groupedTokens) {
        DateDimension dateDimension = new DateDimension();
        dateDimension.setFields(this.dates);
        if (groupedTokens.containsKey(RuleType.DATE)) {
            dateDimension.setConditions(groupedTokens.get(RuleType.DATE).stream().map(token -> new DateCondition((JSONArray)token.getParseContent())).collect(Collectors.toList()));
        }
        return dateDimension;
    }

    private Metric parseMetric(Map<RuleType, List<Token>> groupedTokens) {
        Metric metric = new Metric();
        assert (this.metrics.size() == 1);
        metric.setFields(this.metrics);
        if (groupedTokens.containsKey(RuleType.RANGE)) {
            metric.setConditions(groupedTokens.get(RuleType.RANGE).stream().map(token -> new ValueCondition(token)).collect(Collectors.toList()));
        }
        if (groupedTokens.containsKey(RuleType.RANK)) {
            assert (groupedTokens.get(RuleType.RANK).size() == 1);
            metric.setSorts(groupedTokens.get(RuleType.RANK).stream().map(token -> (Sort)((JSONObject)token.getParseContent()).toJavaObject(Sort.class)).collect(Collectors.toList()));
        }
        if (groupedTokens.containsKey(RuleType.CALCULATE)) {
            assert (groupedTokens.get(RuleType.CALCULATE).size() == 1);
            metric.setCalculates(groupedTokens.get(RuleType.CALCULATE).stream().map(token -> CalculateParser.of((String)((JSONObject)token.getParseContent()).getString("type"))).collect(Collectors.toList()));
        }
        return metric;
    }

    public List<Field> getMetrics() {
        return this.metrics;
    }

    public List<Field> getDates() {
        return this.dates;
    }

    public List<Field> getEntities() {
        return this.entities;
    }

    public void setMetrics(List<Field> metrics) {
        this.metrics = metrics;
    }

    public void setDates(List<Field> dates) {
        this.dates = dates;
    }

    public void setEntities(List<Field> entities) {
        this.entities = entities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricParse)) {
            return false;
        }
        MetricParse other = (MetricParse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$metrics = this.getMetrics();
        List other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        List this$dates = this.getDates();
        List other$dates = other.getDates();
        if (this$dates == null ? other$dates != null : !((Object)this$dates).equals(other$dates)) {
            return false;
        }
        List this$entities = this.getEntities();
        List other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricParse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        List $dates = this.getDates();
        result = result * 59 + ($dates == null ? 43 : ((Object)$dates).hashCode());
        List $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    public String toString() {
        return "MetricParse(metrics=" + this.getMetrics() + ", dates=" + this.getDates() + ", entities=" + this.getEntities() + ")";
    }
}

