/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.datasource;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeExecutor
implements Executor {
    private static final String date_format = "yyyy-MM-dd";
    private static final String year_format = "yyyy";

    public Output doProcess(JSONObject context) {
        CopyOnWriteArrayList logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        Date date = new Date();
        return Output.through((String)"currentDate", (Object)this.formatDate(date)).keep("lastMonth", (Object)this.formatDate(this.getLastMonthDate(date))).keep("lastDay", (Object)this.formatDate(this.getLastDayDate(date))).keep("currentMonthFirst", (Object)this.formatDate(this.currentMonthFirst())).keep("currentMonthTheLast", (Object)this.formatDate(this.currentMonthTheLast())).keep("lastMonthFirst", (Object)this.formatDate(this.lastMonthFirst())).keep("lastMonthTheLast", (Object)this.formatDate(this.lastMonthTheLast())).keep("currentYearFirst", (Object)this.formatDate(this.currentYearFirst())).keep("currentYearTheLast", (Object)this.formatDate(this.currentYearTheLast())).keep("lastYearFirst", (Object)this.formatDate(this.lastYearFirst())).keep("lastYearTheLast", (Object)this.formatDate(this.lastYearTheLast())).keep("lastQuarterStart", (Object)this.formatDate(DateTimeExecutor.getStartQuarter((Date)new Date()))).keep("lastQuarterEnd", (Object)this.formatDate(DateTimeExecutor.getLastQuarter((Date)new Date()))).keep("currentQuarterStart", (Object)this.formatDate(DateTimeExecutor.getStartOrEndDayOfQuarter((Boolean)true))).keep("currentQuarterEnd", (Object)this.formatDate(DateTimeExecutor.getStartOrEndDayOfQuarter((Boolean)false))).keep("currentYear", (Object)this.formatYear(this.currentYearFirst())).keep("lastYear", (Object)this.formatYear(this.lastYearFirst())).keep("lastYearMonthFirst", (Object)this.formatDate(this.lastYearMonthFirst())).keep("lastYearMonthTheLast", (Object)this.formatDate(this.lastYearMonthTheLast())).keep("pastSevenDay", (Object)this.getPastOrFutureDate(7, false)).keep("futureSevenDay", (Object)this.getPastOrFutureDate(7, true)).keep("pastThirtyDay", (Object)this.getPastOrFutureDate(30, false)).keep("futureThirtyDay", (Object)this.getPastOrFutureDate(30, true)).keep("pastSixtyDay", (Object)this.getPastOrFutureDate(60, false)).keep("futureSixtyDay", (Object)this.getPastOrFutureDate(60, true)).keep("pastNinetyDay", (Object)this.getPastOrFutureDate(90, false)).keep("futureNinetyDay", (Object)this.getPastOrFutureDate(90, true)).keep("pastOneHundredTwentyDay", (Object)this.getPastOrFutureDate(120, false)).keep("futureOneHundredTwentyDay", (Object)this.getPastOrFutureDate(120, true)).keep("pastOneHundredFiftyDay", (Object)this.getPastOrFutureDate(150, false)).keep("futureOneHundredFiftyDay", (Object)this.getPastOrFutureDate(150, true)).keep("pastOneHundredEightyDay", (Object)this.getPastOrFutureDate(180, false)).keep("futureOneHundredEightyDay", (Object)this.getPastOrFutureDate(180, true)).keep("nextMonth", (Object)this.getNextMonth()).keep("logCheckDtos", logCheckDtos);
    }

    private Date lastYearMonthTheLast() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    private Date lastYearMonthFirst() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Date getLastMonthDate(Date date) {
        return this.dataCalculate(date, 2, -1);
    }

    private Date getLastDayDate(Date date) {
        return this.dataCalculate(date, 5, -1);
    }

    private Date dataCalculate(Date date, int field, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, day);
        return calendar.getTime();
    }

    private Date currentMonthFirst() {
        Calendar canlendar = Calendar.getInstance();
        canlendar.setTime(new Date());
        canlendar.set(5, 1);
        return canlendar.getTime();
    }

    private Date currentMonthTheLast() {
        Calendar canlendar = Calendar.getInstance();
        canlendar.setTime(new Date());
        canlendar.set(5, 1);
        canlendar.roll(5, -1);
        return canlendar.getTime();
    }

    private Date lastMonthFirst() {
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(2, -1);
        canlendar.set(5, 1);
        return canlendar.getTime();
    }

    private Date lastMonthTheLast() {
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(2, -1);
        canlendar.set(5, canlendar.getActualMaximum(5));
        return canlendar.getTime();
    }

    private Date currentYearFirst() {
        Calendar currCal = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, currCal.get(1));
        return calendar.getTime();
    }

    private Date currentYearTheLast() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 11);
        calendar.set(5, 31);
        return calendar.getTime();
    }

    private Date lastYearFirst() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Date lastYearTheLast() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        calendar.set(2, 11);
        calendar.set(5, 31);
        return calendar.getTime();
    }

    private String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    private String formatYear(Date date) {
        return new SimpleDateFormat("yyyy").format(date);
    }

    public static Date getStartQuarter(Date date) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(date);
        startCalendar.set(2, (startCalendar.get(2) / 3 - 1) * 3);
        startCalendar.set(5, 1);
        DateTimeExecutor.setMinTime((Calendar)startCalendar);
        return startCalendar.getTime();
    }

    public static Date getLastQuarter(Date date) {
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(date);
        int month = endCalendar.get(2);
        endCalendar.set(2, (month / 3 - 1) * 3 + 3);
        endCalendar.set(5, 1);
        return new Date(endCalendar.getTime().getTime() - 86400000L);
    }

    private static void setMinTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date getStartOrEndDayOfQuarter(Boolean isFirst) {
        LocalDate today = LocalDate.now();
        LocalDate resDate = LocalDate.now();
        if (today == null) {
            today = resDate;
        }
        Month month = today.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        resDate = isFirst != false ? LocalDate.of(today.getYear(), firstMonthOfQuarter, 1) : LocalDate.of(today.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(today.isLeapYear()));
        return Date.from(resDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private String getPastOrFutureDate(int days, boolean isFuture) {
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (!isFuture) {
            return today.minusDays(days).format(formatter);
        }
        return today.plusDays(--days).format(formatter);
    }

    private String getNextMonth() {
        return LocalDate.now().plusMonths(1L).format(DateTimeFormatter.ofPattern("yyyy-MM"));
    }
}

