/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import groovy.lang.Tuple3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataProcessAfterSearchExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(DataProcessAfterSearchExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    public Output doProcess(JSONObject context) {
        Output output = Output.through();
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        output = this.processEntityTypeWords(context, question, output);
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        LogCheckDto logCheckDto = new LogCheckDto();
        List input = (List)context.getOrDefault((Object)"originalStandardWords", new ArrayList());
        List result = (List)context.getOrDefault((Object)"distinctOtherStandardWords", new ArrayList());
        logCheckDto.buildParams("DataProcessAfterSearch", LogUtils.SUCCESS, JSONObject.toJSONString((Object)input), JSONObject.toJSONString((Object)result), "");
        logCheckDtos.add(logCheckDto);
        return output.keep("logCheckDtos", logCheckDtos);
    }

    private Output processTargetTypeWords(JSONObject context, String question, Output output) {
        List standardWords = (List)context.get((Object)"originalTargetWords");
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            return output;
        }
        standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWords((List)standardWords, (String)question, (String)"standard_name");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("target_standard_name", (Object)standardWords.stream().map(source -> source.getString("standard_name")).collect(Collectors.joining(" ")));
        return output.keep(jsonObject);
    }

    private Output processEntityTypeWords(JSONObject context, String question, Output output) {
        List standardWords = (List)context.get((Object)"originalStandardWords");
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            return output;
        }
        standardWords = this.filterSchemaStandardWords(standardWords, context);
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        boolean synonymOldSwitch = (Boolean)environment.getProperty("synonym.old.switch", Boolean.class);
        log.info("\u5176\u4ed6\u7c7b\u578b\u7684\u540c\u4e49\u8bcd\u662f\u5426\u8d70\u8001es\u5f00\u5173:{}", (Object)synonymOldSwitch);
        standardWords = !Objects.isNull(synonymOldSwitch) && synonymOldSwitch ? DataProcessAfterSearchExecutor.filterLongestStandardWords((List)standardWords, (String)question, (String)"standard_name") : DataProcessAfterSearchExecutor.filterLongestStandardWordsV2((List)standardWords, (String)question);
        context.put("distinctOtherStandardWords", (Object)standardWords);
        HashMap synon2Detail = new HashMap();
        HashSet appendFilterWords = new HashSet();
        HashSet appendSpecailFilterWords = new HashSet();
        ArrayList standardLexiconList = new ArrayList();
        ArrayList standardWordList = new ArrayList();
        JSONArray schemaJsonArray = context.getJSONObject("schemas").getJSONArray("Schemas");
        standardWords.forEach(standardWord -> {
            List<String> synonyms = standardWord.getJSONArray("match_words").stream().map(Object::toString).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(synonyms)) {
                String entityType = standardWord.getString("entity_type");
                String schemaEnName = schemaJsonArray.stream().map(schema -> (JSONObject)schema).filter(schema -> entityType.equals(schema.getString("title"))).findFirst().orElse(new JSONObject()).getString("name");
                synonyms.forEach(sy -> synon2Detail.put(sy, new Tuple3((Object)standardWord.getString("standard_name"), (Object)schemaEnName, (Object)entityType)));
            }
            if (StringUtils.isNotEmpty((String)standardWord.getString("standard_name"))) {
                standardWordList.add(standardWord.getString("standard_name"));
            }
            if (StringUtils.isNotBlank((String)standardWord.getString("standard_name")) && StringUtils.length((String)standardWord.getString("standard_name")) > 1 && !StringUtils.isNumeric((String)standardWord.getString("standard_name")) || CollectionUtils.isNotEmpty(synonyms)) {
                synonyms.add(standardWord.getString("standard_name"));
                Object[] objectArray = new Object[2];
                objectArray[0] = synonyms.stream().filter(question::contains).reduce((x, y) -> x.length() > y.length() ? x : y).orElse("");
                objectArray[1] = standardWord.getString("entity_type");
                appendFilterWords.add(String.format("%s\u662f%s", objectArray));
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = synonyms.stream().filter(question::contains).reduce((x, y) -> x.length() > y.length() ? x : y).orElse("");
                objectArray2[1] = standardWord.getString("entity_type");
                appendSpecailFilterWords.add(String.format("\u300c%s\u300d\u662f%s", objectArray2));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("c_name", (Object)standardWord.getString("entity_type"));
            jsonObject.put("standard_name", (Object)standardWord.getString("standard_name"));
            jsonObject.put("Synonyms_aliases", (Object)standardWord.getString("synonyms"));
            jsonObject.put("synonyms", StringUtils.isNotEmpty((String)standardWord.getString("synonyms")) ? (List)standardWord.getObject("synonyms", List.class) : new ArrayList());
            standardLexiconList.add(jsonObject);
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("synonymsMap", synon2Detail);
        jsonObject.put("appendFilterQ", appendFilterWords);
        jsonObject.put("appendSpecailFilterQ", appendSpecailFilterWords);
        jsonObject.put("standard_lexicon", standardLexiconList);
        jsonObject.put("standardWords", standardWordList);
        return output.keep(jsonObject);
    }

    public static List<JSONObject> filterLongestStandardWords(List<JSONObject> standardWords, String question, String key) {
        if (CollectionUtils.isEmpty(standardWords)) {
            log.info("standardWords\u4e3a\u7a7a");
            return standardWords;
        }
        ArrayList<JSONObject> legalStandardWords = new ArrayList<JSONObject>();
        ArrayList allList = new ArrayList();
        standardWords.forEach(standardWord -> {
            JSONObject standardObject = new JSONObject();
            standardObject.put(key, (Object)standardWord.getString(key));
            standardObject.put("compare_field", (Object)standardWord.getString(key));
            standardObject.put("priority", (Object)1);
            allList.add(standardObject);
            JSONArray synonyms = standardWord.getJSONArray("synonyms");
            if (CollectionUtils.isNotEmpty((Collection)synonyms)) {
                synonyms.forEach(synonym -> {
                    JSONObject synonymObject = new JSONObject();
                    synonymObject.put(key, (Object)standardWord.getString(key));
                    synonymObject.put("compare_field", (Object)synonym.toString());
                    synonymObject.put("priority", (Object)2);
                    allList.add(synonymObject);
                });
            }
        });
        List groupList = DataProcessAfterSearchExecutor.groupByInclusion(allList);
        ArrayList<String> reservedStandard = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            log.info("groupList\u4e3a\u7a7a");
            return standardWords;
        }
        ArrayList<JSONObject> searchEabledStandardAndSynonyms = new ArrayList<JSONObject>();
        block0: for (Object jsonObjects : groupList) {
            if (CollectionUtils.isEmpty((Collection)jsonObjects)) {
                log.info("groupList-jsonObjects\u4e3a\u7a7a");
                continue;
            }
            List sortedJsonObjects = jsonObjects.stream().sorted((obj1, obj2) -> {
                String compareField1 = obj1.getString("compare_field");
                String compareField2 = obj2.getString("compare_field");
                int lengthComparison = Integer.compare(compareField2.length(), compareField1.length());
                if (lengthComparison != 0) {
                    return lengthComparison;
                }
                int priority1 = (Integer)obj1.getOrDefault((Object)"priority", (Object)1);
                int priority2 = (Integer)obj2.getOrDefault((Object)"priority", (Object)1);
                return Integer.compare(priority1, priority2);
            }).collect(Collectors.toList());
            String questionSubString = question;
            for (JSONObject standardAndSynonyms : sortedJsonObjects) {
                if (!questionSubString.contains(standardAndSynonyms.getString("compare_field"))) continue;
                searchEabledStandardAndSynonyms.add(standardAndSynonyms);
                continue block0;
            }
        }
        if (CollectionUtils.isNotEmpty(searchEabledStandardAndSynonyms)) {
            List jsonObjects = DataProcessAfterSearchExecutor.removeIncludedCompareField(searchEabledStandardAndSynonyms);
            for (JSONObject jsonObject : jsonObjects) {
                if (!question.contains(jsonObject.getString("compare_field"))) continue;
                reservedStandard.add(jsonObject.getString(key));
            }
        }
        for (JSONObject standardWord2 : standardWords) {
            if (!reservedStandard.contains(standardWord2.getString(key))) continue;
            legalStandardWords.add(standardWord2);
        }
        standardWords = legalStandardWords;
        return standardWords;
    }

    public static List<JSONObject> filterLongestStandardWordsV2(List<JSONObject> standardWords, String question) {
        if (CollectionUtils.isEmpty(standardWords)) {
            log.info("standardWords\u4e3a\u7a7a");
            return standardWords;
        }
        ArrayList allList = new ArrayList();
        standardWords.forEach(standardWord -> {
            List matchestWords = (List)standardWord.getOrDefault((Object)"match_words", List.class);
            if (CollectionUtils.isNotEmpty((Collection)matchestWords)) {
                matchestWords.forEach(synonym -> {
                    JSONObject synonymObject = new JSONObject();
                    synonymObject.put("compare_field", synonym);
                    synonymObject.put("applicationCodes", standardWord.get((Object)"applicationCodes"));
                    synonymObject.put("version", standardWord.get((Object)"version"));
                    synonymObject.put("standard_name", standardWord.get((Object)"standard_name"));
                    synonymObject.put("match_words", standardWord.get((Object)"match_words"));
                    synonymObject.put("entity_type", standardWord.get((Object)"entity_type"));
                    synonymObject.put("synonyms", standardWord.get((Object)"synonyms"));
                    allList.add(synonymObject);
                });
            }
        });
        List groupList = DataProcessAfterSearchExecutor.groupByInclusionV2(allList, (String)question);
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            log.info("groupList\u4e3a\u7a7a");
            return standardWords;
        }
        ArrayList<JSONObject> searchEabledStandardAndSynonyms = new ArrayList<JSONObject>();
        for (List jsonObjects : groupList) {
            if (CollectionUtils.isEmpty((Collection)jsonObjects)) {
                log.info("groupList-jsonObjects\u4e3a\u7a7a");
                continue;
            }
            List sortedJsonObjects = jsonObjects.stream().sorted((obj1, obj2) -> {
                String compareField1 = obj1.getString("compare_field");
                String compareField2 = obj2.getString("compare_field");
                int lengthComparison = Integer.compare(compareField2.length(), compareField1.length());
                return lengthComparison;
            }).collect(Collectors.toList());
            String questionSubString = question;
            String maxCompare = "";
            for (JSONObject standardAndSynonyms : sortedJsonObjects) {
                if (!questionSubString.contains(standardAndSynonyms.getString("compare_field"))) continue;
                maxCompare = standardAndSynonyms.getString("compare_field");
                break;
            }
            for (JSONObject standardAndSynonyms : sortedJsonObjects) {
                if (!questionSubString.contains(standardAndSynonyms.getString("compare_field")) || !maxCompare.equals(standardAndSynonyms.getString("compare_field"))) continue;
                searchEabledStandardAndSynonyms.add(standardAndSynonyms);
            }
        }
        return searchEabledStandardAndSynonyms;
    }

    public static List<JSONObject> filterLongestStandardWordsV3(List<JSONObject> standardWords, String question) {
        if (CollectionUtils.isEmpty(standardWords)) {
            log.info("standardWords\u4e3a\u7a7a");
            return standardWords;
        }
        ArrayList allList = new ArrayList();
        standardWords.forEach(standardWord -> {
            List matchestWords = (List)standardWord.getOrDefault((Object)"match_words", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)matchestWords)) {
                matchestWords.forEach(synonym -> {
                    JSONObject synonymObject = new JSONObject();
                    synonymObject.put("compare_field", synonym);
                    synonymObject.put("applicationCodes", standardWord.get((Object)"applicationCodes"));
                    synonymObject.put("version", standardWord.get((Object)"version"));
                    synonymObject.put("standard_name", standardWord.get((Object)"standard_name"));
                    synonymObject.put("match_words", standardWord.get((Object)"match_words"));
                    synonymObject.put("entity_type", standardWord.get((Object)"entity_type"));
                    synonymObject.put("dataSources", standardWord.get((Object)"dataSources"));
                    synonymObject.put("synonyms", standardWord.get((Object)"synonyms"));
                    synonymObject.put("explanation", standardWord.get((Object)"explanation"));
                    List applicationCodes = (List)standardWord.get((Object)"applicationCodes");
                    synonymObject.put("applicationCode", applicationCodes.get(0));
                    allList.add(synonymObject);
                });
            }
        });
        return DataProcessAfterSearchExecutor.getMatchestWords(allList, (String)question);
    }

    public static List<JSONObject> getMatchestWords(List<JSONObject> allList, String question) {
        ArrayList<JSONObject> sameNameDiffPositionStandardWords = new ArrayList<JSONObject>();
        for (JSONObject standardWord : allList) {
            List positions = DataProcessAfterSearchExecutor.findSubstringPositions((String)question, (String)standardWord.getString("compare_field"));
            if (CollectionUtils.isEmpty((Collection)positions)) continue;
            standardWord.put("position", positions.get(0));
            for (int i = 1; i < positions.size(); ++i) {
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)standardWord));
                jsonObject.put("position", positions.get(i));
                sameNameDiffPositionStandardWords.add(jsonObject);
            }
        }
        allList.addAll(sameNameDiffPositionStandardWords);
        List groupList = DataProcessAfterSearchExecutor.groupByInclusionV3(allList, (String)question);
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            log.info("groupList\u4e3a\u7a7a");
            return new ArrayList<JSONObject>();
        }
        ArrayList<JSONObject> searchEabledStandardAndSynonyms = new ArrayList<JSONObject>();
        for (List jsonObjects : groupList) {
            if (CollectionUtils.isEmpty((Collection)jsonObjects)) {
                log.info("groupList-jsonObjects\u4e3a\u7a7a");
                continue;
            }
            List sortedJsonObjects = jsonObjects.stream().sorted((obj1, obj2) -> {
                String compareField1 = obj1.getString("compare_field");
                String compareField2 = obj2.getString("compare_field");
                int lengthComparison = Integer.compare(compareField2.length(), compareField1.length());
                return lengthComparison;
            }).collect(Collectors.toList());
            String questionSubString = question;
            String maxCompare = "";
            for (JSONObject standardAndSynonyms : sortedJsonObjects) {
                if (!questionSubString.contains(standardAndSynonyms.getString("compare_field"))) continue;
                maxCompare = standardAndSynonyms.getString("compare_field");
                break;
            }
            for (JSONObject standardAndSynonyms : sortedJsonObjects) {
                if (!questionSubString.contains(standardAndSynonyms.getString("compare_field")) || !maxCompare.equals(standardAndSynonyms.getString("compare_field"))) continue;
                searchEabledStandardAndSynonyms.add(standardAndSynonyms);
            }
        }
        return searchEabledStandardAndSynonyms;
    }

    private static boolean checkHasTargetAndMetricFlag(List<JSONObject> sortedJsonObjects, String maxCompare, String questionSubString) {
        for (int i = 0; i < sortedJsonObjects.size(); ++i) {
            JSONObject current = sortedJsonObjects.get(i);
            if (!questionSubString.contains(current.getString("compare_field")) || !maxCompare.equals(current.getString("compare_field")) || i <= 0) continue;
            JSONObject previous = sortedJsonObjects.get(i - 1);
            if (current.getString("entity_type").equals(previous.getString("entity_type"))) continue;
            return true;
        }
        return false;
    }

    public static List<JSONObject> filterMaxScoreStandardWords(List<JSONObject> standardWords) {
        if (CollectionUtils.isEmpty(standardWords) || standardWords.size() <= 1) {
            return standardWords;
        }
        JSONObject object = standardWords.stream().max(Comparator.comparing(json -> json.getBigDecimal("score"))).get();
        return Arrays.asList(object);
    }

    public static List<List<JSONObject>> groupByInclusion(List<JSONObject> jsonObjects) {
        jsonObjects.sort((o1, o2) -> o2.getString("compare_field").length() - o1.getString("compare_field").length());
        ArrayList<List<JSONObject>> result = new ArrayList<List<JSONObject>>();
        HashSet<JSONObject> used = new HashSet<JSONObject>();
        for (JSONObject jsonObject : jsonObjects) {
            if (used.contains(jsonObject)) continue;
            ArrayList<JSONObject> group = new ArrayList<JSONObject>();
            group.add(jsonObject);
            used.add(jsonObject);
            for (JSONObject other : jsonObjects) {
                if (used.contains(other) || !jsonObject.getString("compare_field").contains(other.getString("compare_field"))) continue;
                group.add(other);
                used.add(other);
            }
            result.add(group);
        }
        return result;
    }

    public static List<List<JSONObject>> groupByInclusionV2(List<JSONObject> jsonObjects, String question) {
        jsonObjects.sort((o1, o2) -> o2.getString("compare_field").length() - o1.getString("compare_field").length());
        ArrayList<List<JSONObject>> result = new ArrayList<List<JSONObject>>();
        HashSet<JSONObject> used = new HashSet<JSONObject>();
        for (JSONObject jsonObject : jsonObjects) {
            if (used.contains(jsonObject)) continue;
            ArrayList<JSONObject> group = new ArrayList<JSONObject>();
            group.add(jsonObject);
            used.add(jsonObject);
            for (JSONObject other : jsonObjects) {
                if (used.contains(other) || !DataProcessAfterSearchExecutor.indexContains((String)question, (JSONObject)jsonObject, (JSONObject)other)) continue;
                group.add(other);
                used.add(other);
            }
            result.add(group);
        }
        return result;
    }

    public static List<List<JSONObject>> groupByInclusionV3(List<JSONObject> jsonObjects, String question) {
        jsonObjects = jsonObjects.stream().filter(jsonObject -> Objects.nonNull(jsonObject.get((Object)"position"))).collect(Collectors.toList());
        jsonObjects.sort((o1, o2) -> o2.getString("compare_field").length() - o1.getString("compare_field").length());
        ArrayList<List<JSONObject>> result = new ArrayList<List<JSONObject>>();
        HashSet<JSONObject> used = new HashSet<JSONObject>();
        for (JSONObject jSONObject : jsonObjects) {
            if (used.contains(jSONObject)) continue;
            ArrayList<JSONObject> group = new ArrayList<JSONObject>();
            group.add(jSONObject);
            used.add(jSONObject);
            for (JSONObject jSONObject2 : jsonObjects) {
                if (used.contains(jSONObject2) || !DataProcessAfterSearchExecutor.indexContains((String)question, (JSONObject)jSONObject, (JSONObject)jSONObject2)) continue;
                group.add(jSONObject2);
                used.add(jSONObject2);
            }
            result.add(group);
        }
        return result;
    }

    private static boolean indexContains(String question, JSONObject primary, JSONObject compare) {
        if (StringUtils.isEmpty((String)question) || StringUtils.isEmpty((String)primary.getString("compare_field")) || StringUtils.isEmpty((String)compare.getString("compare_field"))) {
            return false;
        }
        Object o1 = primary.get((Object)"position");
        Object o2 = compare.get((Object)"position");
        if (Objects.isNull(o1) || Objects.isNull(o2)) {
            return false;
        }
        int[] primaryPosition = (int[])o1;
        int[] comparePosition = (int[])o2;
        return primaryPosition[0] <= comparePosition[0] && primaryPosition[1] >= comparePosition[1];
    }

    public static List<JSONObject> removeIncludedCompareField(List<JSONObject> sortedStandardAndSynonyms) {
        if (CollectionUtils.isEmpty(sortedStandardAndSynonyms)) {
            return sortedStandardAndSynonyms;
        }
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        List lists = DataProcessAfterSearchExecutor.groupByInclusion(sortedStandardAndSynonyms);
        lists.forEach(l -> res.add((JSONObject)l.get(0)));
        return res;
    }

    public static List<int[]> findSubstringPositions(String text, String substring) {
        if (text == null || substring == null || text.isEmpty() || substring.isEmpty()) {
            return Collections.emptyList();
        }
        if (substring.length() > text.length()) {
            return Collections.emptyList();
        }
        ArrayList<int[]> positions = new ArrayList<int[]>();
        int substringLength = substring.length();
        int maxSearchIndex = text.length() - substringLength;
        for (int i = 0; i <= maxSearchIndex; ++i) {
            if (!text.regionMatches(i, substring, 0, substringLength)) continue;
            positions.add(new int[]{i, i + substringLength - 1});
        }
        return positions;
    }

    public static void main(String[] args) {
        int index = "hhha".indexOf("");
        System.out.println();
    }

    private List<JSONObject> filterSchemaStandardWords(List<JSONObject> standardWords, JSONObject context) {
        ArrayList<JSONObject> legalSchemasStandardWords = new ArrayList<JSONObject>();
        List schemas = context.getJSONObject("schemas").getJSONArray("Schemas").stream().map(inner_hit -> ((JSONObject)inner_hit).getString("title")).collect(Collectors.toList());
        for (JSONObject standardWord : standardWords) {
            if (!schemas.contains(standardWord.getString("entity_type"))) continue;
            legalSchemasStandardWords.add(standardWord);
        }
        standardWords = legalSchemasStandardWords;
        return standardWords;
    }
}

