/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.knowledge.TemplateLocalFileBroker4Knowledge;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SearchCommonKnowledgeExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchCommonKnowledgeExecutor.class);

    public Output doProcess(JSONObject context) {
        log.info("SearchCommonKnowledgeExecutor\u5f00\u59cb");
        TemplateLocalFileBroker4Knowledge bean = (TemplateLocalFileBroker4Knowledge)SpringContextUtil.getBean(TemplateLocalFileBroker4Knowledge.class);
        Output through = Output.through();
        Resource[] resources = (Resource[])PromptAssert.PROMPT_LOAD_FILE_FAILED_ASSERT.tryCatch(() -> new PathMatchingResourcePatternResolver().getResources("classpath:knowledge/**/*.*"), new Object[0]);
        try {
            for (Resource resource : resources) {
                String name = StringUtil.getContentBeforeLastDot((String)resource.getFilename());
                String type = StringUtil.getKnowledgeType((String)resource.getURI().toString());
                String content = bean.get(type, name).getContent((Map)context);
                through.keep(name, (Object)content);
            }
        }
        catch (Exception e) {
            log.error("SearchCommonKnowledgeExecutor\u5f02\u5e38");
        }
        log.info("SearchCommonKnowledgeExecutor\u7ed3\u675f");
        return through;
    }
}

