/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.mapper.mysql.onlyRead.ReportReadMapper;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.MessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDataWithGptSql
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchDataWithGptSql.class);
    public static final Integer QUERY_LIMIT = 50;
    public static final String SEMANTIC_COMPREHENSION = "semantic_comprehension";
    public static final String SQL_STRING = "sql_string";

    public Output doProcess(JSONObject context) {
        JSONObject snl2sqlExcel = context.getJSONObject("nl2sql_excel_multisheet");
        String finallyQuestion = snl2sqlExcel.getString(SEMANTIC_COMPREHENSION);
        QuestionLite question = (QuestionLite)context.getObject("question", QuestionLite.class);
        if (StringUtils.isNotEmpty((CharSequence)finallyQuestion)) {
            question.setMessage(finallyQuestion);
        }
        if (!Objects.isNull(snl2sqlExcel)) {
            if (snl2sqlExcel.containsKey((Object)"reply")) {
                return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
            }
            String querySql = snl2sqlExcel.getString(SQL_STRING);
            if (StringUtils.isNotBlank((CharSequence)querySql)) {
                ReportReadMapper reportReadMapper = (ReportReadMapper)SpringContextUtil.getBean(ReportReadMapper.class);
                try {
                    log.info("GPT\u751f\u6210sql\u6570\u636e\u5e93\u67e5\u8be2sql\uff1a{} ", (Object)querySql);
                    String finalSql = this.addLimitIfAbsent(querySql, context);
                    log.info("\u7ecf\u8fc7sql\u5de5\u5177\u5904\u7406\u540e\u7684sql\uff1a{} ", (Object)finalSql);
                    if (StringUtils.isBlank((CharSequence)finalSql)) {
                        return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
                    }
                    List dataList = reportReadMapper.selectByGpt(finalSql);
                    dataList.forEach(entry -> entry.forEach((key, value) -> {
                        if (null != value && value instanceof Date) {
                            entry.put(key, value.toString());
                        }
                    }));
                    dataList.removeAll(Collections.singleton(null));
                    if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                        List sqlDataList = this.getFieldTitle(context, dataList);
                        String sqlDataStr = CommonUtil.mapToString((List)sqlDataList);
                        return Output.through((String)"sqlQueryData", (Object)sqlDataStr).keep("sqlDataList", (Object)sqlDataList).keep("querySql", (Object)finalSql).keep("userQuestion", (Object)question.getMessage());
                    }
                }
                catch (Exception e) {
                    log.error("GPT\u751f\u6210sql\u6570\u636e\u5e93\u67e5\u8be2\u5931\u8d25\uff1a{} ", (Object)e.getMessage());
                    return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
                }
            }
        }
        return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
    }

    private String addLimitIfAbsent(String sql, JSONObject context) {
        block7: {
            try {
                Statement statement = CCJSqlParserUtil.parse((String)sql);
                if (!(statement instanceof Select)) break block7;
                Select select = (Select)statement;
                PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
                Limit limit = plainSelect.getLimit();
                if (limit == null) {
                    limit = new Limit();
                    limit.setRowCount((Expression)new LongValue((long)QUERY_LIMIT.intValue()));
                    plainSelect.setLimit(limit);
                } else {
                    try {
                        Integer num = Integer.parseInt(limit.getRowCount().toString());
                        if (num > QUERY_LIMIT) {
                            MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                            String locale = ((QuestionLite)context.getObject("question", QuestionLite.class)).getLocale();
                            String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.report.more.data.tip", locale, new Object[]{QUERY_LIMIT});
                            context.put("dataMoreSizeTip", (Object)reply);
                            limit.setRowCount((Expression)new LongValue((long)QUERY_LIMIT.intValue()));
                        }
                    }
                    catch (NumberFormatException e) {
                        limit.setRowCount((Expression)new LongValue((long)QUERY_LIMIT.intValue()));
                    }
                }
                return select.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.buildSqlLimit(sql);
            }
        }
        return null;
    }

    private String buildSqlLimit(String sql) {
        try {
            StringBuilder sb = new StringBuilder(sql);
            String textToAdd = " LIMIT " + QUERY_LIMIT;
            int lastIndex = sb.lastIndexOf(";");
            sql = lastIndex != -1 ? sql.substring(0, lastIndex) + textToAdd + sql.substring(lastIndex) : sql + textToAdd;
            return sql;
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0sql limit\u5931\u8d25\uff1a{} ", (Object)e.getMessage());
            return sql;
        }
    }

    private List<LinkedHashMap<String, Object>> getFieldTitle(JSONObject context, List<LinkedHashMap<String, Object>> data) {
        if (CollectionUtils.isNotEmpty(data)) {
            ArrayList<LinkedHashMap<String, Object>> newDataList = new ArrayList<LinkedHashMap<String, Object>>();
            for (LinkedHashMap<String, Object> datum : data) {
                LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
                for (String key : datum.keySet()) {
                    Object value = datum.get(key);
                    newData.put(this.buildDataKey(context, key), value);
                }
                newDataList.add(newData);
            }
            LinkedHashMap fieldComment = new LinkedHashMap();
            Optional.ofNullable(newDataList.get(0)).ifPresent(item -> item.keySet().forEach(key -> fieldComment.put(key, key)));
            newDataList.add(0, fieldComment);
            return newDataList;
        }
        return data;
    }

    private String buildDataKey(JSONObject context, String dataKey) {
        JSONArray fieldNameMapping = context.getJSONArray("fieldNameMapping");
        if (CollectionUtils.isNotEmpty((Collection)fieldNameMapping)) {
            HashMap<String, String> schemaMap = new HashMap<String, String>();
            for (Object o : fieldNameMapping) {
                LinkedHashMap tableSchema = (LinkedHashMap)o;
                String field = (String)tableSchema.get("field");
                String comment = (String)tableSchema.get("comment");
                schemaMap.put(field, comment != null && !comment.isEmpty() ? comment : field);
            }
            return schemaMap.getOrDefault(dataKey, dataKey);
        }
        return dataKey;
    }
}

