/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.IamService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchHistoryMessageExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchHistoryMessageExecutor.class);
    public static final Integer NEW_SESSION_MESSAGE_TYPE = 301;
    public static final String NOT_SAVE_RESULT_PROMPT = "\u6570\u636e\u5df2\u83b7\u53d6\uff0c\u7ed3\u679c\u8fc7\u957f\u672a\u50a8\u5b58";
    public static final String USER = "user";
    public static final String ASSISTANT = "assistant";
    public static final String ANSWER = "answer";
    public static final List<String> CHANGE_SKILL = Arrays.asList("1,2,3");

    public Output doProcess(JSONObject context) {
        String userToken = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        String asaCode = ((Question)context.getObject("question", Question.class)).getAsaCode();
        String appVersion = ((Question)context.getObject("question", Question.class)).getAppVersion();
        if (ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(appVersion)) {
            JSONObject lastedQuestionOrAnswer = null;
            CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
            JSONObject input = new JSONObject();
            input.put("userToken", (Object)userToken);
            input.put("routerKey", (Object)routerKey);
            input.put("asaCode", (Object)asaCode);
            try {
                String messageId = ((Question)context.getObject("question", Question.class)).getMessageId4Ania();
                String sectionId = ((Question)context.getObject("question", Question.class)).getSectionId();
                String conversationId = ((Question)context.getObject("question", Question.class)).getConversationId();
                IamService bean = (IamService)SpringContextUtil.getBean(IamService.class);
                lastedQuestionOrAnswer = bean.getLastedUserHistoryMessageV2(userToken, routerKey, conversationId, asaCode, messageId, sectionId);
            }
            catch (Exception e) {
                log.error("\u5386\u53f2\u6570\u636e\u67e5\u8be2\u5931\u8d25");
                LogCheckDto logCheckDto = new LogCheckDto();
                StringBuilder result = new StringBuilder();
                result.append("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u8bb0\u5f55\u5931\u8d25\uff0c\u53ef\u80fd\u662fANIA\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0:").append("\u3010").append(e.getMessage()).append("\u3011");
                logCheckDto.buildParams("SearchHistoryMessage", "P.SCRUMBI.901.0101", input.toJSONString(), result.toString(), "\u8bf7\u7b49\u5f853\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ANIA\u670d\u52a1");
                logCheckDtos.add(logCheckDto);
                return Output.finish().keep("noneHistory", (Object)"1").keep("logCheckDtos", logCheckDtos);
            }
            if (Objects.isNull(lastedQuestionOrAnswer)) {
                LogCheckDto logCheckDto = new LogCheckDto();
                logCheckDto.buildParams("SearchHistoryMessage", LogUtils.SUCCESS, input.toJSONString(), "\u5386\u53f2\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a", "");
                logCheckDtos.add(logCheckDto);
                return Output.finish().keep("noneHistory", (Object)"1").keep("logCheckDtos", logCheckDtos);
            }
            if (this.ifSkillChange(lastedQuestionOrAnswer).booleanValue()) {
                return Output.finish().keep("noneHistory", (Object)"1").keep("logCheckDtos", logCheckDtos);
            }
            StringBuilder stringBuilder = this.spliceMultipleParametersV2(lastedQuestionOrAnswer);
            String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
            stringBuilder.append("user:\"").append(question).append("\"").append("\n");
            log.info("gpt\u591a\u8f6e\u95ee\u53e5\u4f18\u5316\u62fc\u63a5\u7ed3\u679c\uff1a{}", (Object)stringBuilder);
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchHistoryMessage", LogUtils.SUCCESS, input.toJSONString(), stringBuilder.toString(), "");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)"multi_question", (Object)stringBuilder).keep("logCheckDtos", logCheckDtos);
        }
        List jsonObjects = null;
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        JSONObject input = new JSONObject();
        input.put("userToken", (Object)userToken);
        input.put("routerKey", (Object)routerKey);
        input.put("asaCode", (Object)asaCode);
        try {
            IamService bean = (IamService)SpringContextUtil.getBean(IamService.class);
            jsonObjects = bean.getLastedUserHistoryMessage(userToken, routerKey, null, asaCode);
        }
        catch (Exception e) {
            log.error("\u5386\u53f2\u6570\u636e\u67e5\u8be2\u5931\u8d25");
            LogCheckDto logCheckDto = new LogCheckDto();
            StringBuilder result = new StringBuilder();
            result.append("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u5bf9\u8bdd\u8bb0\u5f55\u5931\u8d25\uff0c\u53ef\u80fd\u662fANIA\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0:").append("\u3010").append(e.getMessage()).append("\u3011");
            logCheckDto.buildParams("SearchHistoryMessage", "P.SCRUMBI.901.0101", input.toJSONString(), result.toString(), "\u8bf7\u7b49\u5f853\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ANIA\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            return Output.finish().keep("noneHistory", (Object)"1").keep("logCheckDtos", logCheckDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)jsonObjects)) {
            jsonObjects = SearchHistoryMessageExecutor.checkHasNewSessionMessage((List)jsonObjects);
        }
        if (CollectionUtils.isEmpty((Collection)jsonObjects)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchHistoryMessage", LogUtils.SUCCESS, input.toJSONString(), "\u5386\u53f2\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a", "");
            logCheckDtos.add(logCheckDto);
            return Output.finish().keep("noneHistory", (Object)"1").keep("logCheckDtos", logCheckDtos);
        }
        StringBuilder stringBuilder = this.spliceMultipleParametersV1(jsonObjects);
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        stringBuilder.append("user:\"").append(question).append("\"").append("\n");
        log.info("gpt\u591a\u8f6e\u95ee\u53e5\u4f18\u5316\u62fc\u63a5\u7ed3\u679c\uff1a{}", (Object)stringBuilder);
        LogCheckDto logCheckDto = new LogCheckDto();
        logCheckDto.buildParams("SearchHistoryMessage", LogUtils.SUCCESS, input.toJSONString(), stringBuilder.toString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"multi_question", (Object)stringBuilder).keep("logCheckDtos", logCheckDtos);
    }

    private StringBuilder spliceMultipleParametersV1(List<JSONObject> jsonObjects) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            jsonObjects = Lists.reverse(jsonObjects);
            for (int i = 0; i < jsonObjects.size(); ++i) {
                JSONObject answer;
                JSONObject historyJson = (JSONObject)jsonObjects.get(i);
                int num = i + 1;
                String userQuestion = historyJson.getJSONObject("msgExt").getString("msg");
                String assistant = "";
                JSONObject answerWrapper = historyJson.getJSONObject("answerWrapper");
                if (answerWrapper != null && CollectionUtils.isNotEmpty((Collection)answerWrapper.getJSONArray("answer")) && (answer = answerWrapper.getJSONArray("answer").getJSONObject(0)) != null && "card".equals(answer.getString("message_type")) && "answer".equals(answer.getString("type"))) {
                    String message = answer.getString("message");
                    try {
                        JSONObject historyDataJson;
                        String data;
                        JSONObject messageJsonObject = JSONObject.parseObject((String)message);
                        if (Objects.nonNull(messageJsonObject) && StringUtils.isNotEmpty((CharSequence)messageJsonObject.getJSONObject("msgBody").getString("scrumbiQuestion"))) {
                            userQuestion = messageJsonObject.getJSONObject("msgBody").getString("scrumbiQuestion");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(data = (String)Optional.ofNullable(historyDataJson = messageJsonObject.getJSONObject("msgBody").getJSONObject("historyData")).map(lang -> lang.getString("data")).orElse(null)))) {
                            assistant = data;
                        }
                        if (StringUtils.isEmpty((CharSequence)assistant)) {
                            assistant = messageJsonObject.getJSONObject("msgBody").getString("prompt");
                        }
                        if (StringUtils.isEmpty((CharSequence)assistant)) {
                            assistant = "\u6570\u636e\u5df2\u83b7\u53d6\uff0c\u7ed3\u679c\u8fc7\u957f\u672a\u50a8\u5b58";
                        }
                        if (assistant.contains("\u5efa\u8bae\u60a8\u6253\u5f00\u8ffd\u95ee\u6a21\u5f0f\u8fdb\u4e00\u6b65\u660e\u786e\u5b57\u6bb5\u4fe1\u606f\u3002") || assistant.contains("\u5efa\u8b70\u60a8\u6253\u958b\u8ffd\u554f\u6a21\u5f0f\u9032\u4e00\u6b65\u660e\u78ba\u5b57\u6bb5\u4fe1\u606f\u3002")) {
                            assistant = assistant.replace("\u5efa\u8bae\u60a8\u6253\u5f00\u8ffd\u95ee\u6a21\u5f0f\u8fdb\u4e00\u6b65\u660e\u786e\u5b57\u6bb5\u4fe1\u606f\u3002", "").replace("\u5efa\u8b70\u60a8\u6253\u958b\u8ffd\u554f\u6a21\u5f0f\u9032\u4e00\u6b65\u660e\u78ba\u5b57\u6bb5\u4fe1\u606f\u3002", "");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5386\u53f2\u6570\u636e\u8f6c\u6362JSON\u5931\u8d25,message={}", (Object)message);
                    }
                }
                stringBuilder.append("user").append(num).append(":\"" + userQuestion).append("\",");
                stringBuilder.append("assistant" + num + ":\"" + assistant);
                if (i == jsonObjects.size() - 1) {
                    stringBuilder.append("\"\u3002").append("\n");
                    continue;
                }
                stringBuilder.append("\";").append("\n");
            }
        }
        catch (Exception e) {
            log.error("\u666e\u901a\u7248\u591a\u8f6e\u5386\u53f2\u6570\u636e\u62fc\u63a5\u5931\u8d25", (Throwable)e);
        }
        return stringBuilder;
    }

    private StringBuilder spliceMultipleParametersV2(JSONObject lastedQuestionOrAnswer) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String role = lastedQuestionOrAnswer.getString("role");
            String question = "";
            String prompt = "";
            JSONObject historyJson = null;
            if ("user".equals(role)) {
                question = ((JSONObject)lastedQuestionOrAnswer.getJSONArray("content").get(0)).getString("text");
            } else if ("assistant".equals(role)) {
                JSONObject msgBody = ((JSONObject)lastedQuestionOrAnswer.getJSONArray("content").get(0)).getJSONObject("content").getJSONObject("cardContext").getJSONObject("msgBody");
                question = StringUtils.isNotEmpty((CharSequence)msgBody.getString("scrumbiQuestion")) ? msgBody.getString("scrumbiQuestion") : msgBody.getString("question");
                prompt = msgBody.getString("prompt");
                historyJson = msgBody.getJSONObject("historyData");
            }
            stringBuilder.append("user").append(1).append(":\"" + question).append("\",");
            String assistant = "";
            if (Objects.nonNull(historyJson)) {
                assistant = JSONObject.toJSONString(historyJson);
            }
            if (StringUtils.isEmpty((CharSequence)assistant)) {
                assistant = prompt;
            }
            if (StringUtils.isEmpty((CharSequence)assistant)) {
                assistant = "\u6570\u636e\u5df2\u83b7\u53d6\uff0c\u7ed3\u679c\u8fc7\u957f\u672a\u50a8\u5b58";
            }
            if (assistant.contains("\u5efa\u8bae\u60a8\u6253\u5f00\u8ffd\u95ee\u6a21\u5f0f\u8fdb\u4e00\u6b65\u660e\u786e\u5b57\u6bb5\u4fe1\u606f\u3002") || assistant.contains("\u5efa\u8b70\u60a8\u6253\u958b\u8ffd\u554f\u6a21\u5f0f\u9032\u4e00\u6b65\u660e\u78ba\u5b57\u6bb5\u4fe1\u606f\u3002")) {
                assistant = assistant.replace("\u5efa\u8bae\u60a8\u6253\u5f00\u8ffd\u95ee\u6a21\u5f0f\u8fdb\u4e00\u6b65\u660e\u786e\u5b57\u6bb5\u4fe1\u606f\u3002", "").replace("\u5efa\u8b70\u60a8\u6253\u958b\u8ffd\u554f\u6a21\u5f0f\u9032\u4e00\u6b65\u660e\u78ba\u5b57\u6bb5\u4fe1\u606f\u3002", "");
            }
            stringBuilder.append("assistant1:\"" + assistant).append("\n");
        }
        catch (Exception e) {
            log.error("\u666e\u901a\u7248\u591a\u8f6e\u5386\u53f2\u6570\u636e\u62fc\u63a5\u5931\u8d25", (Throwable)e);
        }
        return stringBuilder;
    }

    private Boolean ifSkillChange(JSONObject lastedQuestionOrAnswer) {
        try {
            String role = lastedQuestionOrAnswer.getString("role");
            String agileDataSkillType = null;
            if ("user".equals(role)) {
                agileDataSkillType = lastedQuestionOrAnswer.getJSONObject("ext").getString("agileDataSkillType");
            } else if ("assistant".equals(role)) {
                agileDataSkillType = ((JSONObject)lastedQuestionOrAnswer.getJSONArray("content").get(0)).getJSONObject("content").getJSONObject("cardContext").getJSONObject("msgBody").getString("agileDataSkillType");
            }
            if (CHANGE_SKILL.contains(agileDataSkillType)) {
                log.info("\u6280\u80fd\u5207\u6362\u6210\u95ee\u6570\uff0c\u4e0d\u7ec4\u88c5\u591a\u8f6e");
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u6280\u80fd\u5207\u6362\u67e5\u8be2\u5f02\u5e38\uff0c\u4e0d\u7ec4\u88c5\u591a\u8f6e");
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String ss = "{\"msgType\":\"CUSTOM\",\"skillType\":\"1\",\"msgExt\":{\"msg\":\"\u67e5\u770b\u4eca\u5e74\u7684\u8ba2\u5355\u91d1\u989d\",\"busiInfo\":{},\"skillType\":\"1\",\"data\":{},\"sourceSerialNo\":842801366426176,\"appName\":\"ania\",\"msgId\":\"515b8aa1-3626-8929-b96b-4d3f2dda018c\",\"messageId\":842801473917504,\"language\":\"zh_CN\",\"sessionId\":\"1750727774166\",\"asaCode\":\"asada\",\"userId\":\"zhupy@digiwin.com\",\"token\":\"7040fb0e-0574-4c1f-8453-9b8677a91470\",\"probe\":true,\"client-agent\":\"webplatform\",\"hide\":1,\"isAlarm\":false,\"clientExt\":{\"sourceSerialNo\":842801366426176,\"probe\":true,\"hide\":1,\"applicationCode\":\"M3989cda3eAT\"},\"showType\":\"2\",\"time\":1750727774166,\"routerKey\":\"AthenaHZTest\",\"applicationCode\":\"M3989cda3eAT\"},\"method\":\"dataset\",\"messageId\":842801473917504,\"msgBody\":{\"snapshotId\":\"ADE_Snapshot--AthenaHZTest----20250624091635-16a75a08-e600-4573-be5c-6affee4bd84f\",\"method\":\"dataset\",\"question\":\"\u67e5\u770b\u4eca\u5e74\u7684\u8ba2\u5355\u91d1\u989d\",\"transIds\":[\"0\"],\"answerResult\":1,\"intentions\":[\"\u4eca\u5e74\u5404\u4e2a\u6708\u7684\u8ba2\u5355\u91d1\u989d\u8d8b\u52bf\u5982\u4f55\uff1f\",\"\u4eca\u5e74\u8ba2\u5355\u91d1\u989d\u6700\u9ad8\u7684\u5ba2\u6237\u662f\u54ea\u4e00\u4f4d\uff1f\",\"\u4eca\u5e74\u8ba2\u5355\u91d1\u989d\u7684\u603b\u548c\u662f\u591a\u5c11\uff1f\"],\"exceedSummarizeSize\":false,\"scrumbiQuestion\":\"\u67e5\u770b\u4eca\u5e74\u7684\u8ba2\u5355\u91d1\u989d\",\"historyData\":{\"data\":\"{data=[{\u4eca\u5e74\u8ba2\u5355\u91d1\u989d=0}]}\"},\"agileDataMessageType\":\"12\",\"generateSerialNo\":842801473917504,\"tokenSize\":89,\"getMessageInfo\":true,\"datasetList\":[{\"datasetName\":\"\u8ba2\u5355\u91d1\u989d\",\"datasetId\":\"DATA_PULLING_H9Eh7D2w\",\"lang\":{\"datasetName\":{\"zh_TW\":\"\u8a02\u55ae\u91d1\u984d\",\"zh_CN\":\"\u8ba2\u5355\u91d1\u989d\"}},\"applicationCode\":\"M3989cda3eAT\",\"applicationName\":\"\u738b\u8d851.0\u6570\u636e\u96c6\u6d4b\u8bd5\"}],\"exceedTokenThreshold\":false,\"defaultShowType\":2},\"asaCode\":\"asada\",\"userId\":\"zhupy@digiwin.com\",\"alarm\":false,\"getMessageInfo\":true}\n";
        JSONObject messageJsonObject = JSONObject.parseObject((String)ss);
        JSONObject historyDataJson = messageJsonObject.getJSONObject("msgBody").getJSONObject("historyData");
        String data = Optional.ofNullable(historyDataJson).map(lang -> lang.getString("data")).orElse(null);
    }

    public static List<JSONObject> checkHasNewSessionMessage(List<JSONObject> jsonObjects) {
        jsonObjects = Lists.reverse(jsonObjects);
        ArrayList<JSONObject> newSessionMessage = new ArrayList<JSONObject>();
        for (JSONObject jsonObject : jsonObjects) {
            if (NEW_SESSION_MESSAGE_TYPE.equals(jsonObject.getJSONObject("msgExt").getInteger("messageType"))) {
                return newSessionMessage;
            }
            if (!"CUSTOM".equals(jsonObject.getString("msgType"))) continue;
            newSessionMessage.add(jsonObject);
        }
        return newSessionMessage;
    }
}

