/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.JSONUtils;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMetricFewShotExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMetricFewShotExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        StringBuilder easySqlFewShot = null;
        StringBuilder generalSqlFewShot = null;
        StringBuilder newEasySqlFewShot = null;
        StringBuilder newGeneralSqlFewShot = null;
        StringBuilder queryClassificationFewShot = null;
        StringBuilder cotExecutionStepsFewShot = null;
        StringBuilder nestSqlFewShot = null;
        List allFewShots = null;
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        JSONObject input = new JSONObject();
        input.put("question", (Object)question);
        try {
            allFewShots = Optional.ofNullable(Retrieve.METRIC_FEW_SHOT.retrieveQuestion(question, context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> (JSONObject)hit).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            log.error("SearchMetricFewShotExecutor doProcess error", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchMetricFewShot", LogUtils.WARING, question, "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
        }
        ArrayList<JSONObject> fewShots = new ArrayList<JSONObject>();
        ArrayList<String> idList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)allFewShots)) {
            for (JSONObject hit : allFewShots) {
                JSONArray jsonArray = hit.getJSONObject("inner_hits").getJSONObject("fewshot_collection").getJSONObject("hits").getJSONArray("hits");
                if (!CollectionUtils.isNotEmpty((Collection)jsonArray)) continue;
                for (Object fewShot : jsonArray) {
                    JSONObject source = ((JSONObject)fewShot).getJSONObject("_source");
                    fewShots.add(source);
                    idList.add(((JSONObject)fewShot).getString("_id"));
                }
            }
        }
        easySqlFewShot = new StringBuilder();
        generalSqlFewShot = new StringBuilder();
        queryClassificationFewShot = new StringBuilder();
        cotExecutionStepsFewShot = new StringBuilder();
        newEasySqlFewShot = new StringBuilder();
        newGeneralSqlFewShot = new StringBuilder();
        nestSqlFewShot = new StringBuilder();
        if (CollectionUtils.isNotEmpty(fewShots)) {
            for (JSONObject fewShot : fewShots) {
                StringBuilder sqlExplain;
                JSONArray jsonArray;
                String fewShotQuestion = fewShot.getString("question");
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("easySql"))) {
                    easySqlFewShot.append("\u8f93\u5165: " + fewShotQuestion + "\n\u8f93\u51fa: " + JSONObject.parseObject((String)fewShot.getString("easySql"), (Feature[])new Feature[]{Feature.OrderedField}).toString() + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("generalSql"))) {
                    generalSqlFewShot.append("\u8f93\u5165: " + fewShotQuestion + "\n\u8f93\u51fa: " + JSONObject.parseObject((String)fewShot.getString("generalSql"), (Feature[])new Feature[]{Feature.OrderedField}).toString() + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("newEasySql"))) {
                    jsonArray = fewShot.getJSONArray("sqlExplain");
                    sqlExplain = new StringBuilder();
                    if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                        for (Object object : jsonArray) {
                            sqlExplain.append(object).append("\n");
                        }
                    }
                    newEasySqlFewShot.append("\u8f93\u5165\uff1a\n- \u7528\u6237\u95ee\u53e5\uff1a" + fewShotQuestion + "\n- \u7528\u6237\u8bed\u8a00\u522b\uff1a" + fewShot.getString("languageType") + "\n- \u6267\u884c\u8ba1\u5212\uff1a\n" + sqlExplain + "\n\u8f93\u51fa: " + JSONUtils.buildFormattedString((Object)JSONObject.parseObject((String)fewShot.getString("newEasySql"), (Feature[])new Feature[]{Feature.OrderedField})) + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("newGeneralSql"))) {
                    jsonArray = fewShot.getJSONArray("sqlExplain");
                    sqlExplain = new StringBuilder();
                    if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                        for (Object object : jsonArray) {
                            sqlExplain.append(object).append("\n");
                        }
                    }
                    newGeneralSqlFewShot.append("\u8f93\u5165\uff1a\n- \u7528\u6237\u95ee\u53e5\uff1a" + fewShotQuestion + "\n- \u7528\u6237\u8bed\u8a00\u522b\uff1a" + fewShot.getString("languageType") + "\n- \u6267\u884c\u8ba1\u5212\uff1a\n" + sqlExplain + "\n\u8f93\u51fa: " + JSONUtils.buildFormattedString((Object)JSONObject.parseObject((String)fewShot.getString("newGeneralSql"), (Feature[])new Feature[]{Feature.OrderedField})) + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("queryClassification"))) {
                    queryClassificationFewShot.append("##\u793a\u4f8b##\n-\u7528\u6237\u8bed\u53e5:\n" + fewShotQuestion + "\n-\u8f93\u51fa:\n" + JSONUtils.buildFormattedString((Object)JSONObject.parseObject((String)fewShot.getString("queryClassification"), (Feature[])new Feature[]{Feature.OrderedField})) + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("cotExecutionSteps"))) {
                    cotExecutionStepsFewShot.append("\u8f93\u5165\uff1a" + fewShotQuestion + "\n\u8f93\u51fa\uff1a\n" + JSONUtils.buildFormattedString((Object)JSONObject.parseObject((String)fewShot.getString("cotExecutionSteps"), (Feature[])new Feature[]{Feature.OrderedField})) + "\n" + System.lineSeparator());
                }
                if (!StringUtils.isNotBlank((CharSequence)fewShot.getString("nestSql"))) continue;
                jsonArray = fewShot.getJSONArray("sqlExplain");
                sqlExplain = new StringBuilder();
                if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                    for (Object object : jsonArray) {
                        sqlExplain.append(object).append("\n");
                    }
                }
                nestSqlFewShot.append("\u8f93\u5165\uff1a\n- \u7528\u6237\u95ee\u53e5\uff1a" + fewShotQuestion + "\n- \u7528\u6237\u8bed\u8a00\u522b\uff1a" + fewShot.getString("languageType") + "\n- \u6267\u884c\u8ba1\u5212\uff1a\n" + sqlExplain + "\n\u8f93\u51fa: " + JSONUtils.buildFormattedString((Object)JSONObject.parseObject((String)fewShot.getString("nestSql"), (Feature[])new Feature[]{Feature.OrderedField})) + "\n" + System.lineSeparator());
            }
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("fewShotIds", idList);
        logCheckDto.buildParams("SearchMetricFewShot", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"easySql_fewShot", (Object)easySqlFewShot).keep("generalSql_fewShot", (Object)generalSqlFewShot).keep("Query_Classification_fewShot", (Object)queryClassificationFewShot).keep("cot_fewShot", (Object)cotExecutionStepsFewShot).keep("new_easy_fewShot", (Object)newEasySqlFewShot).keep("new_general_fewShot", (Object)newGeneralSqlFewShot).keep("nest_fewShot", (Object)nestSqlFewShot).keep("logCheckDtos", logCheckDtos).keep("questionRegion", (Object)("zh_TW".equals(locale) ? "\u81fa\u7063" : "\u5927\u9646"));
    }
}

