/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.TtlCallable;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.config.ThreadPoolManager;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchStandardWordsRollBackExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SearchStandardWordsRollBackExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchStandardWordsRollBackExecutor.class);
    public static final String FILTER_APPEND_EX = "%s\u662f%s";
    public static final String FILTER_APPEND_EX_SPECIAL = "\u300c%s\u300d\u662f%s";

    public Output doProcess(JSONObject context) {
        Output output = Output.through();
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(context.getString("tenantId"));
        JSONObject param = new JSONObject();
        param.put("tenant_ids", tenantIds);
        Future task = ThreadPoolManager.getStandardWordsPool().submit(TtlCallable.get(() -> Arrays.asList(Retrieve.WORDS, Retrieve.WORDS_FOR_LONG, Retrieve.WORDS_FOR_LOOOONG).parallelStream().map(retrieve -> retrieve.retrieveQuestion(question, param)).reduce((resp1, resp) -> SearchStandardWordsRollBackExecutor.mergeJsonObjects((JSONObject)resp1, (JSONObject)resp)).get()));
        JSONObject applicationCodes = new JSONObject();
        applicationCodes.put("applicationCodes", context.get((Object)"applicationCodes"));
        applicationCodes.put("version", context.get((Object)"version"));
        Future appTask = ThreadPoolManager.getAppStandardWordsPool().submit(TtlCallable.get(() -> Arrays.asList(Retrieve.APP_WORDS, Retrieve.APP_WORDS_FOR_LONG).parallelStream().map(retrieve -> retrieve.retrieveQuestion(question, applicationCodes)).reduce((resp1, resp) -> SearchStandardWordsRollBackExecutor.mergeJsonObjects((JSONObject)resp1, (JSONObject)resp)).get()));
        JSONObject matchWResult = new JSONObject();
        try {
            matchWResult = (JSONObject)task.get();
        }
        catch (Exception e) {
            log.error("\u641c\u7d22\u79df\u6237\u540c\u4e49\u8bcd\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        JSONObject appMatchWResult = new JSONObject();
        try {
            appMatchWResult = (JSONObject)appTask.get();
        }
        catch (Exception e) {
            log.error("\u641c\u7d22app\u540c\u4e49\u8bcd\u5931\u8d25:{}", (Throwable)e);
        }
        if (!(matchWResult.containsKey((Object)"hits") && !CollectionUtils.isEmpty((Collection)matchWResult.getJSONObject("hits").getJSONArray("hits")) || appMatchWResult.containsKey((Object)"hits") && !CollectionUtils.isEmpty((Collection)appMatchWResult.getJSONObject("hits").getJSONArray("hits")))) {
            return output;
        }
        JSONArray allMatchWResult = new JSONArray();
        if (!Objects.isNull(appMatchWResult.getJSONObject("hits")) && CollectionUtils.isNotEmpty((Collection)appMatchWResult.getJSONObject("hits").getJSONArray("hits"))) {
            allMatchWResult.addAll((Collection)appMatchWResult.getJSONObject("hits").getJSONArray("hits"));
        }
        if (!Objects.isNull(matchWResult.getJSONObject("hits")) && CollectionUtils.isNotEmpty((Collection)matchWResult.getJSONObject("hits").getJSONArray("hits"))) {
            allMatchWResult.addAll((Collection)matchWResult.getJSONObject("hits").getJSONArray("hits"));
        }
        allMatchWResult.stream().map(hits -> (JSONObject)hits).collect(Collectors.groupingBy(hit -> WordType.of((String)Optional.ofNullable(hit.getJSONObject("fields")).map(e -> e.getJSONArray("entity_type").get(0).toString()).orElse("entity")))).entrySet().stream().map(entry -> {
            List<Object> objects = new ArrayList();
            for (JSONObject e : (List)entry.getValue()) {
                JSONArray jsonArray = e.getJSONObject("inner_hits").getJSONObject("entity_collection").getJSONObject("hits").getJSONArray("hits");
                String type = e.getJSONObject("fields").getJSONArray("entity_type").get(0).toString();
                if (!CollectionUtils.isNotEmpty((Collection)jsonArray)) continue;
                for (Object o : jsonArray) {
                    JSONObject source = ((JSONObject)o).getJSONObject("_source");
                    source.put("entity_type", (Object)type);
                    source.put("score", (Object)((JSONObject)o).getBigDecimal("_score"));
                    objects.add(source);
                }
            }
            Map<String, List<JSONObject>> map = objects.stream().collect(Collectors.groupingBy(j -> Objects.isNull(j.get((Object)"tenant_id")) ? "universal" : j.getString("tenant_id")));
            if (map.size() > 1) {
                objects = map.get(context.get((Object)"tenantId").toString());
            }
            return ((WordType)entry.getKey()).pickKeepData(question, objects, context);
        }).forEach(arg_0 -> ((Output)output).keep(arg_0));
        return output;
    }

    public static JSONObject mergeJsonObjects(JSONObject jsonObject1, JSONObject jsonObject2) {
        JSONObject mergedJson = new JSONObject((Map)jsonObject1);
        Set keys = jsonObject2.keySet();
        for (String key : keys) {
            Object value1 = mergedJson.get((Object)key);
            Object value2 = jsonObject2.get((Object)key);
            if (value1 instanceof JSONObject && value2 instanceof JSONObject) {
                mergedJson.put(key, (Object)SearchStandardWordsRollBackExecutor.mergeJsonObjects((JSONObject)((JSONObject)value1), (JSONObject)((JSONObject)value2)));
                continue;
            }
            if (value1 instanceof JSONArray && value2 instanceof JSONArray) {
                JSONArray array1 = (JSONArray)value1;
                JSONArray array2 = (JSONArray)value2;
                for (int i = 0; i < array2.size(); ++i) {
                    array1.add(array2.get(i));
                }
                mergedJson.put(key, (Object)array1);
                continue;
            }
            mergedJson.put(key, value2);
        }
        return mergedJson;
    }
}

