/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.ParseFactor;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.loader.RuleFactory;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.RuleType;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.model.Token;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.model.Tokenizer;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.util.DateType;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAnalyzeExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(TimeAnalyzeExecutor.class);
    private static final String prefix_1 = "- \u7528\u6237\u8bed\u53e5\u4e2d\u5b58\u5728\"";
    private static final String prefix_2 = "\"\u5219\u8d77\u59cb\u65f6\u95f4\u4e00\u5f8b\u4e3a";
    private static final String prefix_3 = ",\u7ed3\u675f\u65f6\u95f4\u4e00\u5f8b\u4e3a";
    private static final String prefix_4 = "\"\u6307\u65e5\u671f\u65f6\u95f4\u4e3a";
    private static final String prefix_5 = "- \u672a\u6765\"";
    private static final String prefix_6 = "- \u8fc7\u53bb\"";

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        if (StringUtils.isEmpty((CharSequence)(question = question.replace("\\\"", "\"")))) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("TimeAnalyze", LogUtils.ERROR, question, "\u95ee\u53e5\u4e3a\u7a7a", "\u8bf7\u8054\u7cfb\u8bed\u4e49\u5f00\u53d1\u4eba\u5458");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        List tokens = null;
        try {
            tokens = ParseFactor.parse((String)question, (List[])new List[]{RuleFactory.loadRulesFromEs((RuleType)RuleType.DATE)});
            tokens = Tokenizer.process((String)question, (List)tokens);
            if (CollectionUtils.isEmpty((Collection)tokens)) {
                LogCheckDto logCheckDto = new LogCheckDto();
                logCheckDto.buildParams("TimeAnalyze", LogUtils.SUCCESS, question, "\u672a\u89e3\u6790\u5230\u65f6\u95f4\u5143\u7d20", "");
                logCheckDtos.add(logCheckDto);
                return Output.through().keep("logCheckDtos", logCheckDtos);
            }
            tokens = tokens.stream().filter(token -> RuleType.DATE.is(token.getTokenType())).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("\u65f6\u95f4\u89c4\u5219\u89e3\u6790", LogUtils.ERROR, question, "\u7cfb\u7edf\u7ea7\u5f02\u5e38:\u65f6\u95f4\u89e3\u6790\u5931\u8d25", "\u8bf7\u8054\u7cfb\u8bed\u4e49\u5f00\u53d1\u4eba\u5458");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        if (CollectionUtils.isEmpty(tokens)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("TimeAnalyze", LogUtils.SUCCESS, question, "\u8fc7\u6ee4\u540e\u672a\u89e3\u6790\u5230\u65f6\u95f4\u5143\u7d20", "");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        StringBuilder res = new StringBuilder();
        try {
            for (Token token2 : tokens) {
                JSONObject parseContent = JSONObject.parseObject((String)token2.getParseContent().toJSONString());
                String type = parseContent.getString("type");
                JSONArray content = parseContent.getJSONArray("content");
                if (DateType.Duration.is(type)) {
                    String startTime = content.get(0).toString();
                    String endTime = content.get(1).toString();
                    res.append(prefix_1).append(token2.getToken()).append(prefix_2).append(startTime).append(prefix_3).append(endTime).append("\n").append("\n");
                    continue;
                }
                if (DateType.Point.is(type)) {
                    String time = content.get(0).toString();
                    res.append(prefix_1).append(token2.getToken()).append(prefix_4).append(time).append("\n").append("\n");
                    continue;
                }
                if (!DateType.Fuzzy.is(type)) continue;
                String previousStartTime = ((JSONArray)content.get(0)).get(0).toString();
                String previousEndTime = ((JSONArray)content.get(0)).get(1).toString();
                res.append(prefix_6).append(token2.getToken()).append(prefix_2).append(previousStartTime).append(prefix_3).append(previousEndTime).append("\n").append("\n");
                String futureStartTime = ((JSONArray)content.get(1)).get(0).toString();
                String futureEndTime = ((JSONArray)content.get(1)).get(1).toString();
                res.append(prefix_5).append(token2.getToken()).append(prefix_2).append(futureStartTime).append(prefix_3).append(futureEndTime).append("\n").append("\n");
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("\u65f6\u95f4\u89c4\u5219\u89e3\u6790", LogUtils.ERROR, question, "\u7cfb\u7edf\u7ea7\u5f02\u5e38:\u65f6\u95f4\u89e3\u6790\u5931\u8d25", "\u8bf7\u8054\u7cfb\u8bed\u4e49\u5f00\u53d1\u4eba\u5458");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("logCheckDtos", logCheckDtos);
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        logCheckDto.buildParams("\u65f6\u95f4\u89c4\u5219\u89e3\u6790", LogUtils.SUCCESS, question, res.toString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"timeAnalyzeResult", (Object)res.toString()).keep("logCheckDtos", logCheckDtos);
    }
}

