/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.convoBoard;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.convoBoard.ChartPlanReq;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.DataSetPermissionFilterExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.sse.SseSendService4ConvoBoard;
import com.digiwin.chatbi.service.MessageUtils;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SearchDataSet4ConvoBoardExecutor
implements Executor {
    public Output doProcess(JSONObject context) {
        ChartPlanReq req = (ChartPlanReq)context.getObject("chartPlanReq", ChartPlanReq.class);
        context.put("appCodesCondition", Arrays.asList(req.getAppCode()));
        SseSendService4ConvoBoard bean = (SseSendService4ConvoBoard)SpringContextUtil.getBean(SseSendService4ConvoBoard.class);
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        Retrieve retrieve = ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(req.getProductVersion()) ? Retrieve.DATASET_V2 : Retrieve.DATASET_V1;
        List dataSets = Optional.ofNullable(retrieve.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)dataSets)) {
            bean.asyncSendIntentionAnalysic(req.getId(), "### **\u610f\u56fe\u89e3\u8bfb\u5206\u6790**\n" + messageUtils.getMessage("message.scrumbi.no.metric.error"), req.getLocale(), req.isIfStream(), context, Boolean.valueOf(false));
            return Output.finish((String)"success", (Object)true);
        }
        if (ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue()) {
            Question question = new Question();
            question.setUserId(req.getUserId());
            question.setToken(req.getToken());
            question.setRouterKey(req.getRouterKey());
            context.put("question", (Object)question);
            dataSets = new DataSetPermissionFilterExecutor().filterMetricPermission(context, dataSets);
        }
        if (CollectionUtils.isEmpty((Collection)dataSets)) {
            bean.asyncSendIntentionAnalysic(req.getId(), "### **\u610f\u56fe\u89e3\u8bfb\u5206\u6790**\n" + messageUtils.getMessage("message.scrumbi.no.metric.permission"), req.getLocale(), req.isIfStream(), context, Boolean.valueOf(false));
            return Output.finish((String)"success", (Object)true);
        }
        for (JSONObject dataSet2 : dataSets) {
            dataSet2.put("metricName", (Object)dataSet2.getString("datasetName"));
            dataSet2.put("metricId", (Object)dataSet2.getString("datasetId"));
        }
        Map metricAndDataSetIdsMap = dataSets.stream().filter(dataSet -> CollectionUtils.isNotEmpty((Collection)dataSet.getJSONArray("metrics"))).flatMap(dataSet -> {
            String datasetId = dataSet.getString("datasetId");
            return dataSet.getJSONArray("metrics").stream().map(metric -> new AbstractMap.SimpleEntry<String, String>(metric.toString(), datasetId));
        }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if (MapUtils.isEmpty(metricAndDataSetIdsMap)) {
            bean.asyncSendIntentionAnalysic(req.getId(), "### **\u610f\u56fe\u89e3\u8bfb\u5206\u6790**\n" + messageUtils.getMessage("message.scrumbi.no.metric.error"), req.getLocale(), req.isIfStream(), context, Boolean.valueOf(false));
            return Output.finish((String)"success", (Object)true);
        }
        return Output.through((String)"final_dataSet", (Object)dataSets).keep("metricAndDataSetIdsMap", metricAndDataSetIdsMap).keep("metriclist", metricAndDataSetIdsMap.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList()));
    }
}

