/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataAttribution;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.dataAttribution.DataAttributionRequest;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.config.ThreadPoolManager;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAttributionConcurrencyExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(DataAttributionConcurrencyExecutor.class);

    public Output doProcess(JSONObject context) {
        JSONObject drill_down_dimension = context.getJSONObject("drill_down_dimension");
        JSONArray recommended_dimensions = drill_down_dimension.getJSONArray("recommended_dimensions");
        DataAttributionRequest dataAttributionRequest = (DataAttributionRequest)context.getObject("dataAttributionRequest", DataAttributionRequest.class);
        if (CollectionUtils.isEmpty((Collection)recommended_dimensions)) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.data.attribution.no.dimension");
        }
        List dataSets = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
        List futures = this.getCompletableFutures4DataAttrinbution(recommended_dimensions, dataAttributionRequest, dataSets);
        if (CollectionUtils.isEmpty((Collection)futures)) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.data.attribution.create.sql.error");
        }
        JSONArray groupedSolutionSteps = this.assembleParallelResults(futures);
        return Output.through((String)"success", (Object)true).keep("groupedSolutionSteps", (Object)groupedSolutionSteps);
    }

    private JSONArray assembleParallelResults(List<CompletableFuture<JSONObject>> futures) {
        JSONArray groupedSolutionSteps = new JSONArray();
        for (CompletableFuture<JSONObject> future : futures) {
            JSONObject everyContext = new JSONObject();
            try {
                everyContext = future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error("\u5f52\u56e0\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            groupedSolutionSteps.add((Object)everyContext);
        }
        return groupedSolutionSteps;
    }

    private List<CompletableFuture<JSONObject>> getCompletableFutures4DataAttrinbution(JSONArray recommended_dimensions, DataAttributionRequest dataAttributionRequest, List<JSONObject> dataSets) {
        ExecutorService customThreadPool = ThreadPoolManager.getPipelineExecutorPool();
        ArrayList<CompletableFuture<JSONObject>> futures = new ArrayList<CompletableFuture<JSONObject>>();
        for (Object obj : recommended_dimensions) {
            JSONObject recommended_dimension = (JSONObject)obj;
            CompletableFuture<JSONObject> future = CompletableFuture.supplyAsync(() -> {
                try {
                    JSONObject res;
                    if (StringUtils.isNotEmpty((CharSequence)dataAttributionRequest.getPtxId())) {
                        MdcUtil.setTraceId((String)dataAttributionRequest.getPtxId());
                    }
                    JSONObject param = new JSONObject();
                    param.put("dataAttributionRequest", (Object)dataAttributionRequest);
                    List<JSONObject> unitDataSets = Arrays.asList(dataSets.stream().filter(dataSet -> dataSet.getString("datasetId").equals(recommended_dimension.getString("datasetId"))).findFirst().get());
                    param.put("final_dataSet", unitDataSets);
                    param.put("recommended_dimension", (Object)recommended_dimension);
                    Output gptOutput = ExecutorFactory.DATA_ATTRIBUTION_SOLUTION_STEP_USER.doProcess(param);
                    gptOutput.getOutputContext().entrySet().forEach(o -> param.put((String)o.getKey(), o.getValue()));
                    JSONObject jSONObject = res = this.buildForwardAndReverseSolutionStep(recommended_dimension, param, dataAttributionRequest.getLocale());
                    return jSONObject;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error("\u5f52\u56e0\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    MdcUtil.clear();
                }
                return null;
            }, customThreadPool);
            if (!Objects.nonNull(future)) continue;
            futures.add(future);
        }
        return futures;
    }

    private JSONObject buildForwardAndReverseSolutionStep(JSONObject recommended_dimension, JSONObject param, String locale) {
        JSONObject res = new JSONObject();
        JSONArray solutionStep = param.getJSONObject("nl2sql_general_V2").getJSONArray("step");
        JSONObject lastedSolutionStep = (JSONObject)solutionStep.get(solutionStep.size() - 1);
        JSONObject computListJson = lastedSolutionStep.getJSONObject("C");
        Map.Entry valueChangeEntry = null;
        String bussinessType = null;
        for (Map.Entry computListEntrySet : computListJson.entrySet()) {
            if (((String)computListEntrySet.getKey()).contains("|Quantity")) {
                valueChangeEntry = computListEntrySet;
                bussinessType = "Quantity";
                break;
            }
            if (!((String)computListEntrySet.getKey()).contains("|amount")) continue;
            valueChangeEntry = computListEntrySet;
            bussinessType = "amount";
            break;
        }
        JSONObject orderedJson = new JSONObject(new LinkedHashMap(computListJson));
        JSONArray value_change_abs = new JSONArray();
        if (Objects.isNull(valueChangeEntry)) {
            log.error("valueChangeEntry\u4e3a\u7a7a");
        } else {
            value_change_abs.add((Object)((JSONArray)valueChangeEntry.getValue()).get(0).toString().replace("ValueChange", "Change").replace("\u6570\u503c\u53d8\u5316\u91cf", "\u53d8\u5316\u91cf"));
        }
        value_change_abs.add((Object)"Abs(Change)#ValueChangeAbs#\u53d8\u5316\u91cf\u7edd\u5bf9\u503c");
        orderedJson.put("ValueChangeAbs|" + bussinessType, (Object)value_change_abs);
        lastedSolutionStep.put("C", (Object)orderedJson);
        lastedSolutionStep.getJSONObject("S").getJSONArray("field").add((Object)"ValueChangeAbs");
        JSONObject forwardWhereJson = JSONObject.parseObject((String)"{\n        \"and\": [\n            \"ValueChange gt 0 c\"\n        ]\n    }");
        JSONObject reverseWhereJson = JSONObject.parseObject((String)"{\n        \"and\": [\n            \"ValueChange lt 0 c\"\n        ]\n    }");
        JSONArray orderArray = JSONObject.parseArray((String)(" [\n        \"" + lastedSolutionStep.getString("as") + "." + "ValueChangeAbs" + "#desc\"\n    ]"));
        JSONArray limitArray = JSONObject.parseArray((String)"[\n        0,\n        2\n    ]");
        lastedSolutionStep.put("W", (Object)forwardWhereJson);
        lastedSolutionStep.put("O", (Object)orderArray);
        lastedSolutionStep.put("L", (Object)limitArray);
        solutionStep.set(solutionStep.size() - 1, (Object)lastedSolutionStep);
        param.getJSONObject("nl2sql_general_V2").put("step", (Object)solutionStep);
        Output output = ExecutorFactory.INTENT_CONVERTOR_WRAPPER_GENERAL.doProcess(param);
        String title = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)recommended_dimension.getString("title")) : recommended_dimension.getString("title");
        res.put("dimension", (Object)title);
        res.put("dataTag", (Object)output.getOutputContext().getJSONArray("dataTag"));
        JSONArray forwardSolutionStep = output.getOutputContext().getJSONArray("solutionStep");
        JSONObject forward = new JSONObject();
        forward.put("solutionStep", (Object)forwardSolutionStep);
        res.put("forward", (Object)forward);
        lastedSolutionStep.put("W", (Object)reverseWhereJson);
        solutionStep.set(solutionStep.size() - 1, (Object)lastedSolutionStep);
        param.getJSONObject("nl2sql_general_V2").put("step", (Object)solutionStep);
        output = ExecutorFactory.INTENT_CONVERTOR_WRAPPER_GENERAL.doProcess(param);
        JSONArray reverseSolutionStep = output.getOutputContext().getJSONArray("solutionStep");
        JSONObject reverse = new JSONObject();
        reverse.put("solutionStep", (Object)reverseSolutionStep);
        res.put("reverse", (Object)reverse);
        return res;
    }
}

