/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataAttribution;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.dataAttribution.DataAttributionRequest;
import com.digiwin.chatbi.beans.pojos.dataAttribution.FluctuateRequest;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.KnowledgemapsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAppAndVersion4FluctuateExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchAppAndVersion4FluctuateExecutor.class);

    public Output doProcess(JSONObject context) {
        String tenantId;
        String tenantVersion;
        String userId;
        String routerKey;
        String userToken;
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        FluctuateRequest fluctuateRequest = (FluctuateRequest)context.getObject("fluctuateRequest", FluctuateRequest.class);
        if (Objects.nonNull(fluctuateRequest)) {
            userToken = ((FluctuateRequest)context.getObject("fluctuateRequest", FluctuateRequest.class)).getToken();
            routerKey = ((FluctuateRequest)context.getObject("fluctuateRequest", FluctuateRequest.class)).getRouterKey();
            userId = ((FluctuateRequest)context.getObject("fluctuateRequest", FluctuateRequest.class)).getUserId();
        } else {
            userToken = ((DataAttributionRequest)context.getObject("dataAttributionRequest", DataAttributionRequest.class)).getToken();
            routerKey = ((DataAttributionRequest)context.getObject("dataAttributionRequest", DataAttributionRequest.class)).getRouterKey();
            userId = ((DataAttributionRequest)context.getObject("dataAttributionRequest", DataAttributionRequest.class)).getUserId();
        }
        log.info("SearchAppAndVersionExecutor routerKey is exist: {}", (Object)routerKey);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            return Output.through((String)"version", (Object)"2.0");
        }
        JSONObject res = null;
        List<Object> tenantAppCodes = new ArrayList();
        JSONObject input = new JSONObject();
        input.put("userToken", (Object)userToken);
        input.put("routerKey", (Object)routerKey);
        input.put("userId", (Object)userId);
        try {
            KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
            res = bean.getUserAppAndVersion(userToken, routerKey, userId);
            JSONArray tenantAppInfos = res.getJSONObject("response").getJSONArray("appCodes");
            tenantAppCodes = tenantAppInfos.stream().map(Object::toString).collect(Collectors.toList());
            tenantVersion = res.getJSONObject("response").getString("tenantVersion");
            tenantId = res.getJSONObject("profile").getString("tenantId");
            userId = res.getJSONObject("profile").getString("userId");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25:{}", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            StringBuilder result = new StringBuilder();
            result.append("\u67e5\u8be2\u7528\u6237\u8ba2\u8d2d\u7684\u5e94\u7528\u548c\u79df\u6237\u7248\u672c\u5931\u8d25\uff0c\u53ef\u80fd\u662fKM\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0:").append("\u3010").append(e.getMessage()).append("\u3011");
            logCheckDto.buildParams("SearchAppAndVersion", "P.SCRUMBI.901.0105", input.toJSONString(), result.toString(), "\u8bf7\u7b49\u5f853\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5KM\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            return Output.finish().keep("reply", (Object)"\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25").keep("logCheckDtos", logCheckDtos);
        }
        return Output.through((String)"version", (Object)tenantVersion).keep("applicationCodes", tenantAppCodes).keep("tenantId", (Object)tenantId).keep("userId", (Object)userId);
    }
}

