/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.DmlServiceInvoker;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.MatchDatasetPipeline;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.ApolloService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetFinderExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(DataSetFinderExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        Question question = (Question)context.getObject("question", Question.class);
        String routerKey = question.getRouterKey();
        String token = question.getToken();
        String locale = question.getLocale();
        List dataSets_with_permission = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
        StringBuilder result = new StringBuilder();
        JSONObject input = new JSONObject();
        input.put("dataSets_with_permission", (Object)dataSets_with_permission);
        if (CollectionUtils.isNotEmpty((Collection)question.getDatasetIdList())) {
            for (JSONObject dataSet2 : dataSets_with_permission) {
                dataSet2.put("metricName", (Object)"datasetName");
            }
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject successResult = new JSONObject();
            successResult.put("dataSetIds", dataSets_with_permission.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList()));
            logCheckDto.buildParams("DataSetFinder", LogUtils.SUCCESS, input.toJSONString(), successResult.toJSONString(), "");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)"final_dataSet", (Object)dataSets_with_permission).keep("logCheckDtos", logCheckDtos);
        }
        JSONArray appDataSets = new JSONArray();
        ApolloService apolloService = (ApolloService)SpringContextUtil.getBean(ApolloService.class);
        String value = apolloService.getMatchtableSwitch();
        if ("true".equals(value)) {
            try {
                JSONObject param = new JSONObject();
                ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
                param.put("question", (Object)((Question)context.getObject("question", Question.class)).getMessage());
                param.put("applicationCode", applicationCodes);
                param.put("version", (Object)context.getString("version"));
                if (context.containsKey((Object)"dataSets_all_permission") && !context.getBoolean("dataSets_all_permission").booleanValue()) {
                    param.put("datasetIds", dataSets_with_permission.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList()));
                } else {
                    param.put("datasetIds", new ArrayList());
                }
                DmlServiceInvoker bean = (DmlServiceInvoker)SpringContextUtil.getBean(DmlServiceInvoker.class);
                appDataSets = bean.datasetSearchResult(param, token, locale, routerKey);
            }
            catch (Exception e) {
                appDataSets = new JSONArray();
                log.error("AI\u4e2d\u53f0\u627e\u8868\u5931\u8d25:{}", (Throwable)e);
                result.append("AI\u4e2d\u53f0\u627e\u8868\u5931\u8d25\uff0c\u53ef\u80fd\u662fDML\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0:").append("\u3010").append(e.getMessage()).append("\u3011");
            }
        } else {
            appDataSets = MatchDatasetPipeline.process((JSONObject)context);
        }
        if (CollectionUtils.isEmpty((Collection)appDataSets)) {
            String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
            if (StringUtils.isEmpty((String)originFinallyQuestion)) {
                originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getMessage();
            }
            context.put("origin_finally_question", (Object)originFinallyQuestion);
            String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
            Retrieve retrieve = ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion) ? Retrieve.DATASET_ALIKE_V1 : Retrieve.DATASET_ALIKE_V2;
            List dataSets = Optional.ofNullable(retrieve.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("DataSetFinder", "P.SCRUMBI.901.0131", input.toJSONString(), result.toString(), "\u8bf7\u7b49\u5f853\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5DML\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            return Output.through().keep("success", (Object)false).keep("need_sentences_4_without_dataset", (Object)true).keep("sentences_param_4_without_dataset", (Object)StringUtil.buildSentencesParamNoneMetric((List)dataSets, (String)locale)).keep("reply", (Object)"message.scrumbi.no.metric.4.sentence").keep("logCheckDtos", logCheckDtos);
        }
        if (appDataSets.size() > 1) {
            ArrayList<JSONObject> applications = new ArrayList<JSONObject>();
            for (Object appDataSet : appDataSets) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCode", (Object)((JSONObject)appDataSet).getString("applicationCode"));
                jsonObject.put("applicationName", (Object)((JSONObject)appDataSet).getString("applicationName"));
                applications.add(jsonObject);
            }
            return Output.finish((String)"reply", (Object)"message.scrumbi.more.app").keep(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey(), (Object)MetricSearchResultEnum.MORE_APP_MORE_METRIC.getValue()).keep("more_app_list", applications);
        }
        JSONArray allDatasetIds = new JSONArray();
        for (Object appDataSet : appDataSets) {
            allDatasetIds.addAll((Collection)((JSONObject)appDataSet).getJSONArray("datasetIds"));
        }
        List dataSets = dataSets_with_permission.stream().filter(dataSet -> allDatasetIds.contains((Object)dataSet.getString("datasetId"))).collect(Collectors.toList());
        for (JSONObject dataSet3 : dataSets) {
            dataSet3.put("metricName", (Object)"datasetName");
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject successResult = new JSONObject();
        successResult.put("dataSetIds", dataSets.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList()));
        logCheckDto.buildParams("DataSetFinder", LogUtils.SUCCESS, input.toJSONString(), successResult.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"final_dataSet", dataSets).keep("final_search_dimension_entities", (Object)true).keep("logCheckDtos", logCheckDtos);
    }
}

