/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.EffectivescopeEnum;
import com.digiwin.chatbi.common.enums.FilterKnowLedgeTypeEnum;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAllUsefulKnowledgeExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(FilterAllUsefulKnowledgeExecutor.class);

    public Output doProcess(JSONObject context) {
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            return Output.through();
        }
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        String filterKnowledgeType = context.getString("filter_knowledge_type");
        List<Object> dataSetIds = new ArrayList();
        if (FilterKnowLedgeTypeEnum.MATCH_TABLE_FIRST.getCode().equals(filterKnowledgeType)) {
            List dataSets_with_permission = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
            dataSetIds = dataSets_with_permission.stream().map(final_dataset -> final_dataset.getString("datasetId")).collect(Collectors.toList());
        } else if (FilterKnowLedgeTypeEnum.MATCH_TABLE_SECOND.getCode().equals(filterKnowledgeType)) {
            List finalDatasets = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
            dataSetIds = finalDatasets.stream().map(final_dataset -> final_dataset.getString("datasetId")).collect(Collectors.toList());
        }
        List habitualknowledges = (List)context.getOrDefault((Object)"allHabitualknowledges", new ArrayList());
        ArrayList finalDataSetIds = dataSetIds;
        habitualknowledges = habitualknowledges.stream().filter(habitualknowledge -> {
            if (EffectivescopeEnum.ALL.getCode().equals(habitualknowledge.getString("effectiveScope"))) {
                return true;
            }
            if (EffectivescopeEnum.PART.getCode().equals(habitualknowledge.getString("effectiveScope"))) {
                List habitualknowledgeDataSetIds = (List)habitualknowledge.getObject("datasetIds", List.class);
                for (String dataSetId : habitualknowledgeDataSetIds) {
                    if (!finalDataSetIds.contains(dataSetId)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        List nounknowledges = (List)context.getOrDefault((Object)"allNounknowledges", new ArrayList());
        nounknowledges = nounknowledges.stream().filter(nounknowledge -> {
            if (EffectivescopeEnum.ALL.getCode().equals(nounknowledge.getString("effectiveScope"))) {
                return true;
            }
            if (EffectivescopeEnum.PART.getCode().equals(nounknowledge.getString("effectiveScope"))) {
                List nounknowledgeDataSetIds = (List)nounknowledge.getObject("datasetIds", List.class);
                for (String dataSetId : nounknowledgeDataSetIds) {
                    if (!finalDataSetIds.contains(dataSetId)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        nounknowledges = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3(nounknowledges, (String)question);
        JSONArray nounknowledgesParam = new JSONArray();
        String nounKnowledgesStr = "";
        for (Object nounknowledge2 : nounknowledges) {
            JSONObject nounknowledgeParam = new JSONObject();
            nounknowledgeParam.put("\u4e1a\u52a1\u5b9a\u4e49", nounknowledge2.get((Object)"standard_name"));
            nounknowledgeParam.put("\u6570\u636e\u89e3\u91ca", nounknowledge2.get((Object)"explanation"));
            nounknowledgeParam.put("\u540c\u4e49\u8bcd", nounknowledge2.get((Object)"compare_field"));
            nounknowledgesParam.add((Object)nounknowledgeParam);
            if (!Objects.nonNull(nounknowledge2.get((Object)"synonyms"))) continue;
            nounKnowledgesStr = nounKnowledgesStr + nounknowledge2.get((Object)"standard_name").toString() + "\u7684\u540c\u4e49\u8bcd\u662f" + nounknowledge2.get((Object)"compare_field") + ",";
        }
        if (nounKnowledgesStr.endsWith(",")) {
            nounKnowledgesStr = nounKnowledgesStr.substring(0, nounKnowledgesStr.length() - 1);
        }
        JSONArray habitualknowledgesParam = new JSONArray();
        for (JSONObject habitualknowledge2 : habitualknowledges) {
            JSONObject habitualknowledgeParam = new JSONObject();
            habitualknowledgeParam.put("\u4e60\u60ef\u77e5\u8bc6", habitualknowledge2.get((Object)"knowledge"));
            habitualknowledgesParam.add((Object)habitualknowledgeParam);
        }
        Output through = Output.through();
        if (StringUtils.isNotEmpty((CharSequence)nounKnowledgesStr)) {
            through.keep("nounknowledgesAppend", (Object)nounKnowledgesStr);
        }
        through.keep("nounknowledges", (Object)StringUtil.convertArrayToMarkdown((JSONArray)nounknowledgesParam));
        through.keep("habitualknowledges", (Object)StringUtil.convertArrayToMarkdown((JSONArray)habitualknowledgesParam));
        return through;
    }
}

