/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogicFormExtractExecutor
implements Executor {
    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        return Output.through().keep("logicForm", (Object)LogicFormExtractExecutor.searchLogic((JSONObject)context));
    }

    public static JSONObject searchLogic(JSONObject context) {
        ArrayList<String> allNames = new ArrayList<String>();
        for (Object o : context.getJSONArray("entity_names")) {
            allNames.add(o.toString());
        }
        for (Object o : context.getJSONArray("metric_names")) {
            allNames.add(o.toString());
        }
        JSONObject logicForm = context.getJSONObject("QueryLogicForm");
        JSONArray originalMetrics = logicForm.getJSONArray("metric");
        JSONArray validMetrics = new JSONArray();
        ArrayList<String> hallucinationMetrics = new ArrayList<String>();
        if (originalMetrics != null) {
            for (Iterator obj : originalMetrics) {
                String metric = obj.toString();
                if (allNames.contains(metric)) {
                    validMetrics.add((Object)metric);
                    continue;
                }
                hallucinationMetrics.add(metric);
            }
        }
        JSONArray similarMetrics = new JSONArray();
        for (String hallucination : hallucinationMetrics) {
            JSONObject matchObj;
            List matchMetrics = LogicFormExtractExecutor.findSubstrings((String)hallucination, allNames);
            if (!matchMetrics.isEmpty()) {
                matchObj = new JSONObject();
                matchObj.put("metric", (Object)hallucination);
                matchObj.put("match_with", (Object)matchMetrics);
                matchObj.put("type", (Object)"contain");
                similarMetrics.add((Object)matchObj);
                continue;
            }
            matchMetrics = LogicFormExtractExecutor.findSubstringsByEditDistance((String)hallucination, allNames);
            if (matchMetrics.isEmpty()) continue;
            matchObj = new JSONObject();
            matchObj.put("metric", (Object)hallucination);
            matchObj.put("match_with", (Object)matchMetrics);
            matchObj.put("type", (Object)"edit_distance");
            similarMetrics.add((Object)matchObj);
        }
        if (!similarMetrics.isEmpty()) {
            logicForm.put("similar_metrics", (Object)similarMetrics);
        }
        logicForm.put("metric", (Object)validMetrics);
        if (logicForm.containsKey((Object)"entity")) {
            JSONArray entityArr = logicForm.getJSONArray("entity");
            JSONArray cleanedEntities = new JSONArray();
            for (int i = 0; i < entityArr.size(); ++i) {
                JSONObject entityItem = entityArr.getJSONObject(i);
                if (!entityItem.containsKey((Object)"field")) continue;
                JSONArray fieldArr = entityItem.getJSONArray("field");
                JSONArray validFields = new JSONArray();
                for (int j = 0; j < fieldArr.size(); ++j) {
                    JSONObject field = fieldArr.getJSONObject(j);
                    if (!allNames.contains(field.getString("name"))) continue;
                    validFields.add((Object)field);
                }
                if (validFields.isEmpty()) continue;
                entityItem.put("field", (Object)validFields);
                cleanedEntities.add((Object)entityItem);
            }
            logicForm.put("entity", (Object)cleanedEntities);
        }
        return logicForm;
    }

    public static List<String> findSubstrings(String input, List<String> strList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strList) {
            if (!s.contains(input) && !input.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static List<String> findSubstringsByEditDistance(String input, List<String> strList) {
        ArrayList<String> result = new ArrayList<String>();
        int threshold = (int)Math.ceil((double)input.length() / 2.0);
        for (String s : strList) {
            if (!LogicFormExtractExecutor.isEditDistanceLessThan((String)input, (String)s, (int)threshold)) continue;
            result.add(s);
        }
        return result;
    }

    public static boolean isEditDistanceLessThan(String str1, String str2, int num) {
        int i;
        int m = str1.length();
        int n = str2.length();
        int[][] dp = new int[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= n; ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                dp[i][j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? dp[i - 1][j - 1] : Math.min(dp[i - 1][j - 1], Math.min(dp[i - 1][j], dp[i][j - 1])) + 1;
            }
        }
        return dp[m][n] < num;
    }
}

