/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.DataTypeCode;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchMetricTargetMixExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.TranslateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMatchestDataSetExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMatchestDataSetExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        String questionMsg = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
        if (StringUtils.isEmpty((CharSequence)originFinallyQuestion)) {
            originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getMessage();
        }
        JSONObject cnAndTw = this.translateMetric(questionMsg);
        String simplified_use_question = cnAndTw.getString("zh_CN");
        String traditional_use_question = cnAndTw.getString("zh_TW");
        List allAccurateStandardWords = this.getDataSetFieldSchemasAccurateStandardWords(context);
        context.put("mix_standard_synonyms_before_filter", (Object)allAccurateStandardWords);
        List standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3((List)allAccurateStandardWords, (String)originFinallyQuestion);
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3((List)allAccurateStandardWords, (String)simplified_use_question);
        }
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3((List)allAccurateStandardWords, (String)traditional_use_question);
        }
        log.info("standardWords:{}", (Object)standardWords);
        HashSet seen = new HashSet();
        List distinctMetricStandardWords = standardWords.stream().filter(json -> {
            String standardName = json.getString("standard_name");
            String compareField = json.getString("compare_field");
            return seen.add(standardName + compareField);
        }).collect(Collectors.toList());
        return Output.through((String)"mix_standard_synonyms_after_filter", (Object)standardWords).keep("distinctMetricStandardWords", distinctMetricStandardWords);
    }

    private List<JSONObject> getDataSetFieldSchemasAccurateStandardWords(JSONObject context) {
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        List final_dataset = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
        log.info("final_dataset:{}", (Object)final_dataset);
        if (CollectionUtils.isNotEmpty((Collection)final_dataset)) {
            for (JSONObject dataSet : final_dataset) {
                JSONArray schemas = dataSet.getJSONArray("fieldSchema");
                for (Object schemaObj : schemas) {
                    JSONObject schema = (JSONObject)schemaObj;
                    if (StringUtils.isEmpty((CharSequence)schema.getString("dataType")) || !DataTypeCode.NUMERIC.getCode().equalsIgnoreCase(schema.getString("dataType"))) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("applicationCodes", Arrays.asList(dataSet.getString("applicationCode")));
                    jsonObject.put("version", (Object)dataSet.getString("version"));
                    jsonObject.put("standard_name", (Object)schema.getString("title"));
                    jsonObject.put("match_words", Arrays.asList(schema.getString("title")));
                    jsonObject.put("entity_type", (Object)"dataset");
                    jsonObject.put("dataSources", (Object)"dataset");
                    accurateStandardWords.add(jsonObject);
                }
            }
        }
        log.info("accurateStandardWords:{}", accurateStandardWords);
        List standardSynonymsWords = SearchMetricTargetMixExecutor.getStandardSynonymsWords((JSONObject)context, (String)"dataset");
        if (CollectionUtils.isNotEmpty((Collection)standardSynonymsWords)) {
            accurateStandardWords.addAll(standardSynonymsWords);
        }
        return accurateStandardWords;
    }

    private JSONObject translateMetric(String key) {
        TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
        JSONObject cnAndTw = bean.cnAndTw(key);
        return cnAndTw;
    }
}

