/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.output.KMFilterOutputExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import groovy.lang.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class KMFilterDataTypeExecutor
implements KMFilterOutputExecutor {
    private static final String LEFT_VALUE_TYPE = "left_value_type";
    private static final String RIGHT_VALUE_TYPE = "right_value_type";
    private static final String LEFT_DATE_FORMAT = "left_date_format";
    private static final String RIGHT_DATE_FORMAT = "right_date_format";
    private static final Tuple2<String, String> LEFT_VALUE_TYPE_DATE_FORMAT = new Tuple2((Object)"left_value_type", (Object)"left_date_format");
    private static final Tuple2<String, String> RIGHT_VALUE_TYPE_DATE_FORMAT = new Tuple2((Object)"right_value_type", (Object)"right_date_format");
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final Map<String, String> DATA_TYPE_MAP = new /* Unavailable Anonymous Inner Class!! */;

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    public Output doProcess(JSONObject context) {
        Map<String, JSONObject> schemaMap = context.getJSONObject("schemas").getJSONArray("Schemas").stream().collect(Collectors.toMap(schema -> ((JSONObject)schema).getString("name"), schema -> (JSONObject)schema, (oldValue, newValue) -> oldValue));
        String name = "Filter";
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            name = name + "_V1";
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            name = name + "_V2";
        }
        JSONObject kmFilter = context.getJSONObject(name);
        JSONObject condition = kmFilter.getJSONObject("condition");
        kmFilter.put("condition", (Object)this.setDataType(condition, schemaMap));
        kmFilter.put("condition", (Object)this.modEqToRank(kmFilter.getJSONObject("condition")));
        return Output.through((String)name, (Object)kmFilter);
    }

    private JSONObject modEqToRank(JSONObject condition) {
        if (condition.containsKey((Object)"items")) {
            JSONArray items = condition.getJSONArray("items");
            ArrayList<String> itemStrs = new ArrayList<String>();
            for (Object obj : items) {
                JSONObject item = (JSONObject)obj;
                if (!"eq".equals(item.getString("op")) || !"datetime".equals(item.getString(LEFT_VALUE_TYPE))) continue;
                item.put("op", (Object)"gte");
                String itemStr2 = item.toJSONString();
                itemStrs.add(itemStr2);
            }
            if (CollectionUtils.isNotEmpty(itemStrs)) {
                itemStrs.forEach(itemStr -> {
                    JSONObject itemLte = JSONObject.parseObject((String)itemStr);
                    itemLte.put("op", (Object)"lte");
                    items.add((Object)itemLte);
                });
            }
            condition.put("items", (Object)items);
        }
        return condition;
    }

    private JSONObject setDataType(JSONObject condition, Map<String, JSONObject> schemaMap) {
        if (condition.containsKey((Object)"left") && schemaMap.containsKey(condition.getString("left"))) {
            String schemaType = schemaMap.get(condition.getString("left")).getString("dataType");
            schemaType = schemaType.substring(0, 1).toLowerCase() + schemaType.substring(1);
            condition.put(LEFT_VALUE_TYPE, (Object)DATA_TYPE_MAP.getOrDefault(schemaType, schemaType));
        }
        this.setDateFormat(condition, new Tuple2[]{LEFT_VALUE_TYPE_DATE_FORMAT, RIGHT_VALUE_TYPE_DATE_FORMAT});
        if (condition.containsKey((Object)"items")) {
            condition.put("items", condition.getJSONArray("items").stream().map(item -> (JSONObject)item).map(item -> this.setDataType(item, schemaMap)).collect(Collectors.toList()));
        }
        return condition;
    }

    @SafeVarargs
    private final void setDateFormat(JSONObject condition, Tuple2<String, String> ... keys) {
        Arrays.stream(keys).forEach(key -> {
            if (this.isDateType(condition, (String)key.getV1())) {
                condition.put((String)key.getV2(), (Object)DATE_FORMAT);
            }
        });
    }

    private boolean isDateType(JSONObject condition, String key) {
        if (!condition.containsKey((Object)key)) {
            return false;
        }
        String type = condition.getString(key);
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        return "date".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type);
    }

    static {
        DATA_TYPE_MAP.put("date", "datetime");
        DATA_TYPE_MAP.put("numeric", "number");
    }
}

