/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.vos.ChatResultDemoVo;
import com.digiwin.chatbi.common.enums.ChatResultCode;
import com.digiwin.chatbi.common.enums.IntentType;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Function;

public class OutputDataLiteExecutor
implements Executor {
    public static final String OUTPUT_KEY = "finalResult";
    private final EnumMap<IntentType, Function<JSONObject, Output>> intentMap = new EnumMap(IntentType.class);

    public OutputDataLiteExecutor() {
        this.intentMap.put(IntentType.GRAPH, context -> this.finishWithResultVo(context, arg_0 -> this.ofKmModel(arg_0), ChatResultCode.KNOWLEDGE_GRAPH));
        this.intentMap.put(IntentType.PANEL, context -> this.finishWithResultVo(context, arg_0 -> this.ofKmModel(arg_0), ChatResultCode.KNOWLEDGE_GRAPH));
        this.intentMap.put(IntentType.MODEL_CENTER, context -> this.finishWithResultVo(context, arg_0 -> this.ofModelCenter(arg_0), ChatResultCode.MODEL_CENTER));
        this.intentMap.put(IntentType.OTHER, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultDemoVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResultCode)ChatResultCode.OTHER_QUESTION)));
        this.intentMap.put(IntentType.NOT_AVAILABLE, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"reply"), ChatResultCode.OTHER_QUESTION));
        this.intentMap.put(IntentType.UN_SPECIFIED, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"reply"), ChatResultCode.OTHER_QUESTION));
        this.intentMap.put(IntentType.DATA_SOURCE_NOT_MATCH, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"reply"), ChatResultCode.DATA_SOURCE_NOT_MATCH));
        this.intentMap.put(IntentType.FILTER_IN_NOT_SUPPORT, context -> this.finishWithResultVo(context, msg -> IntentType.FILTER_IN_NOT_SUPPORT.getDesc(), ChatResultCode.OTHER_QUESTION));
        this.intentMap.put(IntentType.ERROR, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"error"), ChatResultCode.SYSTEM_ERROR));
    }

    public Output doProcess(JSONObject context) {
        IntentType intentType = IntentType.OTHER;
        if (!Objects.isNull(context.getBoolean("success")) && context.getBoolean("success").booleanValue()) {
            intentType = IntentType.GRAPH;
        }
        Function<JSONObject, Output> action = this.intentMap.getOrDefault(intentType, data -> this.finishWithResultVo(data, msg -> msg, ChatResultCode.UNKNOWN));
        return action.apply(context);
    }

    private JSONObject ofKmModel(JSONObject context) {
        return context.getJSONObject("demo_0830");
    }

    private JSONObject ofModelCenter(JSONObject context) {
        return null;
    }

    private Output finishWithResultVo(JSONObject context, Function<JSONObject, ?> replyGetter, ChatResultCode resultCode) {
        return Output.finish((String)OUTPUT_KEY, (Object)ChatResultDemoVo.createResult((JSONObject)context, replyGetter, (ChatResultCode)resultCode));
    }
}

