/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.vos.ChatResultLiteV2Vo;
import com.digiwin.chatbi.common.enums.ChatResult4LiteCode;
import com.digiwin.chatbi.common.enums.LiteIntentType;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.EnumMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputDataLiteV2Executor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(OutputDataLiteV2Executor.class);
    public static final String OUTPUT_KEY = "finalResult";
    private final EnumMap<LiteIntentType, Function<JSONObject, Output>> intentMap = new EnumMap(LiteIntentType.class);

    public OutputDataLiteV2Executor() {
        this.intentMap.put(LiteIntentType.GRAPH, context -> this.finishWithResultVo(context, arg_0 -> this.ofKmModel(arg_0), ChatResult4LiteCode.GRAPH));
        this.intentMap.put(LiteIntentType.REPLY, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultLiteV2Vo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4LiteCode)ChatResult4LiteCode.REPLY)));
        this.intentMap.put(LiteIntentType.SHEET_CHECK, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultLiteV2Vo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4LiteCode)ChatResult4LiteCode.SHEET_CHECK)));
    }

    public Output doProcess(JSONObject context) {
        Boolean success = (Boolean)context.getOrDefault((Object)"success", (Object)false);
        LiteIntentType intentType = LiteIntentType.REPLY;
        if ("Y".equals(context.getString("more_sheet_check"))) {
            log.info("\u591a\u9875\u7b7e\u9009\u62e9\uff1a{}", (Object)context);
            intentType = LiteIntentType.SHEET_CHECK;
        } else if (Boolean.TRUE.equals(success)) {
            intentType = LiteIntentType.GRAPH;
        }
        Function<JSONObject, Output> action = this.intentMap.getOrDefault(intentType, data -> this.finishWithResultVo(data, msg -> msg, ChatResult4LiteCode.UNKNOWN));
        return action.apply(context);
    }

    private JSONObject ofKmModel(JSONObject context) {
        return context.getJSONObject("presentation_summary");
    }

    private JSONObject ofModelCenter(JSONObject context) {
        return null;
    }

    private Output finishWithResultVo(JSONObject context, Function<JSONObject, ?> replyGetter, ChatResult4LiteCode resultCode) {
        return Output.finish((String)OUTPUT_KEY, (Object)ChatResultLiteV2Vo.createResult((JSONObject)context, replyGetter, (ChatResult4LiteCode)resultCode));
    }
}

