/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.autoData.IntentionConfirmReq;
import com.digiwin.chatbi.beans.vos.ChatResultIntentionConfirmVo;
import com.digiwin.chatbi.common.enums.ChatResult4MetricCode;
import com.digiwin.chatbi.common.enums.MetricIntentType;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.EnumMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputIntentionConfirmExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(OutputIntentionConfirmExecutor.class);
    public static final String OUTPUT_KEY = "finalResult";
    private final EnumMap<MetricIntentType, Function<JSONObject, Output>> intentMap = new EnumMap(MetricIntentType.class);

    public OutputIntentionConfirmExecutor() {
        this.intentMap.put(MetricIntentType.GRAPH, context -> this.finishWithResultVo(context, arg_0 -> this.ofIntentionConfirm(arg_0), ChatResult4MetricCode.GRAPH));
        this.intentMap.put(MetricIntentType.REPLY, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultIntentionConfirmVo.createErrorResult((JSONObject)context, arg_0 -> this.ofIntentionConfirm(arg_0), (ChatResult4MetricCode)ChatResult4MetricCode.REPLY)));
    }

    public Output doProcess(JSONObject context) {
        Boolean success = (Boolean)context.getOrDefault((Object)"success", (Object)false);
        MetricIntentType intentType = MetricIntentType.REPLY;
        if (Boolean.TRUE.equals(success)) {
            intentType = MetricIntentType.GRAPH;
        }
        Function<JSONObject, Output> action = this.intentMap.getOrDefault(intentType, data -> this.finishWithResultVo(data, jsonObject -> jsonObject, ChatResult4MetricCode.UNKNOWN));
        return action.apply(context);
    }

    private JSONObject ofIntentionConfirm(JSONObject context) {
        IntentionConfirmReq intentionConfirmReq = (IntentionConfirmReq)context.getObject("intentionConfirmReq", IntentionConfirmReq.class);
        String intent_analysis_prompt_name = intentionConfirmReq.isEnableDataSearch() ? "Intent_analysis" : "Intent_analysis_disable_search";
        JSONObject intent_analysis = context.getJSONObject(intent_analysis_prompt_name);
        return intent_analysis;
    }

    private Output finishWithResultVo(JSONObject context, Function<JSONObject, JSONObject> replyGetter, ChatResult4MetricCode resultCode) {
        return Output.finish((String)OUTPUT_KEY, (Object)ChatResultIntentionConfirmVo.createResult((JSONObject)context, replyGetter, (ChatResult4MetricCode)resultCode));
    }
}

