/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.prompt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.dtos.chart.ExtractDimensionRes;
import com.digiwin.chatbi.beans.dtos.chart.FieldInfo;
import com.digiwin.chatbi.beans.dtos.chart.ModelInfo;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.IntentType;
import com.digiwin.chatbi.common.enums.MockGptQuestion;
import com.digiwin.chatbi.common.enums.RhErrorEnum;
import com.digiwin.chatbi.common.exception.GptCallAssert;
import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.config.TimeCheckMatch;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.search.config.CustomModel;
import com.digiwin.chatbi.reasoning.search.config.GroundModelConfig;
import com.digiwin.chatbi.reasoning.search.config.ModelConfig;
import com.digiwin.chatbi.reasoning.search.config.RhEndpointConfig;
import com.digiwin.chatbi.service.MessageUtils;
import com.digiwin.chatbi.service.TranslateService;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public abstract class PromptExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(PromptExecutor.class);
    public static final String RESULT_NOT_JSON = "NOT_JSON_";
    private static final Map<String, GPT_CLIENT> GPT_CLIENT_MAP = new HashMap();
    private static final Map<String, List<String>> model_mapping_map;
    private static List<String> needAppendNounknowledgesList;
    private static List<String> needAppendQList;
    private static List<String> needAppendSpecailFilterQ;
    private static List<String> needAppendSqlParam;
    private static List<String> stopProcessIfErrorExecutorList;
    private static List<String> scenePromptList;
    private static List<String> metricPromptList;
    private static List<String> dataSetPromptList;
    private static final String DEFAULT_GPT_CLIENT = "RH_HK_GPT4";
    private GPT_CLIENT gptClient = (GPT_CLIENT)GPT_CLIENT_MAP.getOrDefault("RH_HK_GPT4", GPT_CLIENT.RH.HK.GPT4);

    public String getType() {
        return this.getType();
    }

    public String getName() {
        return this.getName();
    }

    public GPT_CLIENT getGptClient() {
        return this.getGptClient();
    }

    protected String getPromptName() {
        return this.getType() + this.getName();
    }

    public static PromptExecutor OfExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static PromptExecutor OfConditionExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String systemMessage(JSONObject context) {
        String type = this.getType();
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        String enableCustomModel = modelConfig.getEnableCustomModel();
        if ("local".equals(groundModelConfig.getGroundDeployment()) && !"true".equals(enableCustomModel)) {
            type = "prompts_ground";
        }
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get(type, this.getName()).getContent((Map)context);
    }

    public String callGpt(String systemMessage, String userMessage, String appendQuest, Integer maxToken, String temperature, String token) {
        StopWatch stopWatch = StopWatch.createStarted();
        RhEndpointConfig rhEndpointConfig = (RhEndpointConfig)SpringContextUtil.getBean(RhEndpointConfig.class);
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        GPT_CLIENT gptClient = this.getGptClient();
        String endpoint = rhEndpointConfig.getHkEndpoint();
        String apiKey = null;
        String model = null;
        String enableCustomModel = modelConfig.getEnableCustomModel();
        if ("true".equals(enableCustomModel)) {
            gptClient = GPT_CLIENT.STANDARD_OPENAI.AZURE.GPT4;
            CustomModel customModel = this.getModeByStep(this.getName());
            endpoint = customModel.getServiceUrl();
            apiKey = customModel.getApiKey();
            model = customModel.getModel();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endpoint) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)apiKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model)) {
                log.error("\u81ea\u5b9a\u4e49\u5927\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
                return null;
            }
        } else if ("local".equals(groundModelConfig.getGroundDeployment())) {
            gptClient = GPT_CLIENT.DIGI.AI_PROXY.QWEN_QWQ_32B;
            endpoint = groundModelConfig.getServiceUrl();
            apiKey = groundModelConfig.getApiKey();
            model = groundModelConfig.getModel();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endpoint) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)apiKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model)) {
                log.error("\u79c1\u6709\u5316\u5927\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
                return null;
            }
        }
        String result = gptClient.call(systemMessage, Objects.isNull(appendQuest) ? userMessage : userMessage.concat(appendQuest), endpoint, maxToken, temperature, token, apiKey, model, Boolean.valueOf(false), (chunk, context) -> {}, null);
        stopWatch.stop();
        log.info("GPT calling time: {}ms, prompt: {}", (Object)stopWatch.getTime(), (Object)this.getPromptName());
        String finalResult = result;
        String data = (String)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            if ("true".equals(enableCustomModel) || "local".equals(groundModelConfig.getGroundDeployment())) {
                return CommonUtil.extractDataBetweenBraces((String)finalResult);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)finalResult);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonObject.getString("code")) && "0".equals(jsonObject.getString("code"))) {
                String dataBetweenBraces = CommonUtil.extractDataBetweenBraces((String)jsonObject.getString("data"));
                return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataBetweenBraces) ? jsonObject.getString("data") : dataBetweenBraces;
            }
            return null;
        }, new Object[0]);
        String res = null;
        if ("true".equals(enableCustomModel) || "local".equals(groundModelConfig.getGroundDeployment())) {
            res = finalResult;
        } else {
            JSONObject jsonObject = JSONObject.parseObject((String)finalResult);
            jsonObject.put("originalResult", (Object)true);
            res = JSONObject.toJSONString((Object)jsonObject);
        }
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data) ? data : res;
    }

    public String callGpt(String systemMessage, String userMessage, String appendQuest, Integer maxToken, String temperature, String token, Boolean ifStream, GPT_CLIENT.StreamCallback streamCallback, JSONObject context) {
        StopWatch stopWatch = StopWatch.createStarted();
        RhEndpointConfig rhEndpointConfig = (RhEndpointConfig)SpringContextUtil.getBean(RhEndpointConfig.class);
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        GPT_CLIENT gptClient = this.getGptClient();
        String endpoint = rhEndpointConfig.getHkEndpoint();
        String apiKey = null;
        String model = null;
        String enableCustomModel = modelConfig.getEnableCustomModel();
        if ("true".equals(enableCustomModel)) {
            gptClient = GPT_CLIENT.STANDARD_OPENAI.AZURE.GPT4;
            CustomModel customModel = this.getModeByStep(this.getName());
            endpoint = customModel.getServiceUrl();
            apiKey = customModel.getApiKey();
            model = customModel.getModel();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endpoint) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)apiKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model)) {
                log.error("\u81ea\u5b9a\u4e49\u5927\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
                return null;
            }
        } else if ("local".equals(groundModelConfig.getGroundDeployment())) {
            gptClient = GPT_CLIENT.DIGI.AI_PROXY.QWEN_QWQ_32B;
            endpoint = groundModelConfig.getServiceUrl();
            apiKey = groundModelConfig.getApiKey();
            model = groundModelConfig.getModel();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endpoint) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)apiKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model)) {
                log.error("\u79c1\u6709\u5316\u5927\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
                return null;
            }
        }
        String result = gptClient.call(systemMessage, Objects.isNull(appendQuest) ? userMessage : userMessage.concat(appendQuest), endpoint, maxToken, temperature, token, apiKey, model, ifStream, streamCallback, context);
        stopWatch.stop();
        log.info("GPT calling time: {}ms, prompt: {}", (Object)stopWatch.getTime(), (Object)this.getPromptName());
        String finalResult = result;
        String data = (String)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            if ("true".equals(enableCustomModel) || "local".equals(groundModelConfig.getGroundDeployment())) {
                return CommonUtil.extractDataBetweenBraces((String)finalResult);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)finalResult);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonObject.getString("code")) && "0".equals(jsonObject.getString("code"))) {
                String dataBetweenBraces = CommonUtil.extractDataBetweenBraces((String)jsonObject.getString("data"));
                return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataBetweenBraces) ? jsonObject.getString("data") : dataBetweenBraces;
            }
            return null;
        }, new Object[0]);
        String res = null;
        if ("true".equals(enableCustomModel) || "local".equals(groundModelConfig.getGroundDeployment())) {
            res = finalResult;
        } else {
            JSONObject jsonObject = JSONObject.parseObject((String)finalResult);
            jsonObject.put("originalResult", (Object)true);
            res = JSONObject.toJSONString((Object)jsonObject);
        }
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data) ? data : res;
    }

    public String callGpt(List<JSONObject> messages, Integer maxToken, String temperature, String token) {
        return this.callGpt(messages, maxToken, temperature, token, Boolean.valueOf(false), (a, b) -> {}, null);
    }

    public String callGpt(List<JSONObject> messages, Integer maxToken, String temperature, String token, Boolean stream, GPT_CLIENT.StreamCallback streamCallback, JSONObject context) {
        StopWatch stopWatch = StopWatch.createStarted();
        RhEndpointConfig rhEndpointConfig = (RhEndpointConfig)SpringContextUtil.getBean(RhEndpointConfig.class);
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        GPT_CLIENT gptClient = this.getGptClient();
        String endpoint = rhEndpointConfig.getHkEndpoint();
        String apiKey = null;
        String model = null;
        String enableCustomModel = modelConfig.getEnableCustomModel();
        if ("true".equals(enableCustomModel)) {
            gptClient = GPT_CLIENT.STANDARD_OPENAI.AZURE.GPT4;
            CustomModel customModel = this.getModeByStep(this.getName());
            endpoint = customModel.getServiceUrl();
            apiKey = customModel.getApiKey();
            model = customModel.getModel();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endpoint) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)apiKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model)) {
                log.error("\u81ea\u5b9a\u4e49\u5927\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
                return null;
            }
        } else if ("local".equals(groundModelConfig.getGroundDeployment())) {
            gptClient = GPT_CLIENT.DIGI.AI_PROXY.QWEN_QWQ_32B;
            endpoint = groundModelConfig.getServiceUrl();
            apiKey = groundModelConfig.getApiKey();
            model = groundModelConfig.getModel();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endpoint) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)apiKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model)) {
                log.error("\u79c1\u6709\u5316\u5927\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
                return null;
            }
        }
        String result = gptClient.call(messages, endpoint, maxToken, temperature, token, apiKey, model, stream, streamCallback, context);
        stopWatch.stop();
        log.info("GPT calling time: {}ms, prompt: {}", (Object)stopWatch.getTime(), (Object)this.getPromptName());
        String finalResult = result;
        String data = (String)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            if ("true".equals(enableCustomModel) || "local".equals(groundModelConfig.getGroundDeployment())) {
                return CommonUtil.extractDataBetweenBraces((String)finalResult);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)finalResult);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonObject.getString("code")) && "0".equals(jsonObject.getString("code"))) {
                String dataBetweenBraces = CommonUtil.extractDataBetweenBraces((String)jsonObject.getString("data"));
                return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataBetweenBraces) ? jsonObject.getString("data") : dataBetweenBraces;
            }
            return null;
        }, new Object[0]);
        String res = null;
        if ("true".equals(enableCustomModel) || "local".equals(groundModelConfig.getGroundDeployment())) {
            res = finalResult;
        } else {
            JSONObject jsonObject = JSONObject.parseObject((String)finalResult);
            jsonObject.put("originalResult", (Object)true);
            res = JSONObject.toJSONString((Object)jsonObject);
        }
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data) ? data : res;
    }

    public CustomModel getModeByStep(String name) {
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        String modelKey = "default-model-name";
        block0: for (Map.Entry modeMap : model_mapping_map.entrySet()) {
            List steps = (List)modeMap.getValue();
            for (String step : steps) {
                if (!name.startsWith(step)) continue;
                modelKey = (String)modeMap.getKey();
                continue block0;
            }
        }
        String modelName = "";
        if ("default-model-name".equals(modelKey)) {
            modelName = modelConfig.getModelMapping().getDefaultModelName();
        } else if ("semantic-analysis".equals(modelKey)) {
            modelName = modelConfig.getModelMapping().getSemanticAnalysis();
        } else if ("dataset-search".equals(modelKey)) {
            modelName = modelConfig.getModelMapping().getDatasetSearch();
        } else if ("recommended-summary".equals(modelKey)) {
            modelName = modelConfig.getModelMapping().getRecommendedSummary();
        }
        CustomModel customModel = (CustomModel)modelConfig.getCustomModelConfig().get(modelName);
        return customModel;
    }

    protected Output setContext(String gptResult, JSONObject context) {
        JSONObject inputJson;
        CopyOnWriteArrayList logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        String input = "";
        String step = "prompts" + this.getName();
        String resultTitle = "";
        if ("Multi_dialogue".equals(this.getName())) {
            input = context.getString("multi_question");
            resultTitle = "LLM\u89e3\u6790\u591a\u8f6e\u95ee\u53e5\u7ec4\u88c5";
        } else if ("Metric_with_app".equals(this.getName())) {
            input = JSONObject.toJSONString((Object)context.getOrDefault((Object)"no_metric_gpt_param", new Object()));
            resultTitle = "LLM\u89e3\u6790\u6307\u6807\u515c\u5e95";
        } else if ("nl2ele_easy".startsWith(this.getName()) || "nl2sql_general".startsWith(this.getName()) || "nl2sql_nest".startsWith(this.getName())) {
            input = context.getString("metricData");
            resultTitle = "\u6839\u636e\u5f53\u524d\u8bed\u53e5\u4ea7\u751f\u6267\u884c\u8ba1\u5212";
        } else if ("Query_Classification".startsWith(this.getName())) {
            resultTitle = "\u5bf9\u5f53\u524d\u8bed\u53e5\u610f\u56fe\u8bc6\u522b";
            input = context.getString("metricData");
        } else if ("SortAndLimit".equals(this.getName())) {
            resultTitle = "LLM\u89e3\u6790\u6392\u5e8f\u5206\u9875";
            input = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        } else if ("Filter".equals(this.getName())) {
            inputJson = new JSONObject();
            List schemaList = (List)((JSONObject)context.getOrDefault((Object)"schemas", (Object)new JSONObject())).getOrDefault((Object)"Schemas", new ArrayList());
            inputJson.put("schemas", (Object)schemaList);
            inputJson.put("question", (Object)((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", ""));
            input = inputJson.toJSONString();
            resultTitle = "LLM\u89e3\u6790\u8fc7\u6ee4\u6761\u4ef6";
        } else if ("Dimension".equals(this.getName())) {
            inputJson = new JSONObject();
            List dimensions = (List)context.getOrDefault((Object)"dimensions", new ArrayList());
            inputJson.put("dimensions", (Object)dimensions);
            inputJson.put("question", (Object)((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", ""));
            input = inputJson.toJSONString();
            resultTitle = "LLM\u89e3\u6790\u7ef4\u5ea6";
        } else if ("AnalysisPlanning".equals(this.getName())) {
            resultTitle = "LLM\u89e3\u6790\u6a21\u677f";
            input = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        }
        String finalInput = input;
        String finalStep = step;
        LogCheckDto logCheckDto = new LogCheckDto();
        boolean changeErrorCodeFlag = Constants.SCENE_CALL_GPT_NAME_LIST.contains(this.getName()) && context.containsKey((Object)"scelect_scene_metric_mix");
        String finalResultTitle = resultTitle;
        return (Output)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            JSONArray jsonArray;
            String error;
            String locale;
            MessageUtils messageUtils;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)gptResult)) {
                context.put("RHErrorLog", (Object)(this.getName() + "RH\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a"));
                logCheckDto.buildParams(finalStep, changeErrorCodeFlag ? LogUtils.WARING : RhErrorEnum.getErrorCode((String)this.getName(), (String)"2"), finalInput, finalResultTitle + "\u65e0\u7ed3\u679c\uff0c\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a", "\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            } else if (gptResult.startsWith("error:gpt\u8c03\u7528\u5931\u8d25")) {
                logCheckDto.buildParams(finalStep, changeErrorCodeFlag ? LogUtils.WARING : RhErrorEnum.getErrorCode((String)this.getName(), (String)"3"), finalInput, finalResultTitle + "\u8d85\u65f6\uff0c\u53ef\u80fd\u662fRH\u670d\u52a1\u4e0d\u53ef\u7528\u6216LLM\u6267\u884c\u65f6\u95f4\u8d85\u8fc7\u4e86\u7cfb\u7edf\u9884\u8bbe\u7684\u7b49\u5f85\u65f6\u95f4\uff0c\u4f8b\u5982\u9ed8\u8ba4\u76841\u5206\u949f", "\u8bf7\u7b49\u5f851\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5RH\u670d\u52a1");
                context.put("RHErrorLog", (Object)(this.getName() + "RH\u5f02\u5e38\u6216\u8d85\u65f6"));
            } else {
                String reply;
                JSONObject jsonObject = JSONObject.parseObject((String)gptResult);
                if (jsonObject.containsKey((Object)"originalResult")) {
                    String msg = jsonObject.getString("msg");
                    messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    locale = ((Question)context.getObject("question", Question.class)).getLocale();
                    error = messageUtils.getMessageByLangName("message.scrumbi.rh.or.es.sys.error", locale);
                    String reply2 = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)msg) ? msg : error;
                    context.put("RHErrorLog", (Object)(this.getName() + "RH\u5f02\u5e38 \u5f02\u5e38\u539f\u56e0\uff1a" + reply2));
                    if (stopProcessIfErrorExecutorList.contains(this.getName())) {
                        logCheckDto.setCode("U.SCRUMBI.901.0128");
                        logCheckDto.setResult("\u5927\u6a21\u578b\u8bbf\u95ee\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0:" + reply2);
                        logCheckDto.setSuggestion("1.\u8bf7\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\n2.\u91cd\u8bd5\u65e0\u679c\u540e\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                        logCheckDtos.add(logCheckDto);
                        return Output.finish((String)"error", (Object)error).keep("success", (Object)false).keep("reply", (Object)"message.scrumbi.rh.or.es.sys.error").keep("logCheckDtos", (Object)logCheckDtos);
                    }
                }
                logCheckDto.buildParams(finalStep, LogUtils.SUCCESS, finalInput, gptResult, "");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonObject.getString("code")) && !"0".equals(jsonObject.getString("code")) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(reply = jsonObject.getString("reply"))) && !reply.startsWith("\u5bf9\u4e0d\u8d77\uff0c\u6211")) {
                    context.put("RHErrorLog", (Object)("RH\u5f02\u5e38 \u5f02\u5e38\u539f\u56e0\uff1a" + reply));
                }
            }
            if ("AnalysisPlanning".equals(this.getName()) && "0".equals(JSONObject.parseObject((String)gptResult).getString("intent_code"))) {
                Output keep = Output.through((String)PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.OTHER.getCode()).keep("error", (Object)"\u672a\u89e3\u6790\u5230\u6a21\u677f").keep("success", (Object)false);
                List templateNames = context.getJSONArray("templates").stream().map(t -> ((JSONObject)t).getString("templateName")).collect(Collectors.toList());
                messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                locale = ((Question)context.getObject("question", Question.class)).getLocale();
                String targetName = this.getTargetName(context);
                String param = StringUtil.formatListToBrackets(templateNames, (String)locale);
                String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.template.error", locale, new Object[]{targetName, param});
                keep.keep("tempLateReply", (Object)reply);
                return keep;
            }
            if ("Metric_with_app".equals(this.getName())) {
                String appIndex = JSONObject.parseObject((String)gptResult).getString("selected_application_index");
                JSONArray jsonArray2 = JSONObject.parseObject((String)gptResult).getJSONArray("matched_metrics");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appIndex) || CollectionUtils.isEmpty((Collection)jsonArray2)) {
                    logCheckDto.setCode("U.SCRUMBI.901.0111");
                    logCheckDto.setResult("LLM\u672a\u5339\u914d\u5230\u5408\u9002\u7684\u6307\u6807\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\n1.\u53e5\u5b50\u4e2d\u63d0\u5230\u7684\u6307\u6807\u672a\u914d\u7f6e\uff0c\n2.\u914d\u7f6e\u4e86\u6307\u6807\u4f46\u63cf\u8ff0\u4e0d\u660e\u786e\uff0c\n3.\u914d\u7f6e\u4e86\u6307\u6807\u4f46\u672a\u53d1\u7248\uff08\u5207\u7248\uff09\n4.\u540c\u4e49\u8bcd\u914d\u9519");
                    logCheckDto.setSuggestion("1.\u6253\u5f00\u6307\u6807\u548c\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u9875\u9762\u3002\n2.\u786e\u8ba4\u6240\u9700\u6307\u6807\u662f\u5426\u5df2\u914d\u7f6e\uff0c\u6307\u6807\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u3002\n3.\u68c0\u67e5\u6307\u6807\u7684\u540c\u4e49\u8bcd\u662f\u5426\u5df2\u8bbe\u7f6e\uff0c\u786e\u4fdd\u5176\u51c6\u786e\u6027\u3002\n4.\u6267\u884c\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                    logCheckDtos.add(logCheckDto);
                    messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    locale = ((Question)context.getObject("question", Question.class)).getLocale();
                    error = messageUtils.getMessageByLangName("message.scrumbi.no.metric", locale);
                    String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
                    if (StringUtils.isEmpty((String)originFinallyQuestion)) {
                        originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getMessage();
                    }
                    context.put("origin_finally_question", (Object)originFinallyQuestion);
                    List metricList = Optional.ofNullable(Retrieve.METRIC_ALIKE.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                    return Output.through((String)"error", (Object)error).keep("success", (Object)false).keep("need_sentences_4_without_metric", (Object)true).keep("sentences_param_4_without_metric", (Object)StringUtil.buildSentencesParamNoneMetric((List)metricList, (String)locale)).keep("reply", (Object)"message.scrumbi.no.metric.4.sentence").keep("logCheckDtos", (Object)logCheckDtos);
                }
            }
            if ("Metric_without_app".equals(this.getName()) && CollectionUtils.isEmpty((Collection)(jsonArray = JSONObject.parseObject((String)gptResult).getJSONArray("selected_metrics")))) {
                MessageUtils messageUtils2 = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                String locale2 = ((Question)context.getObject("question", Question.class)).getLocale();
                String error2 = messageUtils2.getMessageByLangName("message.scrumbi.no.metric", locale2);
                return Output.finish((String)"error", (Object)error2).keep("success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.4.sentence");
            }
            logCheckDtos.add(logCheckDto);
            return Output.through((String)this.getName(), (Object)JSONObject.parseObject((String)gptResult, (Feature[])new Feature[]{Feature.OrderedField})).keep("success", (Object)true).keep("logCheckDtos", (Object)logCheckDtos);
        }, e -> {
            log.error("gpt\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)e.toString());
            StringBuilder result = new StringBuilder();
            result = result.append(finalResultTitle).append("\u51fa\u9519\uff0c\u8f93\u51fa\u7ed3\u679c\u4e0d\u662f\u5408\u6cd5\u7684JSON\u5b57\u7b26\u4e32,\u53ef\u80fd\u662fLLM\u8f93\u51fa\u7ed3\u679c\u8d85\u957f\u5bfc\u81f4\u88ab\u622a\u65ad,\u5931\u8d25\u539f\u56e0:").append("\u3010").append("\u3011");
            logCheckDto.buildParams(finalStep, changeErrorCodeFlag ? LogUtils.WARING : RhErrorEnum.getErrorCode((String)this.getName(), (String)"1"), finalInput, result.toString(), "\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u8f93\u51fa\u65e5\u5fd7");
            if (gptResult.startsWith("error:")) {
                if ("AnalysisPlanning".equals(this.getName())) {
                    Output keep = Output.through((String)PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.OTHER.getCode()).keep("error", (Object)e.getMessage()).keep("success", (Object)false);
                    List templateNames = ((List)context.getJSONObject("templates")).stream().map(t -> t.getString("templateName")).collect(Collectors.toList());
                    logCheckDtos.add(logCheckDto);
                    MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                    String param = StringUtil.formatListToBrackets(templateNames, (String)locale);
                    String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.template.error", locale, new Object[]{this.getTargetName(context), param});
                    keep.keep("tempLateReply", (Object)reply).keep("logCheckDtos", (Object)logCheckDtos);
                    return keep;
                }
                if ("Metric_with_app".equals(this.getName()) || "Metric_without_app".equals(this.getName())) {
                    logCheckDtos.add(logCheckDto);
                    return Output.finish((String)"error", (Object)"message.scrumbi.rh.error").keep("success", (Object)false).keep("reply", (Object)"message.scrumbi.rh.or.es.sys.error").keep("logCheckDtos", (Object)logCheckDtos);
                }
                if ("Autocomplete_Rec".equals(this.getName())) {
                    logCheckDtos.add(logCheckDto);
                    return Output.through();
                }
                logCheckDtos.add(logCheckDto);
                return Output.finish((String)PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.ERROR.getCode()).keep("error", (Object)e.getMessage()).keep("success", (Object)false).keep("logCheckDtos", (Object)logCheckDtos).keep("reply", (Object)"message.scrumbi.rh.or.es.sys.error");
            }
            Output keep = Output.through((String)("NOT_JSON_" + this.getPromptName()), (Object)gptResult);
            if ("AnalysisPlanning".equals(this.getName())) {
                List templateNames = ((List)context.getJSONObject("templates")).stream().map(t -> t.getString("templateName")).collect(Collectors.toList());
                MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                String param = StringUtil.formatListToBrackets(templateNames, (String)locale);
                String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.template.error", locale, new Object[]{this.getTargetName(context), param});
                keep.keep("tempLateReply", (Object)reply);
            }
            if ("Metric_with_app".equals(this.getName()) || "Metric_without_app".equals(this.getName())) {
                logCheckDtos.add(logCheckDto);
                MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                String error = messageUtils.getMessageByLangName("message.scrumbi.no.metric", locale);
                return Output.finish((String)"error", (Object)error).keep("success", (Object)false).keep("reply", (Object)"message.scrumbi.rh.or.es.sys.error").keep("logCheckDtos", (Object)logCheckDtos);
            }
            logCheckDtos.add(logCheckDto);
            return keep.keep("logCheckDtos", (Object)logCheckDtos);
        });
    }

    public String getTargetName(JSONObject context) {
        String targetName = Optional.ofNullable(context.getObject("targets", List.class)).map(targets -> {
            for (Object t : targets) {
                JSONObject jsonObject = (JSONObject)t;
                if (!StringUtils.isNotEmpty((String)context.getString("datasourceId")) || !context.getString("datasourceId").equals(jsonObject.getString("datasourceId"))) continue;
                return jsonObject.getString("datasourceName");
            }
            return context.getString("datasourceId");
        }).orElse("");
        return targetName;
    }

    public Output doProcess(JSONObject context) {
        Question question = (Question)context.getObject(PipelineFactory.PipelineKey.QUESTION.getKey(), Question.class);
        String finalAppendQ = PromptExecutor.getAppendQ((JSONObject)context, (String)this.getName());
        String finalCheckTimeMatch = PromptExecutor.getCheckTimeMatch((String)question.getSimpleMessage(), (String)this.getName());
        String finalQuestionMsg = PromptExecutor.getQuestionMsg((JSONObject)context, (String)this.getName());
        if (MockGptQuestion.allQuestion().contains(finalQuestionMsg)) {
            try {
                List mock = Optional.ofNullable(Retrieve.MOCK.retrieveSentence(new String[]{"mock"})).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source").getString("mock")).collect(Collectors.toList())).orElse(null);
                if (CollectionUtils.isNotEmpty((Collection)mock) && mock.contains("1")) {
                    String responseBody = MockGptQuestion.getResultByQuestionAndType((String)finalQuestionMsg, (String)this.getName());
                    return this.setContext(CommonUtil.extractDataBetweenBraces((String)JSONObject.parseObject((String)responseBody).getString("data")), context);
                }
            }
            catch (Exception e2) {
                log.error("mock\u5931\u8d25");
            }
        }
        if (needAppendSqlParam.contains(this.getName())) {
            context.put("metricData", (Object)PromptExecutor.getMetricData((JSONObject)context));
            context.put("metricDataMd", (Object)PromptExecutor.getMetricDataMd((JSONObject)context));
            context.put("questionRegion", (Object)this.getQuestionRegion(context));
        }
        String gptResult = (String)PromptAssert.PROMPT_CALL_FAIL_ASSERT.tryCatch(() -> this.callGpt(this.systemMessage(context), org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)finalCheckTimeMatch) ? finalCheckTimeMatch : finalQuestionMsg, finalAppendQ, Integer.valueOf(4096), context.getString("temperature"), question.getToken()), e -> "error:" + e.getMessage());
        Output output = this.setContext(gptResult, context);
        return output;
    }

    public static String getCheckTimeMatch(String msg, String name) {
        String checkTimeMatch = null;
        if ("SortAndLimit".equals(name)) {
            TimeCheckMatch timeCheckMatch = (TimeCheckMatch)SpringContextUtil.getBean((String)"timeCheckMatch", TimeCheckMatch.class);
            List strings = Optional.ofNullable(timeCheckMatch.getTimeCheckList()).orElse(new ArrayList());
            checkTimeMatch = msg;
            for (int i = 0; i < strings.size(); ++i) {
                checkTimeMatch = checkTimeMatch.replaceAll((String)strings.get(i), "");
            }
        }
        return checkTimeMatch;
    }

    public static String getAppendQ(JSONObject context, String name) {
        String appendKey = name.startsWith("SemanticFuzzyResolver") ? "appendFilterWords4SchemasCheck" : "appendFilterQ";
        String appendSpecailKey = name.startsWith("SemanticFuzzyResolver") ? "appendSpecailFilterWords4SchemasCheck" : "appendSpecailFilterQ";
        Set appendFilterQ = needAppendSpecailFilterQ.contains(name) ? (Set)Optional.ofNullable(context.getObject(appendSpecailKey, Set.class)).orElse(new HashSet()) : (Set)Optional.ofNullable(context.getObject(appendKey, Set.class)).orElse(new HashSet());
        Set appendAnalysisQ = Optional.ofNullable(context.getObject("appedAnalysisWords", Set.class)).orElse(new HashSet());
        if ("AnalysisPlanning".equals(name) && CollectionUtils.isNotEmpty((Collection)appendAnalysisQ)) {
            appendAnalysisQ.addAll(appendFilterQ);
            appendAnalysisQ.forEach(str -> appendFilterQ.add(ZhConverterUtil.toSimple((String)str)));
        }
        String appendQ = null;
        if (CollectionUtils.isNotEmpty((Collection)appendFilterQ) && needAppendQList.contains(name)) {
            appendQ = "(" + org.apache.commons.lang3.StringUtils.join((Iterable)appendFilterQ, (String)",") + ")";
        }
        if ("Dimension".equals(name)) {
            appendQ = ZhConverterUtil.toSimple(appendQ);
            String synonymToStandardName4Dimension = PromptExecutor.buildDimensionSynonym((JSONObject)context);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)synonymToStandardName4Dimension)) {
                appendQ = (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appendQ) ? "" : appendQ) + "(" + synonymToStandardName4Dimension + ")";
            }
        }
        if (PromptExecutor.prefixContains((List)needAppendNounknowledgesList, (String)name).booleanValue() && context.containsKey((Object)"nounknowledgesAppend")) {
            String string = appendQ = Objects.isNull(appendQ) ? "(" + context.getString("nounknowledgesAppend") + ")" : appendQ + "(" + context.getString("nounknowledgesAppend") + ")";
        }
        if (needAppendSqlParam.contains(name)) {
            String synonymToStandardName4Dimension;
            String synonymToStandardName = PromptExecutor.buildSqlParamsV2((JSONObject)context);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)synonymToStandardName)) {
                appendQ = (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appendQ) ? "" : appendQ) + "(" + synonymToStandardName + ")";
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(synonymToStandardName4Dimension = PromptExecutor.buildDimensionSynonym((JSONObject)context)))) {
                appendQ = (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appendQ) ? "" : appendQ) + "(" + synonymToStandardName4Dimension + ")";
            }
            if (name.startsWith("nl2ele_easy") || name.startsWith("nl2sql_general") || name.startsWith("nl2sql_nest")) {
                if (context.containsKey((Object)"cot_sql")) {
                    appendQ = Objects.isNull(appendQ) ? context.getString("cot_sql") : appendQ + context.getString("cot_sql");
                } else {
                    JSONArray sqlExplain = context.getJSONArray("sqlExplain");
                    String languageType = context.getString("languageType");
                    StringBuilder cotAppendQ = new StringBuilder();
                    cotAppendQ.append("\n").append("- \u7528\u6237\u8bed\u8a00\u522b\uff1a").append(languageType).append("\n").append("- \u6267\u884c\u8ba1\u5212\uff1a");
                    for (Object s : sqlExplain) {
                        cotAppendQ.append("\n").append(s);
                    }
                    appendQ = Objects.isNull(appendQ) ? cotAppendQ.toString() : appendQ + cotAppendQ.toString();
                }
            }
        }
        return appendQ;
    }

    public static String getQuestionMsg(JSONObject context, String name) {
        Question question = (Question)context.getObject(PipelineFactory.PipelineKey.QUESTION.getKey(), Question.class);
        String questionMsg = question.getMessage().replaceAll("\\\\", "");
        if ("AnalysisPlanning".equals(name)) {
            HashMap targetsAndSynonyms = (HashMap)context.getObject("targetsAndSynonyms", HashMap.class);
            if (!Objects.isNull(targetsAndSynonyms)) {
                List targets = (List)context.getOrDefault((Object)"targets", new ArrayList());
                JSONObject jsonObject = null;
                if (CollectionUtils.isNotEmpty((Collection)targets)) {
                    jsonObject = (JSONObject)targetsAndSynonyms.get(((JSONObject)targets.get(0)).getString("datasourceName"));
                }
                if (!Objects.isNull(jsonObject) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonObject.getString("synonyms"))) {
                    List synonyms = (List)jsonObject.getObject("synonyms", List.class);
                    String synonym = synonyms.stream().filter(questionMsg::contains).reduce((x, y) -> x.length() > y.length() ? x : y).orElse("");
                    questionMsg = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)synonym) ? questionMsg.replace(synonym, jsonObject.getString("standard_name")) : questionMsg;
                }
            }
            questionMsg = ZhConverterUtil.toSimple((String)questionMsg);
        }
        if ("Multi_dialogue".equals(name)) {
            questionMsg = context.getString("multi_question");
        }
        if ("Dimension".equals(name)) {
            questionMsg = ZhConverterUtil.toSimple((String)questionMsg);
        }
        return questionMsg;
    }

    public static Boolean prefixContains(List<String> needAppendNounknowledgesList, String name) {
        for (String s : needAppendNounknowledgesList) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static String buildSqlParams(JSONObject context) {
        String synonymToStandardNameStr;
        StringBuilder synonymToStandardName = new StringBuilder("\u6307\u6807\u4fe1\u606f\uff1a");
        String questionMsg = ((Question)context.getObject(PipelineFactory.PipelineKey.QUESTION.getKey(), Question.class)).getMessage().replaceAll("\\\\", "");
        List metrics = context.containsKey((Object)"scelect_dataSet") ? (List)context.getOrDefault((Object)"final_dataSet", new ArrayList()) : (List)context.getOrDefault((Object)"final_metric", new ArrayList());
        HashMap metricsAndSynonyms = (HashMap)context.getObject("metricsAndSynonyms", HashMap.class);
        if (!Objects.isNull(metricsAndSynonyms)) {
            for (JSONObject metric2 : metrics) {
                String metricName;
                String metricNameCN = metricName = metric2.getString("metricName");
                String metricNameTW = metricName;
                JSONObject jsonObject = (JSONObject)metricsAndSynonyms.get(metricName);
                if (Objects.isNull(jsonObject)) {
                    TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
                    JSONObject cnAndTw = bean.cnAndTw(metricName);
                    metricNameCN = cnAndTw.getString("zh_CN");
                    metricNameTW = cnAndTw.getString("zh_TW");
                }
                if (Objects.isNull(jsonObject)) {
                    jsonObject = (JSONObject)metricsAndSynonyms.get(metricNameCN);
                }
                if (Objects.isNull(jsonObject)) {
                    jsonObject = (JSONObject)metricsAndSynonyms.get(metricNameTW);
                }
                if (Objects.isNull(jsonObject) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonObject.getString("synonyms"))) continue;
                List synonyms = (List)jsonObject.getObject("synonyms", List.class);
                String synonym = synonyms.stream().filter(questionMsg::contains).reduce((x, y) -> x.length() > y.length() ? x : y).orElse("");
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)synonym)) continue;
                synonymToStandardName.append("\u300c").append(synonym).append("\u300d\u662f\u6307\u300c").append(jsonObject.getString("standard_name")).append("\u300d,");
            }
        }
        if ((synonymToStandardNameStr = synonymToStandardName.toString()).endsWith(",")) {
            synonymToStandardNameStr = synonymToStandardNameStr.substring(0, synonymToStandardNameStr.length() - 1);
        }
        if ("\u6307\u6807\u4fe1\u606f\uff1a".equals(synonymToStandardNameStr)) {
            synonymToStandardNameStr = "";
        }
        List params = metrics.stream().map(metric -> {
            JSONObject param = new JSONObject();
            param.put("metricId", (Object)metric.getString("metricId"));
            String nameKey = context.containsKey((Object)"scelect_dataSet") ? "datasetName" : "metricName";
            param.put("metricName", (Object)metric.getString(nameKey));
            param.put("businessType", (Object)metric.getString("businessType"));
            JSONArray fieldSchemas = (JSONArray)metric.getOrDefault((Object)"fieldSchema", (Object)new JSONArray());
            JSONArray fieldSchemaParams = new JSONArray();
            for (Object obj : fieldSchemas) {
                JSONObject fieldSchema = (JSONObject)obj;
                JSONObject fieldSchemaParam = new JSONObject();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldSchema.getString("defaultDate")) && !"null".equals(fieldSchema.getString("defaultDate"))) {
                    fieldSchemaParam.put("defaultDate", (Object)fieldSchema.getString("defaultDate"));
                }
                fieldSchemaParam.put("dataType", (Object)fieldSchema.getString("dataType"));
                fieldSchemaParam.put("name", (Object)fieldSchema.getString("name"));
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldSchema.getString("description"))) {
                    fieldSchemaParam.put("description", (Object)fieldSchema.getString("description"));
                }
                fieldSchemaParam.put("title", (Object)fieldSchema.getString("title"));
                if (CollectionUtils.isNotEmpty((Collection)fieldSchema.getJSONArray("enums"))) {
                    JSONArray enums = fieldSchema.getJSONArray("enums");
                    JSONArray enumsArray = new JSONArray();
                    for (Object enumObj : enums) {
                        if (Objects.isNull(enumObj)) continue;
                        JSONObject enumJsonObject = new JSONObject();
                        enumJsonObject.put("description", (Object)((JSONObject)enumObj).getString("description"));
                        enumJsonObject.put("value", (Object)((JSONObject)enumObj).getString("value"));
                        enumsArray.add((Object)enumJsonObject);
                    }
                    fieldSchemaParam.put("enums", (Object)enumsArray);
                }
                fieldSchemaParams.add((Object)fieldSchemaParam);
            }
            param.put("fieldSchema", (Object)fieldSchemaParams);
            return param;
        }).collect(Collectors.toList());
        context.put("metricData", (Object)JSONObject.toJSONString(params));
        log.info("metricData fieldSchema:{}", params);
        return synonymToStandardNameStr;
    }

    private static String buildSqlParamsV2(JSONObject context) {
        String synonymToStandardNameStr;
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        boolean synonymOldSwitch = (Boolean)environment.getProperty("synonym.old.switch", Boolean.class);
        log.info("buildSqlParams\u662f\u5426\u8d70\u8001es\u5f00\u5173:{}", (Object)synonymOldSwitch);
        if (!Objects.isNull(synonymOldSwitch) && synonymOldSwitch) {
            return PromptExecutor.buildSqlParams((JSONObject)context);
        }
        StringBuilder synonymToStandardName = new StringBuilder("\u6307\u6807\u4fe1\u606f\uff1a");
        List finalMetricstandardwords = (List)context.getObject("distinctMetricStandardWords4Gpt", List.class);
        if (CollectionUtils.isNotEmpty((Collection)finalMetricstandardwords)) {
            for (JSONObject metricstandardword : finalMetricstandardwords) {
                String standardName = metricstandardword.getString("standard_name");
                String compare_field = metricstandardword.getString("compare_field");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)standardName) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)compare_field) || standardName.equals(compare_field)) continue;
                synonymToStandardName.append("\u300c").append(compare_field).append("\u300d\u662f\u6307\u300c").append(standardName).append("\u300d,");
            }
        }
        if ((synonymToStandardNameStr = synonymToStandardName.toString()).endsWith(",")) {
            synonymToStandardNameStr = synonymToStandardNameStr.substring(0, synonymToStandardNameStr.length() - 1);
        }
        if ("\u6307\u6807\u4fe1\u606f\uff1a".equals(synonymToStandardNameStr)) {
            synonymToStandardNameStr = "";
        }
        return synonymToStandardNameStr;
    }

    public static String getMetricData(JSONObject context) {
        List metrics = context.containsKey((Object)"scelect_dataSet") ? (List)context.getOrDefault((Object)"final_dataSet", new ArrayList()) : (List)context.getOrDefault((Object)"final_metric", new ArrayList());
        ExtractDimensionRes extractDimensionRes = (ExtractDimensionRes)context.getObject("extractDimensionRes", ExtractDimensionRes.class);
        List params = PromptExecutor.getMetricData((Boolean)context.containsKey((Object)"scelect_dataSet"), (List)metrics, (ExtractDimensionRes)extractDimensionRes);
        return JSONObject.toJSONString((Object)params);
    }

    public static String getMetricDataMd(JSONObject context) {
        List metrics = context.containsKey((Object)"scelect_dataSet") ? (List)context.getOrDefault((Object)"final_dataSet", new ArrayList()) : (List)context.getOrDefault((Object)"final_metric", new ArrayList());
        ExtractDimensionRes extractDimensionRes = (ExtractDimensionRes)context.getObject("extractDimensionRes", ExtractDimensionRes.class);
        List params = PromptExecutor.getMetricData((Boolean)context.containsKey((Object)"scelect_dataSet"), (List)metrics, (ExtractDimensionRes)extractDimensionRes);
        JSONArray jsonArray = new JSONArray();
        params.forEach(p -> jsonArray.add(p));
        log.info("metricData fieldSchema:{}", (Object)params);
        return StringUtil.convertJsonToMarkdown((JSONArray)jsonArray);
    }

    public String getQuestionRegion(JSONObject context) {
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        return "zh_TW".equals(locale) ? "\u81fa\u7063" : "\u5927\u9646";
    }

    public static List<JSONObject> getMetricData(Boolean ifDataSet, List<JSONObject> metrics, ExtractDimensionRes extractDimensionRes) {
        return metrics.stream().map(metric -> {
            JSONObject param = new JSONObject();
            String idKey = ifDataSet != false ? "datasetId" : "metricId";
            String nameKey = ifDataSet != false ? "datasetName" : "metricName";
            param.put("metricId", (Object)metric.getString(idKey));
            param.put("metricName", (Object)metric.getString(nameKey));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metric.getString("businessType"))) {
                param.put("businessType", (Object)PromptExecutor.transBusinessTypeForGPT((String)metric.getString("businessType")));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metric.getString("description"))) {
                param.put("description", (Object)metric.getString("description"));
            }
            JSONArray fieldSchemas = (JSONArray)metric.getOrDefault((Object)"fieldSchema", (Object)new JSONArray());
            JSONArray fieldSchemaParams = new JSONArray();
            for (Object obj : fieldSchemas) {
                FieldInfo fieldInfo;
                ModelInfo modelInfo;
                JSONObject fieldSchema = (JSONObject)obj;
                JSONObject fieldSchemaParam = new JSONObject(new LinkedHashMap());
                fieldSchemaParam.put("dataType", (Object)fieldSchema.getString("dataType"));
                fieldSchemaParam.put("name", (Object)fieldSchema.getString("name"));
                fieldSchemaParam.put("title", (Object)fieldSchema.getString("title"));
                if (Objects.nonNull(extractDimensionRes) && Objects.nonNull(modelInfo = (ModelInfo)extractDimensionRes.getModels().stream().filter(e -> e.getModelCode().equals(metric.getString("modelCode"))).findFirst().orElse(null)) && Objects.nonNull(fieldInfo = (FieldInfo)modelInfo.getFieldInfo().stream().filter(f -> f.getFieldCode().equals(fieldSchema.getString("name"))).findFirst().orElse(null))) {
                    fieldSchemaParam.put("contents", (Object)fieldInfo.getContents());
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldSchema.getString("description"))) {
                    fieldSchemaParam.put("description", (Object)fieldSchema.getString("description"));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldSchema.getString("defaultDate")) && !"null".equals(fieldSchema.getString("defaultDate"))) {
                    fieldSchemaParam.put("defaultDate", (Object)fieldSchema.getString("defaultDate"));
                }
                if (CollectionUtils.isNotEmpty((Collection)fieldSchema.getJSONArray("enums"))) {
                    JSONArray enums = fieldSchema.getJSONArray("enums");
                    JSONArray enumsArray = new JSONArray();
                    for (Object enumObj : enums) {
                        if (Objects.isNull(enumObj)) continue;
                        JSONObject enumJsonObject = new JSONObject();
                        enumJsonObject.put("description", (Object)((JSONObject)enumObj).getString("description"));
                        enumJsonObject.put("value", (Object)((JSONObject)enumObj).getString("value"));
                        enumsArray.add((Object)enumJsonObject);
                    }
                    fieldSchemaParam.put("enums", (Object)enumsArray);
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldSchema.getString("businessType"))) {
                    fieldSchemaParam.put("businessType", (Object)PromptExecutor.transBusinessTypeForGPT((String)fieldSchema.getString("businessType")));
                }
                fieldSchemaParams.add((Object)fieldSchemaParam);
            }
            param.put("fieldSchema", (Object)fieldSchemaParams);
            return param;
        }).collect(Collectors.toList());
    }

    private static String buildDimensionSynonym(JSONObject context) {
        String synonymToTitleStr;
        StringBuilder synonymToTitle = new StringBuilder("\u7ef4\u5ea6\u4fe1\u606f\uff1a");
        List dimensionAndSynonyms = (List)context.getOrDefault((Object)"distinctDimensionStandardWords", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)dimensionAndSynonyms)) {
            for (JSONObject dimensionAndSynonym : dimensionAndSynonyms) {
                String title = dimensionAndSynonym.getString("title");
                String compare_field = dimensionAndSynonym.getString("compare_field");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)title) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)compare_field) || title.equals(compare_field)) continue;
                synonymToTitle.append("\u300c").append(compare_field).append("\u300d\u662f\u6307\u300c").append(title).append("\u300d,");
            }
        }
        if ((synonymToTitleStr = synonymToTitle.toString()).endsWith(",")) {
            synonymToTitleStr = synonymToTitleStr.substring(0, synonymToTitleStr.length() - 1);
        }
        if ("\u7ef4\u5ea6\u4fe1\u606f\uff1a".equals(synonymToTitleStr)) {
            synonymToTitleStr = "";
        }
        return synonymToTitleStr;
    }

    public String pipelineName() {
        return this.getPromptName();
    }

    private static String transBusinessTypeForGPT(String businessType) {
        if ("unitPrice".equals(businessType)) {
            return "amount";
        }
        if ("days".equals(businessType)) {
            return "Quantity";
        }
        return businessType;
    }

    public boolean onCondition(JSONObject context) {
        if (scenePromptList.contains(this.getName())) {
            return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
        }
        if (metricPromptList.contains(this.getName())) {
            return context.containsKey((Object)"scelect_metric");
        }
        if (dataSetPromptList.contains(this.getName())) {
            return context.containsKey((Object)"scelect_dataSet");
        }
        return true;
    }

    static {
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.RH.HK.values()) {
            GPT_CLIENT_MAP.put("RH_HK_" + hK, hK);
            GPT_CLIENT_MAP.put("RH_" + hK, hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AZURE.values()) {
            GPT_CLIENT_MAP.put("AZURE_" + hK.getModel().toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AI_PROXY.values()) {
            GPT_CLIENT_MAP.put("AI_PROXY_" + hK.toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AI_PROXY_VIP.values()) {
            GPT_CLIENT_MAP.put("AI_PROXY_VIP_" + hK.toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.RH.PASS.values()) {
            GPT_CLIENT_MAP.put("RH_" + hK, hK);
        }
        model_mapping_map = new HashMap();
        model_mapping_map.put("semantic-analysis", Arrays.asList("nl2ele_easy", "nl2sql_general", "nl2sql_nest", "Multi_dialogue", "Query_Classification", "SemanticFuzzyResolver", "nl2sql_cot"));
        model_mapping_map.put("dataset-search", Arrays.asList("QueryLogicForm", "TableFilter"));
        model_mapping_map.put("recommended-summary", Arrays.asList("none_metric_suggested_queries", "Autocomplete_Rec", "businessTypeIdentification", "result_summary", "Query_Rec_no_metric", "Query_Rec_with_metric", "Query_Rec"));
        needAppendNounknowledgesList = new ArrayList<String>(Arrays.asList("SemanticFuzzyResolver", "nl2sql_cot", "nl2sql_general", "nl2sql_nest", "nl2ele_easy"));
        needAppendQList = new ArrayList<String>(Arrays.asList("Filter", "AnalysisPlanning", "Dimension", "Query_Classification", "nl2ele_easy", "nl2sql_general", "nl2sql_cot", "nl2sql_nest", "SemanticFuzzyResolver", "Autocomplete_Rec", "TableFilter", "QueryLogicForm"));
        needAppendSpecailFilterQ = new ArrayList<String>(Arrays.asList("Filter", "nl2ele_easy", "nl2sql_general", "nl2sql_cot", "nl2sql_nest", "SemanticFuzzyResolver", "Autocomplete_Rec"));
        needAppendSqlParam = new ArrayList<String>(Arrays.asList("nl2ele_easy", "nl2sql_general", "Query_Classification", "nl2sql_cot", "nl2sql_nest", "SemanticFuzzyResolver"));
        stopProcessIfErrorExecutorList = new ArrayList<String>(Arrays.asList("Multi_dialogue", "Filter", "AnalysisPlanning", "Dimension", "SortAndLimit", "Metric_with_app", "SemanticFuzzyResolver", "Query_Classification", "nl2ele_easy", "nl2sql_general", "nl2sql_cot", "nl2sql_nest", "QueryLogicForm", "TableFilter"));
        scenePromptList = new ArrayList<String>(Arrays.asList("AlikeTarget", "Filter", "AnalysisPlanning", "Dimension", "SortAndLimit"));
        metricPromptList = new ArrayList<String>(Arrays.asList("Metric_with_app", "Query_Classification", "nl2sql_cot", "nl2ele_easy", "nl2sql_general", "uncertain_metric_suggested_queries", "none_metric_suggested_queries", "SemanticFuzzyResolver", "Autocomplete_Rec"));
        dataSetPromptList = new ArrayList<String>(Arrays.asList("Query_Classification_V1", "Query_Classification_V2", "nl2sql_cot_V1", "nl2sql_cot_V2", "nl2sql_nest_V1", "nl2sql_nest_V2", "nl2ele_easy_V1", "nl2ele_easy_V2", "nl2sql_general_V1", "nl2sql_general_V2", "none_metric_suggested_queries_V1", "none_metric_suggested_queries_V2", "SemanticFuzzyResolver_V1", "SemanticFuzzyResolver_V2", "Autocomplete_Rec_V1", "Autocomplete_Rec_V2", "TableFilter", "QueryLogicForm"));
        ArrayList<String> addNeedAppendQList = new ArrayList<String>();
        for (String s : needAppendQList) {
            addNeedAppendQList.add(s + "_V1");
        }
        needAppendQList.addAll(addNeedAppendQList);
        ArrayList<String> addNeedAppendSpecailFilterQ = new ArrayList<String>();
        for (String string : needAppendSpecailFilterQ) {
            addNeedAppendSpecailFilterQ.add(string + "_V1");
        }
        needAppendSpecailFilterQ.addAll(addNeedAppendSpecailFilterQ);
        ArrayList<String> addNeedAppendDimensionFilterQ = new ArrayList<String>();
        for (String s : needAppendSqlParam) {
            addNeedAppendDimensionFilterQ.add(s + "_V1");
            addNeedAppendDimensionFilterQ.add(s + "_V2");
        }
        needAppendSqlParam.addAll(addNeedAppendDimensionFilterQ);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String s : stopProcessIfErrorExecutorList) {
            arrayList.add(s + "_V1");
            arrayList.add(s + "_V2");
        }
        stopProcessIfErrorExecutorList.addAll(arrayList);
    }
}

