/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.rule;

import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.WNode;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class R4RemoveRedundantWFilterRule
implements OptimizationRule {
    public boolean apply(List<StepNode> steps) {
        boolean changed = false;
        for (StepNode step : steps) {
            WNode whereClause = step.getW();
            if (whereClause == null || whereClause.getConditions() == null) continue;
            Map conditions = whereClause.getConditions();
            HashMap<String, List> newConditions = new HashMap<String, List>(conditions);
            for (Map.Entry entry : conditions.entrySet()) {
                List subConditions;
                List uniqueConditions;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!key.equals("and") && !key.equals("or") || !(value instanceof List) || (uniqueConditions = this.removeDuplicateConditions(subConditions = (List)value)).size() >= subConditions.size()) continue;
                newConditions.put(key, uniqueConditions);
                changed = true;
            }
            if (!changed) continue;
            whereClause.setConditions(newConditions);
        }
        return changed;
    }

    private List<Object> removeDuplicateConditions(List<?> conditions) {
        ArrayList<Object> uniqueConditions = new ArrayList<Object>();
        HashSet<String> seen = new HashSet<String>();
        for (Object condition : conditions) {
            String conditionStr;
            if (condition instanceof Map) {
                Map conditionMap = (Map)condition;
                conditionStr = this.normalizeConditionMap(conditionMap).toString();
            } else {
                conditionStr = condition.toString();
            }
            if (seen.contains(conditionStr)) continue;
            seen.add(conditionStr);
            uniqueConditions.add(condition);
        }
        return uniqueConditions;
    }

    private Map<String, Object> normalizeConditionMap(Map<String, Object> conditionMap) {
        HashMap<String, Object> normalized = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : conditionMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                normalized.put(key, this.normalizeConditionMap(nestedMap));
                continue;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                ArrayList normalizedList = new ArrayList();
                for (Object item : listValue) {
                    if (item instanceof Map) {
                        Map itemMap = (Map)item;
                        normalizedList.add(this.normalizeConditionMap(itemMap));
                        continue;
                    }
                    normalizedList.add(item);
                }
                normalized.put(key, normalizedList);
                continue;
            }
            normalized.put(key, value);
        }
        return normalized;
    }

    public String getName() {
        return "R4: \u79fb\u9664\u5197\u4f59\u7684W\u8fc7\u6ee4\u5668";
    }
}

