/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.sse;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.EventData;
import com.digiwin.chatbi.common.enums.SseEventlEnum;
import com.digiwin.chatbi.common.util.SseEmitterUtils;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SseSendService4ConvoBoard {
    private static final Logger log = LoggerFactory.getLogger(SseSendService4ConvoBoard.class);
    @Resource
    private Executor sseSendExecutor;
    private static int otherMilliseconds = 100;

    public void asyncSendIntentionAnalysic(String requestId, String msg, String locale, boolean ifStream, JSONObject context, Boolean success) {
        this.buildIntentionAnalysic(context, locale, msg, success);
        if (!ifStream) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
                String[] answerSplit = answer.split("");
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData analysicDetailEventData;
                    if (SseContext.getConvoBoardResultState((String)requestId).booleanValue()) {
                        analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_CONVOBOARD.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer.substring(i), "success");
                        SseEmitterUtils.sendEventDataReduceLog((String)requestId, (EventData)analysicDetailEventData);
                        break;
                    }
                    Thread.sleep(otherMilliseconds);
                    analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_CONVOBOARD.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventDataReduceLog((String)requestId, (EventData)analysicDetailEventData);
                }
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, success != false ? "success" : "fail");
                SseEmitterUtils.sendEventDataReduceLog((String)requestId, (EventData)analysicCompleateEventData);
                CountDownLatch convoBoardResultLatch = SseContext.getConvoBoardResultLatch((String)requestId);
                convoBoardResultLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u610f\u56fe\u5206\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    private void buildIntentionAnalysic(JSONObject context, String locale, String msg, Boolean success) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject intentionAnalysis = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_CONVOBOARD.getType(), (Object)new JSONObject());
        intentionAnalysis.put("content", (Object)detail);
        intentionAnalysis.put("status", (Object)success);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_CONVOBOARD.getType(), (Object)intentionAnalysis);
        context.put("processStreamData", (Object)processStreamData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResult(String requestId, String res, boolean success) {
        try {
            SseContext.putConvoBoardResultState((String)requestId, (Boolean)true);
            CountDownLatch convoBoardResultLatch = SseContext.getConvoBoardResultLatch((String)requestId);
            boolean await = convoBoardResultLatch.await(30L, TimeUnit.SECONDS);
            if (await) {
                log.info("sendResult\u6210\u529f");
            } else {
                log.info("sendResult\u8d85\u65f6");
            }
            EventData resultEventData = new EventData(SseEventlEnum.SCRUMBI_RESULT.getEvent(), SseEventlEnum.SseEventDataTypeEnum.RESULT.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), res, success ? "success" : "fail");
            SseEmitterUtils.sendEventData((String)requestId, (EventData)resultEventData);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u5f02\u6b65\u53d1\u9001\u6700\u7ec8\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            EventData doneEventData = new EventData(SseEventlEnum.SCRUMBI_DONE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
            SseEmitterUtils.sendEventData((String)requestId, (EventData)doneEventData);
        }
    }
}

