/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.client.GPT_MODEL;
import com.digiwin.chatbi.client.GPT_PROVIDER;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AiMockDataService {
    private static final Logger log = LoggerFactory.getLogger(AiMockDataService.class);
    @Value(value="${test.apollo:123}")
    private String testApollo;

    public JSONObject create(JSONObject param) throws Exception {
        Integer dataNumber = param.getInteger("dataNumber");
        List dataRules = (List)param.getObject("dataRules", List.class);
        StringBuilder dataRulesFormatter = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)dataRules)) {
            dataRules.stream().map(dataRule -> dataRule).forEach(dataRule -> dataRulesFormatter.append((String)dataRule).append("\n"));
        }
        Question question = new Question();
        JSONObject schema = new JSONObject();
        schema.put("schema", (Object)param.getString("schema"));
        question.setMessage(schema.toJSONString());
        question.setGptProvider(GPT_PROVIDER.RH);
        question.setGptModel(GPT_MODEL.GPT3_5_TURBO);
        JSONObject context = new JSONObject();
        context.put("maxToken", (Object)4096);
        context.put("question", (Object)question);
        context.put("dataNumber", (Object)(Objects.isNull(dataNumber) ? 5 : dataNumber));
        context.put("dataRules", (Object)dataRulesFormatter);
        context.put("temperature", (Object)"0.5");
        Output output = ExecutorFactory.CALL_GPT_WITH_GENERATE_DATA_PROMPT.doProcess(context);
        JSONObject res = output.getOutputContext().getJSONObject("Generate_data");
        String error = output.getOutputContext().getString("NOT_JSON_promptsGenerate_data");
        if (Objects.isNull(res)) {
            throw new BussinessException("mock\u7ed3\u679c\u5f02\u5e38\uff0c\u751f\u6210\u7684\u7ed3\u679c\u4e3a" + error);
        }
        return res;
    }

    public String apolloTest() {
        return this.testApollo;
    }
}

