/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.chatbi.beans.entity.UserReportRelationEntity;
import com.digiwin.chatbi.beans.entity.UserReportsEntity;
import com.digiwin.chatbi.common.enums.ReportTypeEnum;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.UserReportRelationMapper;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.UserReportsMapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportService.class);
    @Autowired
    private UserReportRelationMapper userReportRelationMapper;
    @Autowired
    private UserReportsMapper userReportsMapper;

    public List<UserReportRelationEntity> selectCommonReport(String url) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(UserReportRelationEntity::getFileUrl, (Object)url)).eq(UserReportRelationEntity::getReportType, (Object)ReportTypeEnum.COMMON.getCode());
        return this.userReportRelationMapper.selectList((Wrapper)queryWrapper);
    }

    public List<UserReportRelationEntity> selectUserReport(String userId, String tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(UserReportRelationEntity::getUserId, (Object)userId)).eq(UserReportRelationEntity::getTenantId, (Object)tenantId)).eq(UserReportRelationEntity::getReportType, (Object)ReportTypeEnum.USER.getCode());
        List userReportRelationEntities = null;
        userReportRelationEntities = this.userReportRelationMapper.selectList((Wrapper)queryWrapper);
        return userReportRelationEntities;
    }

    public void insertReportRelation(UserReportRelationEntity userReportRelationEntity) {
        this.userReportRelationMapper.insert((Object)userReportRelationEntity);
    }

    public String selectByUserIdAndTenantId(String userId, String tenantId) {
        return this.userReportRelationMapper.selectByUserIdAndTenantId(userId, tenantId);
    }

    public int updateById(UserReportRelationEntity userReportRelationEntity) {
        return this.userReportRelationMapper.updateById((Object)userReportRelationEntity);
    }

    public int releaseLock(UserReportRelationEntity userReportRelationEntity) {
        userReportRelationEntity.setLockStatus("0");
        return this.userReportRelationMapper.updateById((Object)userReportRelationEntity);
    }

    public int lock(UserReportRelationEntity userReportRelationEntity) {
        userReportRelationEntity.setLockStatus("1");
        userReportRelationEntity.setLockTime(new Date());
        return this.userReportRelationMapper.updateById((Object)userReportRelationEntity);
    }

    public void batchInsertReport(List<UserReportsEntity> userReportsEntitys) {
        if (CollectionUtils.isEmpty(userReportsEntitys)) {
            return;
        }
        this.userReportsMapper.batchInsert(userReportsEntitys);
    }

    public void deleteByRelationId(Integer relationId) {
        if (Objects.isNull(relationId)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserReportsEntity::getRelationId, (Object)relationId);
        List list = this.userReportsMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.userReportsMapper.deleteBatchIds((Collection)list.stream().map(UserReportsEntity::getId).collect(Collectors.toList()));
        }
    }

    public List<UserReportsEntity> getUserReportsByUseIdAndTenantId(String userId, String tenantId) {
        List list = this.userReportsMapper.getUserReportsByUseIdAndTenantId(userId, tenantId);
        return list;
    }

    public List<UserReportsEntity> selectReportByRelationId(Integer relationId) {
        if (Objects.isNull(relationId)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserReportsEntity::getRelationId, (Object)relationId);
        List list = this.userReportsMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    public String getSheetNameByTableName(String tableName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserReportsEntity::getTableName, (Object)tableName);
        UserReportsEntity userReportsEntity = (UserReportsEntity)this.userReportsMapper.selectOne((Wrapper)queryWrapper);
        if (null != userReportsEntity) {
            return userReportsEntity.getSheetName();
        }
        return null;
    }
}

