/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.beans.dtos.chart.TopicDetailDto;
import com.digiwin.chatbi.beans.dtos.chart.TopicDto;
import com.digiwin.chatbi.beans.entity.TopicDetailEntity;
import com.digiwin.chatbi.beans.entity.TopicEntity;
import com.digiwin.chatbi.beans.entity.TopicPromptEntity;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.TopicDetailMapper;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.TopicMapper;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.TopicPromptMapper;
import com.digiwin.chatbi.reasoning.process.ChatProcess;
import com.digiwin.chatbi.service.AdtService;
import com.digiwin.chatbi.service.UibotService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TopicService {
    private static final Logger log = LoggerFactory.getLogger(TopicService.class);
    private final Object $lock = new Object[0];
    @Autowired
    private TopicMapper topicMapper;
    @Autowired
    private TopicDetailMapper topicDetailMapper;
    @Autowired
    private TopicPromptMapper topicPromptMapper;
    @Autowired
    private AdtService adtService;
    @Autowired
    private UibotService uibotService;
    @Resource
    private Executor demoV2Executor;
    @Resource
    private ChatProcess chatProcess;

    public Long dataAnalysisDemoSave(TopicDto topicDto) throws BussinessException {
        TopicEntity topicEntity = TopicDto.dtoToEntity((TopicDto)topicDto);
        List topicDetailEntities = topicEntity.getTopicDetailEntities();
        if (CollectionUtils.isEmpty((Collection)topicDetailEntities)) {
            throw new BussinessException("\u8bf7\u8f93\u5165\u95ee\u53e5");
        }
        List reserveDetailIds = topicDetailEntities.stream().filter(d -> Objects.nonNull(d.getId())).map(d -> d.getId()).collect(Collectors.toList());
        List<Object> oldDetailIds = new ArrayList();
        topicEntity.setStatus(Integer.valueOf(1));
        if (Objects.isNull(topicDto.getId())) {
            this.topicMapper.insert((Object)topicEntity);
        } else {
            this.topicMapper.updateById((Object)topicEntity);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TopicDetailEntity::getTopicId, (Object)topicDto.getId());
            List oldTopicDetailEntities = this.topicDetailMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)oldTopicDetailEntities)) {
                oldDetailIds = oldTopicDetailEntities.stream().map(d -> d.getId()).collect(Collectors.toList());
            }
        }
        List delDetailIds = oldDetailIds.stream().filter(o -> !reserveDetailIds.contains(o)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.topicDetailMapper.deleteBatchIds(delDetailIds);
        }
        ArrayList<Integer> addTypeIndex = new ArrayList<Integer>();
        for (int i = 0; i < topicDetailEntities.size(); ++i) {
            ((TopicDetailEntity)topicDetailEntities.get(i)).setTopicId(topicEntity.getId());
            if (!Objects.isNull(((TopicDetailEntity)topicDetailEntities.get(i)).getId())) continue;
            addTypeIndex.add(i);
        }
        Long oldId = ((TopicDetailEntity)topicDetailEntities.get(0)).getId();
        topicDetailEntities = this.batchSaveDetails(topicDetailEntities);
        Long firstId = ((TopicDetailEntity)topicDetailEntities.get(0)).getId();
        ((TopicDetailEntity)topicDetailEntities.get(0)).setId(oldId);
        if (addTypeIndex.size() > 0) {
            for (int i = 0; i < addTypeIndex.size(); ++i) {
                ((TopicDetailEntity)topicDetailEntities.get((Integer)addTypeIndex.get(i))).setId(Long.valueOf(firstId + (long)i));
            }
        }
        ArrayList<TopicPromptEntity> topicPromptSaveEntities = new ArrayList<TopicPromptEntity>();
        for (TopicDetailEntity topicDetailEntity : topicDetailEntities) {
            for (TopicPromptEntity topicPromptEntity : topicDetailEntity.getTopicPromptEntities()) {
                if (Objects.isNull(topicPromptEntity.getDetailId())) {
                    topicPromptEntity.setDetailId(topicDetailEntity.getId());
                }
                topicPromptSaveEntities.add(topicPromptEntity);
            }
        }
        this.topicPromptMapper.batchSave(topicPromptSaveEntities);
        return topicEntity.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicDetailEntity> batchSaveDetails(List<TopicDetailEntity> topicDetailEntities) {
        Object object = this.$lock;
        synchronized (object) {
            this.topicDetailMapper.batchSave(topicDetailEntities);
            return topicDetailEntities;
        }
    }

    public List<TopicDto> dataAnalysisDemoDetail(Long id) {
        List topicEntities = this.topicMapper.selectAll(id);
        if (CollectionUtils.isEmpty((Collection)topicEntities)) {
            return null;
        }
        ArrayList<TopicDto> topicDtos = new ArrayList<TopicDto>();
        for (TopicEntity topicEntity : topicEntities) {
            TopicDto topicDto2 = TopicDto.entityToDto((TopicEntity)topicEntity);
            topicDtos.add(topicDto2);
        }
        return topicDtos.stream().peek(topicDto -> {
            if (CollectionUtils.isNotEmpty((Collection)topicDto.getTopicDetailDtos())) {
                topicDto.setTopicDetailDtos(topicDto.getTopicDetailDtos().stream().filter(detailDto -> detailDto.getId() != null).peek(detailDto -> {
                    if (CollectionUtils.isNotEmpty((Collection)detailDto.getTopicPromptDtos())) {
                        detailDto.setTopicPromptDtos(detailDto.getTopicPromptDtos().stream().filter(promptDto -> promptDto.getId() != null).collect(Collectors.toList()));
                    }
                }).collect(Collectors.toList()));
            }
        }).collect(Collectors.toList());
    }

    public void updateStatus(Long topicId, Integer status) {
        TopicEntity topicEntity = new TopicEntity();
        topicEntity.setId(topicId);
        topicEntity.setStatus(status);
        this.topicMapper.updateById((Object)topicEntity);
    }

    @Async
    public void dataAnalysisDemoRun(Long topicId, String token, String routerKey) throws BussinessException {
        List topicDtos = this.dataAnalysisDemoDetail(topicId);
        TopicDto queryRes = (TopicDto)topicDtos.get(0);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (TopicDetailDto topicDetailDto : queryRes.getTopicDetailDtos()) {
            Long detailId = topicDetailDto.getId();
            String question = topicDetailDto.getQuestion();
            List topicPromptDtos = topicDetailDto.getTopicPromptDtos();
            if (StringUtils.isEmpty((CharSequence)question) || CollectionUtils.isEmpty((Collection)topicPromptDtos)) {
                log.error("detailId:{}\u95ee\u53e5\u6216\u63d0\u793a\u8bcd\u4e3a\u7a7a", (Object)detailId);
                continue;
            }
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                String snapshotId = this.adtService.processMessage(question, token, routerKey);
                if (StringUtils.isEmpty((CharSequence)snapshotId)) {
                    log.info("\u5feb\u7167id\u4e3a\u7a7a");
                    return;
                }
                List userPromptList = topicPromptDtos.stream().map(t -> t.getPrompt()).collect(Collectors.toList());
                String analysis = "";
                if (CollectionUtils.isNotEmpty(userPromptList)) {
                    ResultBean res = this.chatProcess.dataAnalysisDemo(snapshotId, token, routerKey, null, userPromptList);
                    analysis = ((JSONObject)res.getData()).getString("data");
                }
                JSONObject report = this.uibotService.showReport(token, routerKey, snapshotId);
                TopicDetailEntity topicDetailEntity = new TopicDetailEntity();
                BeanUtils.copyProperties((Object)topicDetailDto, (Object)topicDetailEntity);
                topicDetailEntity.setSnapshotId(snapshotId);
                topicDetailEntity.setUibotData(JSONObject.toJSONString((Object)report));
                topicDetailEntity.setAnalysis(analysis);
                this.topicDetailMapper.updateById((Object)topicDetailEntity);
            }, this.demoV2Executor);
            futures.add(future);
        }
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allFutures.get();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u6267\u884c\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0:{}", (Object)e.getMessage());
            throw new BussinessException("\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
        TopicEntity topicEntity = new TopicEntity();
        topicEntity.setId(topicId);
        topicEntity.setStatus(Integer.valueOf(3));
        this.topicMapper.updateById((Object)topicEntity);
    }
}

